/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.FMClientHelper;
import com.kingdee.eas.base.core.fm.client.AbstractOnLineHelpListUI;
import com.kingdee.eas.base.core.fm.client.OnLineHelpViewUI;
import com.kingdee.eas.base.core.fm.client.Resource;
import com.kingdee.eas.base.core.fm.client.ResourceUtils;
import com.kingdee.eas.base.core.fm.client.Ui2OnLineHelpMaping;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OnLineHelpListUI
extends AbstractOnLineHelpListUI {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String DESC = "desc";
    private static final String NUM = "num";
    private static final String UPDATE_TIME = "updatetime";
    private String[] resourceType = new String[]{"801"};
    private static final Logger logger = CoreUIObject.getLogger(OnLineHelpListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        String uiclass = (String)this.getUIContext().get("uiclass");
        Ui2OnLineHelpMaping onLineHelpUtil = Ui2OnLineHelpMaping.getInstance();
        this.resourceType = onLineHelpUtil.getFunction(uiclass);
        ResourceUtils resUtil = new ResourceUtils();
        ArrayList resList = resUtil.getResource(this.resourceType, false);
        this.fillData(resList);
    }

    private void fillData(ArrayList<Resource> resList) throws BOSException, EASBizException {
        IRow row = null;
        this.tblMain.removeRows();
        int size = resList.size();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.addRow();
            Resource resource = resList.get(i);
            row.getCell(ID).setValue((Object)resource.getId());
            row.getCell(NAME).setValue((Object)resource.getName());
            row.getCell(DESC).setValue((Object)resource.getDesc());
            row.getCell(NUM).setValue((Object)resource.getNum());
            row.getCell(UPDATE_TIME).setValue((Object)resource.getUpdateTime());
        }
    }

    @Override
    protected void btnView_actionPerformed(ActionEvent e) throws Exception {
        this.viewAResource();
    }

    private void viewAResource() throws UIException {
        String id = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)ID, (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OnLineHelpViewUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    protected void btnSerach_actionPerformed(ActionEvent e) throws Exception {
        String searchContent = this.txtSearch.getText();
        if (searchContent == null || searchContent.length() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5173\u952e\u5b57\uff01");
            this.txtSearch.requestFocus();
            SysUtil.abort();
        }
        ResourceUtils resUtil = new ResourceUtils();
        String search = URLEncoder.encode(searchContent, "utf-8");
        ArrayList resList = resUtil.getResource(new String[]{search}, true);
        this.fillData(resList);
    }

    @Override
    protected void btnReturn_actionPerformed(ActionEvent e) throws Exception {
        ResourceUtils resUtil = new ResourceUtils();
        ArrayList resList = resUtil.getResource(this.resourceType, false);
        this.fillData(resList);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.viewAResource();
        }
    }

    protected String getSelectedIdValues() {
        int rowNumber = FMClientHelper.getSelectedRow(this.tblMain);
        if (rowNumber == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        IRow row = this.tblMain.getRow(rowNumber);
        row.getCell(ID).getValue();
        return row.getCell(ID).getValue().toString();
    }
}

