/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.core.fm.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.client.FileObject;
import com.kingdee.eas.base.core.fm.client.Resource;
import com.kingdee.eas.base.license.ILicenseSrvAgent;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class ResourceUtils {
    private static final Logger logger = CoreUIObject.getLogger(ResourceUtils.class);
    private static final String WEBURL = "http://web20.kingdee.com/user/res";
    private String customerNum;
    private final String type = "80101";

    public ArrayList getResource(String[] contents, boolean isSearch) throws MalformedURLException, IOException, JSONException {
        ArrayList<Resource> resList = new ArrayList<Resource>();
        for (int i = 0; i < contents.length; ++i) {
            JSONObject json = isSearch ? this.getSearchJson(contents[i]) : this.getResJson(contents[i]);
            if (json == null || json.get("error") != null) continue;
            JSONArray rsArray = json.getJSONArray("rs2");
            int len = rsArray.size();
            for (int j = 0; j < len; ++j) {
                JSONObject rs = rsArray.getJSONObject(j);
                String id = rs.getString("_id");
                String desc = rs.getString("desc");
                String name = rs.getString("name");
                String num = rs.getString("num");
                String price = rs.getString("price");
                String updateTime = rs.getString("udate");
                String version = rs.getString("version");
                String scorec = rs.getString("scorec");
                String scores = rs.getString("scores");
                String author = rs.optString("uname");
                Resource res = new Resource(id, desc, name, num, price, updateTime, version, scorec, scores, author);
                resList.add(res);
            }
        }
        return resList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getJSON(String uri) {
        JSONObject json = null;
        String encoding = "utf-8";
        this.customerNum = ResourceUtils.getCustomerNumber();
        try {
            String lines;
            uri = uri + "&cno=" + this.customerNum;
            URL getUrl = new URL(uri);
            HttpURLConnection con = (HttpURLConnection)getUrl.openConnection();
            con.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            String jsonStr = "";
            while ((lines = reader.readLine()) != null) {
                jsonStr = jsonStr + lines;
            }
            json = JSONObject.fromObject((Object)jsonStr);
            con.disconnect();
        }
        catch (MalformedURLException e) {
            logger.error((Object)("MalformedURLException:" + e));
        }
        catch (IOException e) {
            logger.error((Object)("IOException:" + e));
        }
        catch (JSONException e) {
            logger.error((Object)("JSONException:" + (Object)((Object)e)));
        }
        return json;
    }

    private JSONObject getResJson(String type) {
        String uri = "http://web20.kingdee.com/user/res?type=" + type + "&p=0&l=10&s=1";
        return this.getJSON(uri);
    }

    private JSONObject getSearchJson(String search) {
        String uri = "http://web20.kingdee.com/user/res/search?type=80101&q=" + search + "&p=0&l=9&s=1";
        return this.getJSON(uri);
    }

    private JSONObject getFileJSON(String id) {
        String uri = "http://web20.kingdee.com/user/res/edit?id=" + id;
        return this.getJSON(uri);
    }

    private JSONObject setUseFulJSON(String id, boolean isUseful) {
        String uri = isUseful ? "http://web20.kingdee.com/user/res/setappr?id=" + id + "&score=5&appr=\u597d\u7528" : "http://web20.kingdee.com/user/res/setappr?id=" + id + "&score=0&appr=\u65e0\u7528";
        return this.getJSON(uri);
    }

    public String setUseFulResource(String id, boolean isUseful) throws JSONException {
        JSONObject json = this.setUseFulJSON(id, isUseful);
        if (json != null && json.containsValue((Object)"\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7!")) {
            return "\u4f60\u4e0d\u80fd\u91cd\u590d\u8bc4\u4ef7";
        }
        return "true";
    }

    public Resource getAResource(String id) throws JSONException {
        Resource res = null;
        JSONObject json = this.getFileJSON(id);
        if (json != null) {
            JSONObject rs = json.getJSONObject("u");
            String desc = rs.optString("desc");
            String name = rs.optString("name");
            String num = rs.optString("num");
            String price = rs.optString("price");
            String updateTime = rs.optString("udate");
            String version = rs.optString("version");
            String scorec = rs.optString("scorec");
            String scores = rs.optString("scores");
            String author = rs.optString("uname");
            res = new Resource(id, desc, name, num, price, updateTime, version, scorec, scores, author);
            ArrayList fileList = this.getFileList(json);
            res.setFileList(fileList);
        }
        return res;
    }

    private ArrayList getFileList(JSONObject json) throws JSONException {
        ArrayList<FileObject> fileList = new ArrayList<FileObject>();
        if (json != null && json.has("fs")) {
            JSONArray fs = json.getJSONArray("fs");
            int len = fs.size();
            for (int i = 0; i < len; ++i) {
                JSONObject fileJson = fs.getJSONObject(i);
                FileObject file = new FileObject(fileJson.getString("_id"), fileJson.getString("filename"), fileJson.getString("length"), fileJson.getString("uploadDate"));
                fileList.add(file);
            }
        }
        return fileList;
    }

    public static String getCustomerNumber() {
        String cNum = "unkonwn";
        try {
            ILicenseSrvAgent agent = LicenseSrvAgentFactory.getRemoteInstance();
            LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
            cNum = baseInfo.getSerialNum();
        }
        catch (Exception e) {
            logger.error((Object)("getLicenseException:" + e));
        }
        return cNum;
    }
}

