/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.TreeWillExpandAdapter;
import com.kingdee.eas.base.core.SqlResult;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.fm.common.client.EntityVO;
import com.kingdee.eas.fm.common.client.FMIsqlUI;
import com.kingdee.eas.fm.common.client.FieldVO;
import com.kingdee.eas.fm.common.client.KSqlHelper;
import com.kingdee.eas.fm.common.client.MyTreeCellRender;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;

public class Inspector
extends JFrame {
    private JPanel contentPane;
    private JTree tree;
    public static JTextField txt;

    public static void showId(final String id) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Inspector frame = new Inspector(id);
                    frame.setAlwaysOnTop(true);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Inspector(final String id) throws EASBizException, BOSException, SQLException {
        this.setDefaultCloseOperation(2);
        this.setBounds(200, 100, 850, 800);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPanetool = new JScrollPane();
        this.contentPane.add((Component)scrollPanetool, "North");
        txt = new JTextField();
        scrollPanetool.getViewport().add(txt);
        txt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                Inspector.this.filter_txt();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        this.contentPane.add((Component)scrollPane, "Center");
        this.tree = new JTree();
        scrollPane.setViewportView(this.tree);
        this.tree.addTreeWillExpandListener((TreeWillExpandListener)new TreeWillExpandAdapter(){

            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                Object node = e.getPath().getLastPathComponent();
                if (node instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode cuNode = (DefaultMutableTreeNode)node;
                    if (cuNode.getChildCount() == 1) {
                        String txt = cuNode.toString();
                        int st = txt.indexOf("='") + 2;
                        int ed = txt.indexOf("'", st);
                        String id2 = txt.substring(st, ed);
                        System.out.println("\u8f7d\u5165\u65b0\u6570\u636e:" + id2);
                        try {
                            IRowSet rs = Inspector.this.getRowSet(id2);
                            String tableName = KSqlHelper.getTableNameById(id).toUpperCase();
                            EntityVO evo = FMIsqlUI.tablesCache.get(tableName);
                            Inspector.this.addChildNode(rs, evo, cuNode);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        System.out.println("\u5df2\u52a0\u8f7d\u4e86:" + cuNode.getChildCount() + "\u4e2a\u6570\u636e");
                    }
                    Inspector.this.tree.repaint();
                }
            }
        });
        TreeModel md = this.getTreeModel(id);
        this.tree.setModel(md);
        this.tree.setCellRenderer(new MyTreeCellRender());
    }

    protected void filter_txt() {
        this.tree.repaint();
    }

    private TreeModel getTreeModel(String id) throws SQLException, EASBizException, BOSException {
        IRowSet rs = this.getRowSet(id);
        String tableName = KSqlHelper.getTableNameById(id).toUpperCase();
        EntityVO evo = FMIsqlUI.tablesCache.get(tableName);
        DefaultMutableTreeNode node_fid = new DefaultMutableTreeNode(MessageFormat.format("FID=''{0}'' ({1}, {2})", id, evo.entityAlias, tableName));
        this.addChildNode(rs, evo, node_fid);
        return new DefaultTreeModel(node_fid);
    }

    private void addChildNode(IRowSet rs, EntityVO evo, DefaultMutableTreeNode node_fid) throws SQLException {
        if (rs.next()) {
            ResultSetMetaData meta = rs.getMetaData();
            int c = meta.getColumnCount();
            for (int i = 1; i <= c; ++i) {
                String fmtStr = "{0}={1}    {2} {3}";
                String rsfname = meta.getColumnName(i);
                if (rsfname.equalsIgnoreCase("fid")) continue;
                if ((i - 1) % 7 == 0) {
                    node_fid.add(new DefaultMutableTreeNode(null));
                }
                switch (meta.getColumnType(i)) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        fmtStr = "{0}=''{1}''    {2} {3}";
                        break;
                    }
                }
                FieldVO f = evo.fields.get(rsfname.toUpperCase());
                String falias = f == null || f.fieldAlias == null ? "" : "[" + f.fieldAlias + "]";
                String rsValue = rs.getString(i);
                String tabnameInfields = "";
                boolean isFid = false;
                if (!EmptyUtil.isEmpty((String)rsValue) && KSqlHelper.isBOSFidType(rsValue)) {
                    isFid = true;
                    tabnameInfields = KSqlHelper.getTableNameById(rsValue);
                    tabnameInfields = tabnameInfields == null ? "" : " (" + FMIsqlUI.tablesCache.get((Object)tabnameInfields.toUpperCase()).entityAlias + ", " + tabnameInfields + ")";
                }
                DefaultMutableTreeNode nodef = new DefaultMutableTreeNode(MessageFormat.format(fmtStr, rsfname, rsValue == null ? "" : rsValue, falias, tabnameInfields));
                if (isFid) {
                    nodef.add(new DefaultMutableTreeNode(MessageFormat.format("FID=''{0}''", rsValue == null ? "" : rsValue)));
                }
                node_fid.add(nodef);
            }
        }
    }

    public IRowSet getRowSet(String id) throws BOSException, EASBizException {
        String tableName = KSqlHelper.getTableNameById(id);
        String sql = "select * from " + tableName + " where fid ='" + id + "'";
        IFMIsqlFacade isql = FMIsqlFacadeFactory.getRemoteInstance();
        SqlResult rs = isql.executeSql(sql);
        if (rs.getRowSets().size() != 1) {
            return null;
        }
        return (IRowSet)rs.getRowSets().get(0);
    }
}

