/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.common.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.util.editor.StyledEditor;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.EntityVO;
import com.kingdee.eas.fm.common.client.FMIsqlUI;
import com.kingdee.eas.fm.common.client.FieldVO;
import com.kingdee.eas.fm.common.client.KSqlHelper;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

class MyStyledEditor
extends StyledEditor
implements DropTargetListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5328092058321722192L;
    FMIsqlUI sqlui;
    Timer timer = new Timer("EditorHoverTimer", true);
    boolean hoveringEnable = false;
    Point oldMousePoint;
    int oldDotPot;
    Rectangle oldtxtRect;
    private Object locker = new Object();
    public static String DELIMCHAR_NO_QUETO = "()*<>'`[], \n\r\f\t";
    public static String DELIMCHAR = DELIMCHAR_NO_QUETO + "\"";
    public static String BOSFIDSPECIALCHAR = "+=/-";

    public MyStyledEditor(FMIsqlUI sqlui) {
        new DropTarget((Component)((Object)this), 1, this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.sqlui = sqlui;
        this.setTimer();
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.hoveringEnable = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.hoveringEnable = false;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.hoveringEnable = true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hoveringEnable = true;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hoveringEnable = false;
    }

    protected void setTimer() {
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MyStyledEditor.this.sqlui.isCacheLoading || !MyStyledEditor.this.hoveringEnable || !MyStyledEditor.this.sqlui.ctrlpressed) {
                    return;
                }
                Object object = MyStyledEditor.this.locker;
                synchronized (object) {
                    MyStyledEditor.this.hoveringEnable = false;
                    try {
                        MyStyledEditor.this.activeGrabText();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MyStyledEditor.this.hoveringEnable = true;
                }
            }
        }, 2000L, 200L);
    }

    protected void activeGrabText() throws BadLocationException {
        Point curMousePot = this.sqlui.txtScript.getMousePosition();
        int curDotPot = -1;
        try {
            curDotPot = this.viewToModel(curMousePot);
        }
        catch (Exception e) {
            return;
        }
        if (curDotPot == -1 || curMousePot == null || curMousePot.equals(this.oldMousePoint)) {
            return;
        }
        this.oldMousePoint = curMousePot;
        if (curDotPot == -1 || curDotPot == this.oldDotPot) {
            return;
        }
        this.oldDotPot = curDotPot;
        String curtxt = this.getText(curDotPot, 1);
        Rectangle txtRect = new Rectangle();
        String txt = this.getGrabTextAndRectangleAtDot(curDotPot, txtRect);
        if (!txtRect.contains(curMousePot.x, curMousePot.y)) {
            return;
        }
        if (txtRect.equals(this.oldtxtRect)) {
            return;
        }
        this.oldtxtRect = txtRect;
        Point showPt = txtRect.getLocation();
        SwingUtilities.convertPointToScreen(showPt, (Component)this.sqlui.txtScript);
        showPt.y += txtRect.height - 5;
        this.fireHoveringOnTxt(txt, showPt, curDotPot);
    }

    protected String getGrabTextAndRectangleAtDot(int dot, Rectangle rec) throws BadLocationException {
        int stp;
        int cp = dot;
        int edp = cp;
        int max = this.getText().length();
        for (stp = cp - 1; stp > 0 && DELIMCHAR_NO_QUETO.indexOf(this.getText(stp, 1)) <= -1; --stp) {
        }
        while (edp < max && DELIMCHAR_NO_QUETO.indexOf(this.getText(edp, 1)) <= -1) {
            ++edp;
        }
        String txt = "";
        txt = this.getText(stp + 1, edp - stp - 1);
        System.out.println("hoving on:" + txt);
        boolean isFid = KSqlHelper.isBOSFidType(txt);
        if (this.hasBOSFidChar(txt) && !isFid) {
            int selindex = cp - stp;
            StringTokenizer tks = new StringTokenizer(txt, DELIMCHAR + BOSFIDSPECIALCHAR + " ", true);
            int courtLen = 0;
            while (tks.hasMoreTokens()) {
                String s = tks.nextToken();
                if ((courtLen += s.length()) <= selindex) continue;
                txt = s;
                break;
            }
        }
        if (rec != null && !EmptyUtil.isEmpty((String)txt)) {
            Rectangle stRect = this.modelToView(stp + 1);
            Rectangle txtRect = new Rectangle(stRect);
            Rectangle edRect = this.modelToView(stp + txt.length() + 1);
            txtRect.setSize(edRect.x + edRect.width - stRect.x, stRect.height);
            rec.x = txtRect.x;
            rec.y = txtRect.y;
            rec.width = txtRect.width;
            rec.height = txtRect.height;
        }
        return txt;
    }

    public boolean hasBOSFidChar(String txt) {
        if (txt == null || txt.length() == 0) {
            return false;
        }
        for (int i = 0; i < BOSFIDSPECIALCHAR.length(); ++i) {
            char c = BOSFIDSPECIALCHAR.charAt(i);
            if (txt.indexOf(c) <= -1) continue;
            return true;
        }
        return false;
    }

    protected void fireHoveringOnTxt(String newTxt, Point p, int currentDot) {
        this.onHoveringTextChanged(newTxt, p, currentDot);
    }

    public void onHoveringTextChanged(String newTxt, Point p, int currentDot) {
        if (newTxt.length() == 1 && DELIMCHAR.indexOf(newTxt.charAt(0)) > -1) {
            this.sqlui.closeHint();
        } else {
            this.handleContext(p, newTxt, currentDot);
        }
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        DataFlavor[] flavors = transferable.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor d = flavors[i];
            try {
                if (!d.equals(DataFlavor.stringFlavor)) continue;
                String src = (String)transferable.getTransferData(d);
                int pos = this.viewToModel(event.getLocation());
                this.getDocument().insertString(pos, src, null);
                this.setCaretPosition(pos + src.length());
                this.grabFocus();
                this.sqlui.closeHint();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        event.dropComplete(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        int p = this.viewToModel(dtde.getLocation());
        this.grabFocus();
        this.setCaretPosition(p);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.hoveringEnable = e.getModifiers() == 2;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        String txt;
        if (e.getModifiers() == 16 && e.getClickCount() == 1 && e.getButton() == 1) {
            try {
                this.getHighlighter().removeAllHighlights();
                int curp = this.getCaretPosition();
                int txtlength = this.getText().length();
                txt = this.getCharBeforeAtDot(curp);
                curp = this.matchBracket(curp, txtlength, txt, "(", ")");
                curp = this.matchBracket(curp, txtlength, txt, "{", "}");
                curp = this.matchBracket(curp, txtlength, txt, "[", "]");
            }
            catch (BadLocationException curp) {
                // empty catch block
            }
        }
        this.sqlui.closeHint();
        this.oldtxtRect = null;
        if (e.getButton() == 3 && e.getClickCount() == 1) {
            int curDotPot = this.viewToModel(new Point(e.getX(), e.getY()));
            Rectangle txtRect = new Rectangle();
            try {
                txt = this.getGrabTextAndRectangleAtDot(curDotPot, txtRect);
                Point showPt = txtRect.getLocation();
                SwingUtilities.convertPointToScreen(showPt, (Component)this.sqlui.txtScript);
                showPt.y += txtRect.height - 5;
                this.fireHoveringOnTxt(txt, showPt, curDotPot);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        }
    }

    private int matchBracket(int curp, int txtlength, String txt, String leftB, String rightB) throws BadLocationException {
        if (txt.equals(leftB)) {
            int match = 1;
            do {
                String s;
                if (rightB.equals(s = this.getCharBeforeAtDot(++curp))) {
                    --match;
                    continue;
                }
                if (!leftB.equals(s)) continue;
                ++match;
            } while (match != 0 && curp < txtlength);
            if (match == 0) {
                this.setHighlight(curp - 1, curp, null, true);
            }
        } else if (txt.equals(rightB)) {
            int match = 1;
            do {
                String s;
                if (leftB.equals(s = this.getCharBeforeAtDot(--curp))) {
                    --match;
                    continue;
                }
                if (!rightB.equals(s)) continue;
                ++match;
            } while (match != 0 && curp > 0);
            if (match == 0) {
                this.setHighlight(curp - 1, curp, null, true);
            }
        }
        return curp;
    }

    public String getCharBeforeAtDot(int pos) {
        try {
            return this.getText(pos - 1, 1);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public String getCharAfterAtDot(int pos) {
        try {
            return this.getText(pos, 1);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public Object setHighlight(int pstart, int pend, Highlighter.HighlightPainter p, boolean removeAllHighlight) throws BadLocationException {
        p = p == null ? DefaultHighlighter.DefaultPainter : p;
        Highlighter h = this.getHighlighter();
        if (removeAllHighlight) {
            h.removeAllHighlights();
        }
        return h.addHighlight(pstart, pend, p);
    }

    protected void handleContext(Point p, String txt, int currentDot) {
        String tableName2;
        String uuid = txt;
        BOSObjectType bosType = null;
        try {
            bosType = BOSUuid.read((String)uuid).getType();
        }
        catch (UuidException uuidException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (bosType != null) {
            try {
                tableName2 = FMIsqlFacadeFactory.getRemoteInstance().getTableNameByBosType(bosType);
                EntityVO evo = FMIsqlUI.tablesCache.get(tableName2.toUpperCase(Locale.ENGLISH));
                if (null != evo) {
                    String tabName = evo.tableName;
                    String tabAlias = evo.entityAlias;
                    String showText = tabAlias + " (" + tabName + ")";
                    this.sqlui.popHint(p, FMIsqlUI.HINTTYPE.HOVING_FID, txt, showText, false);
                }
            }
            catch (BOSException tableName2) {}
        } else if (txt.length() == 8) {
            try {
                tableName2 = FMIsqlFacadeFactory.getRemoteInstance().getTableNameByBosType(BOSObjectType.create((String)txt));
                EntityVO evo = FMIsqlUI.tablesCache.get(tableName2.toUpperCase(Locale.ENGLISH));
                if (null != evo) {
                    String tabName = evo.tableName;
                    String tabAlias = evo.entityAlias;
                    this.sqlui.popHelp(p, FMIsqlUI.HINTTYPE.TABLE, "", tabAlias + " (" + tabName + ")", false);
                }
            }
            catch (BOSException tableName3) {}
        } else if (!"WHERE".equalsIgnoreCase(txt)) {
            txt = txt.toUpperCase(Locale.ENGLISH);
            boolean hasPeriod = false;
            String las = "";
            String pre = "";
            if (txt.matches("((\".*\")|\\w+)[.](\\w|[^.])*")) {
                int mid = txt.lastIndexOf(".");
                pre = txt.substring(0, mid).toUpperCase(Locale.ENGLISH);
                las = txt.substring(mid + 1).toUpperCase(Locale.ENGLISH);
                hasPeriod = true;
            } else {
                las = txt.toUpperCase(Locale.ENGLISH);
            }
            String sql = this.sqlui.getCurrentSqlAtDot(currentDot);
            HashMap<String, String> aliasTabs = this.sqlui.getTableNameAndAlias(sql);
            if (hasPeriod) {
                if (EmptyUtil.isEmpty((String)las)) {
                    return;
                }
                String tabName = aliasTabs.get(pre);
                EntityVO evo = FMIsqlUI.tablesCache.get(tabName);
                if (!EmptyUtil.isEmpty((Object)evo)) {
                    FieldVO fvo;
                    String tabAlias = evo.entityAlias;
                    if (las.endsWith("_L1") || las.endsWith("_L2") || las.endsWith("_L3")) {
                        las = las.substring(0, las.length() - 3);
                    }
                    if (EmptyUtil.isEmpty((Object)(fvo = evo.fields.get(las)))) {
                        return;
                    }
                    this.sqlui.popHelp(p, FMIsqlUI.HINTTYPE.FIELD, "", fvo.fieldAlias + "(" + fvo.fieldName + ") in " + tabAlias + " (" + tabName + " as " + pre + ")", false);
                }
            } else {
                EntityVO evo = FMIsqlUI.tablesCache.get(txt);
                if (!EmptyUtil.isEmpty((Object)evo)) {
                    String tabAlias = evo.entityAlias;
                    this.sqlui.popHelp(p, FMIsqlUI.HINTTYPE.TABLE, "", tabAlias + " (" + txt + ")", false);
                    return;
                }
                String tabName = aliasTabs.get(las);
                if (!EmptyUtil.isEmpty((String)tabName)) {
                    evo = FMIsqlUI.tablesCache.get(tabName);
                    if (EmptyUtil.isEmpty((Object)evo)) {
                        return;
                    }
                    String tabAlias = evo.entityAlias;
                    this.sqlui.popHelp(p, FMIsqlUI.HINTTYPE.TABLE, "", tabAlias + " (" + tabName + " as " + txt + ")", false);
                    return;
                }
                for (String tabName2 : aliasTabs.values()) {
                    FieldVO fvo;
                    evo = FMIsqlUI.tablesCache.get(tabName2);
                    if (EmptyUtil.isEmpty((Object)evo)) continue;
                    String tabAlias = evo.entityAlias;
                    if (las.endsWith("_L1") || las.endsWith("_L2") || las.endsWith("_L3")) {
                        las = las.substring(0, las.length() - 3);
                    }
                    if (EmptyUtil.isEmpty((Object)(fvo = evo.fields.get(las)))) continue;
                    this.sqlui.popHelp(p, FMIsqlUI.HINTTYPE.FIELD, "", fvo.fieldAlias + "(" + fvo.fieldName + ") in " + tabAlias + " (" + tabName2 + ")", false);
                    return;
                }
            }
        }
    }
}

