/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangArea;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.IRefChecker;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.FinancingSourcesCollection;
import com.kingdee.eas.fm.fin.FinancingSourcesFactory;
import com.kingdee.eas.fm.fin.FinancingSourcesInfo;
import com.kingdee.eas.fm.fin.IFinancingProducts;
import com.kingdee.eas.fm.fin.client.AbstractFinancingProductsEditUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class FinancingProductsEditUI
extends AbstractFinancingProductsEditUI {
    private String[] protectNum = new String[]{"005", "009", "008", "010", "011", "in001", "in002", "in003"};
    private static final Logger logger = CoreUIObject.getLogger(FinancingProductsEditUI.class);

    public FinancingProductsEditUI() throws Exception {
        this.fillFinSourceCombo(this.comboFinSource);
    }

    @Override
    public void loadFields() {
        UIUtil.setSelectObject((KDComboBox)this.comboFinSource, (Object)this.editData.getFinancingSource());
        this.BillType.removeAllItems();
        this.BillType.addItem((Object)FinancingBillTypeEnum.Loan);
        this.BillType.addItem((Object)FinancingBillTypeEnum.BONDS);
        super.loadFields();
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        if (this.editData.getBillType() != null && FinancingBillTypeEnum.Loan.equals((Object)this.editData.getBillType())) {
            this.chkIsConsingnLoanDefault.setEnabled(true);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        CoreBaseInfo info = (CoreBaseInfo)this.getDataObject();
        try {
            this.doCheck(info);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void doCheck(CoreBaseInfo info) throws BOSException, BizReferenceException {
        FinancingProductsInfo fpinfo = (FinancingProductsInfo)info;
        IRefChecker checker = RefCheckerFactory.getRemoteInstance();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            UIUtil.setComponentEnable((JComponent)((Object)this), (boolean)true);
            this.chkIsFinLoanDef.setEnabled(fpinfo.getBillType().equals((Object)FinancingBillTypeEnum.Loan));
            this.chkIsIvtLoanDef.setEnabled(fpinfo.getBillType().equals((Object)FinancingBillTypeEnum.Loan));
            if (checker.isReferenced(info.getId())) {
                this.txtNumber.setEnabled(false);
                this.comboFinSource.setEnabled(false);
                this.prmtNoteType.setEnabled(false);
            }
            for (int i = 0; i < this.protectNum.length; ++i) {
                if (!this.txtNumber.getText().equals(this.protectNum[i])) continue;
                this.txtNumber.setEnabled(false);
                this.prmtNoteType.setEnabled(false);
                this.comboFinSource.setEnabled(false);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDMultiLangBox)this.txtName);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.txtNumber);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.comboFinSource);
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, this.BillType);
        super.verifyInput(e);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingProductsFactory.getRemoteInstance();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        if ("ADDNEW".equals(this.getOprtState())) {
            FinancingSourcesInfo fs = (FinancingSourcesInfo)this.getUIContext().get("ParentNode");
            this.editData.setFinancingSource(fs);
            this.editData.setBillType(FinancingBillTypeEnum.Loan);
        }
    }

    private void fillFinSourceCombo(KDComboBox combo) throws BOSException {
        FinancingSourcesCollection coll = FinancingSourcesFactory.getRemoteInstance().getFinancingSourcesCollection();
        combo.removeAllItems();
        combo.addItems(coll.toArray());
    }

    public void onLoad() throws Exception {
        this.comboFinSource.setEditable(false);
        this.comboFinSource.setEnabled(false);
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
            super.onLoad();
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        this.initPrmtParent();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            EntityViewInfo view = this.prmtParent.getEntityViewInfo();
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
            view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(this.editData.getNumber() + "!%"), CompareType.NOTLIKE));
        }
        if (this.editData.getParent() != null && this.getOprtState().equals(OprtState.EDIT)) {
            this.prmtParent.setValue((Object)this.editData.getParent());
            UIUtil.setSelectObject((KDComboBox)this.comboFinSource, (Object)this.editData.getFinancingSource());
            this.comboFinSource.setEnabled(false);
            this.comboFinSource.setEditable(false);
        } else {
            this.comboFinSource.setEnabled(true);
            this.comboFinSource.setEditable(false);
        }
        this.contNoteType.setVisible(false);
    }

    private void initBillType() {
        this.BillType.removeAllItems();
        this.BillType.addItem((Object)FinancingBillTypeEnum.Loan);
        this.chkIsConsingnLoanDefault.setEnabled(true);
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingProductsInfo objectValue = new FinancingProductsInfo();
        objectValue.setCreator(ContextHelperFactory.getRemoteInstance().getCurrentUser());
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("FinancingSource.*"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("BillType"));
        sic.add(new SelectorItemInfo("NoteType.*"));
        sic.add(new SelectorItemInfo("isFinLoanDefault"));
        sic.add(new SelectorItemInfo("isIvtLoanDefault"));
        sic.add(new SelectorItemInfo("isConsingnLoanDefault"));
        sic.add(new SelectorItemInfo("isBondsDefault"));
        sic.add(new SelectorItemInfo("parent.*"));
        return sic;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        if (this.txtNumber.getText().equals(null) && KDBizMultiLangBox.getLanguageList().get(0).toString().equals(null) && this.comboFinSource.getSelectedItem().toString().equals(null) && this.prmtNoteType.getSelectorCollection().toString().equals(null) && KDBizMultiLangArea.getLanguageList().get(0).equals(null)) {
            this.BillType.setSelectedIndex(-1);
        }
        super.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
    }

    @Override
    protected void BillType_itemStateChanged(ItemEvent e) throws Exception {
        if (this.BillType.getSelectedItem() != null) {
            this.chkIsConsingnLoanDefault.setSelected(false);
            this.chkIsFinLoanDef.setSelected(false);
            this.chkIsIvtLoanDef.setSelected(false);
            this.chkIsBond.setSelected(false);
            if (FinancingBillTypeEnum.Loan.equals(this.BillType.getSelectedItem())) {
                this.chkIsConsingnLoanDefault.setEnabled(true);
                this.chkIsFinLoanDef.setEnabled(true);
                this.chkIsIvtLoanDef.setEnabled(true);
                this.chkIsBond.setEnabled(false);
            } else if (FinancingBillTypeEnum.BONDS.equals(this.BillType.getSelectedItem())) {
                this.chkIsConsingnLoanDefault.setEnabled(false);
                this.chkIsFinLoanDef.setEnabled(false);
                this.chkIsIvtLoanDef.setEnabled(false);
                this.chkIsBond.setEnabled(true);
            }
        } else {
            this.chkIsConsingnLoanDefault.setEnabled(false);
        }
        this.initPrmtParent();
    }

    protected void initPrmtParent() throws Exception {
        IFinancingProducts a = (IFinancingProducts)this.getBizInterface();
        Set set = a.getReferenceCollection();
        set.add("1111111");
        FilterInfo filter = new FilterInfo();
        if (this.comboFinSource.getSelectedItem() != null) {
            FinancingSourcesInfo fsi = (FinancingSourcesInfo)this.comboFinSource.getSelectedItem();
            filter.getFilterItems().add(new FilterItemInfo("FinancingSource.id", (Object)fsi.getId(), CompareType.EQUALS));
        }
        if (this.BillType.getSelectedItem() != null) {
            FinancingBillTypeEnum billTypeEnum = (FinancingBillTypeEnum)((Object)this.BillType.getSelectedItem());
            filter.getFilterItems().add(new FilterItemInfo("BillType", (Object)billTypeEnum.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        this.prmtParent.setEntityViewInfo(view);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtParent = new KDBizPromptBox();
        this.add((Component)this.prmtParent);
        this.kDLabelContainer3.setBoundEditor((JComponent)this.prmtParent);
        this.dataBinder.registerBinding("parent", FinancingProductsInfo.class, (Component)this.prmtParent, "data");
        this.prmtParent.setName("prmtParent");
        this.prmtParent.setQueryInfo("com.kingdee.eas.fm.fin.app.F7FinancingProductsQuery");
        this.prmtParent.setEditFormat("$number$");
        this.prmtParent.setCommitFormat("$number$");
        this.prmtParent.setDisplayFormat("$name$");
        this.prmtParent.setRequired(false);
        this.prmtParent.setEditable(false);
        this.comboFinSource.setEditable(false);
        this.comboFinSource.setEnabled(false);
        this.prmtParent.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    FinancingProductsEditUI.this.prmtParent_dataChanged(e);
                }
                catch (Exception exc) {
                    FinancingProductsEditUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    protected void prmtParent_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtParent.getValue();
        if (this.prmtParent.getValue() != null) {
            FinancingProductsInfo f = (FinancingProductsInfo)this.prmtParent.getValue();
            UIUtil.setSelectObject((KDComboBox)this.comboFinSource, (Object)f.getFinancingSource());
            this.comboFinSource.setEnabled(false);
            this.comboFinSource.setEditable(false);
        } else {
            this.comboFinSource.setEnabled(true);
        }
    }

    @Override
    protected void comboFinSource_itemStateChanged(ItemEvent e) throws Exception {
        this.initPrmtParent();
    }

    @Override
    protected void chkIsBond_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkIsBond.isSelected()) {
            this.BillType.setSelectedItem((Object)FinancingBillTypeEnum.BONDS);
        }
    }
}

