/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.base.ITechPostType;
import com.kingdee.eas.hr.base.ITechnicalPost;
import com.kingdee.eas.hr.base.TechPostTypeCollection;
import com.kingdee.eas.hr.base.TechPostTypeFactory;
import com.kingdee.eas.hr.base.TechPostTypeInfo;
import com.kingdee.eas.hr.base.TechnicalPostCollection;
import com.kingdee.eas.hr.base.TechnicalPostFactory;
import com.kingdee.eas.hr.base.TechnicalPostInfo;
import com.kingdee.eas.hr.base.client.AbstractStandardTechPostUI;
import com.kingdee.eas.hr.base.client.TechnicalPostUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class StandardTechPostUI
extends AbstractStandardTechPostUI {
    private TechnicalPostCollection postCols = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.CreateTechPostTree();
        this.treeMain.getSelectionModel().setSelectionMode(2);
        this.treeMain.setShowCheckBox(true);
        this.btnYes.setEnabled(true);
        this.btnExit.setEnabled(true);
        TreePath path = new TreePath(((DefaultTreeModel)this.treeMain.getModel()).getRoot());
        this.treeMain.setSelectionPath(path);
    }

    private void CreateTechPostTree() throws BOSException {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.base.core.hr.base.TechPostResource.TECHNICALPOST_TYPE"));
        root.setCheckBoxVisible(false);
        TechPostTypeCollection cols = this.getTechPostTypeCollection();
        TechnicalPostCollection infos = this.getTechnicalPostCollection();
        for (int i = 0; i < cols.size(); ++i) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setUserObject((Object)cols.get(i));
            node.setCheckBoxVisible(false);
            this.setTechnicalPostNode(node, cols.get(i), infos);
            root.add((MutableTreeNode)node);
        }
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)model);
    }

    private void setTechnicalPostNode(DefaultKingdeeTreeNode node, TechPostTypeInfo typeInfo, TechnicalPostCollection infos) throws BOSException {
        for (int i = 0; i < infos.size(); ++i) {
            if (infos.get(i).getCategory() == null || !infos.get(i).getCategory().getId().toString().equals(typeInfo.getId().toString())) continue;
            DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
            newNode.setUserObject((Object)infos.get(i));
            node.add((MutableTreeNode)newNode);
        }
    }

    private TechnicalPostCollection getTechnicalPostCollection() throws BOSException {
        ITechnicalPost iType = TechnicalPostFactory.getRemoteInstance();
        String strQl = "select id,name,category.id,category.number where isStandard=1";
        TechnicalPostCollection techCols = iType.getTechnicalPostCollection(strQl);
        return techCols;
    }

    private TechPostTypeCollection getTechPostTypeCollection() throws BOSException {
        String strQl = "select * where isStandard=1";
        ITechPostType iType = TechPostTypeFactory.getRemoteInstance();
        TechPostTypeCollection techCols = iType.getTechPostTypeCollection(strQl);
        return techCols;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return TechnicalPostUI.class.getName().toString();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.postCols = null;
        this.getUIWindow().close();
    }

    @Override
    public void actionYes_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedIdValues().size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.core.hr.base.TechPostResource.MUST_SELECT_TECHNICAL"));
            return;
        }
        this.getTechnicalCollection();
        this.getUIWindow().close();
    }

    private ArrayList getSelectedIdValues() {
        ArrayList list = new ArrayList();
        this.getChildrenNodes((DefaultKingdeeTreeNode)this.treeMain.getModel().getRoot(), list);
        for (int i = 0; i < list.size(); ++i) {
            if (((DefaultKingdeeTreeNode)list.get(i)).getUserObject() instanceof TechnicalPostInfo) continue;
            list.remove(i);
        }
        return list;
    }

    private void getChildrenNodes(DefaultKingdeeTreeNode parent, ArrayList nodeList) {
        Enumeration enum0 = parent.children();
        if (enum0.hasMoreElements()) {
            while (enum0.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enum0.nextElement();
                if (node.isChecked()) {
                    nodeList.add(node);
                }
                this.getChildrenNodes(node, nodeList);
            }
        }
    }

    private void getTechnicalCollection() throws BOSException {
        ArrayList list = this.getSelectedIdValues();
        HashSet<BOSUuid> sets = new HashSet<BOSUuid>();
        for (int i = 0; i < list.size(); ++i) {
            sets.add(((TechnicalPostInfo)((DefaultKingdeeTreeNode)list.get(i)).getUserObject()).getId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sets, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("category.name"));
        view.getSelector().add(new SelectorItemInfo("category.number"));
        view.getSelector().add(new SelectorItemInfo("category.description"));
        ITechnicalPost iTech = TechnicalPostFactory.getRemoteInstance();
        this.postCols = iTech.getTechnicalPostCollection(view);
    }

    public TechnicalPostCollection getReturnTechnicalCollection() {
        return this.postCols;
    }
}

