/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DirectoryEmptyStrings;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPConnectMode;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileFactory;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileNotFoundStrings;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.MLSXEntryParser;
import com.enterprisedt.net.ftp.TransferCompleteStrings;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.VersionDetails;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.internal.SocketUtils;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.safe.SafeCheckUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;

public class FTPClient
implements FTPClientInterface {
    public static String cvsId = "@(#)$Id: FTPClient.java,v 1.1 2008-12-16 05:14:15 pengxu_ge Exp $";
    public static final int DEFAULT_MONITOR_INTERVAL = 65535;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_PORT = 65535;
    public static final int DEFAULT_TIMEOUT = 300000;
    private static final int SHORT_TIMEOUT = 500;
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static final String SOCKS_PORT = "socksProxyPort";
    private static final String SOCKS_HOST = "socksProxyHost";
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    public static final byte CARRIAGE_RETURN = 13;
    public static final byte LINE_FEED = 10;
    public static final byte[] FTP_LINE_SEPARATOR = new byte[]{13, 10};
    private static final String STOU_FILENAME_MARKER = "FILE:";
    private static final String STORE_CMD = "STOR ";
    private static final String STORE_UNIQ_CMD = "STOU ";
    private static final String MODTIME_STR = "modtime";
    public static Locale[] DEFAULT_LISTING_LOCALES;
    private static Logger log;
    private SimpleDateFormat tsFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    protected FTPControlSocket control = null;
    protected FTPDataSocket data = null;
    protected int timeout = 300000;
    protected int serverWakeupInterval = 0;
    protected InetAddress remoteAddr;
    protected String remoteHost;
    protected String id;
    private static int masterId;
    protected int controlPort = 21;
    private boolean autoPassiveIPSubstitution = false;
    private String activeIP = null;
    protected String controlEncoding = "US-ASCII";
    private boolean strictReturnCodes = false;
    protected DirectoryEmptyStrings dirEmptyStrings = new DirectoryEmptyStrings();
    protected TransferCompleteStrings transferCompleteStrings = new TransferCompleteStrings();
    protected FileNotFoundStrings fileNotFoundStrings = new FileNotFoundStrings();
    private boolean cancelTransfer = false;
    private boolean resume = false;
    private boolean mdtmSupported = true;
    private boolean sizeSupported = true;
    private long resumeMarker = 0L;
    private boolean deleteOnFailure = true;
    protected boolean detectTransferMode = false;
    private int lowPort = -1;
    private int highPort = -1;
    private String storeCommand = "STOR ";
    protected long monitorInterval = 65535L;
    protected int transferBufferSize = 16384;
    private int downloadCount = 0;
    private int uploadCount = 0;
    private int deleteCount = 0;
    private boolean listenOnAllInterfaces = true;
    private FTPFileFactory fileFactory = null;
    private Locale[] listingLocales;
    private MLSXEntryParser mlsxParser = new MLSXEntryParser();
    protected FTPProgressMonitor monitor = null;
    protected FTPMessageListener messageListener = null;
    protected FTPProgressMonitorEx monitorEx = null;
    protected FTPTransferType transferType = FTPTransferType.ASCII;
    private FTPConnectMode connectMode = FTPConnectMode.PASV;
    protected FTPReply lastValidReply;
    protected FTPReply lastReply;

    public static int[] getVersion() {
        return VersionDetails.getVersion();
    }

    public static String getBuildTimestamp() {
        return VersionDetails.getBuildTimestamp();
    }

    public FTPClient(String remoteHost) throws IOException, FTPException {
        this(remoteHost, 21, 0);
    }

    public FTPClient(String remoteHost, int controlPort) throws IOException, FTPException {
        this(remoteHost, controlPort, 0);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout);
    }

    public FTPClient(String remoteHost, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, encoding);
    }

    public FTPClient(InetAddress remoteAddr) throws IOException, FTPException {
        this(remoteAddr, 21, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort) throws IOException, FTPException {
        this(remoteAddr, controlPort, 0);
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, DEFAULT_ENCODING, null));
    }

    public FTPClient(InetAddress remoteAddr, int controlPort, int timeout, String encoding) throws IOException, FTPException {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        if (controlPort < 0) {
            controlPort = 21;
        }
        this.initialize(new FTPControlSocket(remoteAddr, controlPort, timeout, encoding, null));
    }

    public FTPClient() {
        this.tsFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.listingLocales = DEFAULT_LISTING_LOCALES;
        this.id = Integer.toString(++masterId);
        log.debug(VersionDetails.report(this));
    }

    @Override
    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        log.debug("Connecting to " + this.remoteAddr + ":" + this.controlPort);
        this.initialize(new FTPControlSocket(this.remoteAddr, this.controlPort, this.timeout, this.controlEncoding, this.messageListener));
    }

    @Override
    public boolean connected() {
        if (this.control == null) {
            return false;
        }
        try {
            if (!SocketUtils.isConnected(this.control.controlSock)) {
                this.control = null;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        System.out.println("FTPClient::checkConnection()--shouldBeConnected=" + shouldBeConnected + ",connected=" + this.connected());
        if (shouldBeConnected && !this.connected()) {
            throw new FTPException("The FTP client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.connected()) {
            throw new FTPException("The FTP client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    protected void initialize(FTPControlSocket control) throws IOException {
        this.control = control;
        control.setMessageListener(this.messageListener);
        control.setStrictReturnCodes(this.strictReturnCodes);
        control.setListenOnAllInterfaces(this.listenOnAllInterfaces);
        control.setTimeout(this.timeout);
        control.setAutoPassiveIPSubstitution(this.autoPassiveIPSubstitution);
        if (this.activeIP != null) {
            control.setActivePortIPAddress(this.activeIP);
        }
        if (this.lowPort > 0 && this.highPort > 0) {
            control.setActivePortRange(this.lowPort, this.highPort);
        }
    }

    public void debugResponses(boolean on) {
        if (on) {
            Logger.setLevel(Level.DEBUG);
        } else {
            Logger.setLevel(Level.OFF);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getDownloadCount() {
        return this.downloadCount;
    }

    @Override
    public void resetDownloadCount() {
        this.downloadCount = 0;
    }

    @Override
    public int getUploadCount() {
        return this.uploadCount;
    }

    @Override
    public void resetUploadCount() {
        this.uploadCount = 0;
    }

    @Override
    public int getDeleteCount() {
        return this.deleteCount;
    }

    @Override
    public void resetDeleteCount() {
        this.deleteCount = 0;
    }

    public void setStrictReturnCodes(boolean strict) {
        this.strictReturnCodes = strict;
        if (this.control != null) {
            this.control.setStrictReturnCodes(strict);
        }
    }

    public boolean isStrictReturnCodes() {
        return this.strictReturnCodes;
    }

    public void setListenOnAllInterfaces(boolean listenOnAll) {
        this.listenOnAllInterfaces = listenOnAll;
        if (this.control != null) {
            this.control.setListenOnAllInterfaces(listenOnAll);
        }
    }

    public boolean getListenOnAllInterfaces() {
        return this.listenOnAllInterfaces;
    }

    public FileNotFoundStrings getFileNotFoundMessages() {
        return this.fileNotFoundStrings;
    }

    public void setFileNotFoundMessages(FileNotFoundStrings fileNotFoundStrings) {
        this.fileNotFoundStrings = fileNotFoundStrings;
    }

    public TransferCompleteStrings getTransferCompleteMessages() {
        return this.transferCompleteStrings;
    }

    public void setTransferCompleteMessages(TransferCompleteStrings transferCompleteStrings) {
        this.transferCompleteStrings = transferCompleteStrings;
    }

    public DirectoryEmptyStrings getDirectoryEmptyMessages() {
        return this.dirEmptyStrings;
    }

    public void setDirectoryEmptyMessages(DirectoryEmptyStrings dirEmptyStrings) {
        this.dirEmptyStrings = dirEmptyStrings;
    }

    @Override
    public void setDetectTransferMode(boolean detectTransferMode) {
        this.detectTransferMode = detectTransferMode;
    }

    @Override
    public boolean getDetectTransferMode() {
        return this.detectTransferMode;
    }

    public void setForceUniqueNames(boolean forceUnique) {
        this.storeCommand = forceUnique ? STORE_UNIQ_CMD : STORE_CMD;
    }

    protected void chooseTransferMode(String filename) throws IOException, FTPException {
        if (this.detectTransferMode) {
            if (filename == null) {
                log.warn("Cannot choose transfer mode as filename not supplied");
                return;
            }
            if (FileTypes.ASCII.matches(filename) && this.transferType.equals(FTPTransferType.BINARY)) {
                this.setType(FTPTransferType.ASCII);
                log.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(filename) && this.transferType.equals(FTPTransferType.ASCII)) {
                this.setType(FTPTransferType.BINARY);
                log.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.timeout = millis;
        if (this.control != null) {
            this.control.setTimeout(millis);
        }
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getRemotePort() {
        return this.controlPort;
    }

    @Override
    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = remotePort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(int controlPort) throws FTPException {
        this.checkConnection(false);
        this.controlPort = controlPort;
    }

    public InetAddress getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(InetAddress remoteAddr) throws FTPException {
        this.checkConnection(false);
        this.remoteAddr = remoteAddr;
        this.remoteHost = remoteAddr.getHostName();
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public void setRemoteHost(String remoteHost) throws IOException, FTPException {
        this.checkConnection(false);
        this.remoteHost = remoteHost;
        this.remoteAddr = InetAddress.getByName(remoteHost);
    }

    public boolean isAutoPassiveIPSubstitution() {
        return this.autoPassiveIPSubstitution;
    }

    public void setAutoPassiveIPSubstitution(boolean autoPassiveIPSubstitution) {
        this.autoPassiveIPSubstitution = autoPassiveIPSubstitution;
        if (this.control != null) {
            this.control.setAutoPassiveIPSubstitution(autoPassiveIPSubstitution);
        }
    }

    public int getServerWakeupInterval() {
        return this.serverWakeupInterval;
    }

    public void setServerWakeupInterval(int interval) {
        this.serverWakeupInterval = interval;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    @Override
    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.controlEncoding = controlEncoding;
    }

    public FTPMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(FTPMessageListener listener) {
        this.messageListener = listener;
        if (this.control != null) {
            this.control.setMessageListener(listener);
        }
    }

    public FTPProgressMonitorEx getProgressMonitorEx() {
        return this.monitorEx;
    }

    public void setProgressMonitorEx(FTPProgressMonitorEx monitorEx) {
        this.monitorEx = monitorEx;
    }

    public void setConnectMode(FTPConnectMode mode) {
        this.connectMode = mode;
    }

    public FTPConnectMode getConnectMode() {
        return this.connectMode;
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.monitor = monitor;
        this.monitorInterval = interval;
    }

    @Override
    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public FTPProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    @Override
    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(long interval) {
        this.monitorInterval = interval;
    }

    public void setTransferBufferSize(int size) {
        this.transferBufferSize = size;
    }

    public int getTransferBufferSize() {
        return this.transferBufferSize;
    }

    @Override
    public void cancelTransfer() {
        this.cancelTransfer = true;
        log.warn("cancelTransfer() called");
    }

    public boolean isTransferCancelled() {
        return this.cancelTransfer;
    }

    public boolean isDeleteOnFailure() {
        return this.deleteOnFailure;
    }

    public void setDeleteOnFailure(boolean deleteOnFailure) {
        this.deleteOnFailure = deleteOnFailure;
    }

    public void setPORTIP(String IPAddress) throws FTPException {
        this.setActiveIPAddress(IPAddress);
    }

    public void setActiveIPAddress(String activeIP) throws FTPException {
        this.activeIP = activeIP;
        if (this.control != null) {
            this.control.setActivePortIPAddress(activeIP);
        }
    }

    public String getActiveIPAddress() {
        return this.activeIP;
    }

    public void setActivePortRange(int lowest, int highest) throws FTPException {
        this.lowPort = lowest;
        this.highPort = highest;
        if (lowest < 0 || lowest > highest || highest > 65535) {
            throw new FTPException("Invalid port range specified");
        }
        if (this.control != null) {
            this.control.setActivePortRange(lowest, highest);
        }
        log.debug("setActivePortRange(" + lowest + "," + highest + ")");
    }

    public int getActiveLowPort() {
        return this.lowPort;
    }

    public int getActiveHighPort() {
        return this.highPort;
    }

    public void login(String user, String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
    }

    public void login(String user, String password, String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.user(user);
        if (this.lastValidReply.getReplyCode().equals("230")) {
            return;
        }
        this.password(password);
        if (this.lastValidReply.getReplyCode().equals("332")) {
            this.account(accountInfo);
        }
    }

    public void user(String user) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("USER " + user);
        if (null != this.lastReply) {
            System.out.println("FTPClient::user()-------user =" + user + ",lastReply.getReplyCode() =" + this.lastReply.getReplyCode() + ",lastReply.getReplyText() =" + this.lastReply.getReplyText());
        }
        String[] validCodes = new String[]{"230", "331"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        if (null != this.lastValidReply) {
            System.out.println("FTPClient::user()-------user =" + user + ",lastValidReply.getReplyCode() =" + this.lastValidReply.getReplyCode() + ",lastValidReply.getReplyText() =" + this.lastValidReply.getReplyText());
        }
    }

    public void password(String password) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("PASS " + password);
        if (null != this.lastReply) {
            System.out.println("FTPClient::password()-------,lastReply.getReplyCode() =" + this.lastReply.getReplyCode() + ",lastReply.getReplyText() =" + this.lastReply.getReplyText());
        }
        String[] validCodes = new String[]{"230", "202", "332"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        if (null != this.lastValidReply) {
            System.out.println("FTPClient::password()-------lastValidReply.getReplyCode() =" + this.lastValidReply.getReplyCode() + ",lastValidReply.getReplyText() =" + this.lastValidReply.getReplyText());
        }
    }

    public void account(String accountInfo) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ACCT " + accountInfo);
        String[] validCodes = new String[]{"230", "202"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public static void initSOCKS(String port, String host) {
        Properties props = System.getProperties();
        props.put(SOCKS_PORT, port);
        props.put(SOCKS_HOST, host);
        System.setProperties(props);
    }

    public static void initSOCKSAuthentication(String username, String password) {
        Properties props = System.getProperties();
        props.put("java.net.socks.username", username);
        props.put("java.net.socks.password", password);
        System.setProperties(props);
    }

    public static void clearSOCKS() {
        Properties prop = System.getProperties();
        prop.remove(SOCKS_HOST);
        prop.remove(SOCKS_PORT);
        System.setProperties(prop);
    }

    String getRemoteHostName() {
        return this.control.getRemoteHostName();
    }

    public String quote(String command, String[] validCodes) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand(command);
        this.lastValidReply = validCodes != null ? this.control.validateReply(this.lastReply, validCodes) : this.lastReply;
        return this.lastValidReply.getReplyText();
    }

    public String quote(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastValidReply = this.control.sendCommand(command);
        return this.lastValidReply.getRawReply();
    }

    @Override
    public String executeCommand(String command) throws FTPException, IOException {
        return this.quote(command);
    }

    @Override
    public boolean exists(String remoteFile) throws IOException, FTPException {
        char ch;
        this.checkConnection(true);
        if (this.sizeSupported) {
            this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.sizeSupported = false;
            log.debug("SIZE not supported - trying MDTM");
        }
        if (this.mdtmSupported) {
            this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
            ch = this.lastReply.getReplyCode().charAt(0);
            if (ch == '2') {
                return true;
            }
            if (ch == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
                return false;
            }
            this.mdtmSupported = false;
            log.debug("MDTM not supported - trying RETR");
        }
        ServerSocket sock = new ServerSocket(0);
        short port = (short)sock.getLocalPort();
        sock.close();
        this.control.sendPORTCommand(port);
        this.lastReply = this.control.sendCommand("RETR " + remoteFile);
        char ch2 = this.lastReply.getReplyCode().charAt(0);
        if (ch2 == '1' || ch2 == '2' || ch2 == '4') {
            return true;
        }
        if (ch2 == '5' && this.fileNotFoundStrings.matches(this.lastReply.getReplyText())) {
            return false;
        }
        String msg = "Unable to determine if file '" + remoteFile + "' exists.";
        log.warn(msg);
        throw new FTPException(msg);
    }

    FTPReply readReply() throws IOException {
        return this.control.readReply();
    }

    String getPASVAddress(String pasvReply) {
        int i;
        int start = -1;
        for (i = 0; i < pasvReply.length(); ++i) {
            if (!Character.isDigit(pasvReply.charAt(i))) continue;
            start = i;
            break;
        }
        int end = -1;
        for (i = pasvReply.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(pasvReply.charAt(i))) continue;
            end = i;
            break;
        }
        if (start < 0 || end < 0) {
            return null;
        }
        return pasvReply.substring(start, end + 1);
    }

    public FTPReply sendCommand(String command) throws IOException {
        return this.control.sendCommand(command);
    }

    public void validateReply(FTPReply reply, String expectedReplyCode) throws FTPException {
        this.control.validateReply(reply, expectedReplyCode);
    }

    public void validateReply(FTPReply reply, String[] expectedReplyCodes) throws FTPException {
        this.control.validateReply(reply, expectedReplyCodes);
    }

    @Override
    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SIZE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        String replyText = this.lastValidReply.getReplyText();
        int spacePos = replyText.indexOf(32);
        if (spacePos >= 0) {
            replyText = replyText.substring(0, spacePos);
        }
        try {
            return Long.parseLong(replyText);
        }
        catch (NumberFormatException ex) {
            throw new FTPException("Failed to parse reply: " + replyText);
        }
    }

    @Override
    public void resume() throws FTPException {
        if (this.transferType.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.resume = true;
        log.info("Resume=true");
    }

    @Override
    public void cancelResume() throws IOException, FTPException {
        this.restart(0L);
        this.resume = false;
    }

    protected void forceResumeOff() {
        this.resume = false;
    }

    public void restart(long size) throws IOException, FTPException {
        this.lastReply = this.control.sendCommand("REST " + size);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
    }

    @Override
    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        return this.put(localPath, remoteFile, false);
    }

    @Override
    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        return this.put(srcStream, remoteFile, false);
    }

    @Override
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        FileInputStream srcStream = new FileInputStream(localPath);
        return this.put(srcStream, remoteFile, append);
    }

    @Override
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        Exception e = null;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.UPLOAD, remoteFile);
            }
            remoteFile = this.putData(srcStream, remoteFile, append);
            this.validateTransfer();
            ++this.uploadCount;
        }
        catch (FTPException ex) {
            e = ex;
            throw ex;
        }
        catch (IOException ex) {
            e = ex;
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
        return remoteFile;
    }

    public void validateTransfer() throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"225", "226", "250", "426", "450"};
        this.lastReply = this.control.readReply();
        String code = this.lastReply.getReplyCode();
        if ((code.equals("426") || code.equals("450")) && !this.cancelTransfer) {
            throw new FTPException(this.lastReply);
        }
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        if (this.cancelTransfer) {
            log.warn("Transfer has been cancelled!");
            throw new FTPTransferCancelledException();
        }
    }

    protected void validateTransferOnError(IOException ex) throws IOException, FTPException {
        log.debug("Validate transfer on error after exception", ex);
        this.checkConnection(true);
        this.control.setTimeout(500);
        try {
            this.validateTransfer();
        }
        catch (Exception e) {
            log.warn("Validate transfer on error failed", e);
        }
        finally {
            this.control.setTimeout(this.timeout);
        }
    }

    private void closeDataSocket() {
        if (this.data != null) {
            try {
                this.data.close();
                this.data = null;
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
    }

    protected void closeDataSocket(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    protected void closeDataSocket(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException ex) {
                log.warn("Caught exception closing data socket", ex);
            }
        }
        this.closeDataSocket();
    }

    protected void setupDataSocket() throws IOException, FTPException {
        this.data = this.control.createDataSocket(this.connectMode);
        this.data.setTimeout(this.timeout);
    }

    protected String initPut(String remoteFile, boolean append) throws IOException, FTPException {
        boolean storeUnique;
        this.checkConnection(true);
        boolean bl = storeUnique = remoteFile == null || remoteFile.length() == 0;
        if (storeUnique) {
            remoteFile = "";
            if (append) {
                String msg = "A remote filename must be supplied when appending";
                log.error(msg);
                throw new FTPException(msg);
            }
        }
        this.cancelTransfer = false;
        boolean close = false;
        try {
            this.setupDataSocket();
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                try {
                    this.resumeMarker = 0L;
                    this.resumeMarker = this.size(remoteFile);
                }
                catch (FTPException ex) {
                    log.warn("Failed to find size of file '" + remoteFile + "' for resuming (" + ex.getMessage() + ")");
                }
                this.restart(this.resumeMarker);
            }
            String cmd = append ? "APPE " : (storeUnique ? "STOU" : this.storeCommand);
            this.lastReply = this.control.sendCommand(cmd + remoteFile);
            String[] validCodes = new String[]{"125", "150", "151", "350"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
            String replyText = this.lastValidReply.getReplyText();
            if (storeUnique) {
                int pos = replyText.indexOf(STOU_FILENAME_MARKER);
                if (pos >= 0) {
                    remoteFile = replyText.substring(pos += STOU_FILENAME_MARKER.length()).trim();
                } else {
                    log.debug("Could not find FILE: in reply - using last word instead.");
                    pos = replyText.lastIndexOf(32);
                    remoteFile = replyText.substring(++pos);
                    int len = remoteFile.length();
                    if (len > 0 && remoteFile.charAt(len - 1) == '.') {
                        remoteFile = remoteFile.substring(0, len - 1);
                    }
                }
            }
            String string = remoteFile;
            return string;
        }
        catch (IOException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initPut()", ex);
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initPut()", ex);
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String putData(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        IOException storedEx = null;
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        long size = 0L;
        try {
            in = new BufferedInputStream(srcStream);
            remoteFile = this.initPut(remoteFile, append);
            out = new BufferedOutputStream(new DataOutputStream(this.getOutputStream()), this.transferBufferSize * 2);
            if (this.resume) {
                in.skip(this.resumeMarker);
            }
            byte[] buf = new byte[this.transferBufferSize];
            byte[] prevBuf = new byte[FTP_LINE_SEPARATOR.length];
            int matchpos = 0;
            long monitorCount = 0L;
            int count = 0;
            boolean isASCII = this.getType() == FTPTransferType.ASCII;
            long start = System.currentTimeMillis();
            while ((count = in.read(buf)) > 0 && !this.cancelTransfer) {
                if (isASCII) {
                    for (int i = 0; i < count; ++i) {
                        if (buf[i] == 10 && matchpos == 0) {
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                            continue;
                        }
                        if (buf[i] == FTP_LINE_SEPARATOR[matchpos]) {
                            prevBuf[matchpos] = buf[i];
                            if (++matchpos != FTP_LINE_SEPARATOR.length) continue;
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                            matchpos = 0;
                            continue;
                        }
                        if (matchpos > 0) {
                            out.write(13);
                            out.write(10);
                            size += 2L;
                            monitorCount += 2L;
                        }
                        out.write(buf[i]);
                        ++size;
                        ++monitorCount;
                        matchpos = 0;
                    }
                } else {
                    out.write(buf, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (this.monitor != null && monitorCount > this.monitorInterval) {
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - start <= (long)(this.serverWakeupInterval * 1000)) continue;
                start = System.currentTimeMillis();
                this.sendServerWakeup();
            }
            if (isASCII && matchpos > 0) {
                out.write(13);
                out.write(10);
                size += 2L;
                monitorCount += 2L;
            }
            this.resume = false;
        }
        catch (IOException ex) {
            storedEx = ex;
            log.error("Caught and rethrowing exception in getDataAfterInitGet()", ex);
            return remoteFile;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ex) {
            log.warn("Caught exception closing input stream", ex);
        }
        this.closeDataSocket(out);
        if (storedEx != null) {
            throw storedEx;
        }
        if (this.monitor != null) {
            this.monitor.bytesTransferred(size);
        }
        log.debug("Transferred " + size + " bytes to remote host");
        return remoteFile;
        finally {
            this.resume = false;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing input stream", ex);
            }
            this.closeDataSocket(out);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes to remote host");
        }
    }

    @Override
    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        return this.put(bytes, remoteFile, false);
    }

    @Override
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return this.put(input, remoteFile, append);
    }

    @Override
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        File localFile = new File(localPath);
        if (localFile.isDirectory()) {
            localPath = localPath + File.separator + remoteFile;
            log.debug("Setting local path to " + localPath);
        }
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        Exception e = null;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.getData(localPath, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
        }
        catch (FTPException ex) {
            e = ex;
            throw ex;
        }
        catch (IOException ex) {
            e = ex;
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
    }

    @Override
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        Exception e = null;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.getData(destStream, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
        }
        catch (FTPException ex) {
            e = ex;
            throw ex;
        }
        catch (IOException ex) {
            e = ex;
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
    }

    public void resetTransferMode(FTPTransferType previousType) throws IOException, FTPException {
        if (!this.transferType.equals(previousType)) {
            this.setType(previousType);
        }
    }

    protected void initGet(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        boolean close = false;
        try {
            this.setupDataSocket();
            if (this.resume) {
                if (this.transferType.equals(FTPTransferType.ASCII)) {
                    throw new FTPException("Resume only supported for BINARY transfers");
                }
                this.restart(this.resumeMarker);
            }
            this.lastReply = this.control.sendCommand("RETR " + remoteFile);
            String[] validCodes1 = new String[]{"125", "150"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes1);
        }
        catch (IOException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initGet()", ex);
            throw ex;
        }
        catch (FTPException ex) {
            close = true;
            log.error("Caught and rethrowing exception in initGet()", ex);
            throw ex;
        }
        finally {
            if (close) {
                this.resume = false;
                this.closeDataSocket();
            }
        }
    }

    private void getData(String localPath, String remoteFile) throws IOException, FTPException {
        File localFile = new File(localPath = SafeCheckUtils.cleanPathString(localPath));
        if (localFile.exists()) {
            if (!localFile.canWrite()) {
                throw new FTPException(localPath + " is readonly - cannot write");
            }
            if (this.resume) {
                this.resumeMarker = localFile.length();
            }
        }
        this.initGet(remoteFile);
        FileOutputStream out = new FileOutputStream(localPath, this.resume);
        try {
            this.getDataAfterInitGet(out);
        }
        catch (IOException ex) {
            if (this.deleteOnFailure) {
                localFile.delete();
                log.debug("Deleting local file '" + localFile.getAbsolutePath() + "'");
            } else {
                log.debug("Possibly partial local file not deleted");
            }
            throw ex;
        }
    }

    private void getData(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.initGet(remoteFile);
        this.getDataAfterInitGet(destStream);
    }

    InputStream getInputStream() throws IOException {
        return this.data.getInputStream();
    }

    OutputStream getOutputStream() throws IOException {
        return this.data.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDataAfterInitGet(OutputStream destStream) throws IOException, FTPException {
        BufferedOutputStream out = new BufferedOutputStream(destStream);
        BufferedInputStream in = null;
        long size = 0L;
        IOException storedEx = null;
        try {
            int count;
            in = new BufferedInputStream(new DataInputStream(this.data.getInputStream()));
            long monitorCount = 0L;
            byte[] chunk = new byte[this.transferBufferSize];
            boolean isASCII = this.getType() == FTPTransferType.ASCII;
            long start = System.currentTimeMillis();
            byte[] prevBuf = new byte[FTP_LINE_SEPARATOR.length];
            int matchpos = 0;
            while ((count = this.readChunk(in, chunk, this.transferBufferSize)) >= 0 && !this.cancelTransfer) {
                if (isASCII) {
                    for (int i = 0; i < count; ++i) {
                        if (chunk[i] == FTP_LINE_SEPARATOR[matchpos]) {
                            prevBuf[matchpos] = chunk[i];
                            if (++matchpos != FTP_LINE_SEPARATOR.length) continue;
                            out.write(LINE_SEPARATOR);
                            size += (long)LINE_SEPARATOR.length;
                            monitorCount += (long)LINE_SEPARATOR.length;
                            matchpos = 0;
                            continue;
                        }
                        if (matchpos > 0) {
                            out.write(prevBuf, 0, matchpos);
                            size += (long)matchpos;
                            monitorCount += (long)matchpos;
                        }
                        out.write(chunk[i]);
                        ++size;
                        ++monitorCount;
                        matchpos = 0;
                    }
                } else {
                    out.write(chunk, 0, count);
                    size += (long)count;
                    monitorCount += (long)count;
                }
                if (this.monitor != null && monitorCount > this.monitorInterval) {
                    this.monitor.bytesTransferred(size);
                    monitorCount = 0L;
                }
                if (this.serverWakeupInterval <= 0 || System.currentTimeMillis() - start <= (long)(this.serverWakeupInterval * 1000)) continue;
                start = System.currentTimeMillis();
                this.sendServerWakeup();
            }
            if (isASCII && matchpos > 0) {
                out.write(prevBuf, 0, matchpos);
                size += (long)matchpos;
                monitorCount += (long)matchpos;
            }
        }
        catch (IOException ex) {
            storedEx = ex;
            log.error("Caught and rethrowing exception in getDataAfterInitGet()", ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                log.warn("Caught exception closing output stream", ex);
            }
            this.resume = false;
            this.closeDataSocket(in);
            if (storedEx != null) {
                throw storedEx;
            }
            if (this.monitor != null) {
                this.monitor.bytesTransferred(size);
            }
            log.debug("Transferred " + size + " bytes from remote host");
        }
    }

    @Override
    public byte[] get(String remoteFile) throws IOException, FTPException {
        FTPTransferType previousType = this.transferType;
        this.chooseTransferMode(remoteFile);
        boolean resetMode = true;
        Exception e = null;
        try {
            if (this.monitorEx != null) {
                this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            ByteArrayOutputStream result = new ByteArrayOutputStream(this.transferBufferSize);
            this.getData(result, remoteFile);
            this.validateTransfer();
            ++this.downloadCount;
            byte[] byArray = result == null ? null : result.toByteArray();
            return byArray;
        }
        catch (FTPException ex) {
            e = ex;
            throw ex;
        }
        catch (IOException ex) {
            e = ex;
            resetMode = false;
            this.validateTransferOnError(ex);
            throw ex;
        }
        finally {
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            if (resetMode) {
                this.resetTransferMode(previousType);
            }
        }
    }

    public boolean site(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SITE " + command);
        String[] validCodes = new String[]{"200", "202", "250", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastReply.getReplyCode().equals("200");
    }

    public String list(String dirname) throws IOException, FTPException {
        return this.list(dirname, false);
    }

    public String list(String dirname, boolean full) throws IOException, FTPException {
        String[] list = this.dir(dirname, full);
        StringBuffer result = new StringBuffer();
        String sep = System.getProperty("line.separator");
        for (int i = 0; i < list.length; ++i) {
            result.append(list[i]);
            result.append(sep);
        }
        return result.toString();
    }

    public void setFTPFileFactory(FTPFileFactory fileFactory) {
        this.fileFactory = fileFactory;
    }

    public void setParserLocale(Locale locale) {
        this.listingLocales = new Locale[1];
        this.listingLocales[0] = locale;
    }

    public void setParserLocales(Locale[] locales) {
        this.listingLocales = locales;
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MLST " + name);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
        if (this.lastReply.getReplyData() != null) {
            return this.mlsxParser.parse(this.lastReply.getReplyData()[0]);
        }
        log.warn("No file data returned from MLST");
        return null;
    }

    @Override
    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        if (this.fileFactory == null) {
            try {
                this.fileFactory = new FTPFileFactory(this.system());
            }
            catch (FTPException ex) {
                log.warn("SYST command failed - setting Unix as default parser", ex);
                this.fileFactory = new FTPFileFactory("UNIX");
            }
        }
        this.fileFactory.setLocales(this.listingLocales);
        String path = this.pwd();
        if (dirname != null && dirname.length() > 0 && dirname.indexOf(42) < 0 && dirname.indexOf(63) < 0) {
            path = path + "/" + dirname;
        }
        FTPFile[] result = this.fileFactory.parse(this.dir(dirname, true));
        for (int i = 0; i < result.length; ++i) {
            result[i].setPath(path);
        }
        return result;
    }

    @Override
    public String[] dir() throws IOException, FTPException {
        return this.dir(null, false);
    }

    @Override
    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        this.checkConnection(true);
        this.cancelTransfer = false;
        try {
            String command;
            this.setupDataSocket();
            String string = command = full ? "LIST " : "NLST ";
            if (dirname != null) {
                command = command + dirname;
            }
            command = command.trim();
            this.lastReply = this.control.sendCommand(command);
            String[] validCodes1 = new String[]{"125", "150", "226", "450", "550"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes1);
            Object[] result = new String[]{};
            String replyCode = this.lastValidReply.getReplyCode();
            if (!(replyCode.equals("450") || replyCode.equals("550") || replyCode.equals("226"))) {
                BufferedReader in = null;
                Vector<String> lines = new Vector<String>();
                try {
                    in = new LineNumberReader(new InputStreamReader(this.data.getInputStream(), this.controlEncoding));
                    String line = null;
                    while ((line = this.readLine((LineNumberReader)in)) != null && !this.cancelTransfer) {
                        lines.addElement(line);
                        log.log(Level.ALL, line, null);
                    }
                }
                catch (IOException ex) {
                    this.validateTransferOnError(ex);
                    throw ex;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failed to close socket in dir()", ex);
                    }
                    this.closeDataSocket();
                }
                String[] validCodes2 = new String[]{"226", "250"};
                this.lastReply = this.control.readReply();
                this.lastValidReply = this.control.validateReply(this.lastReply, validCodes2);
                if (!lines.isEmpty()) {
                    result = new String[lines.size()];
                    lines.copyInto(result);
                }
            } else {
                String replyText = this.lastValidReply.getReplyText().toUpperCase();
                if (!this.dirEmptyStrings.matches(replyText) && !this.transferCompleteStrings.matches(replyText)) {
                    throw new FTPException(this.lastReply);
                }
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.closeDataSocket();
        }
    }

    public int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        return in.read(chunk, 0, chunksize);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        return in.read();
    }

    protected String readLine(LineNumberReader in) throws IOException {
        return in.readLine();
    }

    public FTPReply getLastValidReply() {
        return this.lastValidReply;
    }

    public FTPReply getLastReply() {
        return this.lastReply;
    }

    @Override
    public FTPTransferType getType() {
        return this.transferType;
    }

    @Override
    public void setType(FTPTransferType type) throws IOException, FTPException {
        this.checkConnection(true);
        String typeStr = FTPTransferType.ASCII_CHAR;
        if (type.equals(FTPTransferType.BINARY)) {
            typeStr = FTPTransferType.BINARY_CHAR;
        }
        String[] validCodes = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("TYPE " + typeStr);
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        this.transferType = type;
    }

    @Override
    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        String[] validCodes = new String[]{"200", "250"};
        this.lastReply = this.control.sendCommand("DELE " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        ++this.deleteCount;
    }

    @Override
    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RNFR " + from);
        this.lastValidReply = this.control.validateReply(this.lastReply, "350");
        this.lastReply = this.control.sendCommand("RNTO " + to);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    @Override
    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("RMD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    @Override
    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MKD " + dir);
        String[] validCodes = new String[]{"200", "250", "257"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    @Override
    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CWD " + dir);
        this.lastValidReply = this.control.validateReply(this.lastReply, "250");
    }

    @Override
    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("CDUP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    @Override
    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("MDTM " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
        Date ts = this.tsFormat.parse(this.lastValidReply.getReplyText(), new ParsePosition(0));
        return ts;
    }

    @Override
    public void setModTime(String remoteFile, Date modTime) throws IOException, FTPException {
        this.checkConnection(true);
        String time = this.tsFormat.format(modTime);
        this.lastReply = this.control.sendCommand("MFMT " + time + " " + remoteFile);
        this.lastValidReply = this.control.validateReply(this.lastReply, "213");
    }

    @Override
    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("PWD");
        this.lastValidReply = this.control.validateReply(this.lastReply, "257");
        String text = this.lastValidReply.getReplyText();
        int start = text.indexOf(34);
        int end = text.lastIndexOf(34);
        if (start >= 0 && end > start) {
            return text.substring(start + 1, end);
        }
        return text;
    }

    public String[] features() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("FEAT");
        String[] validCodes = new String[]{"211", "500", "502"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        if (this.lastValidReply.getReplyCode().equals("211")) {
            return this.lastValidReply.getReplyData();
        }
        throw new FTPException(this.lastReply);
    }

    @Override
    public String system() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("SYST");
        String[] validCodes = new String[]{"200", "213", "215", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void noOperation() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("NOOP");
        String[] validCodes = new String[]{"200", "250"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    public String stat() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("STAT");
        String[] validCodes = new String[]{"211", "212", "213"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    public void sendServerWakeup() throws IOException, FTPException {
        this.noOperation();
    }

    @Override
    public void keepAlive() throws IOException, FTPException {
        log.debug("keepAlive() called");
        int op = (int)Math.ceil(Math.random() * 2.0);
        switch (op) {
            case 1: {
                this.noOperation();
                break;
            }
            case 2: {
                this.pwd();
                break;
            }
            default: {
                this.pwd();
            }
        }
    }

    public String help(String command) throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("HELP " + command);
        String[] validCodes = new String[]{"211", "214"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        return this.lastValidReply.getReplyText();
    }

    protected void abort() throws IOException, FTPException {
        this.checkConnection(true);
        this.lastReply = this.control.sendCommand("ABOR");
        String[] validCodes = new String[]{"426", "226"};
        this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        try {
            this.lastReply = this.control.sendCommand("QUIT");
            String[] validCodes = new String[]{"221", "226"};
            this.lastValidReply = this.control.validateReply(this.lastReply, validCodes);
        }
        finally {
            try {
                this.control.logout();
            }
            finally {
                this.control = null;
            }
        }
    }

    @Override
    public void quitImmediately() throws IOException, FTPException {
        this.cancelTransfer();
        try {
            if (this.control != null && this.control.controlSock != null) {
                this.control.controlSock.close();
            }
        }
        finally {
            this.control = null;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        result.append("FTP").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return result.toString();
    }

    static {
        log = Logger.getLogger("FTPClient");
        masterId = 0;
        DEFAULT_LISTING_LOCALES = new Locale[2];
        FTPClient.DEFAULT_LISTING_LOCALES[0] = Locale.ENGLISH;
        FTPClient.DEFAULT_LISTING_LOCALES[1] = Locale.getDefault();
    }
}

