/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class MLSXEntryParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: MLSXEntryParser.java,v 1.1 2008-12-16 05:14:15 pengxu_ge Exp $";
    private static final String SIZE = "Size";
    private static final String MODIFY = "Modify";
    private static final String CREATE = "Create";
    private static final String TYPE = "Type";
    private static final String UNIQUE = "Unique";
    private static final String PERM = "Perm";
    private static final String LANG = "Lang";
    private static final String MEDIA_TYPE = "Media-Type";
    private static final String CHARSET = "CharSet";
    private static final String FILE_TYPE = "file";
    private static final String LISTED_DIR_TYPE = "cdir";
    private static final String PARENT_DIR_TYPE = "pdir";
    private static final String SUB_DIR_TYPE = "dir";
    private SimpleDateFormat tsFormat1 = new SimpleDateFormat("yyyyMMddHHmmss");
    private SimpleDateFormat tsFormat2 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");

    public MLSXEntryParser() {
        this.tsFormat1.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.tsFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public FTPFile parse(String raw) throws ParseException {
        String[] fields = this.split(raw, ';');
        String path = null;
        FTPFile ftpFile = new FTPFile(raw);
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (i + 1 == fields.length) {
                path = field.trim();
                ftpFile.setPath(path);
                String name = path;
                int pos = name.lastIndexOf(47);
                if (pos >= 0) {
                    name = name.substring(pos);
                }
                ftpFile.setName(name);
                continue;
            }
            int pos = field.indexOf(61);
            if (pos <= 0) continue;
            String name = field.substring(0, pos);
            String value = field.substring(++pos);
            if (name.equalsIgnoreCase(SIZE)) {
                ftpFile.setSize(this.parseSize(value));
                continue;
            }
            if (name.equalsIgnoreCase(MODIFY)) {
                ftpFile.setLastModified(this.parseDate(value));
                continue;
            }
            if (name.equalsIgnoreCase(TYPE)) {
                if (value.equalsIgnoreCase(FILE_TYPE)) {
                    ftpFile.setDir(false);
                    continue;
                }
                ftpFile.setDir(true);
                continue;
            }
            if (name.equalsIgnoreCase(PERM)) {
                ftpFile.setPermissions(value);
                continue;
            }
            if (!name.equalsIgnoreCase(CREATE)) continue;
            ftpFile.setCreated(this.parseDate(value));
        }
        return ftpFile;
    }

    private long parseSize(String value) throws ParseException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Failed to parse size: " + value, 0);
        }
    }

    private Date parseDate(String value) throws ParseException {
        try {
            return this.tsFormat1.parse(value);
        }
        catch (ParseException ex) {
            return this.tsFormat2.parse(value);
        }
    }

    @Override
    public void setLocale(Locale locale) {
    }
}

