/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.internal;

import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;

public class SocketUtils {
    private static Logger log = Logger.getLogger("SocketUtils");

    public static Socket createSocket(InetAddress host, int port, int timeout) throws IOException {
        if (timeout == 0) {
            return new Socket(host, port);
        }
        try {
            Class<?> socketAddress = Class.forName("java.net.SocketAddress");
            Method connectMethod = Socket.class.getMethod("connect", socketAddress, Integer.TYPE);
            Socket sock = (Socket)Socket.class.newInstance();
            Class<?> inetSocketAddress = Class.forName("java.net.InetSocketAddress");
            Constructor<?> inetSocketAddressCtr = inetSocketAddress.getConstructor(InetAddress.class, Integer.TYPE);
            Object address = inetSocketAddressCtr.newInstance(host, new Integer(port));
            log.debug("Invoking connect with timeout=" + timeout);
            connectMethod.invoke((Object)sock, address, new Integer(timeout));
            log.debug("Connected successfully");
            return sock;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            return new Socket(host, port);
        }
        catch (Exception ex) {
            log.debug("Could not use timeout connecting to host (" + ex.toString() + ")");
            return new Socket(host, port);
        }
    }

    public static boolean isConnected(Socket sock) throws IOException {
        try {
            Method connectedMethod = Socket.class.getMethod("isConnected", null);
            Boolean result = (Boolean)connectedMethod.invoke((Object)sock, (Object[])null);
            log.info("SocketUtils::isConnected----result=" + result);
            return result;
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            log.error("Could not use Socket.isConnected (" + ex.toString() + ")");
            return true;
        }
        catch (Exception ex) {
            log.error("Could not use Socket.isConnected (" + ex.toString() + ")");
            return true;
        }
    }
}

