/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.test.FTPTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestExists
extends FTPTestCase {
    public static String cvsId = "@(#)$Id: TestExists.java,v 1.1 2008-12-16 05:14:14 pengxu_ge Exp $";

    @Override
    protected String getLogName() {
        return "TestExists.log";
    }

    public void testExistsWhenDoesnt() throws Exception {
        this.log.debug("testExistsWhenDoesnt()");
        try {
            this.connect();
            this.ftp.chdir(this.testdir);
            String filename = this.generateRandomFilename();
            TestExists.assertFalse((boolean)this.ftp.exists(filename));
            this.log.debug(filename + " does not exist.");
            this.ftp.quit();
        }
        finally {
            if (this.ftp.connected()) {
                this.ftp.quitImmediately();
            }
        }
    }

    public void testExistsWhenDoes() throws Exception {
        this.log.debug("testExistsWhenDoes()");
        this.connect();
        this.ftp.chdir(this.testdir);
        String filename = this.generateRandomFilename();
        this.ftp.put(this.localDataDir + this.localTextFile, filename);
        TestExists.assertTrue((boolean)this.ftp.exists(filename));
        this.log.debug(filename + " does exist.");
        this.ftp.delete(filename);
        this.ftp.quit();
    }

    public static Test suite() {
        return new TestSuite(TestExists.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestExists.suite());
    }
}

