/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.service;

import com.enterprisedt.util.safe.SafeCheckUtils;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.fme.app.DocumentFactory;
import com.kingdee.eas.base.fme.app.DocumentInfo;
import com.kingdee.eas.base.fme.app.IDocument;
import com.kingdee.eas.base.fme.bo.DocumentBO;
import com.kingdee.eas.base.fme.dao.IFMEDao;
import com.kingdee.eas.base.fme.ftp.FMEFtpFactory;
import com.kingdee.eas.base.fme.ftp.FMEFtpInputStream;
import com.kingdee.eas.base.fme.ftp.FtpConfig;
import com.kingdee.eas.base.fme.ftp.IFMEFtp;
import com.kingdee.eas.base.fme.service.FtpDocumentInfo;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.fme.service.ServiceResult;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.fme.util.FMEUIUtils;
import com.kingdee.eas.base.fme.util.FMEUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractFMEService
implements IFMEService {
    protected IFMEDao dao;
    protected IFMEFtp ftp;

    public abstract void initDaoAndFtpInterface();

    @Override
    public void backupFile() {
    }

    @Override
    public void restoreFile() {
    }

    @Override
    public ServiceResult uploadFile(String[] filePath, String businessID) {
        return this.uploadFile(filePath, businessID, null, null, null);
    }

    @Override
    public ServiceResult uploadFile(String[] filePath, String businessID, Component component, String[] uploadIndex) {
        return this.uploadFile(filePath, businessID, component, uploadIndex, null);
    }

    private IFMEFtp lazyLoadFtpServiceInstanaceByPathID(String pathID) {
        System.out.println("===============================================================================\u5ef6\u8fdf\u52a0\u8f7d\uff0c\u5b9e\u4f8b\u5316FTPInstance==========================pathID is:" + pathID + "==");
        this.ftp = FMEFtpFactory.getFMEFtpInstanceWithPathID(this.dao, pathID);
        return this.ftp;
    }

    private IFMEFtp lazyLoadFtpServiceInstanaceByServerID(String serverID) {
        System.out.println("===============================================================================\u5ef6\u8fdf\u52a0\u8f7d\uff0c\u5b9e\u4f8b\u5316FTPInstance==========================serverID is:" + serverID + "==");
        this.ftp = FMEFtpFactory.getFMEFtpInstanceWithServerID(this.dao, serverID);
        return this.ftp;
    }

    private FtpConfig lazyLoadFtpConfigByServerID(String serverID) {
        System.out.println("===============================================================================\u5ef6\u8fdf\u52a0\u8f7d\uff0c\u83b7\u53d6Config==========================serverID is:" + serverID + "==");
        FtpConfig config = FMEFtpFactory.getFMEFtpConfigWithServerID(this.dao, serverID);
        return config;
    }

    @Override
    public ServiceResult uploadFile(String[] filePath, String businessID, Component component, String[] uploadIndex, FMEParameter param) {
        System.out.println("uploadFile(String[] filePath, String businessID, Component component, String[] uploadIndex, FMEParameter param");
        ServiceResult result = new ServiceResult();
        int uploadCount = filePath.length;
        long allFileSize = 0L;
        if (uploadCount == 0) {
            System.out.println("\u4e0a\u4f20\u6587\u4ef6\u4e2a\u6570\u4e3a0");
            result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u4e2a\u6570\u4e3a0");
        } else {
            System.out.println("======FME\u670d\u52a1\u9884\u4e0a\u4f20\u6587\u4ef6\u4e2a\u6570\u4e3a" + uploadCount);
            try {
                String newPathID = "";
                String newCategoryInfo = "";
                if (param != null) {
                    newPathID = param.getNewPathID();
                    newCategoryInfo = param.getNewCategoryInfo();
                    System.out.println("=\u65b0\u589eNewPathID======================" + newPathID);
                    System.out.println("=\u65b0\u589enewCategoryInfo======================" + newCategoryInfo);
                } else {
                    System.out.println("\u4f20\u5165\u7684FMEParameter \u4e3anull");
                }
                System.out.println("\u83b7\u53d6NewPathID \u5bf9\u5e94\u7684=========:" + newPathID);
                try {
                    System.out.println("============>>>===================\u4e00\u6b21\u5ba2\u6237\u7aef\u8bf7\u6c42\u670d\u52a1\u7aefDAO\u64cd\u4f5c\uff0c\u67e5\u8be2\u5b58\u50a8\u8def\u5f84,\u6839\u636e\u5b58\u50a8\u8def\u5f84\uff0c\u83b7\u53d6\u5bf9\u5e94\u7684FtpConfig");
                    this.lazyLoadFtpServiceInstanaceByPathID(newPathID);
                }
                catch (Exception sse) {
                    System.out.println("===============================\u52a0\u8f7d\u4fdd\u5b58\u8def\u5f84\u629b\u51fa\u5f02\u5e38\uff1a" + sse.getMessage());
                }
                DocumentBO[] docBO = new DocumentBO[uploadCount];
                String[] documentIDArray = new String[uploadCount];
                for (int i = 0; i < uploadCount; ++i) {
                    String filename = filePath[i];
                    File oneFile = new File(filename);
                    FileInputStream fis = new FileInputStream(oneFile);
                    int fileSize = fis.available();
                    allFileSize += (long)fileSize;
                    String remoteFileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(filename));
                    String displayName = FMEUIUtils.getFileNameFromAbsolutePath(filename);
                    DocumentBO oneBO = new DocumentBO();
                    oneBO.setDisplayName(displayName);
                    oneBO.setName(remoteFileName);
                    oneBO.setSize(fileSize);
                    oneBO.setStatus('3');
                    oneBO.setBusinessID(businessID);
                    if (filename.length() >= 255) {
                        oneBO.setDescription(filename.substring(0, 255));
                    } else {
                        oneBO.setDescription(filename);
                    }
                    oneBO.setNewPathID(newPathID);
                    oneBO.setNewCategoryInfo(newCategoryInfo);
                    docBO[i] = oneBO;
                }
                System.out.println("============>>>==>>>==============\u4e8c\u6b21\u5ba2\u6237\u7aef\u8bf7\u6c42\u670d\u52a1\u7aefDAO\u64cd\u4f5c\uff0c\u63d2\u5165\u5f85\u4e0a\u4f20\u8bb0\u5f55");
                List insertResultList = null;
                try {
                    insertResultList = this.dao.insertUnloadDocument(docBO);
                }
                catch (Exception insertUE) {
                    System.out.println("\u63d2\u5165\u5f85\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55\u629b\u51fa\u5f02\u5e38\uff1a" + insertUE.getMessage());
                }
                int insertListSize = 0;
                if (insertResultList != null) {
                    insertListSize = insertResultList.size();
                }
                int[] updateFileResult = new int[insertListSize];
                boolean uploadFileOK = true;
                for (int k = 0; k < insertListSize; ++k) {
                    String[] oneInsertResult = (String[])insertResultList.get(k);
                    String documentID = oneInsertResult[0];
                    String uploadPath = oneInsertResult[1];
                    System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6" + k + "Document id:" + documentID);
                    documentIDArray[k] = documentID;
                    System.out.println("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84 :" + uploadPath);
                    DocumentBO oneBO = docBO[k];
                    oneBO.setPath(uploadPath);
                    oneBO.setDocumentID(documentID);
                    if (documentID != null && documentID.trim().length() > 0) {
                        int uploadResult;
                        String filename = filePath[k];
                        File oneFile = new File(filename);
                        FileInputStream fis = new FileInputStream(oneFile);
                        int fileSize = oneBO.getSize();
                        FMEFtpInputStream ffis = new FMEFtpInputStream(component, "\u6b63\u5728\u4e0a\u4f20......", fis, fileSize);
                        ffis.setUpload(true);
                        if (uploadIndex != null && uploadIndex.length > k) {
                            String oneUploadIndex = uploadIndex[k];
                            ffis.setProgressIndex(oneUploadIndex);
                        } else {
                            System.out.println("\u6ca1\u6709\u6307\u5b9a\u4e0a\u4f20\u7684\u6587\u4ef6\u7d22\u5f15\uff0c\u5c5e\u4e8e\u670d\u52a1\u7aef\u6587\u4ef6\u4e0a\u4f20....");
                            ffis.setProgressIndex("");
                        }
                        String remoteFileName = oneBO.getName();
                        updateFileResult[k] = uploadResult = this.ftp.uploadStream(ffis, uploadPath + remoteFileName);
                        if (uploadResult == 0) {
                            oneBO.setStatus('0');
                            continue;
                        }
                        uploadFileOK = false;
                        documentIDArray[k] = "";
                        if (uploadResult == 1) {
                            result.setResult(false, "\u6587\u4ef6\u53d1\u9001\u8fc7\u7a0b\u88ab\u4e2d\u6b62");
                            continue;
                        }
                        result.setResult(false, "\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001");
                        continue;
                    }
                    uploadFileOK = false;
                    result.setResult(false, "\u9884\u5b58\u50a8\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5");
                    break;
                }
                if (uploadFileOK && insertListSize > 0) {
                    System.out.println("============>>>==>>>==>>>============\u4e09\u6b21\u5ba2\u6237\u7aef\u8bf7\u6c42\u670d\u52a1\u7aefDAO\u64cd\u4f5c\uff0c\u66f4\u65b0\u6587\u6863\u6807\u51c6\u3001\u5b58\u50a8\u4e1a\u52a1\u6587\u6863\u8d44\u6599");
                    String[] uploadDocumentID = this.dao.insert(docBO);
                    if (uploadDocumentID.length == documentIDArray.length) {
                        System.out.println("\u66f4\u65b0\u67e5\u8be2\u6587\u4ef6\u5b8c\u6210\u6210\u529f==================================");
                        result.setResult(true);
                    } else {
                        System.out.println("\u66f4\u65b0\u67e5\u8be2\u6587\u4ef6\u5931\u8d25\uff1a==================================\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                        result.setResult(false, "\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                    }
                } else {
                    System.out.println("===================\u4e0a\u4f20\u6587\u4ef6\u4e2d\uff0c\u51fa\u73b0\u4e0a\u4f20\u5931\u8d25\u7684\u6587\u4ef6\uff0c\u629b\u51fa\u5f02\u5e38\u4fe1\u606f" + result.getResultDetail());
                }
                result.setResultID(documentIDArray);
                result.setFileSize(allFileSize);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                String exMessage = se.getMessage();
                if (exMessage.indexOf("java.io.FilePermission") != -1) {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u5ba2\u6237\u7aefJRE\u6743\u9650\u9650\u5236");
                } else {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38");
                }
                result.setResultDetail(se.getMessage());
            }
        }
        return result;
    }

    @Override
    public ServiceResult uploadFile(InputStream is, String fileName, String businessID, FMEParameter param) {
        return this.uploadFile(is, fileName, businessID, param, null, null);
    }

    @Override
    public ServiceResult uploadFile(InputStream is, String fileName, String businessID, FMEParameter param, String defaultRemoteFileName, InputStream swfIs) {
        ServiceResult result = new ServiceResult();
        if (is == null) {
            System.out.println("\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull");
            result.setResult(false, "\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull");
        } else {
            try {
                String newPathID = "";
                String newCategoryInfo = "";
                if (param != null) {
                    newPathID = param.getNewPathID();
                    newCategoryInfo = param.getNewCategoryInfo();
                    System.out.println("=\u65b0\u589eNewPathID======================" + newPathID);
                    System.out.println("=\u65b0\u589enewCategoryInfo======================" + newCategoryInfo);
                } else {
                    System.out.println("\u4f20\u5165\u7684FMEParameter \u4e3anull");
                }
                System.out.println("\u83b7\u53d6NewPathID \u5bf9\u5e94\u7684=========:" + newPathID);
                try {
                    System.out.println("============>>>===================one time query savepath ,get ftpconfig");
                    this.lazyLoadFtpServiceInstanaceByPathID(newPathID);
                }
                catch (Exception sse) {
                    System.out.println("===============================\u52a0\u8f7d\u4fdd\u5b58\u8def\u5f84\u629b\u51fa\u5f02\u5e38\uff1a" + sse.getMessage());
                }
                DocumentBO[] docBO = new DocumentBO[1];
                String[] documentIDArray = new String[1];
                for (int i = 0; i < 1; ++i) {
                    String remoteFileName = defaultRemoteFileName;
                    if (remoteFileName == null || remoteFileName.length() <= 0) {
                        remoteFileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(fileName));
                    }
                    String displayName = fileName;
                    DocumentBO oneBO = new DocumentBO();
                    oneBO.setDisplayName(displayName);
                    oneBO.setName(remoteFileName);
                    int fileSize = is.available();
                    oneBO.setSize(fileSize);
                    oneBO.setStatus('3');
                    oneBO.setBusinessID(businessID);
                    if (fileName.length() >= 255) {
                        oneBO.setDescription(fileName.substring(0, 255));
                    } else {
                        oneBO.setDescription(fileName);
                    }
                    oneBO.setNewPathID(newPathID);
                    oneBO.setNewCategoryInfo(newCategoryInfo);
                    docBO[i] = oneBO;
                }
                System.out.println("============>>>==>>>==============second time ,insert waiting upload record");
                List insertResultList = null;
                try {
                    insertResultList = this.dao.insertUnloadDocument(docBO);
                }
                catch (Exception insertUE) {
                    System.out.println("\u63d2\u5165\u5f85\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55\u629b\u51fa\u5f02\u5e38\uff1a" + insertUE.getMessage());
                }
                int insertListSize = 0;
                if (insertResultList != null) {
                    insertListSize = insertResultList.size();
                }
                int[] updateFileResult = new int[insertListSize];
                boolean uploadFileOK = true;
                for (int k = 0; k < insertListSize; ++k) {
                    String[] oneInsertResult = (String[])insertResultList.get(k);
                    String documentID = oneInsertResult[0];
                    String uploadPath = oneInsertResult[1];
                    System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6" + k + "Document id:" + documentID);
                    documentIDArray[k] = documentID;
                    System.out.println("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84 :" + uploadPath);
                    DocumentBO oneBO = docBO[k];
                    oneBO.setPath(uploadPath);
                    oneBO.setDocumentID(documentID);
                    if (documentID != null && documentID.trim().length() > 0) {
                        int uploadResult;
                        String tmpRemoteFileName = oneBO.getName();
                        updateFileResult[k] = uploadResult = this.ftp.uploadStream(is, uploadPath + tmpRemoteFileName);
                        if (uploadResult == 0) {
                            oneBO.setStatus('0');
                            if (defaultRemoteFileName == null || defaultRemoteFileName.length() <= 0) continue;
                            String tmpRemoteFileName2 = tmpRemoteFileName.substring(0, tmpRemoteFileName.lastIndexOf(".")) + ".swf";
                            int swfUploadResult = this.ftp.uploadStream(swfIs, uploadPath + tmpRemoteFileName2, true);
                            System.out.println("swf file upload result [" + swfUploadResult + "]");
                            continue;
                        }
                        uploadFileOK = false;
                        documentIDArray[k] = "";
                        if (uploadResult == 1) {
                            result.setResult(false, "\u6587\u4ef6\u53d1\u9001\u8fc7\u7a0b\u88ab\u4e2d\u6b62");
                            continue;
                        }
                        result.setResult(false, "\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001");
                        continue;
                    }
                    uploadFileOK = false;
                    result.setResult(false, "\u9884\u5b58\u50a8\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5");
                    break;
                }
                if (uploadFileOK && insertListSize > 0) {
                    System.out.println("============>>>==>>>==>>>============third time ,update docuent status,save docInfo");
                    String[] uploadDocumentID = this.dao.insert(docBO);
                    if (uploadDocumentID.length == documentIDArray.length) {
                        System.out.println("update query document info==================================");
                        result.setResult(true);
                    } else {
                        System.out.println("update query document info fail:==================================\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                        result.setResult(false, "\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                    }
                } else {
                    System.out.println("===================\u4e0a\u4f20\u6587\u4ef6\u4e2d\uff0c\u51fa\u73b0\u4e0a\u4f20\u5931\u8d25\u7684\u6587\u4ef6\uff0c\u629b\u51fa\u5f02\u5e38\u4fe1\u606f" + result.getResultDetail());
                }
                result.setResultID(documentIDArray);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                String exMessage = se.getMessage();
                if (exMessage.indexOf("java.io.FilePermission") != -1) {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u5ba2\u6237\u7aefJRE\u6743\u9650\u9650\u5236");
                } else {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38");
                }
                result.setResultDetail(se.getMessage());
            }
        }
        return result;
    }

    @Override
    public ServiceResult updateFile(Context ctx, InputStream is, String businessID, String documentId) {
        ServiceResult result = new ServiceResult();
        try {
            DocumentBO documentBO = this.dao.query(businessID, documentId);
            String uploadPath = documentBO.getPath();
            String remoteFileName = documentBO.getName();
            this.lazyLoadFtpServiceInstanaceByServerID(documentBO.getServerID());
            int uploadResult = this.ftp.uploadStream(is, uploadPath + remoteFileName);
            result.setResult(0 == uploadResult);
            System.out.println("\u66f4\u65b0\u6587\u4ef6\u7ed3\u679c:" + uploadResult);
        }
        catch (Exception e) {
            System.out.println("\u66f4\u65b0\u6587\u4ef6\u5931\u8d25-- e:" + e.getMessage());
        }
        return result;
    }

    @Override
    public ServiceResult updateFile(Context ctx, InputStream is, String businessID, String documentId, int mSize, String ntkoSaveMethod) {
        ServiceResult result = new ServiceResult();
        try {
            DocumentBO documentBO = this.dao.query(businessID, documentId);
            String uploadPath = documentBO.getPath();
            String remoteFileName = documentBO.getName();
            this.lazyLoadFtpServiceInstanaceByServerID(documentBO.getServerID());
            int uploadResult = this.ftp.uploadStream(is, uploadPath + remoteFileName);
            boolean isDocx = remoteFileName.substring(remoteFileName.lastIndexOf(".") + 1).equalsIgnoreCase("docx");
            boolean isXlsx = remoteFileName.substring(remoteFileName.lastIndexOf(".") + 1).equalsIgnoreCase("xlsx");
            if (0 == uploadResult && ntkoSaveMethod.equals("SaveAsOtherFormatToURL") && (isDocx || isXlsx)) {
                String newName = remoteFileName.replaceAll(remoteFileName.substring(remoteFileName.lastIndexOf(".")), isDocx ? ".doc" : ".xls");
                String oleDisplayName = documentBO.getDisplayName();
                String newDisplayName = oleDisplayName.replaceAll(oleDisplayName.substring(oleDisplayName.lastIndexOf(".")), isDocx ? ".doc" : ".xls");
                this.ftp.rename(uploadPath + remoteFileName, uploadPath + newName);
                IDocument iDoc = null;
                iDoc = ctx == null ? DocumentFactory.getRemoteInstance() : DocumentFactory.getLocalInstance((Context)ctx);
                DocumentInfo docInfo = iDoc.getValue(FMEUtils.getObjectPK("DocumentID", documentId));
                docInfo.setSize(mSize);
                docInfo.setName(newName);
                iDoc.update(FMEUtils.getObjectPK("DocumentID", documentId), docInfo);
                documentBO.setDisplayName(newDisplayName);
                this.dao.update(new DocumentBO[]{documentBO});
            }
            result.setResult(0 == uploadResult);
            System.out.println("\u66f4\u65b0\u6587\u4ef6\u7ed3\u679c\u5e76\u91cd\u547d\u540d\u540e\u7f00:" + uploadResult);
        }
        catch (Exception e) {
            System.out.println("\u66f4\u65b0\u6587\u4ef6\u5e76\u91cd\u547d\u540d\u540e\u7f00\u5931\u8d25-- e:" + e.getMessage());
        }
        return result;
    }

    @Override
    public ServiceResult uploadFile(InputStream[] is, String[] fileName, String businessID, FMEParameter param) {
        ServiceResult result = new ServiceResult();
        long allFileSize = 0L;
        int uploadCount = fileName.length;
        if (is == null || is.length <= 0 || fileName == null || fileName.length <= 0 || is.length != fileName.length) {
            System.out.println("\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull");
            result.setResult(false, "\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull,\u6216\u8005\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e3anull,\u83b7\u53d6\u5927\u5c0f\u4e0d\u4e00\u81f4");
        } else {
            try {
                String newPathID = "";
                String newCategoryInfo = "";
                if (param != null) {
                    newPathID = param.getNewPathID();
                    newCategoryInfo = param.getNewCategoryInfo();
                    System.out.println("=\u65b0\u589eNewPathID======================" + newPathID);
                    System.out.println("=\u65b0\u589enewCategoryInfo======================" + newCategoryInfo);
                } else {
                    System.out.println("\u4f20\u5165\u7684FMEParameter \u4e3anull");
                }
                System.out.println("\u83b7\u53d6NewPathID \u5bf9\u5e94\u7684=========:" + newPathID);
                try {
                    System.out.println("============>>>===================one time query savepath ,get ftpconfig");
                    this.lazyLoadFtpServiceInstanaceByPathID(newPathID);
                }
                catch (Exception sse) {
                    System.out.println("===============================\u52a0\u8f7d\u4fdd\u5b58\u8def\u5f84\u629b\u51fa\u5f02\u5e38\uff1a" + sse.getMessage());
                }
                DocumentBO[] docBO = new DocumentBO[uploadCount];
                String[] documentIDArray = new String[uploadCount];
                for (int i = 0; i < is.length; ++i) {
                    String remoteFileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(fileName[i]));
                    String displayName = fileName[i];
                    DocumentBO oneBO = new DocumentBO();
                    oneBO.setDisplayName(displayName);
                    oneBO.setName(remoteFileName);
                    int fileSize = is[i].available();
                    allFileSize += (long)fileSize;
                    oneBO.setSize(fileSize);
                    oneBO.setStatus('3');
                    oneBO.setBusinessID(businessID);
                    if (fileName[i].length() >= 255) {
                        oneBO.setDescription(fileName[i].substring(0, 255));
                    } else {
                        oneBO.setDescription(fileName[i]);
                    }
                    oneBO.setNewPathID(newPathID);
                    oneBO.setNewCategoryInfo(newCategoryInfo);
                    docBO[i] = oneBO;
                }
                System.out.println("============>>>==>>>==============second time ,insert waiting upload record");
                List insertResultList = null;
                try {
                    insertResultList = this.dao.insertUnloadDocument(docBO);
                }
                catch (Exception insertUE) {
                    System.out.println("\u63d2\u5165\u5f85\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55\u629b\u51fa\u5f02\u5e38\uff1a" + insertUE.getMessage());
                }
                int insertListSize = 0;
                if (insertResultList != null) {
                    insertListSize = insertResultList.size();
                }
                int[] updateFileResult = new int[insertListSize];
                boolean uploadFileOK = true;
                for (int k = 0; k < insertListSize; ++k) {
                    String[] oneInsertResult = (String[])insertResultList.get(k);
                    String documentID = oneInsertResult[0];
                    String uploadPath = oneInsertResult[1];
                    System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6" + k + "Document id:" + documentID);
                    documentIDArray[k] = documentID;
                    System.out.println("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84 :" + uploadPath);
                    DocumentBO oneBO = docBO[k];
                    oneBO.setPath(uploadPath);
                    oneBO.setDocumentID(documentID);
                    if (documentID != null && documentID.trim().length() > 0) {
                        int uploadResult;
                        String remoteFileName = oneBO.getName();
                        updateFileResult[k] = uploadResult = this.ftp.uploadStream(is[k], uploadPath + remoteFileName);
                        if (uploadResult == 0) {
                            oneBO.setStatus('0');
                            continue;
                        }
                        uploadFileOK = false;
                        documentIDArray[k] = "";
                        if (uploadResult == 1) {
                            result.setResult(false, "\u6587\u4ef6\u53d1\u9001\u8fc7\u7a0b\u88ab\u4e2d\u6b62");
                            continue;
                        }
                        result.setResult(false, "\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001");
                        continue;
                    }
                    uploadFileOK = false;
                    result.setResult(false, "\u9884\u5b58\u50a8\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5");
                    break;
                }
                if (uploadFileOK && insertListSize > 0) {
                    System.out.println("============>>>==>>>==>>>============third time ,update docuent status,save docInfo");
                    String[] uploadDocumentID = this.dao.insert(docBO);
                    if (uploadDocumentID.length == documentIDArray.length) {
                        System.out.println("update query document info==================================");
                        result.setResult(true);
                    } else {
                        System.out.println("update query document info fail:==================================\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                        result.setResult(false, "\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                    }
                } else {
                    System.out.println("===================\u4e0a\u4f20\u6587\u4ef6\u4e2d\uff0c\u51fa\u73b0\u4e0a\u4f20\u5931\u8d25\u7684\u6587\u4ef6\uff0c\u629b\u51fa\u5f02\u5e38\u4fe1\u606f" + result.getResultDetail());
                }
                result.setResultID(documentIDArray);
                result.setFileSize(allFileSize);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                String exMessage = se.getMessage();
                if (exMessage.indexOf("java.io.FilePermission") != -1) {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u5ba2\u6237\u7aefJRE\u6743\u9650\u9650\u5236");
                } else {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38");
                }
                result.setResultDetail(se.getMessage());
            }
        }
        return result;
    }

    @Override
    public ServiceResult uploadFile(InputStream[] is, String[] fileName, String businessID, FMEParameter param, String[] userIds) {
        ServiceResult result = new ServiceResult();
        long allFileSize = 0L;
        int uploadCount = fileName.length;
        if (is == null || is.length <= 0 || fileName == null || fileName.length <= 0 || is.length != fileName.length) {
            System.out.println("\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull");
            result.setResult(false, "\u4e0a\u4f20\u8f93\u5165\u6d41\u4e3anull,\u6216\u8005\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e3anull,\u83b7\u53d6\u5927\u5c0f\u4e0d\u4e00\u81f4");
        } else {
            try {
                String newPathID = "";
                String newCategoryInfo = "";
                if (param != null) {
                    newPathID = param.getNewPathID();
                    newCategoryInfo = param.getNewCategoryInfo();
                    System.out.println("=\u65b0\u589eNewPathID======================" + newPathID);
                    System.out.println("=\u65b0\u589enewCategoryInfo======================" + newCategoryInfo);
                } else {
                    System.out.println("\u4f20\u5165\u7684FMEParameter \u4e3anull");
                }
                System.out.println("\u83b7\u53d6NewPathID \u5bf9\u5e94\u7684=========:" + newPathID);
                try {
                    System.out.println("============>>>===================one time query savepath ,get ftpconfig");
                    this.lazyLoadFtpServiceInstanaceByPathID(newPathID);
                }
                catch (Exception sse) {
                    System.out.println("===============================\u52a0\u8f7d\u4fdd\u5b58\u8def\u5f84\u629b\u51fa\u5f02\u5e38\uff1a" + sse.getMessage());
                }
                DocumentBO[] docBO = new DocumentBO[uploadCount];
                String[] documentIDArray = new String[uploadCount];
                for (int i = 0; i < is.length; ++i) {
                    String remoteFileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(fileName[i]));
                    String displayName = fileName[i];
                    DocumentBO oneBO = new DocumentBO();
                    oneBO.setDisplayName(displayName);
                    oneBO.setName(remoteFileName);
                    int fileSize = is[i].available();
                    allFileSize += (long)fileSize;
                    oneBO.setSize(fileSize);
                    oneBO.setStatus('3');
                    oneBO.setBusinessID(businessID);
                    if (fileName[i].length() >= 255) {
                        oneBO.setDescription(fileName[i].substring(0, 255));
                    } else {
                        oneBO.setDescription(fileName[i]);
                    }
                    oneBO.setNewPathID(newPathID);
                    oneBO.setNewCategoryInfo(newCategoryInfo);
                    oneBO.setCreaterId(userIds[i]);
                    docBO[i] = oneBO;
                }
                System.out.println("============>>>==>>>==============second time ,insert waiting upload record");
                List insertResultList = null;
                try {
                    insertResultList = this.dao.insertUnloadDocument(docBO);
                }
                catch (Exception insertUE) {
                    System.out.println("\u63d2\u5165\u5f85\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55\u629b\u51fa\u5f02\u5e38\uff1a" + insertUE.getMessage());
                }
                int insertListSize = 0;
                if (insertResultList != null) {
                    insertListSize = insertResultList.size();
                }
                int[] updateFileResult = new int[insertListSize];
                boolean uploadFileOK = true;
                for (int k = 0; k < insertListSize; ++k) {
                    String[] oneInsertResult = (String[])insertResultList.get(k);
                    String documentID = oneInsertResult[0];
                    String uploadPath = oneInsertResult[1];
                    System.out.println("&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6" + k + "Document id:" + documentID);
                    documentIDArray[k] = documentID;
                    System.out.println("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84 :" + uploadPath);
                    DocumentBO oneBO = docBO[k];
                    oneBO.setPath(uploadPath);
                    oneBO.setDocumentID(documentID);
                    if (documentID != null && documentID.trim().length() > 0) {
                        int uploadResult;
                        String remoteFileName = oneBO.getName();
                        updateFileResult[k] = uploadResult = this.ftp.uploadStream(is[k], uploadPath + remoteFileName);
                        if (uploadResult == 0) {
                            oneBO.setStatus('0');
                            continue;
                        }
                        uploadFileOK = false;
                        documentIDArray[k] = "";
                        if (uploadResult == 1) {
                            result.setResult(false, "\u6587\u4ef6\u53d1\u9001\u8fc7\u7a0b\u88ab\u4e2d\u6b62");
                            continue;
                        }
                        result.setResult(false, "\u6587\u4ef6\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff0c\u4e0d\u80fd\u53d1\u9001");
                        continue;
                    }
                    uploadFileOK = false;
                    result.setResult(false, "\u9884\u5b58\u50a8\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5EAS\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5");
                    break;
                }
                if (uploadFileOK && insertListSize > 0) {
                    System.out.println("============>>>==>>>==>>>============third time ,update docuent status,save docInfo");
                    String[] uploadDocumentID = this.dao.insert(docBO);
                    if (uploadDocumentID.length == documentIDArray.length) {
                        System.out.println("update query document info==================================");
                        result.setResult(true);
                    } else {
                        System.out.println("update query document info fail:==================================\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                        result.setResult(false, "\u9884\u4e0a\u4f20\u7684\u6587\u4ef6\u4e2d\uff0c\u66f4\u65b0\u63d2\u5165BusiDoc\u8bb0\u5f55\u5931\u8d25");
                    }
                } else {
                    System.out.println("===================\u4e0a\u4f20\u6587\u4ef6\u4e2d\uff0c\u51fa\u73b0\u4e0a\u4f20\u5931\u8d25\u7684\u6587\u4ef6\uff0c\u629b\u51fa\u5f02\u5e38\u4fe1\u606f" + result.getResultDetail());
                }
                result.setResultID(documentIDArray);
                result.setFileSize(allFileSize);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
                String exMessage = se.getMessage();
                if (exMessage.indexOf("java.io.FilePermission") != -1) {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff0c\u5ba2\u6237\u7aefJRE\u6743\u9650\u9650\u5236");
                } else {
                    result.setResult(false, "\u4e0a\u4f20\u6587\u4ef6\u64cd\u4f5c\u629b\u51fa\u5f02\u5e38");
                }
                result.setResultDetail(se.getMessage());
            }
        }
        return result;
    }

    private boolean sameUploadDocumentID(String[] documentIDArrays, String[] uploadDocIDArray) {
        boolean isSame = true;
        if (documentIDArrays == null && uploadDocIDArray != null) {
            isSame = false;
        } else if (documentIDArrays != null && uploadDocIDArray == null) {
            isSame = false;
        } else if (documentIDArrays.length != uploadDocIDArray.length) {
            isSame = false;
        } else {
            for (int i = 0; i < documentIDArrays.length; ++i) {
                System.out.println(i + "---" + documentIDArrays[i] + "    " + uploadDocIDArray[i]);
                if (documentIDArrays[i].equals(uploadDocIDArray[i])) continue;
                isSame = false;
                System.out.println("\u9884\u4e0a\u4f20\u7684\u6587\u6863ID:" + documentIDArrays[i] + "\u8ddf\u4e0a\u4f20\u66f4\u65b0\u7684\u540eID" + uploadDocIDArray[i] + "\u4e0d\u4e00\u81f4");
            }
        }
        return isSame;
    }

    @Override
    public ServiceResult downloadFile(String businessID, String documentID, String downloadFilePathName) {
        ServiceResult sr = this.downloadFile(businessID, documentID, downloadFilePathName, null, null);
        return sr;
    }

    @Override
    public ServiceResult downloadFileByOutputStream(String documentID, HttpServletRequest request, HttpServletResponse response) {
        ServiceResult result = new ServiceResult();
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
            result.setResult(false, "\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
        } else {
            try {
                DocumentBO oneBO = this.dao.queryDocumentByDocumentID(documentID);
                System.out.println("AbstractFMEService::downloadFileByOutputStream()--queryDocumentByDocumentID(documentID) is ok!,oneBO=" + oneBO);
                String serverID = oneBO.getServerID();
                System.out.println("AbstractFMEService::downloadFileByOutputStream()--oneBO.getServerID()=" + serverID);
                this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                String remoteFile = oneBO.getPath() + oneBO.getName();
                this.dao.insertOperLog(documentID, 1);
                ServletOutputStream servletOutputStream = response.getOutputStream();
                boolean downloadResult = this.ftp.downloadStreamByFileName(remoteFile, (OutputStream)servletOutputStream, oneBO);
                if (downloadResult) {
                    result.setResultDetail(remoteFile);
                    result.setResult(true, "\u4e0b\u8f7d\u6587\u4ef6" + remoteFile + "\u6210\u529f");
                    System.out.println("AbstractFMEService::downloadFileByOutputStream()----------downloadResult=" + downloadResult + "," + "\u4e0b\u8f7d\u6587\u4ef6" + remoteFile + "\u6210\u529f");
                } else {
                    result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                    System.out.println("AbstractFMEService::downloadFileInServer()----------downloadResult=" + downloadResult + "," + "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                }
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0b\u8f7d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38");
                result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
                System.err.println("AbstractFMEService::downloadFileInServer()----------has error! \u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
            }
        }
        return result;
    }

    @Override
    public ServiceResult downloadFileInServer(String businessID, String documentID, HttpServletRequest request) {
        return this.downloadFileInServer(businessID, documentID, request, false);
    }

    @Override
    public ServiceResult downloadFileInServer(String businessID, String documentID, HttpServletRequest request, boolean dealFileName) {
        return this.downloadFileInServer(businessID, documentID, request, dealFileName, false);
    }

    @Override
    public boolean isFileInFtpServer(String businessID, String documentID, boolean convertFileName) {
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u4e8eFTP\u670d\u52a1\u5668\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u5224\u65ad");
        } else {
            try {
                DocumentBO oneBO = this.dao.query(businessID, documentID);
                System.out.println("AbstractFMEService::downloadFileInServer()--this.dao.query(businessID, documentID) is ok!,oneBO=" + oneBO);
                String serverID = oneBO.getServerID();
                System.out.println("AbstractFMEService::downloadFileInServer()--oneBO.getServerID()=" + serverID);
                this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                String remoteFile = oneBO.getPath() + oneBO.getName();
                if (convertFileName) {
                    String fileName = oneBO.getName();
                    remoteFile = oneBO.getPath() + fileName.substring(0, fileName.lastIndexOf(".")) + ".swf";
                }
                return this.ftp.exists(remoteFile);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u5224\u65ad\u6587\u4ef6\u662f\u5426\u5b58\u5728\u4e8eFTP\u670d\u52a1\u5668\u629b\u51fa\u5f02\u5e38");
                System.err.println("AbstractFMEService::isFileInFtpServer()----------has error! \u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
            }
        }
        return false;
    }

    @Override
    public ServiceResult downloadFileInServer(String businessID, String documentID, HttpServletRequest request, boolean dealFileName, boolean convertFileName) {
        System.out.println("AbstractFMEService::downloadFileInServer()----parameters are ,businessID" + businessID + ",documentID=" + documentID);
        String downloadFilePathName = "";
        ServiceResult result = new ServiceResult();
        int downloadSize = -1;
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
            result.setResult(false, "\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
        } else {
            try {
                String tempDir;
                String dateTempDir;
                File parDir;
                String fileName;
                DocumentBO oneBO = this.dao.query(businessID, documentID);
                System.out.println("AbstractFMEService::downloadFileInServer()--this.dao.query(businessID, documentID) is ok!,oneBO=" + oneBO);
                String serverID = oneBO.getServerID();
                System.out.println("AbstractFMEService::downloadFileInServer()--oneBO.getServerID()=" + serverID);
                this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                String remoteFile = oneBO.getPath() + oneBO.getName();
                if (convertFileName) {
                    fileName = oneBO.getName();
                    remoteFile = oneBO.getPath() + fileName.substring(0, fileName.lastIndexOf(".")) + ".swf";
                }
                this.dao.insertOperLog(documentID, 1);
                fileName = oneBO.getName();
                if (!dealFileName || !convertFileName) {
                    fileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(oneBO.getName()));
                }
                if (dealFileName) {
                    try {
                        fileName = URLEncoder.encode(fileName, "UTF-8");
                        fileName = fileName.replaceAll("%", "");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        fileName = fileName.replaceAll("\\+", "2B");
                        fileName = fileName.replaceAll("=", "3D");
                    }
                }
                if (convertFileName) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(".")) + ".swf";
                }
                if (!(parDir = new File(SafeCheckUtils.cleanPathString(dateTempDir = (tempDir = this.getWebTempDir(request)) + this.dateToString() + File.separator))).exists()) {
                    parDir.mkdirs();
                }
                downloadFilePathName = dateTempDir + fileName;
                boolean downloadResult = false;
                if (dealFileName && convertFileName && new File(SafeCheckUtils.cleanPathString(downloadFilePathName)).exists()) {
                    System.out.println("AbstractFMEService::downloadFileInServer()----------[" + downloadFilePathName + "] exists, ignore download it again");
                    downloadResult = true;
                } else {
                    downloadResult = convertFileName ? this.ftp.downloadStreamByFileName(remoteFile, downloadFilePathName, null) : this.ftp.downloadStreamByFileName(remoteFile, downloadFilePathName, oneBO);
                }
                if (downloadResult) {
                    this.deleteOldDir(tempDir);
                    downloadSize = 1;
                    result.setResultDetail(downloadFilePathName);
                    result.setResult(true, "\u4e0b\u8f7d\u6587\u4ef6" + downloadFilePathName + "\u6210\u529f");
                    System.out.println("AbstractFMEService::downloadFileInServer()----------downloadResult=" + downloadResult + "," + "\u4e0b\u8f7d\u6587\u4ef6" + downloadFilePathName + "\u6210\u529f");
                } else {
                    downloadSize = 0;
                    result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                    System.out.println("AbstractFMEService::downloadFileInServer()----------downloadResult=" + downloadResult + "," + "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                }
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0b\u8f7d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38");
                result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
                downloadSize = 0;
                System.err.println("AbstractFMEService::downloadFileInServer()----------has error! \u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
            }
        }
        return result;
    }

    @Override
    public String getDownloadPathFileName(String businessID, String documentID, HttpServletRequest request) {
        String downloadFilePathName = "";
        try {
            DocumentBO oneBO = this.dao.query(businessID, documentID);
            String serverID = oneBO.getServerID();
            this.lazyLoadFtpServiceInstanaceByServerID(serverID);
            this.dao.insertOperLog(documentID, 1);
            String fileName = oneBO.getName();
            String tempDir = this.getWebTempDir(request);
            String dateTempDir = tempDir + this.dateToString() + File.separator;
            File parDir = new File(dateTempDir);
            if (!parDir.exists()) {
                parDir.mkdirs();
            }
            downloadFilePathName = dateTempDir + fileName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return downloadFilePathName;
    }

    private Date stringToDate(String fileName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date returnDate = null;
        try {
            returnDate = sdf.parse(fileName);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return returnDate;
    }

    private void deleteOldDir(String tempDir) {
        File temp = new File(tempDir);
        if (temp.isDirectory()) {
            File[] dirArray = temp.listFiles();
            int dirCount = 0;
            for (int m = 0; m < dirArray.length; ++m) {
                if (!dirArray[m].isDirectory()) continue;
                ++dirCount;
            }
            Object[] dirFileName = new Integer[dirCount];
            int n = 0;
            File[] otherFileArray = new File[dirCount];
            for (int i = 0; i < dirArray.length; ++i) {
                if (!dirArray[i].isDirectory()) continue;
                otherFileArray[n++] = dirArray[i];
            }
            HashMap<Object, File> fileMap = new HashMap<Object, File>();
            if (otherFileArray.length > 0) {
                for (int t = 0; t < dirCount; ++t) {
                    try {
                        dirFileName[t] = Integer.valueOf(otherFileArray[t].getName().replaceAll("-", ""));
                        fileMap.put(dirFileName[t], otherFileArray[t]);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Arrays.sort(dirFileName);
                for (int k = 0; k < dirFileName.length - 1; ++k) {
                    File deletedir = (File)fileMap.get(dirFileName[k]);
                    AbstractFMEService.deleteFile(deletedir.getPath());
                }
            }
        }
    }

    public static void deleteFile(String filePath) {
        try {
            System.out.println("Begin delete files from :=" + filePath);
            File file = new File(filePath);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] fileList = file.listFiles();
                    if (fileList != null && fileList.length > 0) {
                        for (int i = 0; i < fileList.length; ++i) {
                            String path = fileList[i].getCanonicalPath();
                            AbstractFMEService.deleteFile(path);
                        }
                    }
                } else {
                    System.out.println("Delete file :=" + file.getCanonicalPath());
                    file.delete();
                }
                file.delete();
            }
        }
        catch (Exception e) {
            System.out.println("delete file error");
            e.printStackTrace();
        }
    }

    private String returnDleteDir(String filename1, String filename2) {
        Date fileDate2;
        String returnFileName = null;
        Date fileDate1 = this.stringToDate(filename1);
        returnFileName = fileDate1.compareTo(fileDate2 = this.stringToDate(filename2)) == -1 ? filename1 : filename2;
        return returnFileName;
    }

    @Override
    public ServiceResult downloadFileInServer(String documentID, HttpServletRequest request) {
        String downloadFilePathName = "";
        ServiceResult result = new ServiceResult();
        int downloadSize = -1;
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
            result.setResult(false, "\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
        } else {
            try {
                boolean downloadResult;
                System.out.println("downloadFile==========>=============1 request DAO===queryDownloadFileInfo============");
                DocumentBO oneBO = this.dao.queryDocumentByDocumentID(documentID);
                String serverID = oneBO.getServerID();
                System.out.println("downloadFile==========>=============2 request DAO===lazyLoadFtpConfig============");
                this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                String remoteFile = oneBO.getPath() + oneBO.getName();
                this.dao.insertOperLog(documentID, 1);
                String fileName = FMEUIUtils.getRandomFileName(FMEUIUtils.getFileExtName(oneBO.getName()));
                String tempDir = this.getWebTempDir(request);
                String dateTempDir = tempDir + this.dateToString() + File.separator;
                File parDir = new File(dateTempDir);
                if (!parDir.exists()) {
                    parDir.mkdirs();
                }
                if (downloadResult = this.ftp.downloadStreamByFileName(remoteFile, downloadFilePathName = dateTempDir + fileName)) {
                    this.deleteOldDir(tempDir);
                    downloadSize = 1;
                    result.setResultDetail(downloadFilePathName);
                    result.setResult(true, "\u4e0b\u8f7d\u6587\u4ef6" + downloadFilePathName + "\u6210\u529f");
                } else {
                    downloadSize = 0;
                    result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                }
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0b\u8f7d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38");
                result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
                downloadSize = 0;
            }
        }
        return result;
    }

    private String dateToString() {
        Date time = new Date();
        String returnTimeStr = new SimpleDateFormat("yyyy-MM-dd").format(time);
        return returnTimeStr;
    }

    private String getWebTempDir(HttpServletRequest request) {
        String path = request.getRealPath("/");
        int fpos = path.indexOf("easweb.ear");
        String rootPath = "";
        if (fpos != -1) {
            rootPath = path.substring(0, fpos);
        }
        String tempDir = rootPath + "easweb.ear" + File.separator + "eas_web.war" + File.separator + "bs" + File.separator + "fme" + File.separator + "temp" + File.separator;
        return tempDir;
    }

    @Override
    public FtpConfig getFtpConfig(String businessID, String documentID) {
        FtpConfig config = null;
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u83b7\u53d6ftp\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6ftp\u4fe1\u606f");
        } else {
            try {
                System.out.println("getFtpConfig==========>=============1 request DAO===queryDownloadFileInfo============");
                DocumentBO oneBO = this.dao.query(businessID, documentID);
                String serverID = oneBO.getServerID();
                System.out.println("getFtpConfig==========>=>============2 request DAO===lazyLoadFtpConfig============");
                config = this.lazyLoadFtpConfigByServerID(serverID);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u83b7\u53d6ftp\u629b\u51fa\u5f02\u5e38");
            }
        }
        return config;
    }

    @Override
    public DocumentBO getDocumentByDocumentID(String businessID, String documentID) {
        System.out.println("\u6839\u636edocumentid\u83b7\u53d6\u6587\u4ef6\u5176\u4ed6\u4fe1\u606f\uff0c\u6587\u6863documentid\u4e3a\uff1a" + documentID);
        DocumentBO oneBO = null;
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u83b7\u53d6ftp\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u83b7\u53d6ftp\u4fe1\u606f");
        } else {
            try {
                oneBO = this.dao.query(businessID, documentID);
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u83b7\u53d6path\u629b\u51fa\u5f02\u5e38");
            }
        }
        if (oneBO != null) {
            System.out.println("\u6839\u636edocumentID\u83b7\u53d6\u6587\u6863\u4fe1\u606f\u6210\u529f\uff01");
        }
        return oneBO;
    }

    @Override
    public ServiceResult downloadFile(String businessID, String documentID, String downloadFilePathName, Component component, String downloadIndex) {
        long downloadSize = -1L;
        ServiceResult result = new ServiceResult();
        if (FMEUIUtils.isBlankString(documentID)) {
            System.out.println("\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
            result.setResult(false, "\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6307\u5b9a\u7684\u6587\u4ef6ID\u4e3a\u7a7a,\u65e0\u6cd5\u8fdb\u884c\u4e0b\u8f7d");
        } else {
            try {
                System.out.println("downloadFile==========>=============1 request DAO===queryDownloadFileInfo============");
                DocumentBO oneBO = this.dao.query(businessID, documentID);
                String serverID = oneBO.getServerID();
                System.out.println("downloadFile==========>=>============2 request DAO===lazyLoadFtpConfig============");
                this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                String remoteFile = oneBO.getPath() + oneBO.getName();
                this.dao.insertOperLog(documentID, 1);
                int downloadResult = this.ftp.downloadStream(component, "\u6b63\u5728\u4e0b\u8f7d......", remoteFile, downloadFilePathName, downloadIndex, oneBO);
                if (downloadResult == 1) {
                    downloadSize = 1L;
                    result.setResult(true, "\u4e0b\u8f7d\u6587\u4ef6" + downloadFilePathName + "\u6210\u529f");
                } else if (downloadResult == 0) {
                    downloadSize = 0L;
                    result.setResult(false, "\u4fdd\u5b58\u6587\u4ef6\u88ab\u53d6\u6d88!");
                } else if (downloadResult == -1) {
                    downloadSize = 0L;
                    result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u65e0\u6cd5\u8fde\u63a5\u670d\u52a1\u5668");
                } else {
                    downloadSize = 0L;
                    result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
            }
            catch (Exception se) {
                se.printStackTrace();
                System.err.println("\u4e0b\u8f7d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38");
                result.setResult(false, "\u4fdd\u5b58\u5931\u8d25,\u5185\u90e8\u5f02\u5e38");
                downloadSize = 0L;
            }
        }
        return result;
    }

    @Override
    public boolean deleteFile(String businessID, String documentID, int deleteType) {
        boolean deleteResult;
        try {
            System.out.println("deleteFile==========>=============1 request DAO===queryDeleteFileInfo============");
            DocumentBO dbo = this.dao.query(businessID, documentID);
            String remoteFileInfo = dbo.getPath() + dbo.getName();
            System.out.println("deleteFile==========>=>============2 request DAO===delete File DB Record============");
            int deleteDaoResult = this.dao.delete(businessID, documentID, deleteType);
            if (deleteDaoResult == -1) {
                System.err.println("\u5220\u9664\u6587\u4ef6\u5931\u8d25\u6216\u8005\u629b\u51fa\u5185\u90e8\u5f02\u5e38");
                deleteResult = false;
            } else {
                switch (deleteDaoResult) {
                    case 0: {
                        String serverID = dbo.getServerID();
                        System.out.println("deleteFile==========>=>=>===========3 request DAO===lazyLoadFtpConfig============");
                        this.lazyLoadFtpServiceInstanaceByServerID(serverID);
                        System.out.println("===============\u5bf9\u6587\u4ef6\u6267\u884c\u7269\u7406\u5220\u9664\uff0c\u6587\u4ef6\u5c06\u4e0d\u518d\u88ab\u4fdd\u5b58");
                        deleteResult = this.ftp.delete(remoteFileInfo);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        System.err.println("\u4e0d\u6b63\u5e38\u7684\u5220\u9664\u72b6\u6001\uff0c\u65e0\u6cd5\u5904\u7406\u5220\u9664\u64cd\u4f5c");
                    }
                }
            }
            deleteResult = true;
        }
        catch (Exception se) {
            se.printStackTrace();
            System.err.println("\u5220\u9664Ftp\u4e0a\u7684\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            deleteResult = false;
        }
        return deleteResult;
    }

    @Override
    public boolean deleteFile(String businessID, String[] documentID, int deleteTpype) {
        return false;
    }

    @Override
    public String renameFile(String businessID, String documentID, String newName) {
        String updateDocumentID = "";
        try {
            DocumentBO oneBO = this.dao.query(businessID, documentID);
            if (oneBO != null) {
                oneBO.setDisplayName(newName);
                String[] updateResult = this.dao.update(new DocumentBO[]{oneBO});
                if (updateResult != null && updateResult.length >= 1) {
                    updateDocumentID = updateResult[0];
                }
            } else {
                System.err.println("\u67e5\u8be2businessid :" + businessID + "--documentID:" + documentID + "\u6ca1\u6709\u76f8\u5e94\u7684\u6587\u4ef6\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
        }
        catch (Exception se) {
            se.printStackTrace();
            System.err.println("\u91cd\u547d\u540d\u6587\u4ef6\u629b\u51fa\u5f02\u5e38" + se.getMessage());
        }
        return updateDocumentID;
    }

    @Override
    public DocumentBO[] getFileInfo(String businessID) {
        DocumentBO[] retBOArray = null;
        try {
            retBOArray = this.dao.query(businessID);
        }
        catch (Exception se) {
            System.err.println("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u629b\u51fa\u5f02\u5e38" + se.getMessage());
        }
        return retBOArray;
    }

    @Override
    public DocumentBO[] getFileInfo(String businessID, boolean showDownloadTime) {
        if (showDownloadTime) {
            DocumentBO[] retBOArray = null;
            try {
                retBOArray = this.dao.queryWithDownloadCount(businessID);
            }
            catch (Exception se) {
                System.err.println("\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u629b\u51fa\u5f02\u5e38" + se.getMessage());
            }
            return retBOArray;
        }
        return this.getFileInfo(businessID);
    }

    @Override
    public String[] replyBusinessDocument(String businessID, String[] documentIDArray, String[] fileNameArray) {
        String[] retBDResult = null;
        try {
            retBDResult = this.dao.insertBusiDoc(businessID, documentIDArray, fileNameArray);
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u589e\u52a0\u6587\u4ef6\u5e94\u7528\u4fe1\u606f\u629b\u51fa\u5f02\u5e38" + se.getMessage());
        }
        return retBDResult;
    }

    @Override
    public boolean deleteFile(String[] businessID) {
        boolean deleteResult = false;
        try {
            int deleteBCount = businessID.length;
            for (int i = 0; i < deleteBCount; ++i) {
                String oneBusinessID = businessID[i];
                DocumentBO[] queryBO = this.dao.query(oneBusinessID);
                if (queryBO != null && queryBO.length > 0) {
                    int documentBOLength = queryBO.length;
                    for (int j = 0; j < documentBOLength; ++j) {
                        boolean delete = this.deleteFile(oneBusinessID, queryBO[j].getDocumentID(), 0);
                        if (!delete) continue;
                        deleteResult = true;
                    }
                    continue;
                }
                System.out.println("\u5bf9\u5e94\u4e1a\u52a1ID\u7684" + oneBusinessID + "\u6ca1\u6709\u7ba1\u7406\u7684\u6587\u4ef6\u8bb0\u5f55");
                deleteResult = true;
            }
            System.out.println("\u6210\u529f\u5220\u9664\u6587\u4ef6" + deleteBCount);
        }
        catch (Exception se) {
            se.printStackTrace();
            System.out.println("\u5220\u9664deleteFile(String[] businessID)\u6587\u4ef6\u62a5\u9519:" + se.getMessage());
            deleteResult = false;
        }
        return deleteResult;
    }

    @Override
    public Map getDocumenIconMap() throws Exception {
        Map iconMap = null;
        try {
            iconMap = this.dao.getIcon();
        }
        catch (Exception se) {
            throw new Exception("getDocumenIconMap throws Exception", se);
        }
        return iconMap;
    }

    @Override
    public FtpDocumentInfo getFtpFile(String serverID, String rootPath) throws Exception {
        this.lazyLoadFtpServiceInstanaceByServerID(serverID);
        return this.ftp.getFtpDocumentInfo(serverID, rootPath);
    }
}

