/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import com.kingdee.eas.base.fme.ui.FMESimpleFilter;
import com.kingdee.eas.base.fme.ui.FMEUIRes;
import com.kingdee.eas.base.fme.uimodel.FMEFileElement;
import com.kingdee.eas.base.fme.uimodel.FMEParameter;
import com.kingdee.eas.base.fme.util.FMEUuid;
import com.kingdee.eas.util.BASE64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FMEUIUtils {
    private static String currentLocationURL = "";
    private static final long RANDOM_SEED = 999999L;
    private static long lastRandomLongValue;
    private static final String DEFAULT_FILE_EXT_NAME = ".tmp";
    private static final int BASE64_ENCODING_LENGTH = 44;
    public static final String JAVA_IO_DIR = "java.io.tmpdir";
    public static final String PARAM_AllowFileType = "allowFileType";
    public static final String PARAM_ClientType = "clientType";
    public static final String PARAM_ForbidFileType = "forbidFileType";
    public static final String PARAM_NewBusinessID = "newBusinessID";
    public static final String PARAM_NewCategoryInfo = "newCategoryInfo";
    public static final String PARAM_NewPathID = "newPathID";
    public static final String PARAM_OperType = "operType";
    public static final String PARAM_QueryBusinessID = "queryBusinessID";
    public static final String PARAM_QueryCateogryInfo = "queryCategoryInfo";
    public static final String PARAM_QueryPathID = "queryPathID";
    public static final String PARAM_AllowTypeFilesSize = "allowTypeFilesSize";
    public static final String PARAM_AllowUpload = "allowUpload";
    public static final String FME_PARAM = "fmeParam";
    public static final String NEEDOPEROBJECT_objIndex = "objIndex";
    public static final String NEEDOPEROBJECT_objKey = "objKey";
    public static final String NEEDOPEROBJECT_ffElement = "ffElement";

    public static void setLocationURL(String locationURL) {
        System.out.println("\u5168\u5c40\u8bbe\u7f6eLocationURL" + locationURL);
        currentLocationURL = locationURL;
    }

    public static String getLocationURL() {
        System.out.println("\u83b7\u53d6\u5168\u5c40LocationURL" + currentLocationURL);
        return currentLocationURL;
    }

    public static String getRandomFileName(String fileExtName) {
        Random rd = new Random(999999L);
        if (fileExtName == null || fileExtName.trim().length() <= 0) {
            fileExtName = DEFAULT_FILE_EXT_NAME;
        }
        String randomStr = FMEUIUtils.getSimpleUUIDString("" + rd.nextLong() + FMEUIUtils.getCurrrentDate().getTime());
        randomStr = randomStr.replaceAll("\\/", "G");
        return "" + randomStr + "." + fileExtName;
    }

    public static String getRandomTempFileName(String fileExtName) {
        Random rd = new Random(999999L);
        String randomStr = "temp";
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        randomStr = randomStr + df.format(date) + rd.nextInt() + "";
        if (fileExtName == null || "".equals(fileExtName.trim())) {
            return randomStr;
        }
        return "" + randomStr + "." + fileExtName;
    }

    public static String getSimpleUUIDString(String type) {
        String uuidStr = "";
        try {
            FMEUuid uuid = FMEUuid.randomUUID();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(44);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeLong(uuid.getMostSignificantBits());
                out.writeLong(uuid.getLeastSignificantBits());
                out.writeInt(type.hashCode());
            }
            catch (IOException ioe) {
                throw new Exception(ioe);
            }
            BASE64Encoder be = new BASE64Encoder();
            uuidStr = be.encode(baos.toByteArray());
        }
        catch (Exception se) {
            System.out.println("FMEUIUtils\u521b\u5efa SimpleUUID\u629b\u51fa\u5f02\u5e38:" + se.getMessage());
        }
        return uuidStr;
    }

    public static long getRandomFileSize() {
        Random rd = null;
        rd = lastRandomLongValue == 0L ? new Random(999999L) : new Random(lastRandomLongValue);
        Random rd2 = new Random(rd.nextLong());
        lastRandomLongValue = rd2.nextLong();
        return lastRandomLongValue;
    }

    public static Date getCurrrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static String getFileNameFromAbsolutePath(String name) {
        String fileName = "";
        int lastPos = name.lastIndexOf(File.separator);
        if (lastPos != -1) {
            fileName = name.substring(lastPos + 1);
        } else {
            lastPos = name.lastIndexOf("/");
            if (lastPos != -1) {
                fileName = name.substring(lastPos + 1);
            }
        }
        return fileName;
    }

    public static String getFileExtName(String name) {
        String fileExtName = "";
        int lastPos = name.lastIndexOf(".");
        fileExtName = lastPos != -1 ? name.substring(lastPos + 1) : "udd";
        return fileExtName;
    }

    public static String getFileDirPath(String name) {
        String fileDirPath = "";
        int fileSeperatorPos = name.lastIndexOf(File.separator);
        fileDirPath = fileSeperatorPos != -1 ? name.substring(0, fileSeperatorPos) : FMEUIRes.DEFAULT_DIR_PATH;
        return fileDirPath;
    }

    public static boolean isForbidFile(String uploadFileType, String forbidType) {
        boolean isForbid = false;
        String[] formbidArray = forbidType.toLowerCase().split(",");
        for (int i = 0; i < formbidArray.length; ++i) {
            if (!uploadFileType.trim().equalsIgnoreCase(formbidArray[i])) continue;
            System.out.println("\u9650\u5236\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + forbidType);
            System.out.println("\u51c6\u5907\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + uploadFileType);
            isForbid = true;
            break;
        }
        return isForbid;
    }

    public static boolean isAllowFile(String uploadFileType, String allowType) {
        boolean isAllow = false;
        String uploadFileType_Temp = uploadFileType.toLowerCase();
        String forbidTypeEnum = allowType.toLowerCase() + ",";
        if (forbidTypeEnum.indexOf(uploadFileType_Temp + ",") != -1) {
            System.out.println("\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + allowType);
            System.out.println("\u51c6\u5907\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e3a\uff1a" + uploadFileType);
            isAllow = true;
        }
        return isAllow;
    }

    public static List getAllowFileFMEFilter(String allowFileType) {
        ArrayList<FMESimpleFilter> filterList = new ArrayList<FMESimpleFilter>();
        String[] extNameArray = allowFileType.split(",");
        for (int i = 0; i < extNameArray.length; ++i) {
            String extName = extNameArray[i];
            FMESimpleFilter oneFilter = new FMESimpleFilter("." + extName, extName.toUpperCase() + "Files (." + extName + ")");
            filterList.add(oneFilter);
        }
        return filterList;
    }

    public static boolean isBlankString(String validateStr) {
        if (validateStr == null) {
            return true;
        }
        return validateStr.trim().length() <= 0;
    }

    public static String getClientTempDir() {
        return System.getProperty(JAVA_IO_DIR);
    }

    public static FMEParameter parseJSONParameter(String jsonParameter) {
        FMEParameter param = new FMEParameter();
        try {
            JSONObject obj = FMEUIUtils.getJSONObject(jsonParameter);
            System.out.println(obj);
            JSONObject paramJSON = obj.getJSONObject(FME_PARAM);
            param.setAllowCount(paramJSON.getInt("allowFileCount"));
            param.setAllowSize(paramJSON.getInt("allowFileSize"));
            param.setClientType(paramJSON.getInt(PARAM_ClientType));
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_AllowFileType))) {
                param.setAllowFileType(paramJSON.getString(PARAM_AllowFileType));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_AllowTypeFilesSize))) {
                param.setAllowTypeFilesSize(paramJSON.getString(PARAM_AllowTypeFilesSize));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_AllowUpload))) {
                param.setAllowUpload(Boolean.valueOf(paramJSON.getString(PARAM_AllowUpload)));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_ForbidFileType))) {
                param.setForbidFileType(paramJSON.getString(PARAM_ForbidFileType));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_NewBusinessID))) {
                param.setNewBusinessID(paramJSON.getString(PARAM_NewBusinessID));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_NewCategoryInfo))) {
                param.setNewCategoryInfo(paramJSON.getString(PARAM_NewCategoryInfo));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_NewPathID))) {
                param.setNewPathID(paramJSON.getString(PARAM_NewPathID));
            }
            param.setOperType(paramJSON.getInt(PARAM_OperType));
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_QueryBusinessID))) {
                param.setQueryBusinessID(paramJSON.getString(PARAM_QueryBusinessID));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_QueryCateogryInfo))) {
                param.setQueryCategoryInfo(paramJSON.getString(PARAM_QueryCateogryInfo));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString(PARAM_QueryPathID))) {
                param.setQueryPathID(paramJSON.getString(PARAM_QueryPathID));
            }
            if (!FMEUIUtils.isBlankString(paramJSON.getString("sizeUnit"))) {
                param.setSizeUnit(paramJSON.getString("sizeUnit"));
            }
        }
        catch (JSONException jsonExt) {
            System.out.println("\u89e3\u6790JSON\u629b\u51fa\u5f02\u5e38:" + jsonExt.getMessage());
        }
        return param;
    }

    public static JSONObject getJSONObject(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(str);
        }
        catch (JSONException e) {
            e.printStackTrace(System.err);
        }
        return jsonObject;
    }

    public static JSONArray getJSONArray(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        JSONArray jsonObject = null;
        try {
            jsonObject = new JSONArray(str);
        }
        catch (JSONException e) {
            e.printStackTrace(System.err);
        }
        return jsonObject;
    }

    public static String getJSONParameter(FMEParameter param) {
        StringBuffer sb = new StringBuffer();
        JSONObject paramObj = new JSONObject();
        JSONObject params = new JSONObject();
        try {
            params.put("allowFileCount", param.getAllowCount());
            params.put(PARAM_AllowFileType, param.getAllowFileType());
            params.put("allowFileSize", param.getAllowSize());
            params.put("sizeUnit", param.getSizeUnit());
            params.put(PARAM_ClientType, param.getClientType());
            params.put(PARAM_ForbidFileType, param.getForbidFileType());
            params.put(PARAM_NewBusinessID, param.getNewBusinessID());
            params.put(PARAM_NewCategoryInfo, param.getNewCategoryInfo());
            params.put(PARAM_NewPathID, param.getNewPathID());
            params.put(PARAM_OperType, param.getOperType());
            params.put(PARAM_QueryBusinessID, param.getQueryBusinessID());
            params.put(PARAM_QueryCateogryInfo, param.getQueryCategoryInfo());
            params.put(PARAM_QueryPathID, param.getQueryPathID());
            paramObj.put(PARAM_AllowTypeFilesSize, param.getAllowTypeFilesSize());
            paramObj.put(PARAM_AllowUpload, String.valueOf(param.isAllowUpload()));
            paramObj.put(FME_PARAM, params);
        }
        catch (JSONException jsonExt) {
            System.out.println("\u589e\u52a0JSON\u5bf9\u8c61\uff0c\u629b\u51fa\u5f02\u5e38:" + jsonExt.getMessage());
        }
        return paramObj.toString();
    }

    public static List parseJSONNeedOperObject(String jsonFileElement) {
        ArrayList<FMEFileElement> needOperObjectList = new ArrayList<FMEFileElement>();
        try {
            JSONArray objArray = FMEUIUtils.getJSONArray(jsonFileElement);
            System.out.println(objArray);
            int arraySize = objArray.length();
            for (int i = 0; i < arraySize; ++i) {
                JSONObject ffElementObj = objArray.getJSONObject(i);
                String uuid = ffElementObj.getString("uuid");
                String path = ffElementObj.getString("path");
                String name = ffElementObj.getString("name");
                String size = ffElementObj.getString("size");
                long intSize = ffElementObj.getLong("intSize");
                String docid = ffElementObj.getString("docid");
                String businessID = ffElementObj.getString("businessID");
                String downloadPath = ffElementObj.getString("downloadPath");
                int fileIndex = ffElementObj.getInt("fileIndex");
                boolean onServer = ffElementObj.getBoolean("onServer");
                boolean isOpenDownload = ffElementObj.getBoolean("isOpenDownload");
                boolean downloadFinished = ffElementObj.getBoolean("downloadFinished");
                FMEFileElement oneElement = new FMEFileElement(uuid, path, name, size, docid);
                oneElement.setBusinessID(businessID);
                oneElement.setDownloadPath(downloadPath);
                oneElement.setFileIndex(fileIndex);
                oneElement.setDownloadFinished(downloadFinished);
                oneElement.setOnServer(onServer);
                oneElement.setIntSize(intSize);
                oneElement.setOpenDownload(isOpenDownload);
                needOperObjectList.add(oneElement);
            }
        }
        catch (JSONException jsonExt) {
            System.out.println("\u89e3\u6790JSON\u629b\u51fa\u5f02\u5e38:" + jsonExt.getMessage());
        }
        return needOperObjectList;
    }

    public static String replaceEscapeChar(String str) {
        if (null != str && !"".equals(str.trim())) {
            for (int i = 0; i < str.length(); ++i) {
                if ((byte)str.charAt(i) != 92) continue;
                str = str.substring(0, i) + "/" + str.substring(i + 1, str.length());
            }
        }
        return str;
    }

    public static boolean isOnlineOpenType(String fileType) {
        boolean isOnlineOpenType = false;
        ArrayList<String> allowOnlineOpenType = new ArrayList<String>();
        allowOnlineOpenType.add("swf");
        allowOnlineOpenType.add("pdf");
        allowOnlineOpenType.add("docx");
        allowOnlineOpenType.add("doc");
        allowOnlineOpenType.add("dot");
        allowOnlineOpenType.add("vsd");
        allowOnlineOpenType.add("mpp");
        allowOnlineOpenType.add("xlsx");
        allowOnlineOpenType.add("xls");
        allowOnlineOpenType.add("pptx");
        allowOnlineOpenType.add("ppt");
        allowOnlineOpenType.add("txt");
        allowOnlineOpenType.add("html");
        allowOnlineOpenType.add("wmv");
        allowOnlineOpenType.add("asf");
        allowOnlineOpenType.add("wma");
        allowOnlineOpenType.add("wm");
        allowOnlineOpenType.add("avi");
        allowOnlineOpenType.add("mpg");
        allowOnlineOpenType.add("mpeg");
        allowOnlineOpenType.add("mp3");
        allowOnlineOpenType.add("mid");
        allowOnlineOpenType.add("midi");
        allowOnlineOpenType.add("rmi");
        allowOnlineOpenType.add("wav");
        allowOnlineOpenType.add("vob");
        fileType = fileType.toLowerCase();
        if (allowOnlineOpenType.indexOf(fileType) != -1) {
            isOnlineOpenType = true;
        }
        return isOnlineOpenType;
    }

    public static boolean isAudioFileType(String fileName) {
        boolean isAudioFile = false;
        ArrayList<String> fileType = new ArrayList<String>();
        fileType.add("wmv");
        fileType.add("asf");
        fileType.add("wma");
        fileType.add("wm");
        fileType.add("avi");
        fileType.add("mpg");
        fileType.add("mpeg");
        fileType.add("mp3");
        fileType.add("mid");
        fileType.add("midi");
        fileType.add("rmi");
        fileType.add("wav");
        int index = fileName.lastIndexOf(".");
        String uploadFileType = "";
        if (index != -1) {
            uploadFileType = fileName.substring(index + 1).toLowerCase();
        }
        if (fileType.indexOf(uploadFileType) != -1) {
            isAudioFile = true;
        }
        return isAudioFile;
    }

    public static boolean isPdfFile(String fileName) {
        boolean isPdfFile = false;
        int index = fileName.lastIndexOf(".");
        String uploadFileType = "";
        if (index != -1) {
            uploadFileType = fileName.substring(index + 1).toLowerCase();
        }
        if (uploadFileType.equals("pdf")) {
            isPdfFile = true;
        }
        return isPdfFile;
    }

    public static boolean isSwfFile(String fileName) {
        boolean isSwfFile = false;
        int index = fileName.lastIndexOf(".");
        String uploadFileType = "";
        if (index != -1) {
            uploadFileType = fileName.substring(index + 1).toLowerCase();
        }
        if (uploadFileType.equals("swf") || uploadFileType.equals("SWF")) {
            isSwfFile = true;
        }
        return isSwfFile;
    }

    public static boolean isOfficeFileType(String fileType) {
        return "doc".equals(fileType) || "docx".equals(fileType) || "dot".equals(fileType) || "xls".equals(fileType) || "xlsx".equals(fileType) || "ppt".equals(fileType) || "pptx".equals(fileType) || "vsd".equals(fileType) || "mpp".equals(fileType);
    }
}

