/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.fme.util;

import com.enterprisedt.util.safe.SafeCheckUtils;
import java.io.File;
import java.io.FileWriter;

public class PolicyUtils {
    public static boolean checkJavaPolicy() {
        String sysDir = System.getProperty("deployment.system.home");
        System.out.println("sysDir:" + sysDir);
        boolean isSysBoot = PolicyUtils.checkPolicyDir(sysDir);
        String userDir = System.getProperty("deployment.user.home");
        System.out.println("userDir:" + userDir);
        boolean isUserBoot = PolicyUtils.checkPolicyDir(userDir);
        if (isSysBoot || isUserBoot) {
            System.out.println("\u60a8\u7684\u7cfb\u7edf\u4f5c\u9996\u6b21\u521d\u59cb\u5316\u64cd\u4f5c\u6210\u529f\uff0c\u5982\u679c\u65e0\u6cd5\u6b63\u5e38\u5de5\u4f5c\uff0c\u8bf7\u5173\u95ed\u6d4f\u89c8\u5668\u5e76\u91cd\u65b0\u6253\u5f00\u91cd\u8bd5\u3002");
        }
        return true;
    }

    private static boolean checkPolicyDir(String sDir) {
        boolean result;
        block7: {
            result = false;
            String vers = System.getProperty("java.version");
            try {
                if (vers.compareTo("1.4") < 0) {
                    String path = System.getProperty("java.home");
                    String securityFilePath = path + "/lib/security";
                    System.out.println("securityFilePath:" + securityFilePath);
                    String policyFile = securityFilePath + "/java.policy";
                    if (PolicyUtils.checkFile(policyFile) == 0) {
                        File f = new File(policyFile);
                        f.delete();
                        System.out.println("Original Policy file deleted!");
                        PolicyUtils.writePolicyFile(policyFile);
                    } else {
                        PolicyUtils.writePolicyFile(policyFile);
                    }
                    break block7;
                }
                if (sDir != null) {
                    String policyPath = sDir + "/security";
                    String policyFile = policyPath + "/java.policy";
                    if (PolicyUtils.checkFile(policyFile) == 0) {
                        return false;
                    }
                    PolicyUtils.createDir(policyPath);
                    result = PolicyUtils.writePolicyFile(policyFile);
                }
                return result;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private static boolean writePolicyFile(String policyFile) {
        try {
            FileWriter fout = new FileWriter(SafeCheckUtils.cleanPathString(policyFile));
            fout.write("grant { \r");
            fout.write("  permission java.security.AllPermission; \r");
            fout.write("  }; \r");
            fout.flush();
            fout.close();
            System.out.println("policy Write OK:" + policyFile);
            return true;
        }
        catch (Exception ex) {
            System.err.println("write policy file is error:" + ex.getMessage());
            return false;
        }
    }

    private static void createDir(String _path) {
        try {
            File f = new File(SafeCheckUtils.cleanPathString(_path));
            if (!f.exists()) {
                f.mkdirs();
            }
            System.out.println("Create Direcory:" + _path);
        }
        catch (Exception ex) {
            System.err.println("Create Direcory Error: " + ex.getMessage());
        }
    }

    private static int checkFile(String filename) {
        File f = new File(SafeCheckUtils.cleanPathString(filename));
        if (f.isFile()) {
            return 0;
        }
        if (f.isDirectory()) {
            return 1;
        }
        return -1;
    }
}

