/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.list;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.filter.commonfiltermodel.ColumnField;
import com.kingdee.eas.base.filter.commonfiltermodel.FilterParameter;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.app.SQLBuilder;
import com.kingdee.eas.base.form.expression.DefaultValueCalculator;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityTable;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpTable;
import com.kingdee.eas.base.form.metadata.QueryInfo;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.eas.base.form.model.DynamicFormModel;
import com.kingdee.eas.base.form.model.PageQueryProxy;
import com.kingdee.eas.base.form.model.command.BeforeDeleteArg;
import com.kingdee.eas.base.form.model.command.BeforeQueryArg;
import com.kingdee.eas.base.form.model.command.QuickQueryDefaultValue;
import com.kingdee.eas.base.form.model.list.IListModel;
import com.kingdee.eas.base.form.model.list.ListApplication;
import com.kingdee.eas.base.form.model.list.ListEventsProxy;
import com.kingdee.eas.base.form.model.list.ListQuickFilterModel;
import com.kingdee.eas.base.form.util.OrderByString;
import com.kingdee.eas.base.form.util.PermissionHelper;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListModel
extends DynamicFormModel
implements IListModel {
    private static final Log log = LogFactory.getLog(ListModel.class);
    private ListQuickFilterModel quickFilterModel;
    private ListEventsProxy.ModelEventsProxy eventsProxy;
    private BusinessInfo bInfo;
    private ListApplication application;
    private QueryInfo queryInfo;
    private SQLBuilder sqlBuilder;
    private FilterParameter filter;
    private FilterInfo linkFilter;
    private String pkSql;
    private int rowCount = 0;
    private String pkFieldName;
    private String mainOrgFieldName;
    private String viewPermItemName;
    private OrgUnitInfo defaultMainOrg;
    private boolean hasFuncPermission = true;
    private LayoutInfo layoutInfo;
    public static int QT_QuickFilter = 1;
    public static int QT_AdvancedFilter = 2;
    private int curQueryType = 0;
    private int prevQueryType = 0;
    private PageQueryProxy pageQuery;
    private EntityTable entryTable;
    private String defaultOrderByField;
    private QuickQueryDefaultValue dvalueArg;
    private String mainOrgV;
    private Set filterFieldsFromPlugin = new HashSet();

    @Override
    public String getMainOrg() {
        return this.mainOrgV;
    }

    public ListModel(BusinessInfo bInfo, LayoutInfo layoutInfo, QueryInfo queryInfo, Context context, QuickQueryDefaultValue dvalueArg) {
        super(bInfo);
        this.bInfo = bInfo;
        this.layoutInfo = layoutInfo;
        FormOperation fo = bInfo.getForm().getOperation("VIEW");
        if (fo != null) {
            this.viewPermItemName = fo.getPermissionItem();
        }
        this.queryInfo = queryInfo;
        this.dvalueArg = dvalueArg;
        this.initQuickFilterModel();
    }

    @Override
    public boolean isQuerySQLBuilt() {
        return this.pkSql != null;
    }

    private void initQuickFilterModel() {
        List quickFilterFields = this.queryInfo.getQuickFilterFields();
        this.quickFilterModel = new ListQuickFilterModel(this.bInfo, this.layoutInfo, quickFilterFields, this.dvalueArg);
    }

    private void initSQLBuilder() {
        this.sqlBuilder = new SQLBuilder(this.queryInfo);
        this.sqlBuilder.setMasterEntityKey("FBillHead");
        this.pkFieldName = this.sqlBuilder.getPk();
    }

    private void selectEntityTable() {
        this.entryTable = null;
        if (this.filter.getSelectedEntities() != null) {
            this.sqlBuilder.setSelectEntitys(this.filter.getSelectedEntities());
            for (String entityKey : this.filter.getSelectedEntities()) {
                Entity entity = this.businessInfo.getEntity(entityKey);
                if (entity.getEntityType() != 1) continue;
                this.entryTable = this.queryInfo.getEntityTable(entityKey);
            }
        } else {
            ArrayList<String> entries = new ArrayList<String>();
            List entities = this.queryInfo.getEntityTables();
            for (EntityTable table : entities) {
                boolean anyFieldRequired = false;
                if (table.getKey().equals("FBillHead")) {
                    entries.add(table.getKey());
                } else {
                    List selectFields = this.queryInfo.getListVisibleSelectFields();
                    for (SelectField sf : selectFields) {
                        if (!sf.isDefaultListVisible() || !sf.getEntityKey().equalsIgnoreCase(table.getKey())) continue;
                        anyFieldRequired = true;
                        break;
                    }
                }
                if (!anyFieldRequired) continue;
                entries.add(table.getKey());
                this.entryTable = table;
                break;
            }
            this.sqlBuilder.setSelectEntitys(entries, true);
        }
    }

    @Override
    public DefaultValueCalculator getDefaultValueCalculator() {
        return new DefaultValueCalculator(this.quickFilterModel.getApplication(), this.bInfo, null);
    }

    @Override
    public ListQuickFilterModel getQuickFilterModel() {
        return this.quickFilterModel;
    }

    @Override
    public OrgUnitInfo getDefaultMainOrg() throws BOSException {
        Field mainOrgField;
        if (this.defaultMainOrg == null && (mainOrgField = this.bInfo.getMainOrgField()) != null) {
            try {
                this.defaultMainOrg = PermissionHelper.getDefaultMainOrg((Context)this.application.getContext(), (OrgType)OrgType.getEnum((int)mainOrgField.getOrgType()), (String)this.viewPermItemName);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return this.defaultMainOrg;
    }

    @Override
    public String getFormId() {
        return this.layoutInfo.getFormId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public Object getValue(String key, int row) {
        return this.quickFilterModel.getValue(key, row);
    }

    public void setValue(String key, Object value, int row) throws BOSException, EASBizException {
        this.quickFilterModel.setValue(key, value, row);
    }

    @Override
    public String getBillIdBySeq(int seq, boolean setAsCurrent) throws BOSException {
        PageQueryProxy.PkInfo pk = null;
        try {
            pk = this.pageQuery.getPk(seq);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pk == null ? null : pk.mainPk;
    }

    private String checkFunctionPermission() throws BOSException {
        String orgPermFilter;
        block4: {
            orgPermFilter = null;
            if (this.bInfo.getMainOrgField() != null && !StringUtils.isEmpty((String)this.viewPermItemName)) {
                OrgUnitInfo mainOrg = this.application.getMainOrgUnit();
                OrgType orgType = BusinessProcessUtil.getOrgTypeFromEntity((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.bInfo.getForm().getBosType()));
                String mainOrgId = null;
                if (OrgType.ControlUnit.equals((Object)orgType) && mainOrg != null) {
                    mainOrgId = mainOrg.getCU().getId().toString();
                }
                try {
                    BusinessSeviceUtil.checkFunctionPermission((Context)this.application.getContext(), (String)mainOrgId, (String)this.viewPermItemName);
                    orgPermFilter = mainOrgId;
                }
                catch (EASBizException e) {
                    if (!(e instanceof PermissionException)) break block4;
                    orgPermFilter = "No Permission";
                }
            }
        }
        return orgPermFilter;
    }

    @Override
    public void refresh() throws BOSException {
        String mainOrgFilter;
        if (this.application == null) {
            return;
        }
        String order = null;
        StringBuffer where = new StringBuffer("");
        this.appendWhere(where, this.sqlBuilder.getMergedFilter());
        if (this.filter != null) {
            String temp = this.filter.getFilterString();
            this.appendWhere(where, temp);
            order = this.filter.getSortString();
        }
        if ((mainOrgFilter = this.checkFunctionPermission()) != null) {
            this.appendWhere(where, this.getMainOrgField() + "='" + mainOrgFilter + "'");
        }
        this.preparePageInfo(where.toString(), order);
    }

    private void preparePageInfo(String where, String order) throws BOSException {
        String mainOrg = this.getMainOrgField();
        if (mainOrg.length() > 0) {
            mainOrg = mainOrg + ",";
        }
        if (this.pageQuery == null) {
            this.pageQuery = new PageQueryProxy(this.application.getContext(), this.pkFieldName, this.entryTable == null ? null : this.entryTable.getPkFieldName(), mainOrg + this.sqlBuilder.getSQLSelect(), this.sqlBuilder.getSQLFrom(), where.toString(), order);
        } else {
            this.pageQuery.setEntryTableId(this.entryTable == null ? null : this.entryTable.getPkFieldName());
            this.pageQuery.setSelect(mainOrg + this.sqlBuilder.getSQLSelect());
            this.pageQuery.setFrom(this.sqlBuilder.getSQLFrom());
            this.pageQuery.setWhere(where.toString());
            this.pageQuery.setOrder(order);
        }
        this.pageQuery.preparePageInfo();
        this.rowCount = this.pageQuery.getRowCount();
    }

    @Override
    public IRowSet getData(int start, int rows) throws Exception {
        int rowCount = this.getRowCount();
        if (start >= rowCount) {
            return null;
        }
        int end = start + rows;
        if (end >= rowCount) {
            end = rowCount;
        }
        return this.pageQuery.getData(start, end);
    }

    @Override
    public String getMainOrgField() {
        if (this.mainOrgFieldName == null) {
            Entity bill = this.bInfo.getEntity("FBillHead");
            Field mainOrgField = this.bInfo.getMainOrgField();
            this.mainOrgFieldName = mainOrgField != null && !StringUtils.isEmpty((String)mainOrgField.getFieldName()) ? bill.getTableAlias() + "." + mainOrgField.getFieldName() : "";
        }
        return this.mainOrgFieldName;
    }

    private void getListHeader(List columnFields, ReportHeader root) {
        for (ColumnField cf : this.filter.getColumnInfo()) {
            ReportHeader columnHeader = root.addChild(cf.getFieldNameAs(), cf.getCaption());
            columnHeader.setWidth(cf.getColWidth());
        }
    }

    @Override
    public ReportHeader getListHeader() {
        ReportHeader header = new ReportHeader();
        if (this.filter.getColumnInfo() != null) {
            this.getListHeader(this.filter.getColumnInfo(), header);
        } else {
            List selectFields = this.sqlBuilder.getSelectFields();
            for (SelectField field : selectFields) {
                FieldAppearance fieldAp = this.layoutInfo.getFieldAppearance(field.getKey());
                header.addChild(field.getFieldNameAs(), fieldAp.getCaption());
            }
        }
        return header;
    }

    private void setSelectFields() {
        if (this.curQueryType == QT_AdvancedFilter) {
            ArrayList<SelectField> selectFields = new ArrayList<SelectField>();
            for (ColumnField cf : this.filter.getColumnInfo()) {
                SelectField sf = this.queryInfo.getSelectField(cf.getFieldNameAs());
                selectFields.add(sf);
            }
            this.sqlBuilder.setSelectFields(selectFields);
        } else {
            this.sqlBuilder.setSelectFields(this.getDefaultSelectList());
        }
    }

    private List getDefaultSelectList() {
        ArrayList<SelectField> defaultVisibleFields = new ArrayList<SelectField>();
        for (SelectField sf : this.queryInfo.getListVisibleSelectFields()) {
            FieldAppearance fa = this.layoutInfo.getFieldAppearance(sf.getKey());
            if (!fa.isDefaultVisible()) continue;
            defaultVisibleFields.add(sf);
        }
        return defaultVisibleFields;
    }

    public void setFilter(FilterParameter filter, String mainOrg) throws BOSException {
        this.setFilter(filter, mainOrg, true);
    }

    public void setFilter(FilterParameter filter, String mainOrg, boolean execQuery) throws BOSException {
        if (this.sqlBuilder == null) {
            this.initSQLBuilder();
        }
        try {
            this.handlePermission(mainOrg);
            this.hasFuncPermission = true;
        }
        catch (EASBizException e) {
            String errMsg = BatchActionUtil.getExceptionMsg((Context)this.application.getContext(), (Throwable)e);
            this.application.showMessage(errMsg);
            this.hasFuncPermission = false;
        }
        this.buildSql(filter);
        if (execQuery) {
            this.refresh();
        } else {
            this.pkSql = null;
        }
    }

    private void appendWhere(StringBuffer where, String filter) {
        if (filter == null || filter.length() == 0) {
            return;
        }
        if (where.length() > 0) {
            where.append(" AND (").append(filter).append(")");
        } else {
            where.append(" WHERE (").append(filter).append(")");
        }
    }

    private void buildSql(FilterParameter filter) throws BOSException {
        this.filter = filter;
        if (this.filter == null) {
            this.filter = new FilterParameter(null, null, null, null, null);
        }
        this.selectEntityTable();
        this.setSelectFields();
        FilterInfo plugInFilter = new FilterInfo();
        BeforeQueryArg arg = new BeforeQueryArg(plugInFilter);
        this.eventsProxy.fireBeforeQuery(arg);
        this.filter.appendQueryFilter(arg.getFilterBy());
        if (!this.hasFuncPermission) {
            this.filter.appendQueryFilter("1=2");
        } else if (this.businessInfo.getMainOrgField() != null) {
            String mainOrgFilter = this.quickFilterModel.getMainOrgFilter();
            SelectField sf = this.queryInfo.getSelectField(this.businessInfo.getMainOrgField().getKey());
            if (mainOrgFilter == null && this.defaultMainOrg != null) {
                mainOrgFilter = this.defaultMainOrg.getId().toString();
            }
            this.mainOrgV = mainOrgFilter;
            if (mainOrgFilter != null) {
                this.filter.appendQueryFilter(sf.getFieldName(this.application.getContext()) + "='" + mainOrgFilter + "'");
            }
        }
        this.buildOrderBy(arg.getOrderBy());
        FilterInfo mergedFilter = plugInFilter;
        if (this.linkFilter != null) {
            mergedFilter.mergeFilter(this.linkFilter, "and");
        }
        if (mergedFilter.getFilterItems().size() > 0) {
            this.sqlBuilder.setQueryFilter(mergedFilter);
        }
        this.sqlBuilder.mergeFilter(this.application.getContext(), this.bInfo, this.queryInfo.getProperty2tableMap(), this.queryInfo.getMainTableAlias());
        this.sqlBuilder.addFilterFields(this.getFieldNamesInFilter(this.filter.getFieldNamesInFilter()));
        this.filterFieldsFromPlugin.clear();
        this.sqlBuilder.buildSQL(this.application.getContext());
        this.pkSql = "SELECT ";
    }

    private List getFieldNamesInFilter(List fieldList) {
        if (fieldList == null) {
            fieldList = new ArrayList();
        }
        fieldList.addAll(this.filterFieldsFromPlugin);
        return fieldList;
    }

    private void buildOrderBy(String orderByFromPlugIn) {
        if (StringUtils.isEmpty((String)this.filter.getSortString())) {
            if (StringUtils.isEmpty((String)orderByFromPlugIn)) {
                this.filter.setSortString(this.getPredefinedOrderBy());
            } else {
                this.filter.setSortString(orderByFromPlugIn);
            }
        }
    }

    private String getPredefinedOrderBy() {
        if (this.defaultOrderByField == null) {
            FormAppearance form = (FormAppearance)this.layoutInfo.getAppearance("_BILL");
            final StringBuffer sb = new StringBuffer();
            final ListModel lm = this;
            OrderByString orderBy = new OrderByString();
            orderBy.parse(form.getListSortFields(), new OrderByString.FieldProcessor(){

                public void handle(String fieldKey, String sortType) {
                    if (lm.isEntityOfFieldSelected(fieldKey)) {
                        sb.append(",").append(lm.getFieldName(fieldKey, true)).append(" ").append(sortType);
                    }
                }
            });
            if (sb.length() > 0) {
                this.defaultOrderByField = sb.substring(1);
            } else {
                this.getDefaultOrderBy();
            }
        }
        return this.defaultOrderByField;
    }

    public boolean isEntityOfFieldSelected(String fieldKey) {
        Field field = this.businessInfo.getField(fieldKey);
        Entity entity = this.businessInfo.getEntity(field.getEntityKey());
        return this.sqlBuilder.isEntitySelected(entity);
    }

    private String getDefaultOrderBy() {
        if (this.defaultOrderByField == null) {
            String createDateField = null;
            Entity mainEntity = this.businessInfo.getEntity(0);
            for (Field field : mainEntity.getFields()) {
                if (field.getElementType() == 12) {
                    this.defaultOrderByField = OrderByString.getOrderByField((String)this.getFieldName(field.getKey(), false), (boolean)false);
                    break;
                }
                if (field.getElementType() != 26) continue;
                createDateField = field.getKey();
            }
            if (this.defaultOrderByField == null && createDateField != null) {
                this.defaultOrderByField = OrderByString.getOrderByField((String)this.getFieldName(createDateField, false), (boolean)false);
            }
            if (this.defaultOrderByField == null) {
                this.defaultOrderByField = this.pkFieldName;
            }
        }
        return this.defaultOrderByField;
    }

    @Override
    public int getRowCount() throws BOSException {
        return this.rowCount;
    }

    @Override
    public void setListApplication(ListApplication application) {
        this.application = application;
    }

    @Override
    public void setLinkQueryFilter(FilterInfo linkFilter, String mainOrgId) throws BOSException {
        this.linkFilter = linkFilter;
        this.setFilter(null, mainOrgId);
    }

    @Override
    public BusinessInfo getBusinessInfo() {
        return this.bInfo;
    }

    @Override
    public boolean delete(List rowList) throws BOSException {
        List ids = this.pageQuery.getIdList(rowList);
        BeforeDeleteArg arg = new BeforeDeleteArg(ids);
        this.eventsProxy.fireBeforeDelete(arg);
        boolean ret = arg.isRefreshList();
        if (ids.size() > 0) {
            String[] pks = new String[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                pks[i] = (String)ids.get(i);
            }
            DAOHelper.getDAO().delete(this.application.getContext(), pks);
            ret = true;
        }
        return ret;
    }

    @Override
    public String[] getSelectedBillIdArray(List rowSeqList) throws BOSException {
        return this.pageQuery.getIdArray(rowSeqList);
    }

    @Override
    public String[] getSelectedEntryIdArray(List rowSeqList) throws BOSException {
        return this.pageQuery.getEntryIdArray(rowSeqList);
    }

    public List getSelectedBillIds(List rowList) throws BOSException {
        return this.pageQuery.getIdList(rowList);
    }

    @Override
    public LinkedList getCurrentPageIdList() throws BOSException {
        return this.pageQuery.getCurrentPageBillIds();
    }

    @Override
    public List getSelectFields() {
        return this.sqlBuilder.getSelectFields();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handlePermission(String mainOrg) throws BOSException, EASBizException {
        String mainOrgPropertyName;
        if (StringUtils.isEmpty((String)this.viewPermItemName)) {
            return;
        }
        ArrayList<String> mainOrgList = new ArrayList<String>();
        Field mainOrgField = this.bInfo.getMainOrgField();
        if (mainOrgField == null) {
            OrgUnitInfo orgUnit = null;
            OrgType orgType = BusinessProcessUtil.getOrgTypeFromEntity((Context)this.application.getContext(), (BOSObjectType)BOSObjectType.create((String)this.application.getForm().getBosType()));
            orgUnit = OrgType.ControlUnit.equals((Object)orgType) ? (OrgUnitInfo)this.application.getContext().get((Object)orgType) : ContextUtil.getCurrentOrgUnit((Context)this.application.getContext());
            mainOrgList.add(orgUnit.getId().toString());
        } else if (StringUtils.isEmpty((String)mainOrg)) {
            OrgUnitInfo defaultMainOrg = this.getDefaultMainOrg();
            if (defaultMainOrg == null) {
                Context ctx = this.application.getContext();
                throw new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, new Object[]{OrgType.getEnum((int)mainOrgField.getOrgType()), PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.viewPermItemName).getAlias()});
            }
            mainOrgList.add(defaultMainOrg.getId().toString());
        } else {
            String[] orgs = mainOrg.split(",");
            for (int i = 0; i < orgs.length; ++i) {
                mainOrgList.add(orgs[i]);
            }
        }
        String string = mainOrgPropertyName = mainOrgField == null ? null : mainOrgField.getPropertyName();
        if (!StringUtils.isEmpty((String)this.viewPermItemName)) {
            BusinessSeviceUtil.checkFunctionPermission((Context)this.application.getContext(), (String)((String)mainOrgList.get(0)), (String)this.viewPermItemName);
            this.sqlBuilder.handlePermission(this.application.getContext(), this.viewPermItemName, mainOrgList, mainOrgPropertyName);
        }
    }

    @Override
    public void setEventsProxy(ListEventsProxy.ModelEventsProxy eventsProxy) {
        this.eventsProxy = eventsProxy;
    }

    public void createNewData() throws BOSException, EASBizException {
    }

    public void createNewEntryRow(String entityKey) throws BOSException, EASBizException {
    }

    public IObjectCollection getEntryData(Entity entity) {
        return null;
    }

    public int getEntryRowCount(Entity entity) {
        return -1;
    }

    @Override
    public boolean isThereEntryTableJoined() {
        return this.entryTable != null;
    }

    public void clearSession() throws BOSException {
        if (this.pageQuery != null) {
            this.pageQuery.clearSession();
        }
    }

    @Override
    public IRowSet getAllData() throws Exception {
        IRowSet rs = null;
        if (this.pageQuery != null) {
            rs = this.pageQuery.getAllData();
        }
        return rs;
    }

    @Override
    public Object searchValue(String fieldKey, int row) throws BOSException {
        Object ret = null;
        IRowSet rs = this.pageQuery.getCurrentPageData();
        try {
            rs.absolute(row + 1);
            Field field = this.businessInfo.getField(fieldKey);
            Entity entity = this.businessInfo.getEntity(field.getEntityKey());
            ret = rs.getObject(fieldKey);
            if (field.getElementType() == 13) {
                String entityPk = null;
                entityPk = entity.getEntityType() == 0 ? rs.getString(2) : rs.getString(3);
                if (entityPk != null && entityPk.trim().length() > 0) {
                    IObjectValue objectValue = DAOHelper.getDAO().load(this.application.getContext(), entityPk, this.businessInfo.getSelector());
                    ret = objectValue.get(field.getPropertyName());
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ret;
    }

    public void setQueryType(int queryType) {
        this.prevQueryType = this.curQueryType;
        this.curQueryType = queryType;
    }

    public boolean isSameQueryTypeWithPrev() {
        return this.prevQueryType == this.curQueryType;
    }

    @Override
    public String getFieldName(String key, boolean isDisplayField) {
        SelectField field = this.queryInfo.getSelectField(key);
        if (isDisplayField && field.getLookupTable() != null) {
            return field.getLookupTable().getDisplayFieldName(this.application.getContext());
        }
        return field.getFieldName(this.application.getContext());
    }

    @Override
    public String getTableAlias(String key, boolean isBaseDataField, boolean tableForDisplayField) {
        SelectField field = this.queryInfo.getSelectField(key);
        if (field == null) {
            return "";
        }
        if (isBaseDataField && field.getLookupTable() != null) {
            LookUpTable table = field.getLookupTable();
            this.addBaseField4QueryJoin(field.getFieldName(this.application.getContext()));
            if (tableForDisplayField && table.getReferTableNameAs() != null) {
                return table.getReferTableNameAs();
            }
            return table.getTableNameAs();
        }
        String entityKey = field.getField().getEntityKey();
        EntityTable table = this.queryInfo.getEntityTable(entityKey.toUpperCase());
        return table.getTableNameAs();
    }

    private void addBaseField4QueryJoin(String fieldName) {
        this.filterFieldsFromPlugin.add(fieldName);
    }
}

