/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model.list;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiF7Helper {
    private Context context;
    private List id2nameMapList;
    private List prevId2nameMapList;
    private List lookupObjects;
    private List fieldList;
    private List rowList;
    private List fieldIdsList;
    private BusinessInfo businessInfo;

    public MultiF7Helper(Context context, BusinessInfo businessInfo) {
        this.context = context;
        this.businessInfo = businessInfo;
    }

    private int getLookupObjectIndex(int lookupObjId) {
        int index = -1;
        for (int i = 0; i < this.lookupObjects.size(); ++i) {
            LookUpObject obj = (LookUpObject)this.lookupObjects.get(i);
            if (obj.getID() != lookupObjId) continue;
            index = i;
            break;
        }
        return index;
    }

    private List getIdsList4Field(Field field) {
        int index = -1;
        ArrayList idsList = null;
        for (int i = 0; i < this.fieldList.size(); ++i) {
            Field curField = (Field)this.fieldList.get(i);
            if (!curField.getKey().equals(field.getKey())) continue;
            index = i;
            break;
        }
        if (index < 0) {
            this.fieldList.add(field);
            idsList = new ArrayList(this.rowList.size());
            this.fieldIdsList.add(idsList);
        } else {
            idsList = (ArrayList)this.fieldIdsList.get(index);
        }
        return idsList;
    }

    private void addLookupObject(int lookupObjId) {
        LookUpObject lookupObj = this.businessInfo.getLookUpObject(lookupObjId);
        this.lookupObjects.add(lookupObj);
        HashMap id2name = new HashMap();
        this.id2nameMapList.add(id2name);
    }

    public void addBizObjectId(int row, Field field, String ids) {
        List idsList = this.getIdsList4Field(field);
        idsList.add(StringUtil.isEmpty((String)ids) ? null : ids);
        Integer curRow = null;
        if (this.rowList.size() > 0) {
            curRow = (Integer)this.rowList.get(this.rowList.size() - 1);
            if (curRow != row) {
                this.rowList.add(new Integer(row));
            }
        } else {
            this.rowList.add(new Integer(row));
        }
    }

    public void setRowCount(int count) {
        this.rowList = new ArrayList(count);
        this.prevId2nameMapList = this.id2nameMapList;
        this.id2nameMapList = new ArrayList();
        this.lookupObjects = new ArrayList();
        this.fieldList = new ArrayList();
        this.fieldIdsList = new ArrayList();
    }

    public JSONObject getAllDisplayNames() throws EASBizException, BOSException, JSONException {
        JSONObject allNames = new JSONObject();
        allNames.put("rows", (Object)this.getRowIndexArray());
        for (int i = 0; i < this.fieldList.size(); ++i) {
            Field field = (Field)this.fieldList.get(i);
            List idsList = (List)this.fieldIdsList.get(i);
            int lookupObjIndex = this.getLookupObjectIndex(field.getLookUpObjectID());
            if (lookupObjIndex < 0) {
                this.addLookupObject(field.getLookUpObjectID());
                lookupObjIndex = this.id2nameMapList.size() - 1;
            }
            Map id2name = (Map)this.id2nameMapList.get(lookupObjIndex);
            LookUpObject lookupObj = (LookUpObject)this.lookupObjects.get(lookupObjIndex);
            this.parseIds(id2name, idsList);
            String ids = this.getIds(id2name);
            this.updateNames(id2name, field, lookupObj, ids);
            allNames.put(field.getKey(), (Object)this.getDisplayContent(id2name, idsList));
        }
        return allNames;
    }

    private void updateNames(Map id2name, Field field, LookUpObject lookupObj, String ids) throws EASBizException, BOSException {
        String refProperty = field.getRefPropertyName();
        IObjectCollection objCollection = BusinessServiceFactory.getBusinessService().getBaseDatasByKeys(this.context, lookupObj, "id", ids, null, refProperty != null ? refProperty.split(",") : null);
        for (int i = 0; i < objCollection.size(); ++i) {
            IObjectValue vo = objCollection.getObject(i);
            id2name.put(vo.get("id").toString(), vo.get("name"));
        }
    }

    private String getIds(Map id2name) {
        StringBuffer sb = new StringBuffer(2000);
        for (Map.Entry entry : id2name.entrySet()) {
            sb.append(",").append(entry.getKey());
        }
        return sb.substring(1);
    }

    private void parseIds(Map id2name, List idsList) {
        for (int i = 0; i < idsList.size(); ++i) {
            String ids = (String)idsList.get(i);
            String[] idArray = null;
            if (ids == null) continue;
            idArray = ids.split(",");
            for (int j = 0; j < idArray.length; ++j) {
                id2name.put(idArray[j], Boolean.FALSE);
            }
            idsList.set(i, idArray);
        }
    }

    private JSONArray getDisplayContent(Map id2name, List idsList) {
        JSONArray array = new JSONArray();
        for (String[] idArray : idsList) {
            if (idArray != null) {
                StringBuffer sb = new StringBuffer();
                for (int j = 0; j < idArray.length; ++j) {
                    Object value = id2name.get(idArray[j]);
                    if (!(value instanceof String)) continue;
                    sb.append(";").append(value);
                }
                if (sb.length() <= 0) continue;
                array.put((Object)sb.substring(1));
                continue;
            }
            array.put((Object)"");
        }
        return array;
    }

    private JSONArray getRowIndexArray() {
        JSONArray array = new JSONArray();
        for (Integer row : this.rowList) {
            array.put(row.intValue());
        }
        return array;
    }

    public void getDisplayContent() {
    }
}

