/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.dynbusiness.util.ValidationUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public final class ActionUtil {
    public static void lockFields(BillApplication application, Action action, boolean isLocked) {
        String[] parameters = action.getParameters();
        if (action.isExcept()) {
            HashSet<String> paramSet = new HashSet<String>();
            for (int i = 0; i < parameters.length; ++i) {
                paramSet.add(parameters[i]);
            }
            ActionUtil.lockFieldByExcept(application, isLocked, paramSet);
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                String key = parameters[i];
                application.lockElement(key, isLocked);
            }
        }
    }

    private static void lockFieldByExcept(BillApplication application, boolean isLocked, Set paramSet) {
        List entities = application.getBillModel().getBusinessInfo().getEntrys();
        for (int i = 0; i < entities.size(); ++i) {
            String key;
            Vector v;
            Entity entity = (Entity)entities.get(i);
            if (entity.getEntityType() == 0) {
                v = entity.getFields();
                for (Field field : v) {
                    key = field.getKey();
                    if (paramSet.contains(key)) continue;
                    application.lockElement(key, isLocked);
                }
                continue;
            }
            if (entity.getEntryName() == null) continue;
            v = entity.getFields();
            for (Field field : v) {
                key = field.getKey();
                if (paramSet.contains(key)) continue;
                application.lockElement(key, isLocked);
            }
        }
    }

    private static void hideFieldByExcept(BillApplication application, boolean isHide, Set paramSet) {
        List entities = application.getBillModel().getBusinessInfo().getEntrys();
        for (int i = 0; i < entities.size(); ++i) {
            String key;
            Vector v;
            Entity entity = (Entity)entities.get(i);
            if (entity.getEntityType() == 0) {
                v = entity.getFields();
                for (Field field : v) {
                    key = field.getKey();
                    if (paramSet.contains(key)) continue;
                    application.hideElement(key, isHide);
                }
                continue;
            }
            if (entity.getEntryName() == null) continue;
            v = entity.getFields();
            for (Field field : v) {
                key = field.getKey();
                if (paramSet.contains(key)) continue;
                application.hideElement(key, isHide);
            }
        }
    }

    public static void hideFields(BillApplication application, Action action, boolean isHide) {
        String[] parameters = action.getParameters();
        if (action.isExcept()) {
            HashSet<String> paramSet = new HashSet<String>();
            for (int i = 0; i < parameters.length; ++i) {
                paramSet.add(parameters[i]);
            }
            ActionUtil.hideFieldByExcept(application, isHide, paramSet);
        } else {
            for (int i = 0; i < parameters.length; ++i) {
                String key = parameters[i];
                application.hideElement(key, isHide);
            }
        }
    }

    public static String parseUrl(String linkFunc) {
        if (linkFunc == null) {
            return null;
        }
        String url = linkFunc;
        if (linkFunc.equalsIgnoreCase("BillEdit")) {
            url = "/easweb/servlet/BillServlet";
        } else if (linkFunc.equalsIgnoreCase("BillList")) {
            url = "/easweb/servlet/ListServlet";
        }
        return url;
    }

    private static String insteadOfValue(DynamicFormApplication application, boolean stringWithMark, String var, boolean isField, Object value) throws BOSException {
        String rep;
        if (value == null && var != null && application instanceof BillApplication) {
            value = ActionUtil.insteadOfNull((BillApplication)application, var, isField);
        }
        if (value instanceof IObjectValue) {
            IObjectValue ov = (IObjectValue)value;
            value = ov.get(ov.getPKField()).toString();
        } else if (value instanceof BOSUuid) {
            value = value.toString();
        }
        if (value instanceof String && stringWithMark) {
            rep = "'" + value + "'";
        } else if (value instanceof Date || value instanceof Timestamp) {
            SimpleDateFormat formatter = new SimpleDateFormat("{yyyy-MM-dd}");
            rep = formatter.format(value);
        } else {
            rep = value != null ? value.toString() : "null";
        }
        return rep;
    }

    private static Object insteadOfNull(BillApplication billApp, String key, boolean isField) throws BOSException {
        Object value = null;
        DataType dataType = null;
        if (isField) {
            Field field = billApp.getBillModel().getBusinessInfo().getField(key);
            int elementType = field.getElementType();
            dataType = DataMappingUtil.getDataTypeForElementType((int)elementType);
        } else {
            PropertyInfo property = BusinessProcessUtil.getPropertyInfo((Context)billApp.getContext(), (BOSObjectType)BOSObjectType.create((String)billApp.getBillModel().getBusinessInfo().getForm().getBosType()), (String)key);
            if (property instanceof OwnPropertyInfo) {
                dataType = ((OwnPropertyInfo)property).getDataType();
            }
        }
        if (dataType != null) {
            value = ValidationUtils.insteadOfNull(null, (DataType)dataType);
        }
        return value;
    }

    private static boolean isFieldName(String name) {
        return name != null && name.startsWith("[") && name.endsWith("]");
    }

    private static boolean isPropertyName(String name) {
        return name != null && name.startsWith("{") && name.endsWith("}");
    }

    public static String getMessageInParam(Context ctx, String parameter) throws BOSException {
        String language = ResourceUtil.getLanguage((Context)ctx);
        try {
            JSONObject js = new JSONObject(parameter);
            return js.getString(language);
        }
        catch (JSONException e1) {
            throw new BOSException((Throwable)e1);
        }
    }
}

