/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.IFormBusiness;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFormBusiness;
import com.kingdee.eas.base.form.plugin.CommonActionService;
import com.kingdee.eas.base.form.plugin.UpdateStateHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;

public class BillAction
extends CommonActionService {
    private BillApplication application;
    Logger log = Logger.getLogger((String)"com.kingdee.eas.base.form.plugin.BillAction");

    public BillAction(IFormApplication application) {
        super(application);
        this.application = (BillApplication)application;
    }

    @Override
    protected void doOperation(ActionArgs e, String operatedKey) throws BOSException, EASBizException {
        FormOperation fo = this.helper.getFo();
        String operation = fo.getOperation();
        if (!operation.equalsIgnoreCase("Save") && !operation.equalsIgnoreCase("Submit")) {
            UpdateStateHelper upstate = new UpdateStateHelper(((CommonActionService)this).application);
            upstate.updateBillState(fo, e.getRow());
            if (operation.equalsIgnoreCase("New")) {
                this.application.createNewData();
            } else if (operation.equalsIgnoreCase("Edit")) {
                this.application.edit();
            } else if (operation.equalsIgnoreCase("Copy")) {
                this.application.copyData();
            } else if (operation.equalsIgnoreCase("NewEntry")) {
                this.application.createNewEntryRow(operatedKey);
            } else if (operation.equalsIgnoreCase("DeleteEntry")) {
                this.application.deleteEntryRow(operatedKey);
            } else if (operation.equalsIgnoreCase("InsertEntry")) {
                this.application.insertEntryRow(operatedKey);
            } else if (operation.equalsIgnoreCase("Delete")) {
                this.application.delete();
                this.helper.showSuccessMsg();
            } else if (operation.equalsIgnoreCase("Close")) {
                this.application.close();
            } else if (operation.equalsIgnoreCase("Print")) {
                String pks = this.application.getBillValue().get("id") + "";
                String formId = this.application.getView().getLayoutInfo().getFormId();
                String layoutId = this.application.getView().getLayoutInfo().getId();
                this.application.getBillView().print(formId, layoutId, new String[]{pks});
            } else if (operation.equalsIgnoreCase("CreateFrom")) {
                this.application.createFrom();
            } else if (operation.equalsIgnoreCase("CreateTo")) {
                this.application.createTo();
            } else if (operation.equalsIgnoreCase("MoveUpEntry") || operation.equalsIgnoreCase("MoveDownEntry") || operation.equalsIgnoreCase("CopyEntryRow") || operation.equalsIgnoreCase("CopyEntryColumn")) {
                this.application.handleEntry(operatedKey, operation);
            } else if (operation.equalsIgnoreCase("ImportEntry")) {
                this.application.importEntryRow(operatedKey);
            } else if (operation.equalsIgnoreCase("Upload")) {
                this.application.uploadAttachment(operatedKey);
            } else if (operation.equalsIgnoreCase("RelateDocument")) {
                this.application.uploadAttachment(operatedKey);
            } else if (operation.equalsIgnoreCase("OfficeTemplate")) {
                this.application.uploadAttachment(operatedKey);
            } else if (operation.equalsIgnoreCase("ShowFlowChart")) {
                this.application.getBillView().showFlowChart();
            } else if (operation.equalsIgnoreCase("ShowApproveResult")) {
                this.application.getBillView().showApproveResult();
            } else if (operation.equalsIgnoreCase("Refresh")) {
                this.application.getBillView().refresh();
            } else if (operation.equalsIgnoreCase("RelateBill")) {
                this.application.relateBill(operatedKey);
            } else if ("TraceUp".equalsIgnoreCase(operation) || "TraceDown".equalsIgnoreCase(operation)) {
                String className = fo.getRunClassName();
                try {
                    Constructor<?> constructor = Class.forName(className).getConstructor(IFormApplication.class);
                    Object o = constructor.newInstance(this.application);
                    if (!(o instanceof AbstractFormBusiness)) {
                        throw new BOSException("\u81ea\u5b9a\u4e49action\u5fc5\u987b\u7ee7\u627f\u81eaAbstractFormBusiness!");
                    }
                    IFormBusiness fornBusiness = (IFormBusiness)constructor.newInstance(this.application);
                    fornBusiness.doAction(e);
                }
                catch (NoSuchMethodException e1) {
                    this.log.error((Object)e1);
                    throw new BOSException("\u81ea\u5b9a\u4e49action\u5fc5\u987b\u6709\u4e00\u4e2a\u53c2\u6570\u7c7b\u578b\u4e3aIFormApplication\u7684\u6784\u9020\u65b9\u6cd5!");
                }
                catch (Exception e2) {
                    this.log.error((Object)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
        } else if (operation.equalsIgnoreCase("Save")) {
            this.application.save();
            this.helper.showSuccessMsg();
        } else if (operation.equalsIgnoreCase("Submit")) {
            this.application.submit();
        }
        if (transactionOperations.contains(fo.getOperation())) {
            TransactionInvokeUtil.invokeRequired((Object)this, (String)"doUpdate", (Object[])new Object[]{fo}, (Class[])new Class[]{FormOperation.class});
            this.helper.showSuccessMsg();
        }
    }

    public void doUpdate(FormOperation operation) throws EASBizException, BOSException {
        ((BillModel)this.application.getBillModel()).getEventsProxy().fireBeforeInTransaction(operation);
        DAOHelper.getDAO().update(this.application.getContext(), this.application.getBillModel().getBillValue());
        ((BillModel)this.application.getBillModel()).getEventsProxy().fireAfterInTransaction(operation);
    }
}

