/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.form.DAOHelper;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.plugin.AbstractFlowCenterBusiness;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.TransactionInvokeUtil;
import java.util.Calendar;

public class SubmitToFlowCenter
extends AbstractFlowCenterBusiness {
    public SubmitToFlowCenter(IFormApplication application) {
        super(application);
    }

    public void doAction(ActionArgs e) throws BOSException, EASBizException {
        String[] parameters = e.getParamenter();
        if (parameters.length == 0) {
            return;
        }
        String numberKey = parameters[0];
        String requestTimeKey = parameters[1];
        String formID = this.application.getBillView().getLayoutInfo().getFormId();
        String layoutID = this.application.getBillView().getLayoutInfo().getId();
        String title = this.application.getBillView().getLayoutInfo().getCaption();
        String pk = this.getFlowObjectPK(this.application.getBillModel().getPKValue());
        if (pk == null || pk.length() == 0) {
            this.objectValue = BusinessServiceFactory.getBusinessService().createNewObject(this.application.getContext(), "4201B496");
            if (this.objectValue.get("creator") == null) {
                this.objectValue.put("creator", this.application.getBillModel().getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)"));
                this.objectValue.put("createTime", (Object)Calendar.getInstance().getTime());
            }
            this.objectValue.put("workflowStatus", (Object)"0");
            Object flowTypePK = this.application.getCustomParameter("flowTypePK");
            if (flowTypePK != null) {
                this.objectValue.put("flowTypePK", (Object)this.getFlowType(flowTypePK.toString()));
            }
        } else {
            try {
                this.objectValue = DAOHelper.getDAO().load(this.application.getContext(), pk, null);
            }
            catch (DataAccessException ex) {
                throw new BOSException((Throwable)ex);
            }
        }
        Object docNumber = this.application.getBillModel().getValue(numberKey, 0);
        Object requestTime = this.application.getBillModel().getValue(requestTimeKey, 0);
        this.objectValue.put("docNumber", docNumber);
        this.objectValue.put("requestTime", requestTime);
        this.objectValue.put("formID", (Object)formID);
        this.objectValue.put("layoutID", (Object)layoutID);
        this.objectValue.put("title", (Object)title);
        this.objectValue.put("sourcePK", (Object)this.application.getBillModel().getPKValue());
        if (parameters.length > 2) {
            int status = Integer.parseInt(parameters[2]);
            this.objectValue.put("workflowStatus", (Object)new Integer(status));
        }
        TransactionInvokeUtil.invokeRequired((Object)this, (String)"save", null, null);
    }

    private IObjectValue getFlowType(String pk) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        try {
            return DAOHelper.getDAO().load(this.application.getContext(), pk, sic);
        }
        catch (DataAccessException e) {
            return null;
        }
    }
}

