/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.form.BOTPHelper;
import com.kingdee.eas.base.form.app.BusinessSeviceUtil;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.core.OpenModeEnum;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.Appearance;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.Form;
import com.kingdee.eas.base.form.metadata.FormAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.RadioButtonAppearance;
import com.kingdee.eas.base.form.metadata.extcontrol.AccessoryPanelAppearance;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.IDynamicFormModel;
import com.kingdee.eas.base.form.model.IFormApplication;
import com.kingdee.eas.base.form.model.OperationStatus;
import com.kingdee.eas.base.form.model.bill.BillApplication;
import com.kingdee.eas.base.form.model.bill.BillBusinessUtil;
import com.kingdee.eas.base.form.model.bill.BillEventsProxy;
import com.kingdee.eas.base.form.model.bill.BillModel;
import com.kingdee.eas.base.form.model.bill.IBillModel;
import com.kingdee.eas.base.form.model.bill.IBillView;
import com.kingdee.eas.base.form.model.bill.IDList;
import com.kingdee.eas.base.form.model.bill.OpenBillParameter;
import com.kingdee.eas.base.form.model.command.ActionArgs;
import com.kingdee.eas.base.form.model.command.BaseDataFilterArg;
import com.kingdee.eas.base.form.model.command.BeforeCommandArg;
import com.kingdee.eas.base.form.model.command.CellClickArg;
import com.kingdee.eas.base.form.model.command.CommandArg;
import com.kingdee.eas.base.form.plugin.OperationHelper;
import com.kingdee.eas.base.form.util.FormActionUtil;
import com.kingdee.eas.base.form.util.NewF7Utils;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.base.form.web.EntrySelection;
import com.kingdee.eas.base.form.web.FormMetaCacheManager;
import com.kingdee.eas.base.form.web.IWebFormPostData;
import com.kingdee.eas.base.form.web.WebBarBuilder;
import com.kingdee.eas.base.form.web.WebBillViewSate;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WebBillEditPanel
extends DynamicWebFormPanel
implements IBillView,
IWebFormPostData {
    private static final Logger logger = Logger.getLogger(WebBillEditPanel.class);
    private OperationStatus operationStatus = OperationStatus.VIEW;
    public BarDataManager menuData = null;
    private WebBarBuilder barBuilder = null;
    public IBillModel billModel;
    private JSONObject mainMenu;
    private BillEventsProxy.ViewEventsProxy eventsProxy;
    private FieldPermission fieldPerms;
    private boolean viewFromList;
    private OpenBillParameter param;
    private IDList idList;
    private Map selectedRows = new HashMap();
    private Set lockedAttachmentOperation;
    private JSONArray officeCtrls;
    private boolean attachmentInitialized = false;
    private int officeCtrlState = 0;
    private static final int OCS_NOT_INITIALIZED = 0;
    private static final int OCS_NOT_LOADED = 1;
    private static final int OCS_LOADED = 2;
    private String ftpPanelKey = null;

    public boolean closeForm() throws EASBizException, BOSException {
        if (OperationStatus.EDIT.equals(this.operationStatus)) {
            this.operationStatus.canTransfer(OperationStatus.VIEW, this.application);
        }
        return super.closeForm();
    }

    public void setIdList(IDList idList) {
        this.idList = idList;
    }

    public JSONObject getMainMenu() {
        return this.mainMenu;
    }

    public void setFormMdel(IDynamicFormModel dynamicFormModel) {
        super.setFormMdel(dynamicFormModel);
        this.billModel = (IBillModel)dynamicFormModel;
    }

    public WebBillEditPanel(EntityAppearance entryCtl, BusinessInfo businessInfo, BarDataManager menuData) throws Exception {
        super(entryCtl, businessInfo);
        this.menuData = menuData;
        this.initialize(menuData);
    }

    private void initialize(BarDataManager menuData) throws JSONException {
        this.barBuilder = new WebBarBuilder(menuData);
        this.barBuilder.loadBarItems();
        JSONArray items = new JSONArray();
        this.mainMenu = new JSONObject();
        this.mainMenu.put("items", (Object)items);
        this.mainMenu.put("imagepath", (Object)"IMAGES/ToolBar/chs/");
        items.put(this.barBuilder.getMainMenu());
        items.put(this.barBuilder.getToolbar());
        if (this.idList == null) {
            this.idList = new IDList();
        }
    }

    public WebBillEditPanel(LayoutInfo layoutInfo, BusinessInfo businessInfo, BarDataManager menuData) throws Exception {
        super(layoutInfo, businessInfo);
        this.menuData = menuData;
        this.initialize(menuData);
    }

    @Override
    public void loadPostBackData(JSONArray postDatas) throws JSONException, EASBizException, BOSException {
        if (postDatas != null && postDatas.length() > 0) {
            JSONObject entrySelections = (JSONObject)postDatas.get(0);
            this.selectedRows.clear();
            Iterator it = entrySelections.keys();
            while (it.hasNext()) {
                String entryKey = (String)it.next();
                JSONObject entry = entrySelections.getJSONObject(entryKey);
                this.selectedRows.put(entryKey, new EntrySelection(entryKey, entry));
            }
            for (int i = 1; i < postDatas.length(); ++i) {
                JSONObject postData = (JSONObject)postDatas.get(i);
                String key = postData.getString("Key");
                Field field = (Field)this.businessInfo.getElement(key);
                if (field != null) {
                    int row = postData.getInt("Row");
                    Object value = postData.get("Value");
                    this.billModel.setValue(key, value, row);
                    continue;
                }
                if (!"needValidate".equals(key) || !"yes".equals((String)postData.get("Value"))) continue;
                this.application.getApplicationContext().putData(key, postData.get("Value"));
            }
        }
    }

    public String getRequestBillId(String navigator) throws BOSException {
        String billId = null;
        if (navigator.equals("first")) {
            billId = this.idList.getFirstId();
        } else if (navigator.equals("last")) {
            billId = this.idList.getLastId();
        } else if (navigator.equals("next")) {
            billId = this.idList.getNextId();
        } else if (navigator.equals("previous")) {
            billId = this.idList.getPreviousId();
        }
        return billId;
    }

    public void barItemClick(String menuName, boolean bSave) throws EASBizException, BOSException {
        BeforeCommandArg beforeCommandArg = new BeforeCommandArg(menuName);
        this.eventsProxy.beforeBarItemClick(beforeCommandArg);
        if (beforeCommandArg.isCancel()) {
            return;
        }
        BarItem barItem = this.menuData.getBarItem(menuName);
        FormActionUtil.invokeActions((IFormApplication)((BillApplication)this.application), null, (List)barItem.getClickActions(), null, (int)0);
        this.eventsProxy.afterBarItemClick(new CommandArg(menuName));
    }

    @Override
    public void copyData() throws BOSException, EASBizException {
        this.billModel.copyData();
        if (!this.operationStatus.equals(OperationStatus.ADDNEW)) {
            this.setOperationStatus(OperationStatus.ADDNEW);
        }
        this.bindData(this.formModel);
    }

    @Override
    public void createNewData() throws BOSException, EASBizException {
        this.billModel.createNewData();
        this.setOperationStatus(OperationStatus.ADDNEW);
        this.officeCtrlState = 1;
        this.bindData(this.formModel);
    }

    @Override
    public void save() throws BOSException, EASBizException {
        this.correctPKAtNew();
        String id = this.billModel.save();
        this.afterSave(id);
    }

    private void afterSave(String billId) throws EASBizException, BOSException {
        if (OperationStatus.ADDNEW.equals(this.operationStatus)) {
            this.setOperationStatus(OperationStatus.EDIT);
        }
        this.bindData(this.formModel);
        if (this.officeCtrlState == 2) {
            this.comState.saveOfficeDocuments(this.billModel.getPKValue(), this.officeCtrls);
        }
        if (this.ftpPanelKey != null) {
            this.comState.ftpUpload(this.ftpPanelKey, billId);
        }
        this.refreshList(billId);
    }

    private void refreshList(String id) throws BOSException {
        this.idList.add(id);
        this.setParentRefresh(true);
    }

    protected void doLoadActions(FieldAppearance fld) throws BOSException, EASBizException {
        Field field = (Field)this.businessInfo.getElement(fld.getKey());
        List actions = field.getLoadActions();
        FormActionUtil.invokeActions((IFormApplication)((BillApplication)this.application), (Object)field, (List)actions, null, (int)0);
        Entity entity = this.businessInfo.getEntity(field.getEntityKey());
        if (!fld.isVisible(this.operationStatus)) {
            this.setVisible(field.getKey(), false);
            return;
        }
        this.setVisible(field.getKey(), true);
        if (this.isLocked(fld)) {
            this.setEnabled(field.getKey(), false);
        } else {
            this.setEnabled(field.getKey(), true);
        }
    }

    private boolean isLocked(FieldAppearance fld) throws EASBizException, BOSException {
        RuleStatus ruleStatus;
        boolean isLocked = false;
        isLocked = fld.isLocked(this.operationStatus);
        if (isLocked) {
            return true;
        }
        if (fld.getElementType() == 12 && (ruleStatus = this.billModel.getRuleStatus()) != null && ruleStatus.isExist() && !ruleStatus.isModifiable()) {
            return true;
        }
        Field field = (Field)this.businessInfo.getElement(fld.getKey());
        this.handFieldPermission(field);
        return false;
    }

    private boolean handFieldPermission(Field field) throws EASBizException, BOSException {
        if (this.fieldPerms == null) {
            this.fieldPerms = BusinessSeviceUtil.getFieldPermission((Context)this.application.getContext(), (OrgUnitInfo)this.billModel.getMainOrgUnit(), (String)this.businessInfo.getForm().getBosType());
        }
        if (field.getPropertyName() == null) {
            return false;
        }
        FieldAccessInfo fieldAccess = this.fieldPerms.getFieldAccessInfo(field.getPropertyName());
        if (fieldAccess == null) {
            return false;
        }
        if (fieldAccess.isViewable()) {
            return true;
        }
        if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
            this.setVisible(field.getKey(), false);
        }
        return false;
    }

    protected void initFormState() {
        this.comState = new WebBillViewSate(this.layoutInfo, this.businessInfo);
    }

    @Override
    public void setEventsProxy(BillEventsProxy.ViewEventsProxy eventsProxy) {
        this.eventsProxy = eventsProxy;
    }

    private WebBillViewSate getBillViewSate() {
        return (WebBillViewSate)this.comState;
    }

    public void bindData(IDynamicFormModel dataObject) throws EASBizException, BOSException {
        this.billModel = (IBillModel)dataObject;
        if (this.param.billOperation != null) {
            this.setOperationStatus(this.param.billOperation);
            this.param.billOperation = null;
        }
        try {
            super.bindData(dataObject);
            this.bindOfficeControls();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.afterBindData();
        ((BillModel)this.billModel).setChanged(false);
    }

    private void bindOfficeControls() throws EASBizException, BOSException, SQLException, JSONException {
        if (!this.attachmentInitialized) {
            this.setIfHasAttachmentProperty();
            this.attachmentInitialized = true;
        }
        String docSettingCtrl = this.getDocumentControlSetting();
        if (this.officeCtrls != null) {
            if (this.officeCtrlState != 2) {
                this.officeCtrlState = 2;
                for (int i = 0; i < this.officeCtrls.length(); ++i) {
                    try {
                        String billId;
                        Appearance ap = this.layoutInfo.getAppearance(this.officeCtrls.getString(i));
                        if (!StringUtils.isEmpty((String)docSettingCtrl)) {
                            this.comState.setControlProperty(ap.getKey(), "docTypeParam", (Object)docSettingCtrl);
                        }
                        if (!this.hasAttachment(billId = this.billModel.getPKValue(), ap.getKey())) continue;
                        this.comState.setBillId2OfficeControl(billId, ap);
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                this.comState.setOfficeEditable(!OperationStatus.VIEW.equals(this.operationStatus), this.officeCtrls);
            } else {
                for (int i = 0; i < this.officeCtrls.length(); ++i) {
                    try {
                        this.comState.setControlProperty(this.officeCtrls.getString(i), "adjustWidth", (Object)"1");
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void setIfHasAttachmentProperty() throws SQLException, JSONException, EASBizException, BOSException {
        String billId = this.billModel.getPKValue();
        if (billId != null) {
            Map ctrls = ((BillModel)this.billModel).getCtrlsWithDynAttachment();
            for (Map.Entry entry : ctrls.entrySet()) {
                String key = (String)entry.getKey();
                Appearance ap = this.layoutInfo.getAppearance(key);
                if (ap == null || ap.getElementType() != 1023) continue;
                UserInfo user = (UserInfo)this.billModel.getDefaultValueCalculator().evaluateFunction("getUser(@CONTEXT)");
                JSONObject attachmentInfo = new JSONObject();
                attachmentInfo.put("billId", (Object)billId);
                attachmentInfo.put("userName", (Object)user.getName());
                attachmentInfo.put("attachmentId", entry.getValue());
                attachmentInfo.put("controlKey", (Object)this.getKeys(ctrls.get(entry.getKey())));
                this.setControlProperty(key, "attachmentData", attachmentInfo);
            }
        }
    }

    private boolean hasAttachment(String billId, String key) {
        boolean has = false;
        if (billId != null && key != null) {
            String oql = "Select id where billId ='" + billId + "' and controlKey='" + key.toUpperCase() + "'";
            Connection cn = null;
            try {
                cn = EJBFactory.getConnection((Context)this.application.getContext());
                IORMappingDAO ormdao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"40E7BFAC"), (Context)this.application.getContext(), (Connection)cn);
                AbstractBaseObjectCollection datas = (AbstractBaseObjectCollection)ormdao.getCollection(oql);
                has = datas.size() > 0;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return has;
    }

    protected void binControlData(ControlAppearance control) {
        switch (control.getControlType()) {
            case 1027: {
                this.bindImgPanel(control.getKey(), control.getFaceStyle());
                break;
            }
            case 1013: 
            case 1019: 
            case 1022: 
            case 1025: {
                String pk;
                if (this.billModel.getPKValue() != null) {
                    pk = this.billModel.getPKValue();
                } else {
                    pk = "isnewbill";
                    String billTempID = BOSUuid.create((String)"ABCDEF").toString();
                    this.comState.setControlProperty(control.getKey(), "BillTempID", (Object)billTempID);
                }
                this.comState.setControlProperty(control.getKey(), "BillID", (Object)pk);
                break;
            }
            case 1018: {
                if (this.officeCtrlState != 0) break;
                if (this.officeCtrls == null) {
                    this.officeCtrls = new JSONArray();
                }
                this.officeCtrls.put((Object)control.getKey().toUpperCase());
                break;
            }
            case 1021: {
                JSONArray items = this.getRelateBillList(this.getBusinessInfo().getForm().getId(), this.getBillModel().getPKValue(), control.getKey());
                this.comState.setControlProperty(control.getKey(), "relatedBills", (Object)items);
                break;
            }
            case 10: {
                RadioButtonAppearance radioCtrl = (RadioButtonAppearance)control;
                Object fldData = this.formModel.getValue(radioCtrl.getButtonGroup(), 0);
                Object enumItemValue = radioCtrl.getEnumItemValue();
                if (enumItemValue == null || !enumItemValue.equals(fldData)) break;
                this.comState.setControlProperty(control.getKey(), "value", (Object)Boolean.TRUE);
                break;
            }
            case 1024: {
                this.bindFtpPanel(control.getKey());
            }
        }
        super.binControlData(control);
    }

    private void bindImgPanel(String panelKey, int style) {
        try {
            JSONObject imgPanelConfig = new JSONObject();
            imgPanelConfig.put("bosType", (Object)this.businessInfo.getForm().getBosType());
            imgPanelConfig.put("formID", (Object)this.getLayoutInfo().getFormId());
            imgPanelConfig.put("style", style);
            this.comState.initImgPanel(panelKey, imgPanelConfig);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void bindFtpPanel(String panelKey) {
        try {
            JSONObject ftpPanelConfig = new JSONObject();
            ftpPanelConfig.put("formID", (Object)this.getLayoutInfo().getFormId());
            ftpPanelConfig.put("businessID", (Object)this.billModel.getPKValue());
            ftpPanelConfig.put("state", (Object)this.operationStatus.getStatus());
            this.comState.initFtpPanel(panelKey, ftpPanelConfig);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.ftpPanelKey == null) {
            this.ftpPanelKey = panelKey;
        }
    }

    public void applyFTPPanelPolicy(JSONObject ftpPanelPolicy) {
        if (this.ftpPanelKey != null) {
            this.comState.applyFTPPanelPolicy(this.ftpPanelKey, ftpPanelPolicy);
        }
    }

    private JSONArray getRelateBillList(String formId, String billID, String panelKey) {
        JSONArray items = new JSONArray();
        if (formId == null || billID == null) {
            return items;
        }
        Locale loc = this.application.getContext().getLocale();
        String oql = "Select sourceFormID,sourceFormPk,description where formID ='" + formId + "' and FormPk='" + billID + "' and panelKey ='" + panelKey + "' order by createTime ";
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)this.application.getContext());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            IORMappingDAO ormdao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"AF3DA9E4"), (Context)this.application.getContext(), (Connection)cn);
            AbstractBaseObjectCollection datas = (AbstractBaseObjectCollection)ormdao.getCollection(oql);
            if (datas != null && !datas.isEmpty()) {
                for (int i = 0; i < datas.size(); ++i) {
                    JSONObject item = new JSONObject();
                    IObjectValue data = datas.getObject(i);
                    item.put("formId", data.get("sourceFormID"));
                    item.put("billId", data.get("sourceFormPk"));
                    item.put("title", data.get("description", loc));
                    items.put((Object)item);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return items;
    }

    private void afterBindData() throws BOSException, EASBizException {
        List loadActions = this.businessInfo.getForm().getLoadActions();
        FormActionUtil.invokeActions((IFormApplication)((IFormApplication)this.application), null, (List)loadActions, null, (int)0);
        this.eventsProxy.afterBindData();
    }

    public void doUpdateAction(String key, String value, int row) throws EASBizException, BOSException {
        this.billModel.setValue(key, value, row);
        this.focusEntryCell(key, row);
    }

    public void doUpdateAction(String key, boolean value, int row) throws EASBizException, BOSException {
        this.billModel.setValue(key, value ? Boolean.TRUE : Boolean.FALSE, row);
        this.focusEntryCell(key, row);
    }

    private void focusEntryCell(String key, int row) {
        Field field = this.businessInfo.getField(key);
        this.comState.focusEntryCell(field.getEntityKey(), key, row);
    }

    public void addEntryRow(String entityKey) throws EASBizException, BOSException {
        this.billModel.createNewEntryRow(entityKey);
    }

    public void getEntryData(String entityKey) throws JSONException, BOSException, EASBizException {
        this.bindEntityData((EntityAppearance)this.layoutInfo.getAppearance(entityKey));
    }

    public void copyEntryRow(String entityKey, int row) throws EASBizException, BOSException {
        this.billModel.copyEntryRow(entityKey, row);
    }

    public void fireButtonClick(String key) throws EASBizException, BOSException {
        this.eventsProxy.fireButtonClick(new CommandArg(key));
        ButtonAppearance button = this.layoutInfo.getButtonAppearance(key);
        ArrayList actions = button.getClickActions();
        FormActionUtil.invokeActions((IFormApplication)((BillApplication)this.application), (Object)key, (List)actions, null, (int)0);
    }

    public void fireBeforeCloseForm() throws BOSException {
        this.eventsProxy.fireBeforeCloseForm();
    }

    public void fireEntryDblClick(String key, int row, int col, Object value) throws EASBizException, BOSException {
        CellClickArg arg = new CellClickArg(key, row, col, value);
        this.eventsProxy.fireEntryDblClick((CommandArg)arg);
        if (arg.isCancel()) {
            return;
        }
        EntityAppearance entry = (EntityAppearance)this.layoutInfo.getAppearance(key);
        ArrayList actions = entry.getDblClickActions();
        FormActionUtil.invokeActions((IFormApplication)((BillApplication)this.application), (Object)key, (List)actions, (Object)value, (int)0, (int)row);
    }

    public boolean onInitialize(OpenBillParameter param) throws EASBizException, BOSException {
        this.param = param;
        return this.eventsProxy.fireOnInitialize(param);
    }

    public void onLoad() throws JSONException {
        super.onLoad();
        this.eventsProxy.fireOnLoad();
    }

    public void getFieldFilter(String key, int row) throws JSONException, EASBizException {
        Field field = this.billModel.getBusinessInfo().getField(key);
        if (!StringUtils.isEmpty((String)field.getFilter()) || !StringUtils.isEmpty((String)field.getControlFieldKey())) {
            try {
                String oql = this.billModel.getFieldFilter(key, row);
                BaseDataFilterArg arg = new BaseDataFilterArg(key, oql, row);
                this.eventsProxy.fireOnGetFieldFilter(arg);
                super.getFieldFilter(key, row, arg.getOql());
            }
            catch (BOSException e) {
                super.handleGetFieldFilterException(e);
            }
        }
        try {
            this.bindMultiSelectF7(field, key, row);
        }
        catch (BOSException e) {
            e.printStackTrace();
            this.comState.alert(e.getMessage());
        }
    }

    private void bindMultiSelectF7(Field field, String key, int row) throws JSONException, EASBizException, BOSException {
        String fldData;
        if (field.getElementType() == 24 && !StringUtils.isEmpty((String)(fldData = (String)this.formModel.getValue(key, row)))) {
            int pos = fldData.indexOf(93);
            fldData = fldData.substring(1, pos + 1);
            fldData = fldData.replaceAll("\"", "");
            LookUpObject lookupObj = this.businessInfo.getLookUpObject(field.getLookUpObjectID());
            String refProperty = field.getRefPropertyName();
            IObjectCollection objCollection = BusinessServiceFactory.getBusinessService().getBaseDatasByKeys(this.application.getContext(), lookupObj, "number", fldData.substring(1, fldData.length() - 1), null, refProperty != null ? refProperty.split(",") : null);
            JSONObject fieldState = this.comState.getField(key);
            this.bindFieldDataArray(field, fieldState, field.getElementType(), new NewF7Utils().getSortedListOfInputOrder(objCollection, "number", fldData.substring(1, fldData.length() - 1)).toArray());
        }
    }

    public void setBillApplication(BillApplication application) {
        this.application = application;
    }

    @Override
    public void close() throws BOSException, EASBizException {
        try {
            this.getBillViewSate().close();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void addError(String key, String msg) {
    }

    @Override
    public void submit() throws BOSException, EASBizException {
        this.correctPKAtNew();
        String id = this.billModel.submit();
        this.afterSave(id);
    }

    private void correctPKAtNew() {
        if (!this.operationStatus.equals(OperationStatus.ADDNEW)) {
            return;
        }
        IObjectValue objectValue = this.billModel.getBillValue();
        Object pk = objectValue.get(objectValue.getPKField());
        if (pk != null && !(pk instanceof BOSUuid)) {
            objectValue.put(objectValue.getPKField(), null);
        }
    }

    @Override
    public void setOperationStatus(OperationStatus status) throws BOSException, EASBizException {
        OperationStatus oldStatus = this.operationStatus;
        if (oldStatus.canTransfer(status, this.application)) {
            this.operationStatus = status;
            this.refreshApperance(this.businessInfo.getForm(), this.layoutInfo);
        }
    }

    private void refreshApperanceForWf(LayoutInfo layoutInfo) {
        int i;
        if (this.ftpPanelKey != null) {
            this.comState.setControlProperty(this.ftpPanelKey, "State", (Object)this.operationStatus.getStatus());
        }
        ButtonAppearance[] allButtons = layoutInfo.getAllButtonAppearances();
        for (int i2 = 0; i2 < allButtons.length; ++i2) {
            ButtonAppearance button = allButtons[i2];
            if (button.isVisible(this.operationStatus)) {
                this.setVisible(button.getKey(), true);
                this.setEnabled(button.getKey(), false);
                continue;
            }
            this.setVisible(button.getKey(), false);
        }
        ButtonAppearance[] buttons = layoutInfo.getButtonByOperation(this.wfState.getOperation());
        for (i = 0; i < buttons.length; ++i) {
            this.setEnabled(buttons[i].getKey(), true);
        }
        buttons = layoutInfo.getButtonByOperation("Close");
        for (i = 0; i < buttons.length; ++i) {
            this.setEnabled(buttons[i].getKey(), true);
        }
        if (this.officeCtrls != null) {
            this.comState.setOfficeEditable(!OperationStatus.VIEW.equals(this.operationStatus), this.officeCtrls);
        }
    }

    private void refreshApperance(Form form, LayoutInfo layoutInfo) throws EASBizException, BOSException {
        ButtonAppearance[] allButtons = layoutInfo.getAllButtonAppearances();
        for (int i = 0; i < allButtons.length; ++i) {
            ButtonAppearance button = allButtons[i];
            if (button.isVisible(this.operationStatus)) {
                this.setVisible(button.getKey(), true);
                if (button.isLocked(this.operationStatus)) {
                    this.setEnabled(button.getKey(), false);
                    continue;
                }
                this.setEnabled(button.getKey(), true);
                continue;
            }
            this.setVisible(button.getKey(), false);
        }
        Map map = form.getOperations();
        if (map == null) {
            return;
        }
        for (FormOperation fo : map.values()) {
            boolean isEnabled;
            String operation = fo.getOperation();
            ButtonAppearance[] buttons = layoutInfo.getButtonByOperation(operation);
            if (buttons.length == 0 || (isEnabled = fo.isEnabled(this.operationStatus.getStatus()) && BillBusinessUtil.isEnabledState((IFormApplication)this.application, fo, 0))) continue;
            for (int i = 0; i < buttons.length; ++i) {
                ((BillApplication)this.application).lockElement(buttons[i].getKey(), !isEnabled);
            }
        }
        if (this.wfState.isFromWorkflow() && !this.eventsProxy.fireOnRefreshApperanceForWf()) {
            this.refreshApperanceForWf(layoutInfo);
        }
    }

    @Override
    public void createNewEntryRow(String entityKey) throws BOSException, EASBizException {
        this.billModel.createNewEntryRow(entityKey);
        try {
            this.bindEntityData(this.layoutInfo.getEntityAppearance(entityKey));
            this.afterBindData();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void delete() throws BOSException, EASBizException {
        this.billModel.delete();
        this.idList.remove();
        if (this.idList.getCurrentIndex() == -1) {
            this.createNewData();
        } else {
            this.load(this.idList.getCurrentId());
        }
    }

    @Override
    public void deleteEntryRow(String entityKey) throws BOSException, EASBizException {
        this.handleEntry(entityKey, "DeleteEntry");
    }

    @Override
    public void edit() throws EASBizException, BOSException {
        this.setOperationStatus(OperationStatus.EDIT);
        this.bindData(this.formModel);
    }

    @Override
    public void load(String pk) throws BOSException, EASBizException {
        this.billModel.load(pk);
        this.bindData(this.formModel);
    }

    @Override
    public void print() throws BOSException, EASBizException {
        if (this.billModel.getPKValue() == null) {
            this.comState.addErrorMessage("\u6253\u5370\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
            return;
        }
        if (OperationStatus.EDIT.equals(this.operationStatus)) {
            this.billModel.checkIsChanged(false);
        }
        super.print();
    }

    @Override
    public void createFrom() throws BOSException, EASBizException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(" var url = '").append("/easweb/dynform").append("/botp/editPull.jsf?' + ");
            sb.append(" \tExt.urlEncode({pageId:'").append(this.pageId).append("',");
            sb.append(" \t\tbosType:'").append(this.businessInfo.getForm().getBosType()).append("'});");
            sb.append(" var config = {name:'createFromDailog', title:'").append(ResourceUtil.getMessage((Context)this.application.getContext(), (String)"BILL_TRANSFORM")).append("',X:320,Y:160};");
            sb.append(" var retVal = KDWin.openDialog(url, config);");
            sb.append(" if(retVal != null) {");
            sb.append(" \tretVal.urlParam.editPageId = Ext.getCmp('bill').PageID;");
            sb.append(" \tretVal = KDWin.openDialog(retVal.url + Ext.urlEncode(retVal.urlParam), retVal.param);");
            sb.append(" if(retVal != null && retVal.ruleId != null) ");
            sb.append(" \t\tthis.server.call('callCreateFrom',Ext.getCmp('bill').PageID, retVal.srcBosType, retVal.ruleId);");
            sb.append(" }");
            this.comState.outputDynmaicAction(sb.toString());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void handleCreateFrom(String srcBosType, String ruleId, String[] selectedBillIds) throws EASBizException, BOSException {
        this.handleBotpCreate(srcBosType, ruleId, selectedBillIds);
        this.bindData(this.formModel);
    }

    public OperationStatus handleBotpCreate(String srcBosType, String ruleId, String[] selectedBillIds) throws EASBizException, BOSException {
        BOTPHelper botpHelper = new BOTPHelper(this.application.getContext(), srcBosType, this.businessInfo.getForm().getBosType(), ruleId);
        if (selectedBillIds == null) {
            return null;
        }
        BTPTransformResult btpResult = botpHelper.transformTo(selectedBillIds);
        IObjectCollection destBillCols = null;
        if (btpResult != null) {
            destBillCols = btpResult.getBills();
        }
        if (destBillCols == null || destBillCols.size() == 0) {
            return null;
        }
        this.eventsProxy.fireAfterBotp(destBillCols);
        IObjectValue objValue = destBillCols.getObject(0);
        ((BillModel)this.billModel).setBotpModelValue(objValue, btpResult.getBOTRelationCollection());
        if (objValue.get(objValue.getPKField()) != null) {
            this.setOperationStatus(OperationStatus.EDIT);
        }
        return this.getOperationStatus();
    }

    public OrgUnitInfo getMainOrgUnit() {
        return this.billModel.getMainOrgUnit();
    }

    public BOTPHelper getBOTPHelper() {
        return new BOTPHelper(this.application.getContext(), this.businessInfo.getForm().getBosType(), null, null);
    }

    public boolean isViewFromList() {
        return this.viewFromList;
    }

    public void setViewFromList(boolean viewFromList) throws JSONException {
        this.viewFromList = viewFromList;
    }

    @Override
    public IBillModel getBillModel() {
        return this.billModel;
    }

    public void setContentURL(String key, String url, String param) throws BOSException {
        try {
            this.comState.setContentURL(key, url, param);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void afterConfirm(boolean isConfirmed) throws BOSException, EASBizException {
        if (!isConfirmed) {
            return;
        }
        this.afterConfirmOperArgs.setAfterConfirmed(true);
        FormActionUtil.invokeAction((IFormApplication)((IFormApplication)this.application), (ActionArgs)this.afterConfirmOperArgs);
    }

    public void afterConfirm(String id, int returnOption) throws BOSException, EASBizException {
        if (id != null && id.equals("@confirm_data_change")) {
            this.afterConfirmOperArgs.setAfterConfirmed(true);
            this.afterConfirmOperArgs.setCofirmOption(returnOption);
            FormActionUtil.invokeAction((IFormApplication)((IFormApplication)this.application), (ActionArgs)this.afterConfirmOperArgs);
            return;
        }
        this.eventsProxy.fireAfterConfirm(id, returnOption);
        super.afterConfirm(id, returnOption);
    }

    public void showConfirm(String title, String msg) throws BOSException {
        try {
            this.comState.showConfirm(title, msg);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void doEntryActions(Entity entity, IObjectCollection entryCollection) throws EASBizException, BOSException {
        super.doEntryActions(entity, entryCollection);
        List actions = this.businessInfo.getForm().getLoadActions();
        FormActionUtil.invokeActions((IFormApplication)((IFormApplication)this.application), (Object)entity, (List)actions, (Object)entryCollection, (int)2);
    }

    @Override
    public void insertEntryRow(String entityKey) throws BOSException, EASBizException {
        this.handleEntry(entityKey, "InsertEntry");
    }

    public void callBillAction(String actionName, String actionParam) throws BOSException, EASBizException {
        String className = null;
        if (actionName.equals("CallBillFunction")) {
            className = "com.kingdee.eas.base.form.plugin.BillAction";
        }
        if (className == null) {
            return;
        }
        Action action = new Action(className, actionParam);
        FormActionUtil.invokeAction((IFormApplication)((IFormApplication)this.application), null, (Action)action, null);
    }

    @Override
    public void importEntryRow(String entityKey) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" var url = '").append("/easweb/dynform").append("/form/importExcel.jsf?' + ");
        sb.append(" Ext.urlEncode({pageId:'").append(this.pageId).append("'");
        sb.append(",entityKey:'").append(entityKey).append("'});");
        sb.append(" var config = {name:'importEntry', title:'").append("\u5206\u5f55\u5bfc\u5165").append("',X:350,Y:150};");
        sb.append(" var retVal = KDWin.openDialog(url, config);");
        sb.append(" this.bill.doActions(retVal);");
        try {
            this.comState.outputDynmaicAction(sb.toString());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public JSONObject getFormRect() throws JSONException {
        Appearance form = this.layoutInfo.getAppearance("_BILL");
        JSONObject rect = new JSONObject();
        rect.put("width", form.getWidth());
        rect.put("height", form.getHeight());
        return rect;
    }

    @Override
    public void handleEntry(String entityKey, String function) throws BOSException, EASBizException {
        int row = this.getSelectedRow(entityKey);
        if (row == -1) {
            this.application.showMessage("\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002");
            return;
        }
        this.handleEntry(entityKey, function, row);
    }

    public void handleEntry(String entityKey, String function, int rowIndex) throws BOSException, EASBizException {
        if ("CopyEntryRow".equalsIgnoreCase(function)) {
            this.billModel.copyEntryRow(entityKey, rowIndex, -1);
        } else if ("CopyEntryColumn".equalsIgnoreCase(function)) {
            String fieldKey = this.getEntrySelectedField(entityKey);
            if (StringUtils.isEmpty((String)fieldKey)) {
                this.application.showMessage("\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u5217\u6570\u636e\u3002");
                return;
            }
            this.billModel.copyEntryColumn(entityKey, rowIndex, fieldKey);
        } else {
            this.billModel.handleEntry(entityKey, function, rowIndex);
        }
        try {
            this.bindEntityData(this.layoutInfo.getEntityAppearance(entityKey));
            this.afterBindData();
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void afterOperation(FormOperation operation) throws EASBizException, BOSException {
        this.eventsProxy.afterOperation(operation);
    }

    @Override
    public boolean beforeOperation(FormOperation operation) throws EASBizException, BOSException {
        return this.eventsProxy.beforeOperation(operation);
    }

    @Override
    public void navigate(String operation) throws BOSException, EASBizException {
        this.billModel.checkIsChanged(false);
        IObjectValue vo = this.billModel.getBillValue();
        Object pk = vo.get(vo.getPKField());
        String billId = this.getRequestBillId(operation);
        if (!(billId == null || pk != null && billId.equals(pk.toString()))) {
            if (!OperationStatus.VIEW.equals(this.operationStatus) && this.operationStatus.canTransfer(OperationStatus.VIEW, this.application)) {
                this.setOperationStatus(OperationStatus.VIEW);
            }
            this.load(billId);
        } else if ("Previous".equalsIgnoreCase(operation) || "First".equalsIgnoreCase(operation)) {
            this.showMessage("\u5df2\u7ecf\u662f\u6700\u524d\u4e00\u6761");
        } else if ("Next".equalsIgnoreCase(operation) || "Last".equalsIgnoreCase(operation)) {
            this.showMessage("\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761");
        }
    }

    @Override
    public int getSelectedRow(String entityKey) throws BOSException {
        EntrySelection es = (EntrySelection)this.selectedRows.get(entityKey.toUpperCase());
        return es == null ? -1 : es.getRowIndex();
    }

    public String getEntrySelectedField(String entityKey) throws BOSException {
        EntrySelection es = (EntrySelection)this.selectedRows.get(entityKey.toUpperCase());
        return es == null ? null : es.getFieldKey();
    }

    @Override
    public void uploadAttachment(String key) throws BOSException {
        ControlAppearance ap = this.layoutInfo.getControlAppearance(key);
        String pk = this.billModel.getPKValue();
        String extType = ap.getControlType() == 1025 ? "KDDocumentManager" : "KDAttachmentManager";
        StringBuffer sb = new StringBuffer();
        sb.append("var win = new " + extType + "({");
        if (this.billModel.getPKValue() == null) {
            sb.append("billID:'isnewbill");
        } else {
            sb.append("billID:'").append(pk);
        }
        sb.append("',kdattachment:'").append(key.toUpperCase());
        sb.append("',title:'").append(ap.getCaption());
        sb.append("',key:'").append(key);
        sb.append("',subXType:").append(ap.getControlType());
        if (ap.getControlType() == 1022) {
            ControlAppearance ca = this.getAppearanceOfOfficeControlAttached2Template();
            sb.append(",docType:").append(ca != null ? ca.getOfficeDocType() : 0);
            sb.append(",maxAttachmentCount:").append(1);
        }
        if (ap.getControlType() == 1013) {
            sb.append(",isMulAttPanel:").append(((AccessoryPanelAppearance)ap).getIsMulAttPanel());
        }
        if (this.lockedAttachmentOperation != null && this.lockedAttachmentOperation.size() > 0) {
            sb.append(",disabledBarItems:{");
            for (String attachOprKey : this.lockedAttachmentOperation) {
                sb.append(attachOprKey).append(":1,");
            }
            sb.replace(sb.length() - 1, sb.length(), "}");
        }
        sb.append("});win.showManager();");
        try {
            this.comState.outputDynmaicAction(sb.toString());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ControlAppearance getAppearanceOfOfficeControlAttached2Template() throws BOSException {
        String flowDirStr;
        IObjectValue template = this.billModel.getBillValue();
        FormMetaData formAttached2ThisFlow = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)((String)template.get("formId")), null);
        LayoutInfo layout = formAttached2ThisFlow.getLayoutInfo();
        String editor = (String)template.get("documenteditor");
        ControlAppearance ca = null;
        if (editor != null) {
            ca = (ControlAppearance)layout.getAppearance((String)template.get("documenteditor"));
        }
        if (!"com.kingdee.eas.cp.odm".equals(flowDirStr = (String)template.get("flowDirStr")) && ca == null) {
            throw new BOSException("\u6d41\u7a0b\u6a21\u677f\u6ca1\u6709\u8bbe\u7f6eoffice\u63a7\u4ef6\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u6587\u6863\u6a21\u677f\u3002");
        }
        return ca;
    }

    @Override
    public void relateBill(String key) throws BOSException, EASBizException {
        String billID = this.billModel.getPKValue();
        if (billID == null) {
            this.comState.addErrorMessage("\u8bbe\u7f6e\u5173\u8054\u5355\u636e\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
            return;
        }
        String nodeID = null;
        if (this.wfState != null && (nodeID = this.wfState.getNodeID()) == null) {
            nodeID = "-1";
        }
        String oql = "formID='" + this.getLayoutInfo().getFormId() + "' and panelKey='" + key + "' and formPk='" + billID + "'";
        JSONObject para = new JSONObject();
        try {
            para.put("formID", (Object)"pn8JlegzTfevPgwqt+w0z5p+rpI=");
            para.put("thisFormId", (Object)this.getLayoutInfo().getFormId());
            para.put("thisBillId", (Object)billID);
            para.put("thisPanelKey", (Object)key);
            para.put("nodeId", (Object)nodeID);
            para.put("layoutId", (Object)this.getLayoutInfo().getId());
            para.put("oql", (Object)oql);
        }
        catch (JSONException e) {
            // empty catch block
        }
        String url = ResourceUtil.buildUrlEncodeParam((String)"/easweb/servlet/ListServlet", (String)para.toString());
        this.popupWindow(url, "openDialog", "pn8JlegzTfevPgwqt+w0z5p+rpI=");
        try {
            this.comState.outputDynmaicAction("this.server.call('refreshControl',this.bill.PageID,'" + key + "');");
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void refreshControl(String key) {
        this.binControlData(this.layoutInfo.getControlAppearance(key));
    }

    @Override
    public void operateBill(OperationStatus status, String pk) throws BOSException {
        try {
            FormAppearance form = this.getLayoutInfo().getFormAppearance();
            this.comState.showBillOperateForm(status, this.getLayoutInfo().getFormId(), pk, form.getWidth() + 10, form.getHeight());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public void operateBill(OperationStatus status, String formId, String layoutId, String pk) throws Exception {
        Appearance form = this.getLayoutInfo().getAppearance("_BILL");
        if (formId != form.getId()) {
            FormMetaData formMetaData = FormMetaCacheManager.getFormMeta((Context)this.application.getContext(), (String)formId, null);
            LayoutInfo layout = formMetaData.getLayoutInfobyID(layoutId);
            if (layout == null) {
                layout = formMetaData.getLayoutInfo();
                layoutId = layout.getId();
            }
            form = layout.getAppearance("_BILL");
        }
        JSONObject para = new JSONObject();
        JSONObject winParam = new JSONObject();
        try {
            para.put("formID", (Object)formId);
            para.put("layoutID", (Object)layoutId);
            para.put("pk", (Object)pk);
            para.put("status", (Object)status.getStatus());
            winParam.put("name", (Object)"bill");
            winParam.put("title", (Object)form.getCaption());
            winParam.put("x", form.getWidth() + 10);
            winParam.put("y", form.getHeight() + 50);
        }
        catch (JSONException e) {
            // empty catch block
        }
        FormActionUtil.invokeShowPopupAction((IFormApplication)((IFormApplication)this.application), (String)para.toString(), (String)winParam.toString(), (String)"BillServlet", (OpenModeEnum)OpenModeEnum.OpenDialog);
    }

    @Override
    public void lockAttachmentOperation(String key) {
        if (this.lockedAttachmentOperation == null) {
            this.lockedAttachmentOperation = new HashSet();
        }
        this.lockedAttachmentOperation.add(key);
    }

    public void setImage(String key, int row, Object image) throws EASBizException, BOSException {
        this.billModel.setValue(key, image, row);
    }

    public Object getImage(String key, int row) throws EASBizException, BOSException {
        return this.billModel.getValue(key, row);
    }

    public void showFlowChart() throws BOSException, EASBizException {
        super.showFlowChart(this.billModel.getPKValue());
    }

    public void showApproveResult() throws BOSException, EASBizException {
        if (this.billModel.getPKValue() == null) {
            this.comState.addErrorMessage("\u67e5\u770b\u5ba1\u6279\u610f\u89c1\u524d\uff0c\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002");
            return;
        }
        super.showApproveResult();
    }

    public void refresh() throws BOSException, EASBizException {
        FormOperation fo;
        String pk = this.billModel.getPKValue();
        if (pk == null) {
            this.comState.addErrorMessage("\u5355\u636e\u8fd8\u672a\u4fdd\u5b58\uff0c\u4e0d\u80fd\u5237\u65b0");
            return;
        }
        if (!(this.afterConfirmOperArgs != null && this.afterConfirmOperArgs.getAction().getParameters().length != 0 && "Refresh".equals(this.afterConfirmOperArgs.getAction().getParameters()[0]) || (fo = this.billModel.getBusinessInfo().getForm().getOperation("Refresh")) == null)) {
            OperationHelper helper = new OperationHelper((IFormApplication)this.application, fo);
            JSONArray jsa = new JSONArray();
            jsa.put((Object)"Refresh");
            Action action = new Action("com.kingdee.eas.base.form.plugin.BillAction", jsa.toString());
            ActionArgs e = new ActionArgs(null, action, 0);
            if (helper.confirmModelChanged(e)) {
                return;
            }
        }
        this.load(pk);
        super.refresh();
    }

    public void forceRefresh() throws EASBizException, BOSException {
        String pk = this.billModel.getPKValue();
        if (pk != null) {
            this.load(pk);
        }
        super.refresh();
    }

    public void submitWfAfterSelectPerson(String procDefId, Map designatedPerformers) throws BOSException, EASBizException {
        FormOperation fo = this.billModel.getBusinessInfo().getForm().getOperation("Submit");
        OperationHelper helper = new OperationHelper((IFormApplication)this.application, fo);
        helper.isAfterSelectPerson = true;
        helper.afterOperation(fo, procDefId, designatedPerformers);
    }

    public String getFormOperationName(String key) {
        ButtonAppearance button = this.layoutInfo.getButtonAppearance(key);
        return FormActionUtil.getFormOperationName((Appearance)button, (String)"com.kingdee.eas.base.form.plugin.BillAction");
    }

    @Override
    public void signBill(String key) throws BOSException, EASBizException {
        FormActionUtil.invokeElectronicSignAction((IFormApplication)((BillApplication)this.application), (String)key);
    }

    public void deleteSign(String key) throws BOSException, EASBizException {
        FormActionUtil.invokeElectronicSignAction((IFormApplication)((BillApplication)this.application), (String)key, (Boolean)Boolean.TRUE);
    }

    public String getKeys(Object head) throws SQLException, DataAccessException {
        return ((BillModel)this.billModel).getKeysByHead(head);
    }

    public String getPrintFilter(Entity entity) throws EASBizException, BOSException {
        return this.eventsProxy.firePrintFilter(entity);
    }

    @Override
    public void createTo() throws BOSException {
        try {
            StringBuffer sb = new StringBuffer();
            Date date = new Date();
            SimpleDateFormat from = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String times = from.format(date);
            sb.append(" var url = '").append("/easweb/dynform").append("/botp/listPush.jsp?' + ");
            sb.append(" Ext.urlEncode({pageId:'").append(this.pageId).append("',");
            sb.append(" bosType:'").append(this.businessInfo.getForm().getBosType()).append("',");
            sb.append(" sourceBillId:'").append(this.billModel.getPKValue()).append("',");
            sb.append(" from:'").append("edit").append("',");
            sb.append(" date:'" + times + "'});");
            sb.append(" var config = {name:'createToDailog', title:'").append("\u5355\u636e\u8f6c\u6362");
            if (this.application.getCustomParameter("templateid") != null) {
                sb.append("',flowTempId:'").append(this.application.getCustomParameter("templateid"));
            }
            sb.append("',width:400,minHeight:222,iframeHeight:222,iframe:true");
            sb.append(",url:url");
            sb.append("};");
            sb.append(" if(typeof showHideObject != 'undefined' && showHideObject) {showHideObject(false);}");
            sb.append(" if(parent.jCp == undefined){jCp.ui.dialog.win(config);}else{parent.jCp.ui.dialog.win(config);}");
            this.comState.outputDynmaicAction(sb.toString());
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getDocumentControlSetting() {
        String str = null;
        try {
            Context ctx = this.application.getContext();
            Class<?> cls = Class.forName("com.kingdee.eas.cp.base.util.DocumentControlSettingUtil");
            Object obj = cls.newInstance();
            Method method = cls.getMethod("getOfficeSettingDesc", Context.class);
            str = (String)method.invoke(obj, ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return str;
    }
}

