/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client;

import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.model.BarBuilderBase;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarItemClickedEvent;
import com.kingdee.eas.base.form.model.BarItemEvent;
import com.kingdee.eas.base.form.model.BarItemLinkEvent;
import com.kingdee.eas.base.form.model.BarItemPropertyChangedEvent;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class GuiBarBuilder
extends BarBuilderBase {
    private KDMenuBar menubar = null;
    private KDToolBar toolbar = null;
    private KDStatusBar statusbar = null;
    private ActionListener listenerProxy = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                JMenuItem menuItem = (JMenuItem)e.getSource();
                BarItemClickedEvent event = new BarItemClickedEvent();
                event.setBarItem(GuiBarBuilder.this.getBarItem(menuItem.getName()));
                GuiBarBuilder.this.getBarBuilder().fireBarItemClicked(event);
            }
        }
    };

    public GuiBarBuilder(BarDataManager barDataMgr, KDMenuBar menubar, KDToolBar toolbar, KDStatusBar statusbar) {
        super(barDataMgr);
        barDataMgr.getEventProxy().addBarModelListener(this);
        barDataMgr.getEventProxy().addBarItemPropertyChangedListener(this);
        this.menubar = menubar;
        this.toolbar = toolbar;
        this.statusbar = statusbar;
        this.clearMenuBarPassedIn();
    }

    public GuiBarBuilder(BarDataManager barDataMgr, KDMenuBar menubar, KDToolBar toolbar) {
        this(barDataMgr, menubar, toolbar, null);
    }

    public GuiBarBuilder(BarDataManager barDataMgr, KDMenuBar menubar) {
        this(barDataMgr, menubar, null, null);
    }

    private void clearMenuBarPassedIn() {
        this.menubar.removeAll();
    }

    @Override
    protected Object createSubMenu(BarItem barItem) {
        KDMenu subMenu = new KDMenu();
        subMenu.setName(barItem.getName());
        subMenu.setText(barItem.getCaption().replaceAll("&", ""));
        subMenu.setToolTipText(barItem.getToolTip_L2());
        subMenu.setMnemonic(barItem.getMnemonicKey());
        return subMenu;
    }

    @Override
    protected Object createMenuItem(BarItem barItem) {
        Object menuObj = null;
        switch (barItem.getStyle().getValue()) {
            case 0: {
                menuObj = this.createMenuItemButton(barItem);
                break;
            }
            case 2: {
                menuObj = this.createMenuItemCheckBox(barItem);
                break;
            }
            case 3: {
                break;
            }
            case 11: {
                menuObj = this.createMenuSeparator(barItem);
            }
        }
        return menuObj;
    }

    private char getAcceleratorKey(String keyName) {
        if (keyName.length() == 1) {
            return keyName.charAt(0);
        }
        if (keyName.equals("F1")) {
            return 'p';
        }
        if (keyName.equals("F2")) {
            return 'q';
        }
        if (keyName.equals("F3")) {
            return 'r';
        }
        if (keyName.equals("F4")) {
            return 's';
        }
        if (keyName.equals("F5")) {
            return 't';
        }
        if (keyName.equals("F6")) {
            return 'u';
        }
        if (keyName.equals("F7")) {
            return 'v';
        }
        if (keyName.equals("F8")) {
            return 'w';
        }
        if (keyName.equals("F9")) {
            return 'x';
        }
        if (keyName.equals("F10")) {
            return 'y';
        }
        if (keyName.equals("F11")) {
            return 'z';
        }
        if (keyName.equals("F12")) {
            return '{';
        }
        if (keyName.equals("PGUP")) {
            return '!';
        }
        if (keyName.equals("PGDN")) {
            return '\"';
        }
        if (keyName.equals("INSERT")) {
            return '\u009b';
        }
        if (keyName.equals("DELETE")) {
            return '\u007f';
        }
        if (keyName.equals("HOME")) {
            return '$';
        }
        if (keyName.equals("END")) {
            return '#';
        }
        return '\uffff';
    }

    private KeyStroke getAccelerator(String shortcut) {
        int keyMask = 0;
        int key = 65535;
        if (shortcut != null && shortcut.length() > 0) {
            String[] keys = shortcut.split("\\+");
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].trim().equalsIgnoreCase("ctrl")) {
                    keyMask |= 2;
                    continue;
                }
                if (keys[i].trim().equalsIgnoreCase("alt")) {
                    keyMask |= 8;
                    continue;
                }
                if (keys[i].trim().equalsIgnoreCase("shift")) {
                    keyMask |= 1;
                    continue;
                }
                key = this.getAcceleratorKey(keys[i].trim().toUpperCase());
            }
        }
        KeyStroke keyStroke = null;
        if (key != 65535) {
            keyStroke = KeyStroke.getKeyStroke(key, keyMask);
        }
        return keyStroke;
    }

    protected Object createMenuItemButton(BarItem barItem) {
        KDMenuItem menuItem = new KDMenuItem();
        menuItem.setName(barItem.getName());
        menuItem.setText(barItem.getCaption().replaceAll("&", ""));
        menuItem.setToolTipText(barItem.getToolTip_L2());
        menuItem.setMnemonic(barItem.getMnemonicKey());
        menuItem.addActionListener(this.listenerProxy);
        menuItem.setAccelerator(this.getAccelerator(barItem.getShortcut()));
        menuItem.setIcon(this.getIcon(barItem));
        return menuItem;
    }

    protected Object createMenuItemCheckBox(BarItem barItem) {
        KDCheckBoxMenuItem menuItem = new KDCheckBoxMenuItem();
        menuItem.setName(barItem.getName());
        menuItem.setText(barItem.getCaption().replaceAll("&", ""));
        menuItem.setToolTipText(barItem.getToolTip_L2());
        menuItem.setMnemonic(barItem.getMnemonicKey());
        menuItem.setSelected(barItem.getChecked() == 1);
        menuItem.setIcon(this.getIcon(barItem));
        return menuItem;
    }

    @Override
    protected Object createMenuSeparator(BarItem barItem) {
        KDSeparator separator = new KDSeparator();
        separator.setName(barItem.getName());
        return separator;
    }

    @Override
    protected Object createToolbarSeparator(BarItem barItem) {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setName(barItem.getName());
        separator.setOrientation(1);
        return separator;
    }

    @Override
    protected Object createToolbarButton(BarItem barItem) {
        KDWorkButton btn = new KDWorkButton();
        btn.setName(barItem.getName());
        btn.setIcon(this.getIcon(barItem));
        btn.setToolTipText(barItem.getToolTip_L2());
        return btn;
    }

    private Icon getIcon(BarItem barItem) {
        Icon icon = (Icon)barItem.getImage();
        if (icon == null && barItem.getImageKey() != null && barItem.getImageKey().length() > 0) {
            icon = EASResource.getIcon((String)barItem.getImageKey());
            barItem.setImage(icon);
        }
        return icon;
    }

    @Override
    protected void add2Parent(Object parent, Object child) {
        Container cmpParent = (Container)parent;
        cmpParent.add((Component)child);
    }

    @Override
    protected Object getMainMenu() {
        return this.menubar;
    }

    @Override
    protected Object getToolbar() {
        return this.toolbar;
    }

    @Override
    public void barItemAdded(BarItemEvent e) {
    }

    @Override
    public void barItemLinkAdded(BarItemLinkEvent e) {
    }

    @Override
    public void barItemLinkRemoved(BarItemLinkEvent e) {
    }

    @Override
    public void barItemRemoved(BarItemEvent e) {
    }

    @Override
    public void barItemPropertyChanged(BarItemPropertyChangedEvent e) {
    }
}

