/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.eas.base.form.client.UIControlFactory;
import com.kingdee.eas.base.form.client.ctrl.KDExtLabel;
import com.kingdee.eas.base.form.client.ctrl.KDRadioGroupPanel;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.NewF7Utils;
import com.kingdee.eas.base.form.util.StringLib;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UIBuilder {
    private LayoutInfo layoutInfo;
    private JPanel panel;
    private HashMap controls;
    private HashMap mapBtnGroup;
    private BusinessInfo businessInfo;
    private Map mapRows;
    private Map mapColumns;
    private boolean isRuntime = true;
    public static final String DEFAULT_BUTTONGROUP_NAME = "1default";

    public LayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    public void setLayoutInfo(LayoutInfo layoutInfo) {
        this.layoutInfo = layoutInfo;
    }

    public BusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    public void setBusinessInfo(BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    public boolean isRuntime() {
        return this.isRuntime;
    }

    public void setRuntime(boolean isRuntime) {
        this.isRuntime = isRuntime;
    }

    public void setControlKey(String newKey, String oldKey) {
        Object obj = this.controls.get(oldKey);
        if (obj != null) {
            this.controls.remove(oldKey);
            this.controls.put(newKey, obj);
            return;
        }
        obj = this.mapRows.get(oldKey);
        if (obj != null) {
            this.mapRows.remove(oldKey);
            this.mapRows.put(newKey, obj);
            return;
        }
        obj = this.mapColumns.get(oldKey);
        if (obj != null) {
            this.mapColumns.remove(oldKey);
            this.mapColumns.put(newKey, obj);
            return;
        }
    }

    public UIBuilder(LayoutInfo layoutInfo, JPanel panel, BusinessInfo businessInfo) {
        this.panel = panel;
        this.layoutInfo = layoutInfo;
        this.businessInfo = businessInfo;
        this.controls = new HashMap();
        this.mapBtnGroup = new HashMap();
        this.mapColumns = new HashMap();
        this.mapRows = new HashMap();
        KDButtonGroup group = new KDButtonGroup();
        this.mapBtnGroup.put(DEFAULT_BUTTONGROUP_NAME, group);
    }

    public void addControls() {
        this.addControls(this.layoutInfo);
        this.setParens(this.layoutInfo);
    }

    public Component getControl(String key) {
        return (Component)this.controls.get(key);
    }

    public KDButtonGroup getBtnGroup(String key) {
        if (key == null || key.trim().length() == 0) {
            key = DEFAULT_BUTTONGROUP_NAME;
        }
        return (KDButtonGroup)this.mapBtnGroup.get(key);
    }

    private void addControls(LayoutInfo layoutInfo) {
        ArrayList vctControls = layoutInfo.getControls();
        for (int i = 0; i < vctControls.size(); ++i) {
            ControlAppearance ctl = (ControlAppearance)vctControls.get(i);
            this.addControl(ctl);
        }
    }

    public Component addControl(ControlAppearance ctl) {
        Component com = null;
        if (ctl.getControlType() == -1) {
            LayoutInfo sublayoutinfo = ((EntityAppearance)ctl).getLayoutinfo();
            this.addControls(sublayoutinfo);
        } else if (ctl instanceof FieldAppearance) {
            com = this.addFieldControl((FieldAppearance)ctl);
            this.controls.put(ctl.getKey(), com);
        } else {
            com = this.addOtherControl(ctl);
            this.controls.put(ctl.getKey(), com);
        }
        if (com != null && com instanceof JComponent) {
            ((JComponent)com).putClientProperty("TabIndex", new Integer(ctl.getTabindex()));
        }
        return com;
    }

    private void setRadioButton(ControlAppearance ctl, KDRadioButton radio) {
        Field radiofield = (Field)this.businessInfo.getElement(ctl.getKey());
        if (radiofield.getControlFieldKey() == null || radiofield.getControlFieldKey().trim().length() == 0) {
            KDButtonGroup btngroup = (KDButtonGroup)this.mapBtnGroup.get(DEFAULT_BUTTONGROUP_NAME);
            btngroup.add((AbstractButton)radio);
        } else if (this.mapBtnGroup.get(radiofield.getControlFieldKey()) != null) {
            KDButtonGroup btngroup = (KDButtonGroup)this.mapBtnGroup.get(radiofield.getControlFieldKey());
            btngroup.add((AbstractButton)radio);
        } else {
            KDButtonGroup group1 = new KDButtonGroup();
            group1.add((AbstractButton)radio);
            this.mapBtnGroup.put(radiofield.getControlFieldKey(), group1);
        }
    }

    private void setEntityCtl(EntityAppearance ctl, KDTable table) {
        LayoutInfo tableLayoutinfo = ctl.getLayoutinfo();
        ArrayList fldCtls = tableLayoutinfo.getControls();
        Entity entity = this.businessInfo.getEntity(ctl.getKey());
        if (entity != null) {
            if (entity.getEntityType() == 0) {
                table.putClientProperty((Object)"EntryType", (Object)new Integer(0));
                this.createSingleView(ctl, table, fldCtls);
            } else {
                table.getIndexColumn().getStyleAttributes().setHided(true);
                table.putClientProperty((Object)"EntryType", (Object)new Integer(1));
                this.createEntryView(ctl, table, fldCtls);
            }
            this.controls.put(ctl.getKey(), table);
        }
    }

    private void createSingleView(ControlAppearance ctl, KDTable table, ArrayList fldCtls) {
        table.addColumns(2);
        if (!this.isRuntime()) {
            table.getSelectManager().setSelectMode(2);
        }
        IRow row = table.addHeadRow();
        row.getCell(0).setValue((Object)"\u5c5e\u6027");
        row.getCell(1).setValue((Object)"\u503c");
        for (int i = 0; i < fldCtls.size(); ++i) {
            FieldAppearance fldCtl = (FieldAppearance)fldCtls.get(i);
            this.createNewRow(table, fldCtl);
        }
    }

    public void createNewRow(KDTable table, FieldAppearance fldCtl) {
        int rowCount = table.getRowCount();
        IRow row = table.addRow();
        row.setUserObject((Object)fldCtl.getKey());
        row.getCell(0).setValue((Object)fldCtl.getCaption());
        this.mapRows.put(fldCtl.getKey(), row);
        fldCtl.setTabindex(rowCount);
    }

    public void insertNewRow(KDTable table, FieldAppearance fldCtl) {
        IRow row = table.addRow(fldCtl.getTabindex());
        row.setUserObject((Object)fldCtl.getKey());
        row.getCell(0).setValue((Object)fldCtl.getCaption());
        this.mapRows.put(fldCtl.getKey(), row);
    }

    public void removeRow(KDTable table, FieldAppearance fldCtl) {
        String key = fldCtl.getKey();
        int rowCount = table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String tmpkey;
            IRow row = table.getRow(i);
            if (row.getUserObject() == null || !(row.getUserObject() instanceof String) || !(tmpkey = (String)row.getUserObject()).equalsIgnoreCase(key)) continue;
            table.removeRow(i);
            break;
        }
    }

    public IRow getRow(String key) {
        return (IRow)this.mapRows.get(key);
    }

    public IColumn getColumn(String key) {
        return (IColumn)this.mapColumns.get(key);
    }

    private void createEntryView(ControlAppearance ctl, KDTable table, ArrayList fldCtls) {
        table.setColumnMoveable(true);
        table.addHeadRow();
        Collections.sort(fldCtls, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FieldAppearance f0 = (FieldAppearance)arg0;
                FieldAppearance f1 = (FieldAppearance)arg1;
                if (f0.getTabindex() < f1.getTabindex()) {
                    return -1;
                }
                if (f0.getTabindex() > f1.getTabindex()) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < fldCtls.size(); ++i) {
            LookUpObject obj;
            Field field;
            FieldAppearance fldCtl = (FieldAppearance)fldCtls.get(i);
            this.createNewColumn(table, fldCtl);
            if (fldCtl.getControlType() != 7 || (field = (Field)this.businessInfo.getElement(fldCtl.getKey())).getNewF7() != 1 || (obj = this.businessInfo.getLookUpObject(field.getLookUpObjectID())) == null || NewF7Utils.checkNewF7Query(obj.getQueryInfo()) == null) continue;
            field.setNewF7(0);
        }
    }

    public void createNewColumn(KDTable table, FieldAppearance fldCtl) {
        int colCount = table.getColumnCount();
        IRow row = table.getHeadRow(0);
        IColumn col = table.addColumn();
        col.setKey(fldCtl.getKey());
        col.setWidth(fldCtl.getBounds().width);
        this.mapColumns.put(fldCtl.getKey(), col);
        row.getCell(table.getColumnCount() - 1).setValue((Object)fldCtl.getCaption());
        fldCtl.setTabindex(colCount);
    }

    public void insertNewColumn(KDTable table, FieldAppearance fldCtl) {
        IRow row = table.getHeadRow(0);
        IColumn col = table.addColumn(fldCtl.getTabindex());
        col.setKey(fldCtl.getKey());
        col.setWidth(fldCtl.getBounds().width);
        this.mapColumns.put(fldCtl.getKey(), col);
        row.getCell(col.getColumnIndex()).setValue((Object)fldCtl.getCaption());
    }

    public void removeColumn(KDTable table, FieldAppearance fldCtl) {
        int colCount = table.getColumnCount();
        String key = fldCtl.getKey();
        for (int i = 0; i < colCount; ++i) {
            if (!table.getColumnKey(i).equalsIgnoreCase(key)) continue;
            table.removeColumn(i);
            break;
        }
    }

    private void setParens(LayoutInfo layoutInfo) {
        ArrayList vctControls = layoutInfo.getControls();
        for (int i = 0; i < vctControls.size(); ++i) {
            ControlAppearance ctl = (ControlAppearance)vctControls.get(i);
            this.setParen(ctl);
        }
    }

    private void setParen(ControlAppearance ctlInfo) {
        EntityAppearance entityCtl;
        if (ctlInfo instanceof EntityAppearance && (entityCtl = (EntityAppearance)ctlInfo).getControlType() == -1) {
            this.setParens(entityCtl.getLayoutinfo());
            return;
        }
        String key = ctlInfo.getKey();
        String parentKey = StringLib.GetString(ctlInfo.getContainer(), 1, ",");
        if (this.controls.containsKey(key)) {
            Component com = (Component)this.controls.get(key);
            Rectangle rc = com.getBounds();
            Container comContainer = null;
            comContainer = this.controls.containsKey(parentKey) ? (Container)this.controls.get(parentKey) : this.panel;
            com.setBounds(rc);
            if (comContainer instanceof KDContainer) {
                comContainer = ((KDContainer)comContainer).getContentPane();
            }
            if (comContainer.getLayout() instanceof KDLayout) {
                if (this.isRuntime) {
                    comContainer.add(com, new KDLayout.Constraints(384, rc));
                } else {
                    comContainer.add(com, new KDLayout.Constraints(0, rc));
                }
            } else if (comContainer.getLayout() instanceof BorderLayout) {
                comContainer.add(com, "Center");
            } else if (comContainer.getLayout() instanceof TableLayout) {
                int col = Integer.parseInt(StringLib.GetString(ctlInfo.getContainer(), 2, ","));
                int row = Integer.parseInt(StringLib.GetString(ctlInfo.getContainer(), 3, ","));
                TableLayout tb = (TableLayout)comContainer.getLayout();
                comContainer.add(com, tb.cell(row, col));
            } else {
                comContainer.add(com);
            }
        }
    }

    private Component addOtherControl(ControlAppearance ctl) {
        UIControlFactory extCtlFactory = new UIControlFactory(ctl, this.businessInfo);
        Component com = extCtlFactory.createControl();
        if (ctl.getControlType() == 1007) {
            this.setEntityCtl((EntityAppearance)ctl, (KDTable)com);
        } else if (ctl.getControlType() == 1005) {
            this.setTab((KDTabbedPane)com);
        }
        return com;
    }

    private void setTab(KDTabbedPane com) {
        Component[] coms = com.getComponents();
        for (int i = 0; i < coms.length; ++i) {
            this.controls.put(coms[i].getName(), coms[i]);
        }
    }

    private Component addFieldControl(FieldAppearance fld) {
        UIControlFactory extCtlFactory = new UIControlFactory(fld, this.businessInfo);
        if (fld.getControlType() == 10) {
            KDRadioButton radio = (KDRadioButton)extCtlFactory.createControl();
            this.setRadioButton(fld, radio);
            return radio;
        }
        if (fld.getControlType() == 4) {
            return extCtlFactory.createControl();
        }
        if (fld.getControlType() == 32) {
            KDRadioGroupPanel panel = new KDRadioGroupPanel();
            panel.setName(fld.getKey());
            panel.setBounds(fld.getBounds());
            panel.setLayout((LayoutManager)new KDLayout());
            panel.setTitle(fld.getCaption());
            panel.putClientProperty("OriginalBounds", fld.getBounds());
            return panel;
        }
        String sText = StringLib.GetString(fld.getCaption(), 2, "+");
        if (sText.length() == 0) {
            sText = StringLib.GetString(fld.getCaption(), 1, "+");
        }
        KDLabelContainer item = new KDLabelContainer();
        this.setContainer(item, fld, extCtlFactory.createControl(), sText);
        this.controls.put(fld.getKey(), item);
        return item;
    }

    private void setContainer(KDLabelContainer container, FieldAppearance ctlInfo, Component boundEditor, String text) {
        Field fld;
        KDExtLabel lbl = new KDExtLabel();
        container.setBoundLabel((JLabel)((Object)lbl));
        lbl.setContainerLabel(true);
        if (ctlInfo.getStyle() == 6) {
            lbl.setFrameLine(true);
        }
        container.setName(ctlInfo.getKey());
        container.setBounds(ctlInfo.getBounds());
        container.setBoundLabelText(text);
        container.setBoundLabelLength(ctlInfo.getLabelWidth());
        container.setBoundEditor((JComponent)boundEditor);
        container.setBoundLabelUnderline(true);
        if (!this.isRuntime && (fld = this.businessInfo.getField(ctlInfo.getKey())) != null && fld.getPropertyName() != null && fld.getPropertyName().length() > 0) {
            lbl.setIcon(new ImageIcon(EASResource.getImage((String)"imgTbtn_entity")));
        }
        if (ctlInfo.getTextAlign() == 2) {
            lbl.setHorizontalAlignment(0);
        } else if (ctlInfo.getTextAlign() == 3) {
            lbl.setHorizontalAlignment(4);
        }
        if (ctlInfo.getElementType() == 6 || ctlInfo.getElementType() == 1011) {
            container.putClientProperty((Object)"autoHeight", (Object)new Boolean(false));
            lbl.setFrameLine(true);
        } else {
            container.putClientProperty((Object)"autoHeight", (Object)new Boolean(true));
        }
    }
}

