/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFloatTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.base.form.client.ctrl.KDAccessoryPanel;
import com.kingdee.eas.base.form.client.ctrl.KDApproval;
import com.kingdee.eas.base.form.client.ctrl.KDExtLabel;
import com.kingdee.eas.base.form.client.ctrl.KDImgPanel;
import com.kingdee.eas.base.form.client.ctrl.KDPicture;
import com.kingdee.eas.base.form.client.ctrl.KDRect;
import com.kingdee.eas.base.form.client.layout.Table.TableLayout;
import com.kingdee.eas.base.form.core.BasImgHelper;
import com.kingdee.eas.base.form.core.MetaDataFactory;
import com.kingdee.eas.base.form.metadata.ApprovalList;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.util.NewF7Utils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JPanel;

public class UIControlFactory {
    private ControlAppearance ctlInfo;
    private BusinessInfo businessInfo;

    public UIControlFactory(ControlAppearance fldInfo, BusinessInfo businessInfo) {
        this.ctlInfo = fldInfo;
        this.businessInfo = businessInfo;
    }

    public Component createControl() {
        int ctlType = this.ctlInfo.getControlType();
        switch (ctlType) {
            case 0: {
                KDDatePicker datePk = new KDDatePicker();
                return datePk;
            }
            case 998: {
                KDDatePicker longdate = new KDDatePicker();
                longdate.setTimeEnabled(true);
                longdate.setMilliSecondEnable(true);
                return longdate;
            }
            case 1: {
                KDTextField txtField = new KDTextField();
                return txtField;
            }
            case 2: {
                KDFloatTextField floatEditor = new KDFloatTextField();
                return floatEditor;
            }
            case 3: {
                KDFormattedTextField intEditor = new KDFormattedTextField();
                intEditor.setDataType(0);
                return intEditor;
            }
            case 4: {
                KDCheckBox checkEditor = new KDCheckBox();
                checkEditor.setName(this.ctlInfo.getKey());
                checkEditor.setText(((FieldAppearance)this.ctlInfo).getCaption());
                checkEditor.setBounds(((FieldAppearance)this.ctlInfo).getBounds());
                checkEditor.putClientProperty((Object)"autoHeight", (Object)new Boolean(true));
                return checkEditor;
            }
            case 7: {
                LookUpObject obj;
                KDBizPromptBox F7Editor = new KDBizPromptBox();
                Field field = (Field)this.businessInfo.getElement(this.ctlInfo.getKey());
                if (field != null && (obj = this.businessInfo.getLookUpObject(field.getLookUpObjectID())) != null) {
                    if (field.getNewF7() == 1) {
                        if (NewF7Utils.checkNewF7Query(obj.getQueryInfo()) != null) {
                            field.setNewF7(0);
                        }
                    } else if (NewF7Utils.checkNewF7Query(obj.getQueryInfo()) == null) {
                        field.setNewF7(1);
                    }
                    F7Editor.setQueryInfo(obj.getQueryInfo());
                    F7Editor.setDisplayFormat(((FieldAppearance)this.ctlInfo).getDisplayFormat());
                    F7Editor.setEditFormat(((FieldAppearance)this.ctlInfo).getEditFormat());
                    F7Editor.setCommitFormat(((FieldAppearance)this.ctlInfo).getCommitFormat());
                    F7Editor.setEditorLength(this.ctlInfo.getBounds().width);
                    F7Editor.setEnabledMultiSelection(false);
                }
                return F7Editor;
            }
            case 8: {
                KDComboBox cboField = new KDComboBox();
                return cboField;
            }
            case 999: {
                KDTextArea txtArea = new KDTextArea();
                return txtArea;
            }
            case 22: {
                KDFormattedTextField bigDecEditor = new KDFormattedTextField();
                bigDecEditor.setDataType(1);
                return bigDecEditor;
            }
            case 10: {
                KDRadioButton radio = new KDRadioButton();
                radio.setName(this.ctlInfo.getKey());
                radio.setText(this.ctlInfo.getCaption());
                radio.setBounds(this.ctlInfo.getBounds());
                return radio;
            }
            case 1011: {
                KDPicture picture = new KDPicture();
                return picture;
            }
            case 1001: 
            case 1014: {
                KDExtLabel lbl = new KDExtLabel();
                lbl.setName(this.ctlInfo.getKey());
                lbl.setText(this.ctlInfo.getCaption());
                lbl.setBounds(this.ctlInfo.getBounds());
                if (this.ctlInfo.getControlType() == 1014) {
                    lbl.setUnderline(true);
                }
                if (this.ctlInfo.getStyle() == 1) {
                    lbl.setFrameLine(true);
                } else {
                    lbl.setFrameLine(false);
                }
                if (this.ctlInfo.getTextAlign() == 2) {
                    lbl.setHorizontalAlignment(0);
                } else if (this.ctlInfo.getTextAlign() == 3) {
                    lbl.setHorizontalAlignment(4);
                }
                return lbl;
            }
            case 1015: {
                KDTextArea labArea = new KDTextArea();
                labArea.setName(this.ctlInfo.getKey());
                labArea.setEditable(false);
                labArea.setText(this.ctlInfo.getCaption());
                labArea.setBounds(this.ctlInfo.getBounds());
                labArea.setFocusable(false);
                return labArea;
            }
            case 1002: {
                KDWorkButton btn = new KDWorkButton();
                btn.setName(this.ctlInfo.getKey());
                btn.setBounds(this.ctlInfo.getBounds());
                btn.setText(this.ctlInfo.getCaption());
                return btn;
            }
            case 1003: {
                KDSeparator sep = new KDSeparator();
                sep.setName(this.ctlInfo.getKey());
                sep.setBounds(this.ctlInfo.getBounds());
                sep.putClientProperty((Object)"autoHeight", (Object)new Boolean(true));
                return sep;
            }
            case 1004: {
                return this.createTabPage((TabPageAppearance)this.ctlInfo);
            }
            case 1005: {
                KDTabbedPane tab = new KDTabbedPane();
                tab.setName(this.ctlInfo.getKey());
                tab.setBounds(this.ctlInfo.getBounds());
                TabControlAppearance tabAp = (TabControlAppearance)this.ctlInfo;
                ArrayList tabPages = tabAp.getTabPages();
                for (int i = 0; i < tabPages.size(); ++i) {
                    TabPageAppearance tabPageAp = (TabPageAppearance)tabPages.get(i);
                    tab.add((Component)this.createTabPage(tabPageAp), (Object)tabPageAp.getCaption());
                }
                return tab;
            }
            case 1006: {
                KDContainer fram = new KDContainer();
                fram.setName(this.ctlInfo.getKey());
                fram.setContainerType(1);
                fram.setTitle(this.ctlInfo.getCaption());
                fram.setBounds(this.ctlInfo.getBounds());
                fram.getContentPane().setName(this.ctlInfo.getKey());
                fram.getContentPane().setLayout((LayoutManager)new KDLayout());
                fram.getContentPane().putClientProperty("OriginalBounds", this.ctlInfo.getBounds());
                return fram;
            }
            case 1007: {
                KDTable table = new KDTable();
                table.setName(this.ctlInfo.getKey());
                table.setBounds(this.ctlInfo.getBounds());
                return table;
            }
            case 1012: {
                KDPanel panel = new KDPanel();
                panel.setName(this.ctlInfo.getKey());
                panel.setBounds(this.ctlInfo.getBounds());
                panel.setName(this.ctlInfo.getKey());
                this.setLayout(this.ctlInfo, (JPanel)panel);
                return panel;
            }
            case 1013: 
            case 1016: 
            case 1018: 
            case 1021: 
            case 1022: 
            case 1023: 
            case 1024: 
            case 1025: 
            case 1026: {
                KDAccessoryPanel aPanel = new KDAccessoryPanel();
                aPanel.setName(this.ctlInfo.getKey());
                aPanel.setBounds(this.ctlInfo.getBounds());
                aPanel.setTitle(this.ctlInfo.getCaption());
                return aPanel;
            }
            case 1017: {
                KDRect rect = new KDRect();
                rect.setName(this.ctlInfo.getKey());
                rect.setBounds(this.ctlInfo.getBounds());
                return rect;
            }
            case 1019: {
                KDApproval apr = new KDApproval();
                apr.setName(this.ctlInfo.getKey());
                apr.setBounds(this.ctlInfo.getBounds());
                apr.setSeting((ApprovalList)this.ctlInfo);
                return apr;
            }
            case 1027: {
                KDImgPanel imgPanel = new KDImgPanel(this.businessInfo, this.ctlInfo);
                imgPanel.setName(this.ctlInfo.getKey());
                imgPanel.setBounds(this.ctlInfo.getBounds());
                BasImgHelper biHelper = new BasImgHelper();
                biHelper.setBosType(this.businessInfo.getForm().getBosType());
                biHelper.setFieldKey(this.ctlInfo.getKey());
                String imgFile = MetaDataFactory.getImgDataStream(biHelper, null);
                imgPanel.setImagePath(imgFile);
                return imgPanel;
            }
        }
        return null;
    }

    private KDPanel createTabPage(TabPageAppearance tabPageAp) {
        KDPanel tabPage = new KDPanel();
        tabPage.setName(tabPageAp.getKey());
        tabPage.setLayout((LayoutManager)new KDLayout());
        tabPage.putClientProperty((Object)"OriginalBounds", (Object)tabPageAp.getBounds());
        tabPage.putClientProperty((Object)"Text", (Object)tabPageAp.getCaption());
        tabPage.putClientProperty((Object)"TabIndex", (Object)new Integer(tabPageAp.getTabindex()));
        return tabPage;
    }

    private void setLayout(ControlAppearance ctl, JPanel panel) {
        if (ctl.getLayout() instanceof com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout) {
            com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout tbInfo = (com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout)ctl.getLayout();
            TableLayout tb = TableLayout.split(tbInfo.getRows(), tbInfo.getCols());
            ArrayList colStyles = tbInfo.getColStyles();
            for (int i = 0; i < colStyles.size(); ++i) {
                Style style = (Style)colStyles.get(i);
                tb.colStyle(i).setWidth(style.getOut());
                tb.colStyle(i).setMargin(style.getMargin());
            }
            ArrayList rowStyles = tbInfo.getRowStyles();
            for (int i = 0; i < rowStyles.size(); ++i) {
                Style style = (Style)rowStyles.get(i);
                tb.rowStyle(i).setHeight(style.getOut());
                tb.rowStyle(i).setMargin(style.getMargin());
            }
            panel.setLayout(tb);
        } else {
            panel.setLayout((LayoutManager)new KDLayout());
        }
        panel.putClientProperty("OriginalBounds", ctl.getBounds());
    }
}

