/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client.ctrl;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTColumnMoveListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTResizeListener;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.ApprovalList;

public class KDApproval
extends KDTable {
    private ColumnChangeListener columnChangeListener;

    public KDApproval() {
        this.initComponent();
    }

    private void initComponent() {
        this.setColumnMoveable(true);
        this.addHeadRow();
        IRow row = this.getHeadRow(0);
        String[] colCaption = new String[]{"\u4efb\u52a1\u540d\u79f0", "\u5ba1\u6279\u7ed3\u679c", "\u5904\u7406\u7b56\u7565", "\u5ba1\u6279\u610f\u89c1", "\u5ba1\u6279\u4eba", "\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7", "\u5ba1\u6279\u4eba\u804c\u4f4d", "\u5ba1\u6279\u65e5\u671f"};
        String[] colKey = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
        for (int i = 0; i < colCaption.length; ++i) {
            IColumn col = this.addColumn();
            col.setKey(colKey[i]);
            col.setWidth(100);
            row.getCell(this.getColumnCount() - 1).setValue((Object)colCaption[i]);
        }
        this.columnChangeListener = new ColumnChangeListener();
        this.addKDTColumnMoveListener(this.columnChangeListener);
        this.addKDTResizeListener(this.columnChangeListener);
    }

    public void setSeting(ApprovalList approvalList) {
        this.columnChangeListener.setSetting(true);
        if (approvalList.getSetting() != null && approvalList.getSetting().length() > 0) {
            try {
                JSONArray sets = new JSONArray(approvalList.getSetting());
                for (int i = 0; i < sets.length(); ++i) {
                    JSONObject set = (JSONObject)sets.get(i);
                    String key = set.getString("K");
                    int width = set.getInt("W");
                    IColumn col = this.getColumn(key);
                    if (col == null) continue;
                    col.setWidth(width);
                    this.moveColumn(col.getColumnIndex(), i);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        this.columnChangeListener.setSeting(approvalList);
        this.columnChangeListener.setSetting(false);
    }

    class ColumnChangeListener
    implements KDTColumnMoveListener,
    KDTResizeListener {
        private ApprovalList approvalList;
        private boolean isSetting = false;

        ColumnChangeListener() {
        }

        public boolean isSetting() {
            return this.isSetting;
        }

        public void setSetting(boolean isSetting) {
            this.isSetting = isSetting;
        }

        public void setSeting(ApprovalList approvalList) {
            this.approvalList = approvalList;
        }

        public void columnMoved(KDTColumnMoveEvent e) {
            if (!this.isSetting) {
                this.buildSetting();
            }
        }

        public void tableColumnResize(KDTResizeEvent e) {
            if (!this.isSetting) {
                this.buildSetting();
            }
        }

        public void tableRowResize(KDTResizeEvent e) {
        }

        private void buildSetting() {
            JSONArray sets = new JSONArray();
            for (int i = 0; i < KDApproval.this.getColumnCount(); ++i) {
                IColumn col = KDApproval.this.getColumn(i);
                try {
                    JSONObject json = new JSONObject();
                    json.put("K", col.getKey());
                    json.put("W", col.getWidth());
                    sets.put(json);
                    continue;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            this.approvalList.setSetting(sets.toString());
        }
    }
}

