/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client.ctrl;

import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.form.core.BasImgHelper;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.UIManager;

public class KDImgPanel
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private Image image;
    private int imgWidth;
    private int imgHeight;
    private String imgPanelKey;
    private ControlAppearance ctlInfo;
    private BusinessInfo businessInfo;
    private boolean changed = false;
    private String imgFile;

    public int getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(int imgWidth) {
        this.imgWidth = imgWidth;
    }

    public String getImgPanelKey() {
        return this.imgPanelKey;
    }

    public void setImgPanelKey(String imgPanelKey) {
        this.imgPanelKey = imgPanelKey;
        this.ctlInfo.setKey(imgPanelKey);
    }

    public String getImgFile() {
        return this.imgFile;
    }

    public void setImgFile(String imgFile) {
        this.imgFile = imgFile;
        this.ctlInfo.setImgFile(imgFile);
    }

    public int getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(int imgHeight) {
        this.imgHeight = imgHeight;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public KDImgPanel(BusinessInfo businessInfo, ControlAppearance ctlInfo) {
        this.businessInfo = businessInfo;
        this.ctlInfo = ctlInfo;
        this.imgPanelKey = ctlInfo.getKey();
    }

    private InputStream getImgDataStream(String imgData) {
        BasImgHelper biHelper = new BasImgHelper();
        biHelper.setBosType(this.businessInfo.getForm().getBosType());
        biHelper.setFieldKey(this.imgPanelKey);
        if (!StringUtils.isEmpty((String)imgData)) {
            biHelper.setImgFile(imgData);
        } else if (!StringUtils.isEmpty((String)this.imgFile)) {
            biHelper.setImgFile(this.imgFile);
        }
        return biHelper.getImgStreamFromString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImagePath(String imgData) {
        InputStream inputStream = null;
        try {
            inputStream = this.getImgDataStream(imgData);
            if (null == inputStream) {
                this.image = null;
                return;
            }
            this.image = ImageIO.read(inputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.image == null) {
            return;
        }
        this.setImgWidth(this.image.getWidth((ImageObserver)((Object)this)));
        this.setImgHeight(this.image.getHeight((ImageObserver)((Object)this)));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image, 0, 0, this.getBounds().width, this.getBounds().height, (ImageObserver)((Object)this));
    }

    public void paint(Graphics g) {
        super.paint(g);
        Rectangle bounds = this.getBounds();
        Insets insets = this.getInsets();
        int x0 = insets.left;
        int x1 = bounds.width - 1 - insets.right;
        int y1 = bounds.height - 1 - insets.bottom;
        int y0 = insets.top;
        Color color = UIManager.getColor("Label.underlineColor");
        g.setColor(color);
        g.drawLine(x0, y1, x1, y1);
        g.drawLine(x0, y0, x0, y1);
        g.drawLine(x0, y0, x1, y0);
        g.drawLine(x1, y0, x1, y1);
    }
}

