/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.client.layout.Table;

import com.kingdee.eas.base.form.client.layout.Table.ACell;
import com.kingdee.eas.base.form.client.layout.Table.Cell;
import com.kingdee.eas.base.form.client.layout.Table.ICellContent;
import com.kingdee.eas.base.form.client.layout.Table.SizeAdjustor;
import com.kingdee.eas.base.form.client.layout.Table.Style;
import com.kingdee.eas.base.form.client.layout.Table.TableInfo;
import java.awt.Dimension;

public class Table
extends ACell
implements ICellContent {
    protected int _cols;
    protected int _rows;
    protected Style _defaultStyle = new Style();
    protected TableInfo _colX;
    protected TableInfo _rowY;
    protected Cell[][] _aaCell;
    private boolean _isBounds = false;

    public Table(int rows, int cols) {
        this._cols = cols;
        this._rows = rows;
        this._colX = new TableInfo(true, this);
        this._rowY = new TableInfo(false, this);
        this._aaCell = new Cell[this._rows][this._cols];
    }

    public final int getColCount() {
        return this._cols;
    }

    public final int getRowCount() {
        return this._rows;
    }

    public final Style defaultStyle() {
        return this._defaultStyle;
    }

    public final Style getColStyle(int col) {
        return this._colX._aStyle[col];
    }

    public final void setColStyle(int col, Style style) {
        this._colX._aStyle[col] = style;
    }

    public final Style colStyle(int col) {
        if (this._colX._aStyle[col] == null) {
            this._colX._aStyle[col] = new Style();
        }
        return this._colX._aStyle[col];
    }

    public final Style getRowStyle(int row) {
        return this._rowY._aStyle[row];
    }

    public final void setRowStyle(int row, Style style) {
        this._rowY._aStyle[row] = style;
    }

    public final Style rowStyle(int row) {
        if (this._rowY._aStyle[row] == null) {
            this._rowY._aStyle[row] = new Style();
        }
        return this._rowY._aStyle[row];
    }

    public final Cell cell(int row, int col) {
        Cell cell = this._aaCell[row][col];
        if (cell == null) {
            this._aaCell[row][col] = cell = new Cell(row, col);
        }
        return cell;
    }

    public final Cell cell(int index) {
        return this.cell(index / this._cols, index % this._cols);
    }

    public void setCellContent(Cell cell, ICellContent content) {
        cell.setContent(content);
    }

    public boolean removeCellByContent(Object obj) {
        for (int row = 0; row < this._rows; ++row) {
            for (int col = 0; col < this._cols; ++col) {
                Cell cell = this._aaCell[row][col];
                if (cell == null) continue;
                if (cell._isSubTable) {
                    if (!((Table)cell._content).removeCellByContent(obj)) continue;
                    return true;
                }
                if (cell._content == null || !cell._content.hasObject(obj)) continue;
                this._aaCell[row][col] = null;
                return true;
            }
        }
        return false;
    }

    public SizeAdjustor getAdjustorX() {
        return this._colX._adjustor;
    }

    public SizeAdjustor getAdjustorY() {
        return this._rowY._adjustor;
    }

    protected final boolean fitSpace(int width, int height) {
        super.initOutStyle();
        if (!this._outStyle.isVisible()) {
            return true;
        }
        boolean isAdjusted = true;
        this._colX.makeOutInfo();
        this._rowY.makeOutInfo();
        SizeAdjustor adjustorX = this._colX._adjustor;
        SizeAdjustor adjustorY = this._rowY._adjustor;
        for (int row = 0; row < this._rows; ++row) {
            for (int col = 0; col < this._cols; ++col) {
                Cell cell = this._aaCell[row][col];
                if (cell == null) continue;
                cell.makeOutStyle(this._colX._aStyle[col], this._rowY._aStyle[row], this._defaultStyle);
                if (cell._outStyle.isVisible()) {
                    if (!cell.makeOutStyleByContent()) {
                        isAdjusted = false;
                    }
                    adjustorX.getInfoAt(col).makeMax(cell._outStyle._x);
                    adjustorY.getInfoAt(row).makeMax(cell._outStyle._y);
                    continue;
                }
                cell.hideContent();
            }
        }
        if (!this._colX.fitSpace(width)) {
            isAdjusted = false;
        }
        if (!this._rowY.fitSpace(height)) {
            isAdjusted = false;
        }
        return isAdjusted;
    }

    private void readjustSubTable(int width, int height) {
        if (!this._outStyle.isVisible()) {
            return;
        }
        this._colX.readjustSpace(width);
        this._rowY.readjustSpace(height);
        for (int row = 0; row < this._rows; ++row) {
            for (int col = 0; col < this._cols; ++col) {
                Cell cell = this._aaCell[row][col];
                if (cell == null || !cell._outStyle.isVisible() || !cell._isSubTable) continue;
                Style outStyle = cell._outStyle;
                ((Table)cell._content).readjustSubTable(this._colX._adjustor.getOutAt(col) - outStyle.getMarginLeft() - outStyle.getMarginRight(), this._rowY._adjustor.getOutAt(row) - outStyle.getMarginTop() - outStyle.getMarginBottom());
            }
        }
    }

    public void layout(int left, int top) {
        if (!this._outStyle.isVisible()) {
            this.hide();
            return;
        }
        SizeAdjustor adjustorX = this._colX._adjustor;
        SizeAdjustor adjustorY = this._rowY._adjustor;
        this._left = left;
        this._top = top;
        this._width = adjustorX.getTotal();
        this._height = adjustorY.getTotal();
        if (this._style != null) {
            this._left += this._style.getMarginLeft();
            this._top += this._style.getMarginTop();
        }
        int y = this._top;
        for (int row = 0; row < this._rows; ++row) {
            int cy = adjustorY.getOutAt(row);
            int x = this._left;
            for (int col = 0; col < this._cols; ++col) {
                int cx = adjustorX.getOutAt(col);
                Cell cell = this._aaCell[row][col];
                if (cell != null) {
                    cell.setBounds(x, y, cx, cy);
                }
                x += cx;
            }
            y += cy;
        }
    }

    public void hide() {
        for (int row = 0; row < this._rows; ++row) {
            for (int col = 0; col < this._cols; ++col) {
                Cell cell = this._aaCell[row][col];
                if (cell == null) continue;
                cell.hideContent();
            }
        }
    }

    private void checkBounds() {
        if (!this._isBounds) {
            this.fitSpace(-1, -1);
            this._isBounds = true;
        }
    }

    @Override
    public Dimension getMaximumSize() {
        this.checkBounds();
        return new Dimension(this._colX._adjustor.getTotalMax(), this._rowY._adjustor.getTotalMax());
    }

    @Override
    public Dimension getMinimumSize() {
        this.checkBounds();
        return new Dimension(this._colX._adjustor.getTotalMin(), this._rowY._adjustor.getTotalMin());
    }

    @Override
    public Dimension getPreferredSize() {
        this.checkBounds();
        return new Dimension(this._colX._adjustor.getTotal(), this._rowY._adjustor.getTotal());
    }

    @Override
    public void setBounds(int left, int top, int width, int height) {
        if (!this.fitSpace(width, height)) {
            this.readjustSubTable(width, height);
        }
        this.layout(0, 0);
        this._isBounds = true;
    }

    @Override
    public boolean hasObject(Object obj) {
        return false;
    }

    public String toString() {
        int cy;
        int row;
        int cx;
        int col;
        StringBuffer s = new StringBuffer();
        SizeAdjustor adjustorX = this._colX._adjustor;
        SizeAdjustor adjustorY = this._rowY._adjustor;
        s.append("<X>");
        int x = 0;
        for (col = 0; col < this._cols; ++col) {
            cx = adjustorX.getOutAt(col);
            s.append(", [" + col + "]=" + (x += cx));
        }
        s.append("</X>\r\n<Y>");
        int y = 0;
        for (row = 0; row < this._rows; ++row) {
            cy = adjustorY.getOutAt(row);
            s.append(", [" + row + "]=" + (y += cy));
        }
        s.append("</Y>\r\n<Cells>");
        y = 0;
        for (row = 0; row < this._rows; ++row) {
            cy = adjustorY.getOutAt(row);
            x = 0;
            for (col = 0; col < this._cols; ++col) {
                cx = adjustorX.getOutAt(col);
                Cell cell = this._aaCell[row][col];
                s.append("\r\n[" + row + "][" + col + "] ");
                if (cell != null) {
                    s.append("<Cell>" + cell.toString() + "\r\n</Cell>\r\n");
                }
                x += cx;
            }
            y += cy;
        }
        s.append("\r\n</Cells>");
        return (this._style != null ? "<Style>" + this._style + "</Style>" : "") + "\r\n<DefaultStyle>" + this._defaultStyle + "</DefaultStyle>\r\n\r\n<TableX>\r\n" + this._colX.toString() + "\r\n</TableX>\r\n\r\n<TableY>\r\n" + this._rowY.toString() + "\r\n</TableY>\r\n\r\n" + s.toString();
    }
}

