/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Timestamp;

public class BasImgHelper
implements Serializable {
    private static final long serialVersionUID = -5673180173333325731L;
    private String fieldKey;
    private String formID;
    private String bosType;
    private String imgFile;
    private String desc;
    private UserInfo creater;
    private Timestamp createTime;
    private Timestamp lastUpdateTime;
    private UserInfo lastUpdateUser;
    private CtrlUnitInfo ctrlUint;
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String FILEPATH = StringUtils.isEmpty((String)USER_HOME) ? "C:" + File.separator + "tmp" + File.separator + "file" : USER_HOME + File.separator + "tmp" + File.separator + "file";
    public static final String FILE_NOT_FOUND = "file_not_found";
    public static final String FILE_TOO_BIG = "file_too_big";
    public static final String SAVE_SUCC = "save_succ";
    public static final String SAVE_FAIL = "save_fail";
    public static final String DEL_ALL = "del_all";
    public static final String DEL_SOME = "del_some";

    public String getFieldKey() {
        return this.fieldKey;
    }

    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    public String getFormID() {
        return this.formID;
    }

    public void setFormID(String formID) {
        this.formID = formID == null ? "" : formID.replace(" ", "+");
    }

    public String getBosType() {
        return this.bosType;
    }

    public void setBosType(String bosType) {
        this.bosType = bosType == null ? "" : bosType.replace(" ", "+");
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public UserInfo getCreater() {
        return this.creater;
    }

    public void setCreater(UserInfo creater) {
        this.creater = creater;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Timestamp createTime) {
        this.createTime = createTime;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public UserInfo getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(UserInfo lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public CtrlUnitInfo getCtrlUint() {
        return this.ctrlUint;
    }

    public void setCtrlUint(CtrlUnitInfo ctrlUint) {
        this.ctrlUint = ctrlUint;
    }

    public String getImgFile() {
        return this.imgFile;
    }

    public void setImgFile(String imgFile) {
        this.imgFile = imgFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImgString() {
        if (!StringUtils.isEmpty((String)this.imgFile)) {
            return this.imgFile;
        }
        InputStream in = null;
        try {
            in = this.getImgStream();
            byte[] bytes = BasImgHelper.input2byte(in);
            this.setImgFile(StringUtils.byteArrayToString((byte[])bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.imgFile;
    }

    public String setImgStream2String(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] bytes = BasImgHelper.input2byte(inputStream);
            this.setImgFile(StringUtils.byteArrayToString((byte[])bytes));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.imgFile;
    }

    public InputStream getImgStreamFromString() {
        if (StringUtils.isEmpty((String)this.imgFile)) {
            return null;
        }
        byte[] fieldValueByteArray = StringUtils.hexFromString((String)this.imgFile);
        ByteArrayInputStream bis = new ByteArrayInputStream(fieldValueByteArray);
        return bis;
    }

    public InputStream getImgStream() throws FileNotFoundException {
        String fileName = this.getFileName();
        if (fileName == null) {
            return null;
        }
        FileInputStream imgData = null;
        if (BasImgHelper.existFile(FILEPATH, fileName)) {
            imgData = new FileInputStream(fileName);
        }
        return imgData;
    }

    public String setTmpImg(InputStream inputStream) {
        try {
            if (inputStream.available() > 0x600000) {
                return FILE_TOO_BIG;
            }
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] b = new byte[10240];
            while (inputStream.read(b, 0, 10240) != -1) {
                swapStream.write(b);
            }
            swapStream.flush();
            byte[] bytes = swapStream.toByteArray();
            this.setImgFile(StringUtils.byteArrayToString((byte[])bytes));
            swapStream.close();
            inputStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return SAVE_FAIL;
        }
        return SAVE_SUCC;
    }

    public String getFileName() {
        if (StringUtils.isEmpty((String)this.getFormID()) || StringUtils.isEmpty((String)this.getFieldKey())) {
            return null;
        }
        String formIDs = this.getFormID().replace("/", "_").replace("\\", "_").replace("+", "_").replace("=", "");
        return FILEPATH + File.separator + formIDs + "_" + this.fieldKey + ".gif";
    }

    public static boolean existFile(String filePath, String fileName) {
        File f = new File(filePath);
        File f1 = new File(fileName);
        if (!f.exists()) {
            f.mkdirs();
            return false;
        }
        return f1.exists();
    }

    public static void deleteImagFile(String formID, String fieldKey, String delType) {
        try {
            File f = new File(FILEPATH);
            formID = formID.replace("/", "_").replace("\\", "_").replace("+", "_").replace("=", "");
            String fileName = formID + "_" + (fieldKey == null ? "" : fieldKey);
            if (!f.exists()) {
                return;
            }
            File[] fa = f.listFiles();
            if (DEL_ALL.equals(delType)) {
                for (int i = 0; i < fa.length; ++i) {
                    File fs = fa[i];
                    if (fs.isDirectory()) continue;
                    fs.delete();
                }
            } else {
                for (int i = 0; i < fa.length; ++i) {
                    File fs = fa[i];
                    if (fs.isDirectory() || fs.getPath().indexOf(fileName) <= 0) continue;
                    fs.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[10240];
        int rc = 0;
        if (inStream != null) {
            while ((rc = inStream.read(buff, 0, 10240)) > 0) {
                swapStream.write(buff, 0, rc);
            }
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }
}

