/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.IFormServer;
import com.kingdee.eas.base.form.metadata.ElementTypes;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.FormElement;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormFactory {
    private static final Log log = LogFactory.getLog(FormFactory.class);
    private static IFormServer formSever;
    public static final String Form_SERVER_CLASS_TYPE = "com.kingdee.eas.base.form.core.app.DefaultFormServer";

    private static IFormServer getFormServerInstance(Context ctx) {
        block2: {
            try {
                formSever = ctx == null ? (IFormServer)BOSObjectFactory.createRemoteBOSObject((String)Form_SERVER_CLASS_TYPE, IFormServer.class) : (IFormServer)BOSObjectFactory.getLocalBOSObjectFactory((Context)ctx).createBOSObject(Form_SERVER_CLASS_TYPE);
            }
            catch (BOSException bosex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("getFormServerInstance:" + bosex.getMessage()));
            }
        }
        return formSever;
    }

    public static FormMetaData createFormMetaData(BOSObjectType bosType, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            return formServer.getFormMetaData(bosType);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FormMetaData createFormMetaData(String formID, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            return formServer.getFormMetaData(formID);
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FormMetaData createFormMetaData(String formID, IRowSet formRs, Context ctx) throws BOSException {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        return formServer.getFormMetaData(formID, formRs);
    }

    public static FormMetaData createFormMetaData(Context ctx, ElementTypes types, String formID) throws BOSException {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        return formServer.getFormMetaData(types, formID);
    }

    public static List getFormElementList(int elementTypeID, Context ctx) throws BOSException, SQLException {
        ArrayList<FormElement> formList = new ArrayList<FormElement>();
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        ResultSet rs = formServer.getFormList(elementTypeID);
        while (rs.next()) {
            FormElement oneForm = new FormElement(rs.getString("FID"), rs.getString("FName_L1"), rs.getString("FName_L2"), rs.getString("FName_L3"), rs.getInt("FElementTypeID"));
            formList.add(oneForm);
        }
        return formList;
    }

    public static IObjectValue getBillData(String pk, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            return formServer.getBillObjectValue(pk);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateBillData(String pk, IObjectValue obj, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            formServer.updateBillObjectValue(pk, obj);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void insertBarItem2Db(Map param, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            formServer.insertBarItem(param);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void insertBarTemplate2Db(Map param, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            formServer.insertBarTemplate(param);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static Map getBarData(String formID, Integer menuType, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        Map result = null;
        try {
            result = formServer.getBarData(formID, menuType);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ResultSet getAssistantData(String dataType, String cu, String longNumber, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        ResultSet result = null;
        try {
            result = formServer.getAssistantData(dataType, cu, longNumber);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ResultSet getAssistantData(String dataType, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        ResultSet result = null;
        try {
            result = formServer.getAssistantData(dataType);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getAssistantDataVersion(String dataType, String cu, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        String result = null;
        try {
            result = formServer.getAssistantDataVersion(dataType, cu);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getAssistantDataDesc(String ids, Context ctx) {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        String result = null;
        try {
            result = formServer.getAssistantDataDesc(ids);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map getDataForDeploySetting(Context ctx, Map param) throws BOSException {
        Map result = null;
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            result = formServer.getDataForDeploySetting(param);
        }
        catch (BOSException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static Map getDataForDeployPackage(Context ctx, Map param) throws BOSException {
        Map result = null;
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        try {
            result = formServer.getDataForDeployPackage(param);
        }
        catch (BOSException e) {
            log.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static EnumObject getEnumObject(Context ctx, int enumId) throws BOSException {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        EnumObject enumObject = formServer.getEnumObject(enumId);
        return enumObject;
    }

    public static List getFtpServerList(Context ctx) throws BOSException {
        IFormServer formServer = FormFactory.getFormServerInstance(ctx);
        List ftpServerList = formServer.getFtpServerList();
        return ftpServerList;
    }
}

