/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.event.adapter.DyanmicBillEventDefineService;
import com.kingdee.bos.event.adapter.SourceEventInfo;
import com.kingdee.bos.event.adapter.SourceFormalParameterInfo;
import com.kingdee.bos.event.exception.EventRepositoryException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.IMetadataStore;
import com.kingdee.bos.metadata.configure.MetadataStoreFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.util.CloneUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.form.core.app.FormDBUtils;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormMetaData;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MetaDataHelper {
    public static List createParamArray(List idList, int n) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] obj = new Object[n];
        int index = 0;
        for (int i = 0; idList != null && i < idList.size(); ++i) {
            obj[index] = idList.get(i);
            if (++index != n) continue;
            paramList.add(obj);
            obj = new Object[n];
            index = 0;
        }
        if (index != 0 && index < n) {
            while (index != 0 && index < n) {
                obj[index] = new Integer(-1);
                ++index;
            }
            paramList.add(obj);
        }
        return paramList;
    }

    public static String getMarks(int n) {
        String result = "";
        for (int i = 0; i < n; ++i) {
            result = i == 0 ? "( ? " : result + ", ?";
        }
        if (n > 0) {
            result = result + ")";
        }
        return result;
    }

    public static void createDynamicFields(Context ctx, BusinessInfo businessInfo, LayoutInfo layoutInfo, Field[] fields) throws Exception {
        if (fields == null || fields.length == 0) {
            return;
        }
        HashSet<EntityObjectInfo> updateSet = new HashSet<EntityObjectInfo>();
        HashMap<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>();
        for (int i = 0; i < fields.length; ++i) {
            PropertyInfo thisProp;
            Field field = fields[i];
            Entity entity = businessInfo.getEntity(field.getEntityKey());
            String clientBosType = entity.getBosType();
            EntityObjectInfo mainEO = (EntityObjectInfo)entityMap.get(entity.getKey());
            if (mainEO == null) {
                mainEO = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)clientBosType));
                entityMap.put(entity.getKey(), mainEO);
            }
            if ((thisProp = MetaDataHelper.createPropertyInfo(ctx, mainEO, businessInfo, field)) == null) continue;
            if (field.getFieldName() != null) {
                ColumnInfo column = mainEO.getTable().getColumnByName(field.getFieldName());
                if (column != null) {
                    thisProp.setMappingField(column);
                } else {
                    throw new ActionCommonException(null, "\u52a8\u6001\u589e\u52a0\u7684\u5c5e\u6027\u5bf9\u5e94\u7684\u5b57\u6bb5" + field.getFieldName() + "\u4e0d\u5b58\u5728");
                }
            }
            mainEO.getProperties().add(thisProp);
            updateSet.add(mainEO);
        }
        EntityObjectInfo clone = null;
        Iterator iter = updateSet.iterator();
        IMetadataStore mds = MetadataStoreFactory.getMetadataStore((Context)ctx);
        while (iter.hasNext()) {
            EntityObjectInfo entity = (EntityObjectInfo)iter.next();
            clone = CloneUtils.clone((EntityObjectInfo)entity);
            mds.updateEntity(clone);
        }
    }

    public static PropertyInfo createPropertyInfo(Context ctx, EntityObjectInfo mainEO, BusinessInfo businessInfo, Field field) {
        DataType dataType = DataMappingUtil.getDataTypeForElementType(field.getElementType());
        if (dataType == null || field.getPropertyName() == null) {
            return null;
        }
        OwnPropertyInfo thisProp = null;
        if (dataType.equals((Object)DataType.OBJECTVALUE)) {
            LookUpObject lookupObj = businessInfo.getLookUpObject(field.getLookUpObjectID());
            if (lookupObj == null || lookupObj.getBosType() == null) {
                return null;
            }
            String supplierBosType = lookupObj.getBosType();
            LinkPropertyInfo property = new LinkPropertyInfo();
            RelationshipInfo relation = new RelationshipInfo();
            relation.setType(RelationshipType.ASSOCIATION);
            relation.setPackage(mainEO.getPackage());
            String supplierEntity = lookupObj.getBusinessImplName().substring(lookupObj.getBusinessImplName().lastIndexOf(46));
            relation.setName("R_" + mainEO.getName() + "_" + supplierEntity + "_" + field.getPropertyName());
            relation.setClientObject(mainEO);
            EntityObjectInfo supplierEO = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)supplierBosType));
            relation.setSupplierObject(supplierEO);
            relation.setClientCardinality(CardinalityType.ZERO_TO_UNBOUNDED);
            if (field.isMustInput()) {
                relation.setSupplierCardinality(CardinalityType.ONE);
            } else {
                relation.setSupplierCardinality(CardinalityType.ZERO_TO_ONE);
            }
            property.setRelationship(relation);
            thisProp = property;
        } else {
            EnumObject enumInfo;
            OwnPropertyInfo property = new OwnPropertyInfo();
            property.setDataType(dataType);
            property.setMultilingual(field.isMulLanguage());
            if (field.getEnumType() > 0 && (enumInfo = businessInfo.getEnumInfo().get(String.valueOf(field.getEnumType()))) != null) {
                property.setMetadataRef(enumInfo.getEnumClassName());
            }
            thisProp = property;
        }
        thisProp.setConfigured(true);
        thisProp.setName(field.getPropertyName());
        return thisProp;
    }

    public static String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            return entity.getName();
        }
        return alias;
    }

    public static EntityObjectInfo getEntity(IMetaDataPK entityPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(entityPK);
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    public static String getPropertyAlias(PropertyInfo propertyInfo) {
        String alias = propertyInfo.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            alias = propertyInfo.getName();
        }
        return alias;
    }

    public static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    public static void updateEventDef(Context ctx, FormMetaData billMetaData) throws BOSException {
        DyanmicBillEventDefineService srv = new DyanmicBillEventDefineService();
        SourceEventInfo eventInfo = new SourceEventInfo();
        String bosType = billMetaData.getBusinessInfo().getForm().getBosType();
        if (bosType == null || bosType.trim().length() == 0) {
            return;
        }
        EntityObjectInfo mainEO = BusinessProcessUtil.getEntityInfo((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        eventInfo.setEntityName(mainEO.getFullName());
        eventInfo.setBosType(bosType);
        eventInfo.setOperationName("Submit");
        eventInfo.setEventAlias(billMetaData.getBusinessInfo().getForm().getName_L2() + "\u8868\u5355\u63d0\u4ea4\u4e8b\u4ef6");
        ArrayList<SourceFormalParameterInfo> srourceFormalParameterInfos = new ArrayList<SourceFormalParameterInfo>();
        srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter("billID", "\u5355\u636eID", 0, "java.lang.String", true));
        srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter("formID", "\u8868\u5355ID", 1, "java.lang.String", true));
        srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter("billName", "\u5355\u636e\u540d\u79f0", 2, "java.lang.String", false));
        srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter("billNo", "\u5355\u636e\u7f16\u53f7", 3, "java.lang.String", false));
        int index = 4;
        List fields = billMetaData.getLayoutInfo().getFieldAppearances();
        Iterator iter = fields.iterator();
        ArrayList<String> keys = new ArrayList<String>();
        while (iter.hasNext()) {
            FieldAppearance field = (FieldAppearance)iter.next();
            if (!field.isIssueEvent()) continue;
            srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter(field, index++));
            keys.add(field.getKey());
            if (!MetaDataHelper.isDataBase(field)) continue;
            String key = null;
            key = field.getElementType() == 30 ? field.getKey() + ".dataValue" : field.getKey() + ".name";
            srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter(field.getElementType() == 30 ? field.getKey() + "_dataValue" : field.getKey() + "_name", field.getCaption() + "\u540d\u79f0", index++, "java.lang.String", false));
            keys.add(key);
            key = field.getKey() + ".number";
            srourceFormalParameterInfos.add(MetaDataHelper.createAFormalParameter(field.getKey() + "_number", field.getCaption() + "\u7f16\u7801", index++, "java.lang.String", false));
            keys.add(key);
        }
        eventInfo.setSrourceFormalParameterInfos(srourceFormalParameterInfos);
        try {
            srv.saveEventDef(eventInfo, "com.kingdee.bos.event.producer.DynamicBillEventProducer", "com.kingdee.bos.event.adapter.DyanmicBillEventMappingRule");
        }
        catch (EventRepositoryException e) {
            throw new BOSException((Throwable)e);
        }
        List[] updates = new List[]{new ArrayList(), new ArrayList()};
        String[][] params = billMetaData.getBusinessInfo().getForm().getEventParams();
        if (keys.size() == 0) {
            return;
        }
        updates[1] = keys;
        FormDBUtils.updateFormEventParams((String)billMetaData.getBusinessInfo().getForm().getId(), (Context)ctx, (List)updates[0], (List)updates[1]);
        if (updates[0].size() > 0 || updates[1].size() > 0) {
            billMetaData.getBusinessInfo().getForm().setEventParams(FormDBUtils.getFormEventParams((String)billMetaData.getBusinessInfo().getForm().getId(), (Context)ctx));
        }
    }

    private static boolean isDataBase(FieldAppearance field) {
        return DataMappingUtil.isDataBase(field.getElementType());
    }

    private static SourceFormalParameterInfo createAFormalParameter(FieldAppearance field, int index) {
        int elementType = field.getElementType();
        DataType dataType = DataMappingUtil.getDataTypeForElementType(elementType);
        String javaTypeName = null;
        javaTypeName = dataType.equals((Object)DataType.STRING) || dataType.equals((Object)DataType.OBJECTVALUE) || dataType.equals((Object)DataType.OBJECTVALUE) || dataType.equals((Object)DataType.ENUM) ? "java.lang.String" : (dataType.equals((Object)DataType.TIMESTAMP) ? "java.sql.TimeStamp" : (dataType.equals((Object)DataType.BYTEARRAY) ? "java.lang.Byte[]" : DataMappingUtil.getJavaTypeClassName(dataType)));
        return MetaDataHelper.createAFormalParameter(field.getKey(), field.getCaption(), index, javaTypeName, dataType.equals((Object)DataType.OBJECTVALUE));
    }

    private static SourceFormalParameterInfo createAFormalParameter(String key, String alias, int index, String javaTypeName, boolean isPk) {
        SourceFormalParameterInfo formalParameterInfo = new SourceFormalParameterInfo();
        formalParameterInfo.setFormalParameterName(key);
        formalParameterInfo.setFormalParameterType(javaTypeName);
        formalParameterInfo.setFormalParameterMappingName(javaTypeName);
        formalParameterInfo.setPK(isPk);
        formalParameterInfo.setActualParameterIndex(String.valueOf(index));
        formalParameterInfo.setFormalParameterNameAlias(alias);
        formalParameterInfo.setDescription(alias);
        return formalParameterInfo;
    }
}

