/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.core.UserDefinedData.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.form.core.UserDefinedData.UserDefinedDataCollection;
import com.kingdee.eas.base.form.core.UserDefinedData.UserDefinedDataInfo;
import com.kingdee.eas.base.form.core.UserDefinedData.Utils.DBUtil;
import com.kingdee.eas.base.form.core.UserDefinedData.client.AbstractUserDefinedDataF7UI;
import com.kingdee.util.Assert;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class UserDefinedDataF7UI
extends AbstractUserDefinedDataF7UI {
    private static final Logger logger = CoreUIObject.getLogger(UserDefinedDataF7UI.class);
    private boolean isCancel = true;
    private String _subsystemID;
    private UserDefinedDataCollection _classifyDatas;
    private Map _Data_Node_Mapping = new HashMap();
    private DefaultKingdeeTreeNode _root;
    private UserDefinedDataInfo _SelectedData;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map context = this.getUIContext();
        Assert.that((context != null ? 1 : 0) != 0);
        Assert.that((boolean)context.containsKey("SubSystem"));
        this._subsystemID = (String)context.get("SubSystem");
        this.LoadData();
        this.DisplayData();
    }

    private void LoadData() {
        try {
            this._classifyDatas = DBUtil.load_ClassifyUsedDatasBySubsystemid(null, this._subsystemID);
        }
        catch (BOSException e) {
            e.printStackTrace();
            logger.debug((Object)"\u6570\u636e\u52a0\u8f7d\u51fa\u9519", (Throwable)e);
        }
    }

    private void DisplayData() {
        this._root = new DefaultKingdeeTreeNode((Object)"\u8f85\u52a9\u8d44\u6599");
        this.kDTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this._root));
        int size = this._classifyDatas.size();
        for (int i = 0; i < size; ++i) {
            UserDefinedDataInfo item = this._classifyDatas.get(i);
            this.addTreeNodeWithUserData(item);
        }
        this.kDTree.setSelectionNode(this._root);
        this.kDTree.expandPath(this.kDTree.getSelectionPath());
    }

    private DefaultKingdeeTreeNode addTreeNodeWithUserData(UserDefinedDataInfo itemData) {
        DefaultKingdeeTreeNode parentNode;
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode((Object)itemData.getName());
        if (itemData.getParent() != null && this._Data_Node_Mapping.containsKey(itemData.getParent().getId().toString())) {
            parentNode = (DefaultKingdeeTreeNode)this._Data_Node_Mapping.get(itemData.getParent().getId().toString());
        } else {
            this._Data_Node_Mapping.put(itemData.getId().toString(), newNode);
            parentNode = this._root;
        }
        newNode.setUserObject((Object)itemData);
        this.kDTree.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, parentNode.getChildCount());
        return newNode;
    }

    private DefaultKingdeeTreeNode getSelectedTreeNode() {
        DefaultKingdeeTreeNode node = null;
        TreePath path = this.kDTree.getSelectionPath();
        if (path == null) {
            return node;
        }
        node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        return node;
    }

    private UserDefinedDataInfo getSelectedClassify(DefaultKingdeeTreeNode node) {
        UserDefinedDataInfo data = null;
        if (node == null) {
            node = this.getSelectedTreeNode();
        }
        if (node == null || node.getUserObject() == null || !(node.getUserObject() instanceof UserDefinedDataInfo)) {
            return data;
        }
        data = (UserDefinedDataInfo)node.getUserObject();
        return data;
    }

    @Override
    protected void kDTree_valueChanged(TreeSelectionEvent e) throws Exception {
        super.kDTree_valueChanged(e);
        DefaultKingdeeTreeNode node = this.getSelectedTreeNode();
        if (node != null && !node.equals(this._root) && node.getChildCount() == 0) {
            this.kdbtnOk.setEnabled(true);
        } else {
            this.kdbtnOk.setEnabled(false);
        }
    }

    @Override
    protected void kdbtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kdbtnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    @Override
    protected void kdbtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.kdbtnOk_actionPerformed(e);
        this.isCancel = false;
        this._SelectedData = this.getSelectedClassify(null);
        this.getUIWindow().close();
    }

    public UserDefinedDataInfo getResult() {
        return this._SelectedData;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

