/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.metadata;

import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.QueryInfo;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.model.BarTemplateManager;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class FormMetaData
implements Serializable,
Cloneable {
    private static final String version = "001";
    private String formId;
    protected HashMap layoutInfos = new HashMap();
    protected HashMap layoutInfoIDs = new HashMap();
    protected List layoutInfoList = new ArrayList();
    private BusinessInfo businessInfo = new BusinessInfo();
    private BarDataManager barDataModel = null;
    private BarTemplateManager barTemplateManager = null;
    private List _barKeysCache = new ArrayList();
    private QueryInfo queryInfo = null;
    private FormMetaData originFormMetaData = null;

    public synchronized QueryInfo getQueryInfo() {
        if (this.queryInfo == null) {
            this.queryInfo = new QueryInfo(this.businessInfo, this.getOrderedListTabFields(), this.getOrderedQKQueryTabFields(), this.getLayoutInfo());
        }
        return this.queryInfo;
    }

    public String getFormVersion() {
        return this.businessInfo.getForm().getVersion();
    }

    public BarDataManager getBarDataManager() {
        return this.barDataModel;
    }

    public void setBarDataManager(BarDataManager barDataModel) {
        this.barDataModel = barDataModel;
    }

    public BarTemplateManager getBarTemplateManager() {
        return this.barTemplateManager;
    }

    public void setBarTemplateManager(BarTemplateManager barTemplateManager) {
        this.barTemplateManager = barTemplateManager;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public LayoutInfo getLayoutInfo() {
        return (LayoutInfo)this.layoutInfoList.get(0);
    }

    public LayoutInfo getLayoutInfo(String key) {
        return (LayoutInfo)this.layoutInfos.get(key);
    }

    public LayoutInfo getLayoutInfobyID(String ID) {
        return (LayoutInfo)this.layoutInfoIDs.get(ID);
    }

    public void addLayoutInfo(LayoutInfo layoutInfo) {
        this.layoutInfos.put(layoutInfo.getKey(), layoutInfo);
        if (layoutInfo.getId() != null) {
            this.layoutInfoIDs.put(layoutInfo.getId(), layoutInfo);
        }
        this.layoutInfoList.add(layoutInfo);
    }

    public void removeLayoutInfo(String layoutKey) {
        String layoutID = null;
        if (this.layoutInfos.containsKey(layoutKey)) {
            layoutID = ((LayoutInfo)this.layoutInfos.get(layoutKey)).getId();
        }
        this.layoutInfos.remove(layoutKey);
        this.layoutInfoIDs.remove(layoutID);
        for (LayoutInfo layout : this.layoutInfoList) {
            if (!layout.getId().equals(layoutID)) continue;
            this.layoutInfoList.remove(layout);
            break;
        }
    }

    public BusinessInfo getBusinessInfo() {
        return this.businessInfo;
    }

    public List getLayoutInfos() {
        return this.layoutInfoList;
    }

    public Object clone() throws CloneNotSupportedException {
        String id = this.businessInfo.getForm().getId();
        FormMetaData cloneForm = new FormMetaData();
        cloneForm.setFormId("");
        for (LayoutInfo source : this.layoutInfoList) {
            LayoutInfo l = (LayoutInfo)source.clone();
            l.setKey(source.getKey());
            cloneForm.layoutInfoList.add(l);
            cloneForm.layoutInfos.put(l.getKey(), l);
        }
        cloneForm.layoutInfoIDs.clear();
        cloneForm.businessInfo = (BusinessInfo)this.businessInfo.clone();
        if (StringUtils.isEmpty((String)cloneForm.businessInfo.getForm().getTemplateID())) {
            cloneForm.businessInfo.getForm().setTemplateID(this.businessInfo.getForm().getId());
        }
        for (int i = 0; i < this._barKeysCache.size(); ++i) {
            String key = new String((String)this._barKeysCache.get(i));
            cloneForm._barKeysCache.add(key);
        }
        cloneForm.setBarDataManager(this.getBarDataManager());
        cloneForm.setBarTemplateManager(this.getBarTemplateManager());
        return cloneForm;
    }

    public List getOrderedListTabFields() {
        ArrayList result = new ArrayList();
        HashMap tmp = new HashMap();
        ArrayList<Integer> tmp1 = new ArrayList<Integer>();
        LayoutInfo defaultLayoutInfo = this.getLayoutInfo("_Default");
        for (Entity entity : this.businessInfo.getEntrys()) {
            for (Field field : entity.getFields()) {
                List<Field> tmpList;
                FieldAppearance fap = defaultLayoutInfo.getFieldAppearance(field.getKey());
                if (!fap.isListVisible()) continue;
                Integer listTabIndex = new Integer(field.getListTabIndex());
                if (tmp.containsKey(listTabIndex)) {
                    tmpList = (List)tmp.get(listTabIndex);
                    tmpList.add(field);
                    tmp.put(listTabIndex, tmpList);
                    continue;
                }
                tmpList = new ArrayList();
                tmpList.add(field);
                tmp.put(listTabIndex, tmpList);
                tmp1.add(listTabIndex);
            }
        }
        if (tmp1.size() == 1) {
            return this.getOrderedTabIndexFields();
        }
        Collections.sort(tmp1);
        for (int i = 0; i < tmp1.size(); ++i) {
            Integer listTabIndex = (Integer)tmp1.get(i);
            List tmpList = (List)tmp.get(listTabIndex);
            for (int j = 0; j < tmpList.size(); ++j) {
                result.add(tmpList.get(j));
            }
        }
        return result;
    }

    private List getOrderedTabIndexFields() {
        ArrayList result = new ArrayList();
        HashMap tmp = new HashMap();
        ArrayList<Integer> tmp1 = new ArrayList<Integer>();
        LayoutInfo defaultLayoutInfo = this.getLayoutInfo("_Default");
        for (Entity entity : this.businessInfo.getEntrys()) {
            EntityAppearance entityAp = defaultLayoutInfo.getEntityAppearance(entity.getKey());
            for (Field field : entity.getFields()) {
                List<Field> tmpList;
                FieldAppearance fap = defaultLayoutInfo.getFieldAppearance(field.getKey());
                if (!fap.isListVisible()) continue;
                Integer listTabIndex = new Integer(entityAp.getTabindex() * 1000 + fap.getTabindex());
                if (tmp.containsKey(listTabIndex)) {
                    tmpList = (List)tmp.get(listTabIndex);
                    tmpList.add(field);
                    tmp.put(listTabIndex, tmpList);
                    continue;
                }
                tmpList = new ArrayList();
                tmpList.add(field);
                tmp.put(listTabIndex, tmpList);
                tmp1.add(listTabIndex);
            }
        }
        Collections.sort(tmp1);
        for (int i = 0; i < tmp1.size(); ++i) {
            Integer listTabIndex = (Integer)tmp1.get(i);
            List tmpList = (List)tmp.get(listTabIndex);
            for (int j = 0; j < tmpList.size(); ++j) {
                result.add(tmpList.get(j));
            }
        }
        return result;
    }

    public List getOrderedQKQueryTabFields() {
        ArrayList result = new ArrayList();
        HashMap tmp = new HashMap();
        ArrayList<Integer> tmp1 = new ArrayList<Integer>();
        LayoutInfo defaultLayoutInfo = this.getLayoutInfo("_Default");
        for (Entity entity : this.businessInfo.getEntrys()) {
            for (Field field : entity.getFields()) {
                List<Field> tmpList;
                FieldAppearance fap = defaultLayoutInfo.getFieldAppearance(field.getKey());
                if (StringUtils.isEmpty((String)field.getFieldName()) || !fap.isQKQueryVisible()) continue;
                Integer filterTabIndex = new Integer(field.getQkQueryTabIndex());
                if (tmp.containsKey(filterTabIndex)) {
                    tmpList = (List)tmp.get(filterTabIndex);
                    tmpList.add(field);
                    tmp.put(filterTabIndex, tmpList);
                    continue;
                }
                tmpList = new ArrayList();
                tmpList.add(field);
                tmp.put(filterTabIndex, tmpList);
                tmp1.add(filterTabIndex);
            }
        }
        Collections.sort(tmp1);
        for (int i = 0; i < tmp1.size(); ++i) {
            Integer listTabIndex = (Integer)tmp1.get(i);
            List tmpList = (List)tmp.get(listTabIndex);
            for (int j = 0; j < tmpList.size(); ++j) {
                result.add(tmpList.get(j));
            }
        }
        return result;
    }

    public List getBarKeysCache() {
        return this._barKeysCache;
    }

    public static String getVersion() {
        return "201906";
    }

    public void createOriginMetaData() throws Exception {
        this.originFormMetaData = (FormMetaData)ObjectUtils.createCopy((Object)this);
    }

    public FormMetaData getOriginFormMetaData() {
        return this.originFormMetaData;
    }
}

