/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.eas.base.form.core.app.BarUtils;
import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.metadata.EnumBarItemStyle;
import com.kingdee.eas.base.form.model.BarEventsProxy;
import com.kingdee.eas.base.form.model.BarItemClickedEvent;
import com.kingdee.eas.base.form.model.BarItemEvent;
import com.kingdee.eas.base.form.model.BarItemLinkEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarDataManager
implements Serializable {
    private transient BarEventsProxy eventProxy = null;
    private Map allBarItems = new HashMap();
    private Map _removeBarItems = new HashMap();
    private Map topLevelBarItems = new HashMap();
    private String mainMenuName;
    private String statusBarName;
    private List _keysCache = null;

    public BarDataManager(List barKeysCache) {
        this._keysCache = barKeysCache;
    }

    public BarEventsProxy getEventProxy() {
        if (this.eventProxy == null) {
            this.eventProxy = new BarEventsProxy();
        }
        return this.eventProxy;
    }

    public void setEventProxy(BarEventsProxy eventProxy) {
        this.eventProxy = eventProxy;
    }

    public Map getAllBarItems() {
        return this.allBarItems;
    }

    public BarItem getBarItem(String name) {
        return (BarItem)this.allBarItems.get(name);
    }

    public Map getRemoveBarItems() {
        return this._removeBarItems;
    }

    public void setRemoveBarItems(Map removeBarItems) {
        this._removeBarItems = removeBarItems;
    }

    public void fireBarItemClicked(BarItemClickedEvent e) {
        this.eventProxy.getBarItemClickedProxy().fireBarItemClicked(e);
    }

    public BarItem createAndAddBarItem(String name, String caption_l2, String caption_l1, String caption_l3, String description_l2, String description_l1, String description_l3, String tooltip_l2, String tooltip_l1, String tooltip_l3, EnumBarItemStyle style, String imagekey, String shortcut, boolean enabled, boolean visible, boolean checked, boolean isBeginGroup, int elementType, int seq) {
        BarItem barItem = new BarItem(name, caption_l2, caption_l1, caption_l3, description_l2, description_l1, description_l3, tooltip_l2, tooltip_l1, tooltip_l3, style, imagekey, shortcut, enabled, visible, checked, isBeginGroup, elementType, seq);
        this.allBarItems.put(name, barItem);
        this._keysCache.add(name);
        if (this.eventProxy != null) {
            this.eventProxy.getModelEventProxy().fireBarItemAdded(new BarItemEvent(barItem));
        }
        return barItem;
    }

    public BarItem addBarItem(String name, String caption_l2, String caption_l1, String caption_l3, String desc_l2, String desc_l1, String desc_l3, EnumBarItemStyle style, String imagekey, String shortcut, boolean enabled, boolean visible, boolean checked, boolean isBeginGroup, int elementType, int seq) {
        return this.createAndAddBarItem(name, caption_l2, caption_l1, caption_l3, desc_l2, desc_l1, desc_l3, "", "", "", style, imagekey, shortcut, enabled, visible, checked, isBeginGroup, elementType, seq);
    }

    public BarItem addBarItem(String name, String caption_l2, String caption_l1, String caption_l3, String desc_l2, String desc_l1, String desc_l3, String tooltip_l2, String tooltip_l1, String tooltip_l3, EnumBarItemStyle style, String imagekey, String shortcut, boolean enabled, boolean visible, boolean checked, boolean isBeginGroup, int elementType, int seq) {
        BarItem barItem = null;
        switch (style.getValue()) {
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                barItem = this.addTopBar(name, caption_l2, caption_l1, caption_l3, style, elementType, seq);
                break;
            }
            case 1: {
                barItem = this.createAndAddBarItem(name, caption_l2, caption_l1, caption_l3, "", "", "", "", "", "", style, "", "", enabled, visible, false, false, elementType, seq);
                if (this.mainMenuName != null) break;
                this.addTopBar("Menu", "", "", "", EnumBarItemStyle.MainMenu, elementType, seq);
                break;
            }
            default: {
                barItem = this.createAndAddBarItem(name, caption_l2, caption_l1, caption_l3, desc_l2, desc_l1, desc_l3, tooltip_l2, tooltip_l1, tooltip_l3, style, imagekey, shortcut, enabled, visible, checked, isBeginGroup, elementType, seq);
            }
        }
        return barItem;
    }

    public BarItem addSubItem(String name, String caption_l2, String caption_l1, String caption_l3, EnumBarItemStyle style, boolean enabled, boolean visible, int elementType, int seq) {
        BarItem barItem = null;
        switch (style.getValue()) {
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                barItem = this.addTopBar(name, caption_l2, caption_l1, caption_l3, style, elementType, seq);
                break;
            }
            case 1: {
                barItem = this.addBarItem(name, caption_l2, caption_l1, caption_l3, "", "", "", "", "", "", style, "", "", enabled, visible, false, false, elementType, seq);
                if (this.mainMenuName == null) {
                    this.addTopBar("Menu", "", "", "", EnumBarItemStyle.MainMenu, elementType, seq);
                }
                this.addBarItemLink(this.mainMenuName, name);
                break;
            }
        }
        return barItem;
    }

    private BarItem getTopBarItem(EnumBarItemStyle style) {
        BarItem topItem = null;
        for (Map.Entry entry : this.topLevelBarItems.entrySet()) {
            BarItem item = (BarItem)entry.getValue();
            if (item.getStyle().getValue() != style.getValue()) continue;
            topItem = item;
            break;
        }
        return topItem;
    }

    public BarItem addTopBar(String name, String caption_l2, String caption_l1, String caption_l3, EnumBarItemStyle style, int elementType, int seq) {
        if (name == null || name.length() == 0) {
            // empty if block
        }
        BarItem subItem = null;
        switch (style.getValue()) {
            case 7: {
                subItem = this.getTopBarItem(style);
                this.mainMenuName = name;
                break;
            }
            case 10: {
                subItem = this.getTopBarItem(style);
                this.statusBarName = name;
            }
        }
        if (subItem == null) {
            subItem = this.createAndAddBarItem(name, caption_l2, caption_l1, caption_l3, caption_l2, caption_l1, caption_l3, caption_l2, caption_l1, caption_l3, style, "", "", true, true, false, false, elementType, seq);
        } else {
            subItem.setName(name);
            subItem.setCaption_L2(caption_l2);
            subItem.setCaption_L1(caption_l1);
            subItem.setCaption_L3(caption_l3);
        }
        this.topLevelBarItems.put(name, subItem);
        this.allBarItems.put(name, subItem);
        return subItem;
    }

    public boolean addBarItemLinks(String subItemName, String[] barItemNames) {
        BarItem subItem = (BarItem)this.allBarItems.get(subItemName);
        if (subItem != null) {
            return this.addBarItemLinks(subItemName, subItem.getChildrenSize(), barItemNames);
        }
        return false;
    }

    public Map getTopLevelBarItems() {
        return this.topLevelBarItems;
    }

    public boolean addBarItemLinks(String subItemName, int index, String[] barItemNames) {
        BarItem subItem = (BarItem)this.allBarItems.get(subItemName);
        if (subItem == null) {
            return false;
        }
        if (EnumBarItemStyle.BarButtonItem.equals(subItem.getStyle())) {
            subItem.setStyle(EnumBarItemStyle.BarSubItem);
        }
        if (index > subItem.getChildrenSize() || index < 0) {
            index = subItem.getChildrenSize();
        }
        this.addBarItemLinks(subItem, index, barItemNames);
        return true;
    }

    private boolean addBarItemLinks(BarItem parentBarItem, int index, String[] barItemNames) {
        for (int i = 0; i < barItemNames.length; ++i) {
            String itemName = barItemNames[i];
            BarItem barItem = (BarItem)this.allBarItems.get(itemName);
            if (barItem == null || parentBarItem.containChild(itemName)) continue;
            parentBarItem.addChildBarItem(index++, barItem);
            if (this.eventProxy == null) continue;
            this.eventProxy.getModelEventProxy().fireBarItemLinkAdded(new BarItemLinkEvent(parentBarItem, barItem));
        }
        return true;
    }

    public boolean addBarItemLinks(String subItemName, String posRefBarItemName, boolean after, String[] barItemNames) {
        int posRef;
        BarItem subItem = (BarItem)this.allBarItems.get(subItemName);
        if (subItem == null) {
            return false;
        }
        if (EnumBarItemStyle.BarButtonItem.equals(subItem.getStyle())) {
            subItem.setStyle(EnumBarItemStyle.BarSubItem);
        }
        if ((posRef = subItem.getChildIndex(posRefBarItemName)) != subItem.getChildrenSize()) {
            posRef = after ? posRef + 1 : posRef;
        }
        this.addBarItemLinks(subItem, posRef, barItemNames);
        return true;
    }

    public boolean addBarItemLink(String subItemName, String barItemName) {
        BarItem subItem = (BarItem)this.allBarItems.get(subItemName);
        if (subItem == null) {
            return false;
        }
        if (EnumBarItemStyle.BarButtonItem.equals(subItem.getStyle())) {
            subItem.setStyle(EnumBarItemStyle.BarSubItem);
        }
        int index = subItem.getChildrenSize();
        BarItem barItem = (BarItem)this.allBarItems.get(barItemName);
        if (barItem != null && !subItem.containChild(barItemName)) {
            subItem.addChildBarItem(index, barItem);
            if (this.eventProxy != null) {
                this.eventProxy.getModelEventProxy().fireBarItemLinkAdded(new BarItemLinkEvent(subItem, barItem));
            }
        }
        return true;
    }

    public void RemoveBarItem(BarItem barItem) {
        if (barItem == null) {
            return;
        }
        while (barItem.getChildrenSize() > 0) {
            BarItem item = (BarItem)barItem.getChildren().get(barItem.getChildrenSize() - 1);
            if (item.getChildrenSize() > 0) {
                this.RemoveBarItem(item);
            }
            this.RemoveBarItemLinks(barItem, item);
        }
        switch (barItem.getStyle().getValue()) {
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                while (barItem.getParent().size() > 0) {
                    BarItem parentBarItem = (BarItem)barItem.getParent().get(barItem.getParent().size() - 1);
                    this.RemoveBarItemLinks(parentBarItem, barItem);
                }
                break;
            }
        }
        this._removeBarItems.put(barItem.getName(), barItem);
        this.allBarItems.remove(barItem.getName());
        if (this.topLevelBarItems.containsKey(barItem.getName())) {
            this.topLevelBarItems.remove(barItem.getName());
        }
        this._keysCache.remove(barItem.getName());
        if (this.eventProxy != null) {
            this.eventProxy.getModelEventProxy().fireBarItemRemoved(new BarItemEvent(barItem));
        }
    }

    private boolean RemoveBarItemLinks(BarItem parentBarItem, BarItem childBarItem) {
        parentBarItem.removeChildBarItem(childBarItem);
        if (this.eventProxy != null) {
            this.eventProxy.getModelEventProxy().fireBarItemLinkRemoved(new BarItemLinkEvent(parentBarItem, childBarItem));
        }
        return true;
    }

    public static BarDataManager getBarBuilder4Test() throws Exception {
        BarDataManager barBuilder = new BarDataManager(null);
        int elementType = 9999;
        barBuilder.addSubItem("ToolBar", "\u5de5\u5177\u6761", "ToolBar", "\u5de5\u5177\u689d", EnumBarItemStyle.ToolBar, true, false, elementType, 0);
        barBuilder.addBarItem("mnuFileNew", "\u65b0\u5efa(&N)", "new(&N)", "\u65b0\u5efa(&N)", "", "", "", EnumBarItemStyle.BarButtonItem, "imgTbtn_new", "Ctrl+N", true, true, false, true, elementType, 0);
        barBuilder.addBarItem("mnuEditCopy", "\u590d\u5236", "Copy", "\u8907\u88fd", "\u590d\u5236", "Copy", "\u8907\u88fd", EnumBarItemStyle.BarButtonItem, "imgTbtn_copy", "Ctrl+A", true, true, false, false, elementType, 1);
        barBuilder.addBarItem("mnuEditModify", "\u4fee\u6539", "Modify", "\u4fee\u6539", "\u4fee\u6539", "Modify", "\u4fee\u6539", EnumBarItemStyle.BarButtonItem, "imgTbtn_edit", "Ctrl+E", true, true, false, false, elementType, 2);
        barBuilder.addBarItem("mnuEditDelRow", "\u5220\u9664", "Delete", "\u522a\u9664", "\u5220\u9664", "Delete", "\u522a\u9664", EnumBarItemStyle.BarButtonItem, "imgTbtn_deleteline", "Shift+Del", true, true, false, false, elementType, 3);
        barBuilder.addBarItem("mnuDataRefesh", "\u5237\u65b0", "refresh", "\u5237\u65b0", "\u5237\u65b0", "refresh", "\u5237\u65b0", EnumBarItemStyle.BarButtonItem, "imgTbtn_refresh", "F5", true, true, false, true, elementType, 4);
        barBuilder.addBarItem("mnuSubmit", "\u63d0\u4ea4", "commit", "\u63d0\u4ea4", "\u63d0\u4ea4", "commit", "\u63d0\u4ea4", EnumBarItemStyle.BarButtonItem, "", "", true, true, false, true, elementType, 5);
        barBuilder.addBarItem("mnuDiscard", "\u5e9f\u5f03", "cancel", "\u5e9f\u5f03", "\u5e9f\u5f03", "cancel", "\u5e9f\u5f03", EnumBarItemStyle.BarButtonItem, "", "", true, true, false, true, elementType, 6);
        barBuilder.addBarItemLinks("ToolBar", new String[]{"mnuFileNew", "mnuEditCopy", "mnuEditModify", "mnuEditDelRow", "mnuDataRefesh", "mnuSubmit", "mnuDiscard"});
        BarUtils.save2Db(null, (String)"f3936ca9-cbcb-440c-9bf3-ba00b29cb2dd", (String)"\u5e8f\u65f6\u7c3f\u5de5\u5177\u6761", (String)"\u5e8f\u65f6\u7c3f\u5de5\u5177\u6761", (String)"\u5e8f\u65f6\u7c3f\u5de5\u5177\u6761", (BarDataManager)barBuilder);
        return barBuilder;
    }
}

