/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.eas.base.form.metadata.BarItem;
import com.kingdee.eas.base.form.model.BarDataManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarTemplateManager
implements Serializable {
    private Map SubCategoryItems = new HashMap();
    private Map RemovedSubCategoryItems = new HashMap();
    private Map Mapping_TemplateID_BarDataManager = new HashMap();
    private Map RemovedMapping_TemplateID_BarDataManager = new HashMap();
    private List _keysCache = null;

    public BarTemplateManager(List barKeysCache) {
        this._keysCache = barKeysCache;
    }

    public Map getSubCategoryItems() {
        return this.SubCategoryItems;
    }

    public BarItem addSubCategory(String name, String caption_l2, String caption_l1, String caption_l3, String description_l2, String description_l1, String description_l3, int elementType, int seq) {
        BarItem barItem = new BarItem(name, caption_l2, caption_l1, caption_l3, description_l2, description_l1, description_l3, elementType, seq);
        this.SubCategoryItems.put(name, barItem);
        this._keysCache.add(name);
        return barItem;
    }

    public boolean addSubCategoryLink(String parentItemName, String subItemName) {
        BarItem parentItem = (BarItem)this.SubCategoryItems.get(parentItemName);
        if (parentItem == null) {
            return false;
        }
        BarItem subItem = (BarItem)this.SubCategoryItems.get(subItemName);
        if (subItem != null && !parentItem.containChild(subItemName)) {
            parentItem.addChildBarItem(parentItem.getChildrenSize(), subItem);
        } else if (subItem == null) {
            this.getBarDataManagerOfSubCategory(parentItem);
        }
        return true;
    }

    public BarDataManager getBarDataManagerOfSubCategory(BarItem parentSubCategory) {
        BarItem parentItem = (BarItem)this.SubCategoryItems.get(parentSubCategory.getName());
        if (parentItem == null) {
            return null;
        }
        BarDataManager barDataManagerOfSubCategory = null;
        if (parentItem.getBarDataManagerOfSubCategory() == null) {
            barDataManagerOfSubCategory = new BarDataManager(this._keysCache);
            parentItem.setBarDataManagerOfSubCategory(barDataManagerOfSubCategory);
            this.Mapping_TemplateID_BarDataManager.put(parentItem.getName(), barDataManagerOfSubCategory);
        } else {
            barDataManagerOfSubCategory = parentItem.getBarDataManagerOfSubCategory();
        }
        return barDataManagerOfSubCategory;
    }

    public void RemoveSubCategory(BarItem barItem) {
        if (barItem == null) {
            return;
        }
        while (barItem.getChildrenSize() > 0) {
            BarItem item = (BarItem)barItem.getChildren().get(barItem.getChildrenSize() - 1);
            if (item.getChildrenSize() > 0) {
                this.RemoveSubCategory(item);
            }
            this.RemoveSubCategoryLinks(barItem, item);
        }
        while (barItem.getParent().size() > 0) {
            BarItem parentBarItem = (BarItem)barItem.getParent().get(barItem.getParent().size() - 1);
            this.RemoveSubCategoryLinks(parentBarItem, barItem);
        }
        this.RemovedSubCategoryItems.put(barItem.getName(), barItem);
        this.SubCategoryItems.remove(barItem.getName());
        if (this.Mapping_TemplateID_BarDataManager.containsKey(barItem.getName())) {
            this.RemovedMapping_TemplateID_BarDataManager.put(barItem.getName(), this.Mapping_TemplateID_BarDataManager.get(barItem.getName()));
            this.Mapping_TemplateID_BarDataManager.remove(barItem.getName());
        }
        this._keysCache.remove(barItem.getName());
    }

    private boolean RemoveSubCategoryLinks(BarItem parentBarItem, BarItem childBarItem) {
        parentBarItem.removeChildBarItem(childBarItem);
        return true;
    }

    public Map getMapping_TemplateID_BarDataManager() {
        return this.Mapping_TemplateID_BarDataManager;
    }

    public Map getRemovedMapping_TemplateID_BarDataManager() {
        return this.RemovedMapping_TemplateID_BarDataManager;
    }

    public List getTopCategories() {
        ArrayList<BarItem> result = new ArrayList<BarItem>();
        for (Map.Entry entry : this.SubCategoryItems.entrySet()) {
            BarItem item = (BarItem)entry.getValue();
            if (item.getParent().size() != 0) continue;
            result.add(item);
        }
        Collections.sort(result, new intComparator());
        return result;
    }

    public class intComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            int i2;
            int i1 = ((BarItem)o1).getSeq();
            if (i1 > (i2 = ((BarItem)o2).getSeq())) {
                return 1;
            }
            if (i1 == i2) {
                return 0;
            }
            return -1;
        }
    }
}

