/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.TypeInfo;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.base.form.app.SQLBuilder;
import com.kingdee.eas.base.form.core.BusinessServiceFactory;
import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.QueryInfo;
import com.kingdee.eas.base.form.metadata.SelectField;
import com.kingdee.eas.base.form.model.DynamicFormApplication;
import com.kingdee.eas.base.form.util.DataMappingUtil;
import com.kingdee.eas.base.form.util.NewF7Utils;
import com.kingdee.eas.base.form.util.ResourceUtil;
import com.kingdee.eas.base.form.util.StringUtil;
import com.kingdee.eas.base.form.util.UnifiedEnumUtils;
import com.kingdee.eas.base.form.web.DynamicWebFormPanel;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.dynbusiness.util.DataConverter;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicFormPrintDataProvider
extends AbstractPrintDataProvider {
    private static final Logger logger = Logger.getLogger(DynamicFormPrintDataProvider.class);
    private QueryInfo queryInfo;
    private String[] billIds;
    private Context ctx;
    private BusinessInfo bizInfo;
    private LayoutInfo layoutInfo;
    public DynamicFormApplication application;
    private String sorter;

    public void setBillIds(String[] billIds) {
        if (this.isEmpty(billIds)) {
            return;
        }
        String id = billIds[0];
        ObjectUuidPK pk = new ObjectUuidPK(id);
        String bosType = this.bizInfo.getForm().getBosType();
        if (!bosType.equals(pk.getObjectType().toString())) {
            return;
        }
        this.billIds = billIds;
    }

    private boolean isEmpty(String[] billIds) {
        return billIds == null || billIds.length == 0;
    }

    public DynamicFormPrintDataProvider(Context ctx, QueryInfo queryInfo, BusinessInfo bizInfo, LayoutInfo layoutInfo) {
        this.ctx = ctx;
        this.queryInfo = queryInfo;
        this.bizInfo = bizInfo;
        this.layoutInfo = layoutInfo;
    }

    public DynamicFormPrintDataProvider(Context ctx, QueryInfo queryInfo, BusinessInfo bizInfo, LayoutInfo layoutInfo, DynamicFormApplication application) {
        this.ctx = ctx;
        this.queryInfo = queryInfo;
        this.bizInfo = bizInfo;
        this.layoutInfo = layoutInfo;
        this.application = application;
    }

    private String getMultiApproveSQL(boolean isHistory) {
        StringBuffer sb = new StringBuffer();
        String lang = "_" + ResourceUtil.getLanguage(this.ctx);
        sb.append("select a.factdefname").append(lang).append(" AS FActDefName,");
        sb.append("\r\n");
        sb.append("CASE WHEN b.fispass='true' THEN '").append("\u540c\u610f").append("' else '").append("\u4e0d\u540c\u610f").append("' END AS FApproveResult,");
        sb.append("\r\n");
        sb.append("b.fopinion").append(lang).append(" AS FOpinion,b.FhandlerContent AS FHandlerContent,");
        sb.append("\r\n");
        sb.append("a.FpersonEmpName").append(lang).append(" AS FPersonEmpName,d.FName").append(lang).append(" AS FPosition, e.FName").append(lang).append(" AS FCompany,");
        sb.append("\r\n");
        sb.append("CASE WHEN b.FlastUpdateTime is null THEN b.FcreateTime ELSE b.FlastUpdateTime END AS FApproveTime");
        sb.append("\r\n");
        if (isHistory) {
            sb.append("from t_bas_multiapprovehst ");
        } else {
            sb.append("from t_bas_multiapprove ");
        }
        sb.append(" b inner join ");
        if (isHistory) {
            sb.append("T_WFR_AssignHst");
        } else {
            sb.append("t_wfr_assigndetail");
        }
        sb.append(" a on a.fassignid=b.fassignmentid");
        sb.append("\r\n");
        sb.append("left outer join T_HR_PersonPosition c on a.FpersonEmpID=c.FPersonID");
        sb.append("\r\n");
        sb.append("left outer join T_ORG_Position d on d.FID=c.FprimaryPositionID");
        sb.append("\r\n");
        sb.append("left outer join T_ORG_Admin e on e.FID=d.FadminOrgUnitID");
        sb.append("\r\n");
        sb.append("WHERE (");
        sb.append(this.getBindMarkSql("b.FBillID", this.billIds.length));
        sb.append(")");
        return sb.toString();
    }

    private String getBindMarkSql(String key, int length) {
        StringBuffer condition = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                condition.append(" OR ");
                continue;
            }
            condition.append(key).append(" = ?");
        }
        return condition.toString();
    }

    private IRowSet getMultiApproveData() throws BOSException {
        if (this.isEmpty(this.billIds)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMultiApproveSQL(false));
        sb.append("\r\n");
        sb.append(" union all ");
        sb.append("\r\n");
        sb.append(this.getMultiApproveSQL(true));
        sb.append("\r\n");
        if (!StringUtils.isEmpty((String)this.sorter)) {
            sb.append(" order by " + this.sorter + " ");
        } else {
            sb.append(" order by FApproveTime desc");
        }
        String sql = sb.toString();
        Object[] newBillIds = new String[this.billIds.length * 2];
        System.arraycopy(this.billIds, 0, newBillIds, 0, this.billIds.length);
        System.arraycopy(this.billIds, 0, newBillIds, this.billIds.length, this.billIds.length);
        logger.info((Object)sql);
        if (newBillIds.length > 0) {
            logger.info((Object)("billID[0]======" + (String)newBillIds[0]));
        }
        return DBUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])newBillIds);
    }

    private IRowSet getSealCtrlData(String billid, String sealCtrlKey) throws BOSException {
        if (this.isEmpty(this.billIds)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select a.FSealPicture " + sealCtrlKey + " from T_STA_SealFile a , T_BAS_BillAttachmentE b , T_BAS_BillAttachment  c   where  a.fid = b.FRefSealID  and b.fhead=c.fid   and c.FBillId = ? and  b.FControlKey = ?");
        String sql = sb.toString();
        ArrayList mulDatas = new ArrayList();
        ArrayList mulDatasSelFld = new ArrayList();
        HashMap<String, TypeInfo> types = new HashMap<String, TypeInfo>();
        DataType dataType = DataMappingUtil.getDataTypeForElementType(1023);
        TypeInfo type = new TypeInfo(sealCtrlKey, sealCtrlKey, dataType, 0);
        types.put(type.getName().toUpperCase(), type);
        return this.handleMulDatabase(sql, new String[]{billid, sealCtrlKey}, mulDatas, mulDatasSelFld, types);
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        if (this.isEmpty(this.billIds)) {
            return null;
        }
        if (null != dataSource.getReference()) {
            return new DefaultNoteDataProvider().getData(dataSource);
        }
        try {
            this.sorter = dataSource.createWrappedBosRuntimeInfo().getSorter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String id = dataSource.getId();
        String[] entities = id.split("\\.");
        String key = entities[0];
        String filter = null;
        if (key.startsWith("MultiApprove")) {
            return this.getMultiApproveData();
        }
        if (key.startsWith("SEALCTRL")) {
            key = key.split("\\_")[1];
            return this.getSealCtrlData(this.billIds[0], key.toUpperCase());
        }
        Entity entity = this.bizInfo.getEntity(key);
        if (entity == null) {
            throw new ActionCommonException(null, "\u6253\u5370\u5143\u6570\u636e\u4e2d\u7684\u5b9e\u4f53" + key + "\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u8f93\u51fa\u6253\u5370\u5143\u6570\u636e");
        }
        SQLBuilder sqlBuilder = new SQLBuilder(this.queryInfo);
        sqlBuilder.setMasterEntityKey(key);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < entities.length; ++i) {
            list.add(entities[i]);
        }
        sqlBuilder.setSelectEntitys(list);
        sqlBuilder.buildSQL(this.ctx);
        String pkFieldName = StringUtils.isEmpty((String)entity.getEntryPkFieldName()) ? sqlBuilder.getPk() : entity.getTableAlias() + "." + entity.getEntryPkFieldName();
        String fromSQL = "SELECT " + sqlBuilder.getSQLSelect() + " FROM " + sqlBuilder.getSQLFrom();
        fromSQL = fromSQL + " WHERE " + pkFieldName + " IN (" + DBUtil.getBindMarks((int)this.billIds.length) + ") ";
        Entity entryEntity = this.getEntryEntity(entities, entity);
        if (entryEntity != null) {
            if (this.application != null && this.application.getDynamicFormView() instanceof DynamicWebFormPanel) {
                filter = ((DynamicWebFormPanel)this.application.getDynamicFormView()).getPrintFilter(entryEntity);
            }
            if (!StringUtils.isEmpty(filter)) {
                fromSQL = fromSQL + " and " + filter;
            }
            fromSQL = fromSQL + " Order By " + entryEntity.getTableAlias() + ".FSeq";
        }
        List fields = sqlBuilder.getSelectFields();
        ArrayList<Integer> mulDatas = new ArrayList<Integer>();
        ArrayList<SelectField> mulDatasSelFld = new ArrayList<SelectField>();
        Iterator iter = fields.iterator();
        int idx = 1;
        HashMap<String, TypeInfo> types = new HashMap<String, TypeInfo>();
        while (iter.hasNext()) {
            SelectField selectField = (SelectField)iter.next();
            Field field = selectField.getField();
            if (field.getElementType() == 24) {
                mulDatas.add(new Integer(idx));
                mulDatasSelFld.add(selectField);
            }
            DataType dataType = DataMappingUtil.getDataTypeForElementType(field.getElementType());
            FieldAppearance fieldAp = this.layoutInfo.getFieldAppearance(selectField.getKey());
            TypeInfo type = new TypeInfo(selectField.getFieldNameAs(), fieldAp.getCaption(), dataType, 0);
            types.put(type.getName().toUpperCase(), type);
            ++idx;
        }
        return this.handleMulDatabase(fromSQL, this.billIds, mulDatas, mulDatasSelFld, types);
    }

    private Entity getEntryEntity(String[] entities, Entity entity) {
        if (entity.getEntityType() == 1) {
            return entity;
        }
        if (entities.length > 1) {
            return this.bizInfo.getEntity(entities[1]);
        }
        return null;
    }

    private IRowSet handleMulDatabase(String fromSQL, Object[] sqlParams, List mulDatas, List mulDatasSelFld, Map types) throws BOSException {
        DynamicRowSet dynamicRowSet;
        int[] colIdxs = new int[mulDatas.size()];
        for (int i = 0; i < colIdxs.length; ++i) {
            colIdxs[i] = (Integer)mulDatas.get(i);
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            ps = con.prepareStatement(fromSQL);
            if (sqlParams != null) {
                for (int i = 0; i < sqlParams.length; ++i) {
                    ps.setObject(i + 1, sqlParams[i]);
                }
            }
            ResultSet rs = ps.executeQuery();
            DynamicRowSet drs = this.createRowSet(rs, types);
            int colCount = drs.getMetaData().getColumnCount();
            while (rs.next()) {
                int i;
                drs.moveToInsertRow();
                for (i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(drs, rs, i);
                }
                for (i = 0; i < colIdxs.length; ++i) {
                    String value = rs.getString(colIdxs[i]);
                    SelectField selectField = (SelectField)mulDatasSelFld.get(i);
                    String names = null;
                    if (!StringUtils.isEmpty((String)value)) {
                        Object[] values = StringUtil.handleMulDatabase(value, 1);
                        names = this.getMulDisplayNameValues(selectField, value);
                        if (names == null) {
                            names = com.kingdee.eas.dynbusiness.util.StringUtil.getKeyIdListWithOutQuotationMask((Object[])values);
                        }
                    }
                    drs.updateString(colIdxs[i], names);
                }
                drs.insertRow();
            }
            dynamicRowSet = drs;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return dynamicRowSet;
    }

    private DynamicRowSet createRowSet(ResultSet rs, Map types) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        DynamicRowSet drs = new DynamicRowSet(types.size());
        int n = types.size();
        for (int i = 1; i <= n; ++i) {
            ColInfo col = new ColInfo();
            col.columnName = md.getColumnName(i);
            TypeInfo type = (TypeInfo)types.get(col.columnName.toUpperCase());
            col.columnLabel = type.getAlias();
            col.extendedProperties().put("TypeInfo", type);
            col.colType = type.getDataType().equals((Object)DataType.ENUM) ? 12 : (type.getDataType().equals((Object)DataType.BOOLEAN) ? -7 : (type.getDataType().equals((Object)DataType.BYTEARRAY) ? -4 : md.getColumnType(i)));
            col.nullable = 1;
            drs.setColInfo(i, col);
        }
        return drs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateRowSetCell(DynamicRowSet rowset, ResultSet rs, int col) throws SQLException, BOSException {
        DataType tp = DataType.OBJECTVALUE;
        Map map = rowset.getRowSetMetaData().getExtendedProperties(col);
        TypeInfo type = (TypeInfo)map.get("TypeInfo");
        tp = type.getDataType();
        if (tp.equals((Object)DataType.STRING) || tp.equals((Object)DataType.OBJECTVALUE)) {
            String colVal = rs.getString(col);
            Field field = this.bizInfo.getField(type.getName());
            int et = field.getElementType();
            if (colVal == null) {
                rowset.updateNull(col);
            } else {
                HashMap comMap;
                List comList;
                if (et == 30 || et == 31) {
                    colVal = StringUtil.formatAssistData(colVal, this.ctx);
                } else if (et == 29) {
                    EnumObject enumObj = this.bizInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                    try {
                        colVal = UnifiedEnumUtils.getDisplayString(enumObj, et, colVal);
                    }
                    catch (DataConverter.DataConvertException e) {
                        throw new BOSException((Throwable)e);
                    }
                } else if (et == 36 && (comList = (List)(comMap = this.bizInfo.getSqlComboLists()).get(field.getId())) != null) {
                    for (String[] item : comList) {
                        if (!colVal.equals(item[0])) continue;
                        colVal = item[1];
                        break;
                    }
                }
                rowset.updateString(col, colVal);
            }
        } else if (tp.equals((Object)DataType.BOOLEAN)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else {
                int i = TypeConversionUtils.objToInt((Object)colVal);
                rowset.updateBoolean(col, i != 0);
            }
        } else if (tp.equals((Object)DataType.INTEGER)) {
            Object colVal = rs.getObject(col);
            if (colVal instanceof BigDecimal) {
                colVal = new Integer(((BigDecimal)colVal).intValue());
            }
            if (colVal instanceof Integer) {
                int i = (Integer)colVal;
                if (i == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateInt(col, i);
                }
            } else if (colVal instanceof Byte) {
                byte b = (Byte)colVal;
                if (b == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateByte(col, b);
                }
            }
        } else if (tp.equals((Object)DataType.LONG)) {
            long colVal = rs.getLong(col);
            if (colVal == 0L) {
                rowset.updateNull(col);
            } else {
                rowset.updateLong(col, colVal);
            }
        } else if (tp.equals((Object)DataType.SHORT)) {
            short colVal = rs.getShort(col);
            if (colVal == 0) {
                rowset.updateNull(col);
            } else {
                rowset.updateShort(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DECIMAL)) {
            BigDecimal colVal = rs.getBigDecimal(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal.equals(new BigDecimal(0.0))) {
                rowset.updateNull(col);
            } else {
                rowset.updateBigDecimal(col, colVal);
            }
        } else if (tp.equals((Object)DataType.FLOAT)) {
            float colVal = rs.getFloat(col);
            if (colVal == 0.0f) {
                rowset.updateNull(col);
            } else {
                rowset.updateFloat(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DOUBLE)) {
            double colVal = rs.getDouble(col);
            if (colVal == 0.0) {
                rowset.updateNull(col);
            } else {
                rowset.updateDouble(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DATE)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Date) {
                Date da = (Date)colVal;
                rowset.updateDate(col, da);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.TIME)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.TIMESTAMP)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.ENUM)) {
            Object colVal = rs.getObject(col);
            Field field = this.bizInfo.getField(type.getName());
            colVal = StringUtil.formatString(this.ctx, field, null, colVal, this.bizInfo, null);
            rowset.updateObject(col, colVal);
        } else if (tp.equals((Object)DataType.BYTEARRAY)) {
            InputStream colVal = null;
            ByteArrayOutputStream out = null;
            byte[] b = new byte[1000];
            try {
                int n;
                out = new ByteArrayOutputStream(1000);
                colVal = rs.getBinaryStream(col);
                while ((n = colVal.read(b)) != -1) {
                    out.write(b, 0, n);
                }
                rowset.updateObject(col, (Object)out.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (colVal != null) {
                    try {
                        colVal.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected String getMulDisplayNameValues(SelectField selectField, String value) {
        String values = "";
        try {
            JSONArray obj = new JSONArray(value);
            Field field = selectField.getField();
            LookUpObject lookupObj = this.bizInfo.getLookUpObject(selectField.getField().getLookUpObjectID());
            String displayName = field.getSrcDisplayFieldName();
            ArrayList<String> list = field.getSelectors();
            try {
                if (!StringUtils.isEmpty((String)displayName)) {
                    if (displayName.indexOf("_L2") != -1) {
                        displayName = displayName.substring(1, 2).toLowerCase() + displayName.substring(2, displayName.indexOf("_L2"));
                    } else if (displayName.indexOf(".") == -1) {
                        displayName = displayName.substring(1, 2).toLowerCase() + displayName.substring(2);
                    }
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(displayName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] selectors = null;
            if (list != null) {
                selectors = list.toArray(new String[0]);
            }
            String temp = obj.getString(0).substring(1, obj.getString(0).length() - 1).replaceAll("\"", "");
            IObjectCollection objCollection = BusinessServiceFactory.getBusinessService().getBaseDatasByKeys(this.ctx, lookupObj, "number", temp, null, selectors);
            List valueList = NewF7Utils.getSortedListOfInputOrder1(objCollection, "number", temp, displayName);
            for (int i = 0; i < valueList.size(); ++i) {
                IObjectValue objValue = (IObjectValue)valueList.get(i);
                if (objValue == null) continue;
                values = values + objValue.get("name") + ",";
            }
            if (values.length() > 0) {
                values = values.substring(0, values.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }
}

