/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.bos.metadata.entity.DataType;

public final class DataMappingUtil {
    public static DataType getDataTypeForElementType(int elementType) {
        if (DataMappingUtil.isDataBase(elementType)) {
            return DataType.OBJECTVALUE;
        }
        switch (elementType) {
            case 2: 
            case 20: 
            case 21: 
            case 22: {
                return DataType.DECIMAL;
            }
            case 3: {
                return DataType.INTEGER;
            }
            case 4: {
                return DataType.DATE;
            }
            case 5: 
            case 26: 
            case 28: {
                return DataType.TIMESTAMP;
            }
            case 1011: 
            case 1023: {
                return DataType.BYTEARRAY;
            }
            case 8: {
                return DataType.BOOLEAN;
            }
            case 9: 
            case 32: 
            case 10013: {
                return DataType.ENUM;
            }
        }
        return DataType.STRING;
    }

    public static int getColTypeFromDataType(DataType dataType) {
        if (dataType == null) {
            return 500;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            return 500;
        }
        if (dataType.equals((Object)DataType.INTEGER) || dataType.equals((Object)DataType.SHORT) || dataType.equals((Object)DataType.LONG)) {
            return 10;
        }
        if (dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.DECIMAL)) {
            return 9;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return 501;
        }
        if (dataType.equals((Object)DataType.DATE)) {
            return 0;
        }
        if (dataType.equals((Object)DataType.TIME) || dataType.equals((Object)DataType.TIMESTAMP)) {
            return 502;
        }
        return 500;
    }

    public static String getJavaTypeClassName(DataType dataType) {
        if (dataType.equals((Object)DataType.STRING)) {
            return "java.lang.String";
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            return "java.lang.Integer";
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            return "java.lang.Boolean";
        }
        return dataType.getJavaTypeName();
    }

    public static boolean isDataBase(int elementType) {
        return elementType == 13 || elementType == 7 || elementType == 17 || elementType == 18 || elementType == 30 || elementType == 27 || elementType == 19 || elementType == 16 || elementType == 15;
    }
}

