/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.util;

import com.kingdee.eas.base.form.metadata.EnumColType;
import com.kingdee.eas.base.form.metadata.Field;
import java.text.ParseException;

public class SQLHelper {
    public static final String SQL_LIKE = " like ";
    public static final String SQL_WILDCARD = "%";
    public static final String EQ = "=";
    public static final String GT = ">=";
    public static final String LT = "<=";

    public static String getOperator(Field field, boolean isRangeFilter, boolean isFrom) {
        String op = EQ;
        if (isRangeFilter) {
            op = isFrom ? GT : LT;
        } else {
            switch (field.getElementType()) {
                case 1: 
                case 6: 
                case 12: 
                case 24: {
                    op = SQL_LIKE;
                }
            }
        }
        return op;
    }

    public static void appendPredicate(StringBuffer sb, Field field, String fieldName, String value, boolean isRangeFilter, boolean isFrom, int fieldColType) throws ParseException {
        String op = SQLHelper.getOperator(field, isRangeFilter, isFrom);
        boolean like = false;
        boolean isUcase = false;
        if (op.equals(SQL_LIKE)) {
            like = true;
        }
        if (like && field.getElementType() != 24 && !value.toUpperCase().equals(value.toLowerCase())) {
            sb.append("ucase(" + fieldName + ")").append(op);
            isUcase = true;
        } else {
            sb.append(fieldName).append(op);
        }
        sb.append(EnumColType.c2DBPredicate(fieldColType, value, like, isFrom, isUcase));
    }
}

