/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.Action;
import com.kingdee.eas.base.form.metadata.ApprovalList;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ButtonAppearance;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.EnumItem;
import com.kingdee.eas.base.form.metadata.EnumObject;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.FormOperation;
import com.kingdee.eas.base.form.metadata.LookUpObject;
import com.kingdee.eas.base.form.metadata.RadioButtonAppearance;
import com.kingdee.eas.base.form.metadata.TabControlAppearance;
import com.kingdee.eas.base.form.metadata.TabPageAppearance;
import com.kingdee.eas.base.form.metadata.TrdCtrlConstants;
import com.kingdee.eas.base.form.metadata.extcontrol.AccessoryPanelAppearance;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.Style;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import com.kingdee.eas.base.form.util.LabelStyleConstants;
import com.kingdee.eas.base.form.util.StringLib;
import com.kingdee.eas.base.form.web.ExtUIBuilder;
import com.kingdee.eas.base.form.web.F7FormatUtils;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;
import java.util.List;

public class ExtControlFactory {
    public static final String DEFAULT_BUTTONGROUP_NAME = "1default";
    private BusinessInfo businessInfo;
    private ExtUIBuilder uiBuilder;

    public ExtControlFactory(ExtUIBuilder uiBuilder, BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
        this.uiBuilder = uiBuilder;
    }

    private boolean isValidationRequired(ControlAppearance ctlAppearance) {
        return this.getValidationRequiredOperation(ctlAppearance) != null;
    }

    private FormOperation getValidationRequiredOperation(ControlAppearance ctlAppearance) {
        ArrayList actions = null;
        if (ctlAppearance instanceof ButtonAppearance) {
            actions = ((ButtonAppearance)ctlAppearance).getClickActions();
        } else if (ctlAppearance instanceof EntityAppearance) {
            actions = ((EntityAppearance)ctlAppearance).getDblClickActions();
        }
        if (actions != null) {
            for (Action action : actions) {
                String[] param = action.getParameters();
                FormOperation fo = this.businessInfo.getForm().getOperation(param[0]);
                if (fo == null || fo.getId() != 8 && fo.getId() != 9) continue;
                return fo;
            }
        }
        return null;
    }

    public JSONObject createControl(ControlAppearance ctlAppearance) throws JSONException {
        JSONObject ctlRet = new JSONObject();
        Field field = null;
        int ctlType = ctlAppearance.getControlType();
        switch (ctlType) {
            case 0: {
                ctlRet.put("xtype", "datefield");
                ctlRet.put("format", "Y-m-d");
                break;
            }
            case 998: {
                ctlRet.put("xtype", "kddatetimefield");
                ctlRet.put("format", "Y-m-d H:i:s");
                break;
            }
            case 1: {
                ctlRet.put("xtype", "textfield");
                this.setMaxMinEditLenth(ctlAppearance, ctlRet);
                break;
            }
            case 2: {
                ctlRet.put("xtype", "numbertextfield");
                field = this.businessInfo.getField(ctlAppearance.getKey());
                ctlRet.put("decimalPrecision", field.getScale());
                ctlRet.put("digitGroup", field.isDigitGroup());
                this.setMaxMin(ctlAppearance, ctlRet);
                break;
            }
            case 3: {
                ctlRet.put("xtype", "numbertextfield");
                field = this.businessInfo.getField(ctlAppearance.getKey());
                ctlRet.put("allowDecimals", false);
                ctlRet.put("decimalPrecision", -1);
                ctlRet.put("digitGroup", field.isDigitGroup());
                ctlRet.put("maxValue", Integer.MAX_VALUE);
                ctlRet.put("minValue", Integer.MIN_VALUE);
                this.setMaxMin(ctlAppearance, ctlRet);
                break;
            }
            case 4: {
                ctlRet.put("xtype", "kdcheckbox");
                ctlRet.put("boxLabel", ctlAppearance.getCaption());
                break;
            }
            case 7: {
                this.createF7(ctlAppearance, ctlRet, field);
                break;
            }
            case 8: {
                this.createCombo(ctlAppearance, ctlRet);
                break;
            }
            case 32: {
                if (this.uiBuilder.isCreatingBill()) {
                    ctlRet.put("xtype", "kdradiogroup");
                    if (!ctlAppearance.isShowTitle()) break;
                    ctlRet.put("text", ctlAppearance.getCaption());
                    break;
                }
                this.createCombo(ctlAppearance, ctlRet);
                break;
            }
            case 999: {
                ctlRet.put("xtype", "kdtextarea");
                this.setMaxMinEditLenth(ctlAppearance, ctlRet);
                break;
            }
            case 22: {
                ctlRet.put("xtype", "numbertextfield");
                field = this.businessInfo.getField(ctlAppearance.getKey());
                ctlRet.put("digitGroup", field.isDigitGroup());
                break;
            }
            case 10: {
                this.createRadioButton(ctlAppearance, ctlRet);
                break;
            }
            case 1001: {
                ctlRet.put("xtype", "label");
                ctlRet.put("cls", "kd-label");
                if (!StringUtil.isEmpty((String)this.getLabelStyle(1001, ctlAppearance))) {
                    ctlRet.put("style", this.getLabelStyle(1001, ctlAppearance));
                }
                ctlRet.put("text", ctlAppearance.getCaption());
                break;
            }
            case 1015: {
                ctlRet.put("xtype", "kdtextarea");
                ctlRet.put("readOnly", true);
                ctlRet.put("cls", "kd-label");
                ctlRet.put("value", ctlAppearance.getCaption());
                if (StringUtil.isEmpty((String)this.getLabelStyle(1015, ctlAppearance))) break;
                ctlRet.put("style", this.getLabelStyle(1015, ctlAppearance));
                break;
            }
            case 1014: {
                ctlRet.put("xtype", "kdlinkbutton");
                ctlRet.put("text", ctlAppearance.getCaption());
                break;
            }
            case 1002: {
                ctlRet.put("xtype", "kdbutton");
                ctlRet.put("text", ctlAppearance.getCaption());
                FormOperation validationRequiredOperation = this.getValidationRequiredOperation(ctlAppearance);
                if (validationRequiredOperation != null) {
                    ctlRet.put("validation", 1);
                    ctlRet.put("operationType", validationRequiredOperation.getId());
                    break;
                }
                if (!this.isValidationRequired(ctlAppearance)) break;
                ctlRet.put("validation", 1);
                break;
            }
            case 1003: {
                ctlRet.put("xtype", "kdseparator");
                ctlRet.put("style", ctlAppearance.getStyle());
                break;
            }
            case 1005: {
                ctlRet.put("xtype", "tabpanel");
                ctlRet.put("activeTab", 0);
                ctlRet.put("plain", "true");
                ctlRet.put("enableTabScroll", "true");
                ctlRet.put("deferredRender", "false");
                TabControlAppearance tabAp = (TabControlAppearance)ctlAppearance;
                ArrayList tabPages = tabAp.getTabPages();
                JSONArray jstabPages = new JSONArray();
                ctlRet.put("items", jstabPages);
                for (int i = 0; i < tabPages.size(); ++i) {
                    TabPageAppearance tabPage = (TabPageAppearance)tabPages.get(i);
                    JSONObject jstabPage = new JSONObject();
                    jstabPage.put("id", tabPage.getKey().toUpperCase());
                    jstabPage.put("title", tabPage.getCaption());
                    jstabPage.put("xtype", "panel");
                    jstabPage.put("layout", "absolute");
                    jstabPages.put(jstabPage);
                }
                break;
            }
            case 1006: {
                ctlRet.put("xtype", "kdcontainer");
                ctlRet.put("title", ctlAppearance.getCaption());
                ctlRet.put("collapsible", true);
                ctlRet.put("layout", "absolute");
                if (ctlAppearance.getCollapsed() != 1) break;
                ctlRet.put("collapsed", true);
                break;
            }
            case 1007: {
                ctlRet.put("xtype", "kdgrid");
                FormOperation validationRequiredOperation4Entry = this.getValidationRequiredOperation(ctlAppearance);
                if (validationRequiredOperation4Entry != null) {
                    ctlRet.put("validation", 1);
                    ctlRet.put("operationType", validationRequiredOperation4Entry.getId());
                }
                if (!(ctlAppearance instanceof EntityAppearance)) break;
                EntityAppearance entityInfo = (EntityAppearance)ctlAppearance;
                if (entityInfo.isHideHeader()) {
                    ctlRet.put("hideHeaders", true);
                }
                if (entityInfo.isColWidthFixed()) {
                    ctlRet.put("enableColumnResize", false);
                }
                if (!entityInfo.isDblClickEnabled()) break;
                ctlRet.put("enableCellDblClick", true);
                break;
            }
            case 1012: {
                ctlRet.put("xtype", "panel");
                ctlRet.put("border", false);
                this.setLayout(ctlAppearance, ctlRet);
                break;
            }
            case 1026: {
                this.createApprovePanel(ctlAppearance, "kdapprovePanel", ctlRet);
                break;
            }
            case 1013: {
                this.createGeneralPanel(ctlAppearance, "kdattachment", ctlRet);
                ctlRet.put("singleDisplay", ctlAppearance.getSingleDisplay());
                ctlRet.put("displayCreator", ctlAppearance.getDisplayCreator());
                ctlRet.put("displayCreateTime", ctlAppearance.getDisplayCreateTime());
                ctlRet.put("isMulAttPanel", ((AccessoryPanelAppearance)ctlAppearance).getIsMulAttPanel());
                break;
            }
            case 1016: 
            case 1022: 
            case 1025: {
                this.createGeneralPanel(ctlAppearance, "kdattachment", ctlRet);
                break;
            }
            case 1024: {
                this.createFtpPanel(ctlAppearance, "ftpPanel", ctlRet);
                break;
            }
            case 1021: {
                this.createGeneralPanel(ctlAppearance, "kdrelatedbill", ctlRet);
                break;
            }
            case 1017: {
                ctlRet.put("xtype", "kdrect");
                break;
            }
            case 1011: {
                ctlRet.put("xtype", "kdpicfield");
                break;
            }
            case 1018: {
                if (this.businessInfo.getTrdCtrlParams().containsKey(TrdCtrlConstants._OFFICE_TYPE_KEY) && ((Integer)this.businessInfo.getTrdCtrlParams().get(TrdCtrlConstants._OFFICE_TYPE_KEY)).intValue() == TrdCtrlConstants._OFFICE_TYPE_VALUE_IWEB.intValue()) {
                    ctlRet.put("xtype", "kdiweboffice");
                } else {
                    ctlRet.put("xtype", "kdoffice");
                }
                ctlRet.put("officeId", "DOC_" + ctlAppearance.getKey().toUpperCase());
                ctlRet.put("docType", this.getOfficeDocType(ctlAppearance));
                ctlRet.put("pwdRequired", ctlAppearance.getUseSealPassword());
                ctlRet.put("isElectroSignBillVisible", ctlAppearance.getSealType() != 0);
                ctlRet.put("isCheckDocChange", ctlAppearance.isCheckDocChange());
                break;
            }
            case 1019: {
                this.createEmbeddedGrid(ctlAppearance, ctlRet);
                break;
            }
            case 1023: {
                ctlRet.put("xtype", "kdelecsign");
                if (ctlAppearance.getStyle() == 1) {
                    ctlRet.put("cls", "kd-rect");
                    break;
                }
                ctlRet.put("cls", "kd-rect-dotted");
            }
        }
        return ctlRet;
    }

    private void createApprovePanel(ControlAppearance ctlInfo, String xtype, JSONObject ctlRet) throws JSONException {
        ctlRet.put("xtype", xtype);
    }

    private void createGeneralPanel(ControlAppearance ctlInfo, String xtype, JSONObject ctlRet) throws JSONException {
        ctlRet.put("xtype", xtype);
        ctlRet.put("subXType", ctlInfo.getControlType());
        ctlRet.put("title", ctlInfo.getShowTitle() != 0 ? ctlInfo.getCaption() : "");
    }

    private void createFtpPanel(ControlAppearance ctlInfo, String xtype, JSONObject ctlRet) throws JSONException {
        ctlRet.put("xtype", xtype);
        ctlRet.put("ftpServer", ctlInfo.getFtpServer());
        ctlRet.put("ftpFileExt", ctlInfo.getFtpFileExt());
        ctlRet.put("ftpFileSize", ctlInfo.getFtpFileSize());
        ctlRet.put("ftpFileCount", ctlInfo.getFtpFileCount());
    }

    private String getOfficeDocType(ControlAppearance ctlAppearance) {
        String sDocType = null;
        switch (ctlAppearance.getOfficeDocType()) {
            case 0: {
                sDocType = "Word.Document";
                break;
            }
            case 1: {
                sDocType = "Excel.Sheet";
                break;
            }
            case 2: {
                sDocType = "WPS.Document";
                break;
            }
            case 3: {
                sDocType = "ET.WorkBook";
                break;
            }
            default: {
                sDocType = "";
            }
        }
        return sDocType;
    }

    private void createF7(ControlAppearance ctlAppearance, JSONObject ctlRet, Field field) throws JSONException {
        ctlRet.put("xtype", "bosf7field");
        this.setF7PropertyFromFormat(ctlRet, "displayPropertyName", ((FieldAppearance)ctlAppearance).getDisplayFormat());
        this.setF7PropertyFromFormat(ctlRet, "editPropertyName", ((FieldAppearance)ctlAppearance).getEditFormat());
        field = this.businessInfo.getField(ctlAppearance.getKey());
        if (field != null) {
            LookUpObject lookup;
            ctlRet.put("muti", field.getElementType() == 24);
            if (!StringUtils.isEmpty((String)field.getFilter()) || !StringUtils.isEmpty((String)field.getControlFieldKey())) {
                ctlRet.put("needGetFilter", 1);
            }
            if ((lookup = this.businessInfo.getLookUpObject(field.getLookUpObjectID())) != null) {
                if (!StringUtils.isEmpty((String)lookup.getQueryInfo())) {
                    ctlRet.put("queryInfo", lookup.getQueryInfo());
                }
                if (!StringUtils.isEmpty((String)lookup.getUrl())) {
                    ctlRet.put("f7url", lookup.getUrl());
                }
            }
            if (field.isMulLines()) {
                ctlRet.put("multiLine", 1);
            }
            if ((field.getElementType() == 13 || field.getElementType() == 10012 || field.getElementType() == 24) && field.getF7Store() != null && field.getF7Store().length() > 150 && field.getF7Store().contains("_jsvar")) {
                ctlRet.put("xtype", "cpf7field");
                ctlRet.put("f7Store", field.getF7Store());
                ctlRet.put("f7Quot", "&q;");
                ctlRet.put("f7QuotSingle", "&qu;");
            }
        }
    }

    private void setF7PropertyFromFormat(JSONObject f7, String propName, String format) throws JSONException {
        String prop = F7FormatUtils.getJSObjectPropertyNameBy(format);
        if (prop != null) {
            f7.put(propName, prop);
        }
    }

    private void createCombo(ControlAppearance ctlAppearance, JSONObject ctlRet) throws JSONException {
        ctlRet.put("xtype", "kdcombo");
        ctlRet.put("readOnly", true);
        ctlRet.put("lazyRender", true);
        ctlRet.put("triggerAction", "all");
        ctlRet.put("typeAhead", true);
        int elementType = ctlAppearance.getElementType();
        switch (elementType) {
            case 31: {
                ctlRet.put("isMulti", true);
            }
            case 30: {
                Field field = this.businessInfo.getField(ctlAppearance.getKey());
                ctlRet.put("isAssistData", 1);
                ctlRet.put("assistDataType", field.getLink());
                String ctrlFieldKey = field.getControlFieldKey();
                if (StringUtil.isEmpty((String)ctrlFieldKey)) break;
                ctlRet.put("ctrlFieldKey", ctrlFieldKey);
                break;
            }
            case 29: {
                ctlRet.put("isMulti", true);
                this.setComboEnumType(ctlAppearance, ctlRet);
                break;
            }
            case 9: 
            case 32: {
                this.setComboEnumType(ctlAppearance, ctlRet);
                break;
            }
            case 36: {
                Field field1 = this.businessInfo.getField(ctlAppearance.getKey());
                JSONArray items = ExtControlFactory.getSqlComboItems(this.businessInfo, field1);
                ctlRet.put("store", items);
            }
        }
    }

    private void setMaxMinEditLenth(ControlAppearance ctl, JSONObject control) throws NumberFormatException, JSONException {
        Field bizField = this.businessInfo.getField(ctl.getKey());
        if (bizField != null) {
            if (StringLib.isNumeric(bizField.getMaxDataScope())) {
                control.put("maxLength", Double.parseDouble(bizField.getMaxDataScope()));
            }
            if (StringLib.isNumeric(bizField.getMinDataScope())) {
                control.put("minLength", Double.parseDouble(bizField.getMinDataScope()));
            }
        }
    }

    private void setMaxMin(ControlAppearance ctl, JSONObject control) throws NumberFormatException, JSONException {
        Field bizField = this.businessInfo.getField(ctl.getKey());
        if (bizField != null) {
            if (StringLib.isNumeric(bizField.getMaxDataScope())) {
                control.put("maxValue", Double.parseDouble(bizField.getMaxDataScope()));
            }
            if (StringLib.isNumeric(bizField.getMinDataScope())) {
                control.put("minValue", Double.parseDouble(bizField.getMinDataScope()));
            }
        }
    }

    private void setLayout(ControlAppearance ctl, JSONObject control) throws JSONException {
        if (ctl.getLayout() instanceof TableLayout) {
            TableLayout tbInfo = (TableLayout)ctl.getLayout();
            control.put("layout", "table");
            JSONObject layoutConfig = new JSONObject();
            layoutConfig.put("columns", tbInfo.getCols());
            control.put("layoutConfig", layoutConfig);
            JSONArray items = new JSONArray();
            for (int i = 0; i < tbInfo.getRows(); ++i) {
                Style rowStyle = (Style)tbInfo.getRowStyles().get(i);
                for (int j = 0; j < tbInfo.getCols(); ++j) {
                    Style colStyle = (Style)tbInfo.getColStyles().get(j);
                    JSONObject panel = new JSONObject();
                    panel.put("width", colStyle.getOut());
                    panel.put("height", rowStyle.getOut());
                    items.put(panel);
                }
            }
            control.put("items", items);
        } else {
            control.put("layout", "absolute");
        }
    }

    public static JSONArray createBooleanEnums() {
        JSONArray items = new JSONArray();
        items.put(ExtControlFactory.createEnumItem(new Integer(0), "\u5426"));
        items.put(ExtControlFactory.createEnumItem(new Integer(1), "\u662f"));
        return items;
    }

    public static JSONArray createEnumItem(Object value, String displayValue) {
        JSONArray item = new JSONArray();
        item.put(value);
        item.put(displayValue);
        return item;
    }

    public static JSONArray getEnumItems(BusinessInfo bizInfo, Field field) {
        JSONArray items;
        block5: {
            EnumObject enumObj;
            block6: {
                enumObj = bizInfo.getEnumInfo().get(String.valueOf(field.getEnumType()));
                items = new JSONArray();
                if (enumObj == null) break block5;
                if (StringUtils.isEmpty((String)enumObj.getEnumClassName())) break block6;
                for (Object _enum : EnumUtils.getEnumList((String)enumObj.getEnumClassName())) {
                    Object value = null;
                    if (_enum instanceof StringEnum) {
                        value = ((StringEnum)_enum).getValue();
                    } else if (_enum instanceof IntEnum) {
                        value = new Integer(((IntEnum)_enum).getValue());
                    }
                    if (value == null) continue;
                    items.put(ExtControlFactory.createEnumItem(value, _enum.toString()));
                }
                break block5;
            }
            if (enumObj.getEnumItems().size() <= 0) break block5;
            for (EnumItem enumItem : enumObj.getEnumItems()) {
                items.put(ExtControlFactory.createEnumItem(new Integer(enumItem.getValue()), enumItem.getDisplayValue()));
            }
        }
        return items;
    }

    private void setComboEnumType(ControlAppearance ctlAppearance, JSONObject combo) throws JSONException {
        try {
            Field field = this.businessInfo.getField(ctlAppearance.getKey());
            combo.put("store", ExtControlFactory.getEnumItems(this.businessInfo, field));
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    private void createEmbeddedGrid(ControlAppearance ctlAppearance, JSONObject ctlRet) throws JSONException {
        ctlRet.put("xtype", "kdembeddedgrid");
        ctlRet.put("subXType", ctlAppearance.getControlType());
        ctlRet.put("columns", ((ApprovalList)ctlAppearance).getColumns());
        if (((ApprovalList)ctlAppearance).isColWidthFixed()) {
            ctlRet.put("enableColumnResize", false);
        }
        if (!ctlAppearance.isShowTitle()) {
            ctlRet.put("hideHeaders", true);
        }
        if (ctlAppearance.getStyle() == 0) {
            ctlRet.put("border", false);
        }
        if (!((ApprovalList)ctlAppearance).isGridLine()) {
            ctlRet.put("cls", "vline-off");
        }
    }

    public static JSONArray getSqlComboItems(BusinessInfo bizInfo, Field field) {
        JSONArray items = new JSONArray();
        try {
            List list = (List)bizInfo.getSqlComboLists().get(field.getId());
            for (int i = 0; i < list.size(); ++i) {
                String[] item = (String[])list.get(i);
                items.put(ExtControlFactory.createEnumItem(item[0], item[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            items.put("SQL\u9519\u8bef");
        }
        return items;
    }

    private void createRadioButton(ControlAppearance ctlAppearance, JSONObject ctlRet) throws JSONException {
        RadioButtonAppearance radioCtrl = (RadioButtonAppearance)ctlAppearance;
        ctlRet.put("xtype", "kdradio");
        ctlRet.put("boxLabel", radioCtrl.getCaption());
        String radioGroupKey = radioCtrl.getButtonGroup();
        if (radioGroupKey == null || radioGroupKey.trim().length() == 0) {
            radioGroupKey = DEFAULT_BUTTONGROUP_NAME;
        } else {
            Field groupField = this.businessInfo.getField(radioGroupKey);
            if (groupField != null) {
                this.uiBuilder.setFireUpdate(groupField, ctlRet);
            }
        }
        ctlRet.put("name", radioGroupKey);
        Object enumItemValue = radioCtrl.getEnumItemValue();
        if (enumItemValue != null) {
            ctlRet.put("inputValue", radioCtrl.getEnumItemValue());
        } else {
            ctlRet.put("noValueBound", 1);
        }
    }

    private String getLabelStyle(int type, ControlAppearance ctlAppearance) {
        String style = "";
        if (!StringUtil.isEmpty((String)ctlAppearance.getTextStyle())) {
            try {
                JSONObject json = new JSONObject(ctlAppearance.getTextStyle());
                if (json.length() >= 4) {
                    String color = (String)json.get(LabelStyleConstants.COLOR);
                    String fontName = json.getString(LabelStyleConstants.FONT_NAME);
                    int fontStyle = json.getInt(LabelStyleConstants.FONT_STYLE);
                    int fontSize = json.getInt(LabelStyleConstants.FONT_SIZE);
                    int textDecoration = json.getInt(LabelStyleConstants.TEXT_DECORATION);
                    style = "color:rgb(" + color + ");";
                    style = style + "font-family:" + fontName + ";";
                    if ((fontStyle & 1) != 0) {
                        style = style + "font-weight:bold;";
                    }
                    if ((fontStyle & 2) != 0) {
                        style = style + "font-style:italic;";
                    }
                    if ((textDecoration & LabelStyleConstants.INT_LINE_THROUGH) != 0) {
                        style = style + "text-decoration:line-through;";
                    } else if ((textDecoration & LabelStyleConstants.INT_UNDER_LINE) != 0) {
                        style = style + "text-decoration:underline;";
                    }
                    style = style + "font-Size:" + fontSize + "px;";
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (type == 1001) {
            style = style + "line-height:" + ctlAppearance.getHeight() + "px;";
            if (ctlAppearance.getStyle() == 1) {
                style = style + " border:1px solid #0063ab;";
            }
            if (ctlAppearance.getTextAlign() == 2) {
                style = style + " text-align:center;";
            } else if (ctlAppearance.getTextAlign() == 3) {
                style = style + " text-align:right;";
            }
        }
        return style;
    }
}

