/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.form.web;

import com.kingdee.eas.base.form.json.JSONArray;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.base.form.json.JSONObject;
import com.kingdee.eas.base.form.metadata.BusinessInfo;
import com.kingdee.eas.base.form.metadata.ControlAppearance;
import com.kingdee.eas.base.form.metadata.Entity;
import com.kingdee.eas.base.form.metadata.EntityAppearance;
import com.kingdee.eas.base.form.metadata.Field;
import com.kingdee.eas.base.form.metadata.FieldAppearance;
import com.kingdee.eas.base.form.metadata.LayoutInfo;
import com.kingdee.eas.base.form.metadata.RadioButtonAppearance;
import com.kingdee.eas.base.form.metadata.SummaryTypeEnum;
import com.kingdee.eas.base.form.metadata.layout.tablelayout.TableLayout;
import com.kingdee.eas.base.form.model.BarDataManager;
import com.kingdee.eas.base.form.util.StringLib;
import com.kingdee.eas.base.form.web.ExtControlFactory;
import com.kingdee.eas.base.form.web.WebBarBuilder;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ExtUIBuilder {
    public static final int VISIABLE = 1;
    public static final int INVISIBLE = 0;
    private LayoutInfo layoutInfo;
    private JSONObject panel = new JSONObject();
    private HashMap controls;
    private BusinessInfo businessInfo;
    private HashMap entitys;
    private int tabIndex = 0;
    private ExtControlFactory ctrlFactory;
    private boolean isCreatingBill = false;

    public ExtUIBuilder(LayoutInfo layoutInfo, BusinessInfo businessInfo) {
        this.layoutInfo = layoutInfo;
        this.businessInfo = businessInfo;
        this.controls = new HashMap();
        this.isCreatingBill = true;
        try {
            this.panel.put("entitys", new JSONArray());
        }
        catch (JSONException jsonEx) {
            jsonEx.printStackTrace();
        }
        this.entitys = new HashMap();
        this.ctrlFactory = new ExtControlFactory(this, this.businessInfo);
    }

    public boolean isCreatingBill() {
        return this.isCreatingBill;
    }

    public ExtUIBuilder(LayoutInfo layoutInfo, BusinessInfo businessInfo, boolean isCreatingBill) {
        this(layoutInfo, businessInfo);
        this.isCreatingBill = isCreatingBill;
    }

    public int getNextTabIndex() {
        return ++this.tabIndex;
    }

    public void addControls() throws JSONException {
        this.addControls(this.layoutInfo);
        this.setParens(this.layoutInfo);
    }

    public JSONObject getControl(String key) {
        return (JSONObject)this.controls.get(key.toUpperCase());
    }

    private void addControls(LayoutInfo sublayoutInfo) throws JSONException {
        ArrayList vctControls = sublayoutInfo.getControls();
        for (int i = 0; i < vctControls.size(); ++i) {
            ControlAppearance ctl = (ControlAppearance)vctControls.get(i);
            this.addControl(ctl);
        }
    }

    private void addFieldControl(FieldAppearance fld) throws JSONException {
        if (fld.isBillVisible()) {
            JSONObject entity = (JSONObject)this.entitys.get(fld.getEntityKey().toUpperCase());
            JSONArray fields = (JSONArray)entity.get("fields");
            fields.put(fld.getKey().toUpperCase());
            JSONObject ctl = this.ctrlFactory.createControl(fld);
            ctl.put("tabIndex", this.getNextTabIndex());
            String sText = StringLib.GetString(fld.getCaption(), 2, "+");
            if (sText.length() == 0) {
                sText = StringLib.GetString(fld.getCaption(), 1, "+");
            }
            JSONObject Item = null;
            Item = new JSONObject();
            this.setContainer(Item, fld, ctl, sText);
            this.controls.put(fld.getKey().toUpperCase(), Item);
        }
    }

    private void setContainer(JSONObject container, FieldAppearance ctlInfo, JSONObject boundEditor, String lblText) throws JSONException {
        String id = ctlInfo.getKey().toUpperCase();
        boundEditor.put("id", id + "_");
        container.put("id", id);
        container.put("x", ctlInfo.getLeft());
        container.put("y", ctlInfo.getTop());
        container.put("width", ctlInfo.getWidth());
        container.put("height", ctlInfo.getHeight());
        container.put("labelText", lblText);
        container.put("labelWidth", ctlInfo.getLabelWidth());
        if (0 != ctlInfo.getTextAlign()) {
            container.put("labelAlign", ctlInfo.getTextAlign());
        }
        container.put("xtype", "kditemcontainer");
        if (ctlInfo.getElementType() == 6) {
            if (ctlInfo.getStyle() == 0) {
                container.put("style", 3);
            } else {
                container.put("style", ctlInfo.getStyle());
            }
        } else if (ctlInfo.getElementType() == 8 || ctlInfo.getElementType() == 32 && this.isCreatingBill) {
            container.put("style", 4);
        } else if (ctlInfo.getStyle() == 0) {
            container.put("style", 1);
        } else {
            container.put("style", ctlInfo.getStyle());
        }
        Field field = this.businessInfo.getField(ctlInfo.getKey());
        if (field != null) {
            if (this.isCreatingBill && field.getMustInput() == 1) {
                container.put("mustinput", true);
            }
            this.setFireUpdate(field, boundEditor);
        }
        container.put("item", boundEditor);
    }

    protected void setFireUpdate(Field field, JSONObject editor) throws JSONException {
        boolean valueChangedEventBound;
        boolean bl = valueChangedEventBound = field.getUpdateActions() != null && field.getUpdateActions().size() > 0;
        if (field.getFireUpdateEvent() == 1 || valueChangedEventBound) {
            editor.put("fireUpdate", 1);
        }
    }

    private void addControl(ControlAppearance ctl) throws JSONException {
        if (ctl.getControlType() == -1) {
            this.controls.put(ctl.getKey().toUpperCase(), this.panel);
            JSONObject entity = new JSONObject();
            entity.put("key", ctl.getKey());
            entity.put("fields", new JSONArray());
            this.entitys.put(ctl.getKey().toUpperCase(), entity);
            ((JSONArray)this.panel.get("entitys")).put(entity);
            LayoutInfo sublayoutinfo = ((EntityAppearance)ctl).getLayoutinfo();
            this.addControls(sublayoutinfo);
        } else if (ctl instanceof FieldAppearance) {
            this.addFieldControl((FieldAppearance)ctl);
        } else if (this.shouldPresentControl(ctl)) {
            this.addOtherControl(ctl);
        }
    }

    private boolean shouldPresentControl(ControlAppearance ctl) {
        boolean shouldPresent = true;
        if (ctl.getControlType() == 10) {
            shouldPresent = this.isCreatingBill;
        }
        return shouldPresent;
    }

    private void addOtherControl(ControlAppearance ctl) throws JSONException {
        JSONObject control = this.ctrlFactory.createControl(ctl);
        if (ctl.getControlType() == 1007) {
            this.setEntityCtl((EntityAppearance)ctl, control);
        } else if (ctl.getControlType() == 1005) {
            this.setTab(control);
        }
        if (control != null) {
            control.put("id", ctl.getKey().toUpperCase());
            control.put("x", ctl.getLeft());
            control.put("y", ctl.getTop());
            control.put("width", ctl.getWidth());
            control.put("height", ctl.getHeight());
            this.controls.put(ctl.getKey().toUpperCase(), control);
        }
        control.put("tabIndex", this.getNextTabIndex());
        control.put("key", ctl.getKey());
    }

    private void setTab(JSONObject control) throws JSONException {
        JSONArray coms = (JSONArray)control.get("items");
        for (int i = 0; i < coms.length(); ++i) {
            this.controls.put(((JSONObject)coms.get(i)).get("id"), coms.get(i));
        }
    }

    public void setEntityCtl(EntityAppearance entityCtl, JSONObject oGrid) throws JSONException {
        Entity entity = (Entity)this.businessInfo.getElement(entityCtl.getKey());
        ((JSONArray)this.panel.get("entitys")).put(entity);
        if (entity.getEntityType() != 0) {
            oGrid.put("columns", this.createEntryView(entityCtl));
        }
    }

    public static JSONObject createGridToolBar(String id, BarDataManager barData) throws JSONException {
        JSONObject entryToolBar = new JSONObject();
        entryToolBar.put("id", id);
        entryToolBar.put("imagepath", "IMAGES/ToolBar/chs/");
        WebBarBuilder barBuilder = new WebBarBuilder(barData, entryToolBar);
        barBuilder.loadBarItems();
        return entryToolBar;
    }

    protected JSONObject createEntryToolBar(String id, boolean canAddRow) throws JSONException {
        return ExtUIBuilder.createGridToolBar(id, this.addGridToolBarData(id));
    }

    private BarDataManager addGridToolBarData(String id) {
        BarDataManager toolBarData = new BarDataManager(null);
        return toolBarData;
    }

    public static String getIndexKey(BusinessInfo bizInfo, EntityAppearance entityCtl) {
        String seqField = bizInfo.getEntity(entityCtl.getKey()).getSeqFieldKey();
        if (StringUtil.isEmpty((String)seqField)) {
            seqField = "FIndex";
        }
        return seqField.toUpperCase();
    }

    private List getEntityFieldsInTabOrder(EntityAppearance entity) {
        ArrayList fieldList = entity.getLayoutinfo().getControls();
        Collections.sort(fieldList, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FieldAppearance f0 = (FieldAppearance)arg0;
                FieldAppearance f1 = (FieldAppearance)arg1;
                if (f0.getTabindex() < f1.getTabindex()) {
                    return -1;
                }
                if (f0.getTabindex() > f1.getTabindex()) {
                    return 1;
                }
                return 0;
            }
        });
        return fieldList;
    }

    public JSONArray createEntryView(EntityAppearance entityCtl) throws JSONException {
        JSONArray cols = new JSONArray();
        String seqField = this.businessInfo.getEntity(entityCtl.getKey()).getSeqFieldKey();
        if (StringUtil.isEmpty((String)seqField)) {
            cols.put(ExtUIBuilder.createHiddenColumn("FIndex"));
        }
        for (FieldAppearance fldAp : this.getEntityFieldsInTabOrder(entityCtl)) {
            String key = fldAp.getKey().toUpperCase();
            cols.put(this.createColumn(fldAp));
        }
        return cols;
    }

    public JSONObject createColumn(FieldAppearance fldCtl) throws JSONException {
        SummaryTypeEnum summaryType;
        String sCaption1 = StringLib.GetString(fldCtl.getCaption(), 1, "+");
        String sCaption2 = StringLib.GetString(fldCtl.getCaption(), 2, "+");
        JSONObject col = new JSONObject();
        col.put("dataIndex", fldCtl.getKey().toUpperCase());
        col.put("id", fldCtl.getKey().toUpperCase());
        col.put("header", sCaption1);
        col.put("width", fldCtl.getWidth());
        if (fldCtl.getSummaryType() != -1 && (summaryType = SummaryTypeEnum.getEnum(fldCtl.getSummaryType())) != null) {
            col.put("summaryType", summaryType.getName());
        }
        if (fldCtl.getVisible() == 0) {
            col.put("hidden", true);
        } else {
            JSONObject ctl = this.ctrlFactory.createControl(fldCtl);
            col.put("editor", ctl);
            Field field = this.businessInfo.getField(fldCtl.getKey());
            if (field != null) {
                if (field.isMustInput()) {
                    col.put("header", sCaption1 + "<font size=2>*</font>");
                }
                this.setFireUpdate(field, col);
            }
        }
        return col;
    }

    public static JSONObject createHiddenColumn(String key) throws JSONException {
        JSONObject col = ExtUIBuilder.createColumn(key, key);
        col.put("hidden", true);
        col.put("hideable", false);
        return col;
    }

    public static JSONObject createColumn(String key, String caption) throws JSONException {
        JSONObject col = new JSONObject();
        col.put("dataIndex", key);
        col.put("header", caption);
        col.put("width", 50);
        return col;
    }

    private void setParens(LayoutInfo layoutInfo) throws JSONException {
        ArrayList vctControls = layoutInfo.getControls();
        for (int i = 0; i < vctControls.size(); ++i) {
            ControlAppearance ctl = (ControlAppearance)vctControls.get(i);
            if (ctl.getControlType() == 10) {
                this.setParent4Radio((RadioButtonAppearance)ctl);
            } else {
                this.setParent(ctl);
            }
            this.setChangeListeners(ctl);
        }
    }

    private void setChangeListeners(ControlAppearance ctrl) throws JSONException {
        int elementType;
        if (ctrl instanceof FieldAppearance && ((elementType = ((FieldAppearance)ctrl).getElementType()) == 30 || elementType == 31 || elementType == 1020)) {
            Field field = this.businessInfo.getField(ctrl.getKey());
            String ctrlFieldKey = field.getControlFieldKey();
            this.addChangeListener(ctrl, ctrlFieldKey);
        }
    }

    private void addChangeListener(ControlAppearance ctrl, String ctrlFieldKey) throws JSONException {
        if (!StringUtil.isEmpty((String)ctrlFieldKey)) {
            JSONObject controller = (JSONObject)this.controls.get(ctrlFieldKey.toUpperCase());
            controller = controller.getJSONObject("item");
            JSONArray listeners = null;
            String key = "changeListeners";
            if (controller.has(key)) {
                listeners = (JSONArray)controller.get(key);
            } else {
                listeners = new JSONArray();
                controller.put(key, listeners);
            }
            listeners.put(ctrl.getKey());
        }
    }

    private void setEntryFieldChangeListeners(EntityAppearance entityCtl, ControlAppearance ctrl) throws JSONException {
        int elementType;
        if (ctrl instanceof FieldAppearance && ((elementType = ((FieldAppearance)ctrl).getElementType()) == 30 || elementType == 31)) {
            Field field = this.businessInfo.getField(ctrl.getKey());
            String ctrlFieldKey = field.getControlFieldKey();
            this.addEntryFieldChangeListener(entityCtl, ctrl, ctrlFieldKey);
        }
    }

    private void addEntryFieldChangeListener(EntityAppearance entityCtl, ControlAppearance ctrl, String ctrlFieldKey) throws JSONException {
        if (!StringUtil.isEmpty((String)ctrlFieldKey)) {
            JSONObject controller = (JSONObject)this.controls.get(entityCtl.getKey().toUpperCase());
            JSONArray columns = controller.getJSONArray("columns");
            for (int i = 0; i < columns.length(); ++i) {
                controller = columns.getJSONObject(i);
                if (!controller.get("dataIndex").equals(ctrl.getKey().toUpperCase())) continue;
                controller = controller.getJSONObject("editor");
                JSONArray listeners = null;
                String key = "changeListeners";
                if (controller.has(key)) {
                    listeners = (JSONArray)controller.get(key);
                } else {
                    listeners = new JSONArray();
                    controller.put(key, listeners);
                }
                listeners.put(ctrlFieldKey);
            }
        }
    }

    private void setParent(ControlAppearance ctlInfo) throws JSONException {
        if (ctlInfo instanceof EntityAppearance) {
            EntityAppearance entityCtl = (EntityAppearance)ctlInfo;
            if (entityCtl.getControlType() == -1) {
                this.setParens(entityCtl.getLayoutinfo());
                return;
            }
            if (entityCtl.getElementType() == 35) {
                ArrayList vctControls = entityCtl.getLayoutinfo().getControls();
                for (int i = 0; i < vctControls.size(); ++i) {
                    ControlAppearance ctrl = (ControlAppearance)vctControls.get(i);
                    this.setEntryFieldChangeListeners(entityCtl, ctrl);
                }
            }
        }
        this.setParent(ctlInfo, StringLib.GetString(ctlInfo.getContainer(), 1, ","));
    }

    private void setParent(ControlAppearance ctlInfo, String parentKey) throws JSONException {
        String key = ctlInfo.getKey();
        if (this.controls.containsKey(key.toUpperCase())) {
            JSONObject com = (JSONObject)this.controls.get(key.toUpperCase());
            JSONObject comContainer = null;
            comContainer = this.controls.containsKey(parentKey.toUpperCase()) ? (JSONObject)this.controls.get(parentKey.toUpperCase()) : this.panel;
            JSONArray items = this.getItemsAndCreateIfHasNot(comContainer);
            if (comContainer.has("layout") && comContainer.get("layout").equals("table")) {
                ControlAppearance con = this.layoutInfo.getControlAppearance(parentKey);
                int col = Integer.parseInt(StringLib.GetString(ctlInfo.getContainer(), 2, ","));
                int row = Integer.parseInt(StringLib.GetString(ctlInfo.getContainer(), 3, ","));
                TableLayout tbInfo = (TableLayout)con.getLayout();
                int i = row * tbInfo.getCols() + col;
                items.put(i, com);
            } else {
                items.put(com);
            }
        }
    }

    private void setParent4Radio(RadioButtonAppearance radio) throws JSONException {
        String key = radio.getKey();
        String parentKey = StringLib.GetString(radio.getButtonGroup(), 1, ",");
        if (this.controls.containsKey(key.toUpperCase())) {
            JSONObject com = (JSONObject)this.controls.get(key.toUpperCase());
            JSONObject itemContainer = null;
            itemContainer = (JSONObject)this.controls.get(parentKey.toUpperCase());
            if (itemContainer != null) {
                JSONObject radioGroup = itemContainer.getJSONObject("item");
                JSONArray items = this.getItemsAndCreateIfHasNot(radioGroup);
                items.put(com.getString("id"));
                String containerOfRadioGroup = this.layoutInfo.getAppearance(parentKey).getContainer();
                this.setParent(radio, StringLib.GetString(containerOfRadioGroup, 1, ","));
            }
        }
    }

    private JSONArray getItemsAndCreateIfHasNot(JSONObject container) throws JSONException {
        JSONArray items = null;
        if (container.has("items")) {
            items = (JSONArray)container.get("items");
        }
        if (items == null) {
            items = new JSONArray();
            container.put("items", items);
        }
        return items;
    }

    public JSONObject getPanel() {
        return this.panel;
    }
}

