/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.message.WfMessageUtil;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailDigestField;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailEntriesArea;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailEntriesField;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailHisApprove;
import com.kingdee.bos.workflow.extscheme.mailApprove.mailConfig.MailConfigInfo;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.bos.workflow.metas.MailApproveAgentFactory;
import com.kingdee.bos.workflow.metas.MailApproveAgentInfo;
import com.kingdee.bos.workflow.metas.MailApprovePageFactory;
import com.kingdee.bos.workflow.metas.MailApprovePageInfo;
import com.kingdee.bos.workflow.metas.MailApproveState;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.thirdInvoke.ApprovalRecordInfo;
import com.kingdee.bos.workflow.thirdInvoke.WfInvokeTool;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.message.app.ITaskHandler;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.mobile.util.AppMsgUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmailApproveHandler
implements ITaskHandler {
    protected static final Logger logger = Logger.getLogger(EmailApproveHandler.class);

    public void execute(AssignmentCreationEvent ed) {
        Context ctx = this.getContext(ed.solution, ed.databaseCenter);
        if (!ed.isMailApprove) {
            return;
        }
        List list = this.mailConfig(ctx);
        if (list.size() == 0) {
            return;
        }
        Map config = (Map)list.get(0);
        try {
            MailApprovePageInfo page = MailApprovePageFactory.getLocalInstance((Context)ctx).getValue(" where procdefId ='" + ed.processDefId + "' and actdefId ='" + ed.activityDefId + "' and id ='" + ed.mailApprovePageId + "'");
            if (page == null) {
                return;
            }
            MailApproveAgentInfo agent = this.initAgent(ctx, ed);
            try {
                MailApproveHtmlDTO dto = (MailApproveHtmlDTO)JSON.parseObject((String)page.getJsonInfo(), MailApproveHtmlDTO.class);
                String preNidInfo = ed.databaseCenter + "&" + agent.getId().toString() + "&" + ed.assignmentId + "&" + ed.bizObjId + "&" + ed.receiver;
                dto.setPreNidInfo(preNidInfo);
                dto.setAddressInfo(MailConfigInfo.decrypt((String)((String)config.get("fmailaddr"))));
                String title = dto.getMailTitleArea().getTitleName();
                WfActivity act = WfEngine.getEngine((Context)ctx).getActivityInst(ed.actvityInstId);
                Locale l = new Locale(page.getLanguage());
                ctx.setLocale(l);
                String titleVal = WfMessageUtil.parseMessage((String)title, (WfActivity)act, (Locale)l);
                dto.getMailTitleArea().setTitleName(titleVal);
                WfProcess process = WfEngine.getEngine((Context)ctx).getProcessInst(ed.processInstId);
                List digestFieldsTemp = dto.getMailDigestArea().getBillDigestFields();
                ArrayList<MailDigestField> digestFields = new ArrayList<MailDigestField>();
                for (int i = 0; i < digestFieldsTemp.size(); ++i) {
                    MailDigestField field = (MailDigestField)digestFieldsTemp.get(i);
                    if (!this.checkIfDisplay(field.getDisplayVar(), process)) continue;
                    digestFields.add(field);
                }
                dto.getMailDigestArea().setBillDigestFields(digestFields);
                ArrayList<MailEntriesField> allEntryFields = new ArrayList<MailEntriesField>();
                List entriesArea = dto.getMailEntriesAreas();
                if (entriesArea != null) {
                    for (int i = 0; i < entriesArea.size(); ++i) {
                        MailEntriesArea area = (MailEntriesArea)entriesArea.get(i);
                        List temp = area.getEntriesFieldList();
                        ArrayList<MailEntriesField> fields = new ArrayList<MailEntriesField>();
                        for (MailEntriesField field : temp) {
                            if (!this.checkIfDisplay(field.getDisplayVar(), process)) continue;
                            fields.add(field);
                        }
                        area.setEntriesFieldList(fields);
                        allEntryFields.addAll(fields);
                    }
                }
                IObjectValue bill = this.getBizObj(ctx, digestFields, allEntryFields, ed.bizObjId);
                String jsonStr = JSONUtils.convertObjectToJson((Context)ctx, (Object)bill);
                JSONObject jsonObj = JSON.parseObject((String)jsonStr);
                WfAssignment assign = WfEngine.getEngine((Context)ctx).getAssignment(ed.assignmentId);
                for (MailDigestField df : digestFields) {
                    if ("procField.creater".equals(df.getDigestFieldCode())) {
                        Person person = WfEngine.getEngine((Context)ctx).getPariticipantProvider().getPersonByUserId(ctx, process.getProcessMeta().getInitiatorId());
                        df.setDigestFieldValue(person.getEmployeeName(ctx.getLocale()));
                        continue;
                    }
                    if ("procField.priorPerformer".equals(df.getDigestFieldCode())) {
                        df.setDigestFieldValue(assign.getAssignmentInfo().getAssignInfo().getPriorPerformName(ctx.getLocale()));
                        continue;
                    }
                    String val = null;
                    Object obj = this.val(jsonObj, this.cutBillName(df.getDigestFieldCode()), 1, page.getLanguage());
                    if (obj instanceof List) {
                        List coll = (List)obj;
                        if (coll.size() > 0) {
                            val = (String)coll.get(0);
                        }
                    } else {
                        val = (String)obj;
                    }
                    val = this.prepareVal(df.getDigestFieldType(), val, df.getEnumPk(), page.getLanguage());
                    df.setDigestFieldValue(val);
                }
                int MAX_SIZE = 100;
                for (int i = 0; i < entriesArea.size(); ++i) {
                    MailEntriesArea area = (MailEntriesArea)entriesArea.get(i);
                    List fields = area.getEntriesFieldList();
                    ArrayList<Object[]> filedValues = new ArrayList<Object[]>();
                    boolean dataListInited = false;
                    for (int j = 0; j < fields.size(); ++j) {
                        MailEntriesField entryField = (MailEntriesField)fields.get(j);
                        List data = (List)this.val(jsonObj, this.cutBillName(entryField.getThCode()), MAX_SIZE, page.getLanguage());
                        if (!dataListInited && data.size() > 0) {
                            for (int m = 0; m < data.size(); ++m) {
                                filedValues.add(new Object[fields.size()]);
                            }
                            dataListInited = true;
                        }
                        for (int k = 0; k < data.size(); ++k) {
                            String val = (String)data.get(k);
                            val = this.prepareVal(entryField.getDigestFieldType(), val, entryField.getEnumPK(), page.getLanguage());
                            ((Object[])filedValues.get((int)k))[j] = val;
                        }
                    }
                    area.setDataList(filedValues);
                }
                dto.getMailHisApproveArea().setApproveList(this.approveRecord(ctx, ed.bizObjId));
                if (config.get("fsysapproveurl") != null) {
                    String pcApproveURL = "/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=" + ed.assignmentId;
                    String base = (String)config.get("fsysapproveurl");
                    dto.getMailApproveUrlArea().setSysApproveUrl(base + pcApproveURL);
                }
                this.sendMail(ctx, ed, dto);
                agent.setState(MailApproveState.Add_MO_MAIL);
            }
            catch (Throwable t) {
                logger.error((Object)"send EmailApprove Error", t);
                agent.setErrorInfo(StringUtils.stackToString((Throwable)t));
                agent.setState(MailApproveState.BUILD_HTML_ERROR);
            }
            MailApproveAgentFactory.getLocalInstance((Context)ctx).addnew(agent);
        }
        catch (Exception e) {
            logger.error((Object)"EmailApproveHandler execute Error", (Throwable)e);
        }
    }

    private String prepareVal(String dataType, String val, String enumPk, String language) {
        if (val == null || val == "{}") {
            return "";
        }
        if (dataType != null && dataType.toLowerCase().equals("enum")) {
            Map map = (Map)JSON.parseObject((String)val, Map.class);
            val = (String)map.get("alias");
        } else if (val.contains("l1") || val.contains("l2") || val.contains("l3")) {
            val = (String)((Map)JSON.parseObject((String)val, Map.class)).get(language);
        }
        return val;
    }

    private boolean isSend(Context ctx, AssignmentCreationEvent ed) {
        if (!ed.isMailApprove) {
            return false;
        }
        List list = this.mailConfig(ctx);
        return list.size() > 0;
    }

    private List mailConfig(Context ctx) {
        String sql = "select FRENTERID,FAPPID,FSECRET,FMAILADDR,FSYSAPPROVEURL,FMOBAPPROVEURL  from t_wfr_mailconf where fkey = 'approve'";
        ArrayList list = new ArrayList();
        try {
            list = SQL.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return list;
    }

    private MailApproveAgentInfo initAgent(Context ctx, AssignmentCreationEvent ed) throws BOSException {
        PersonInfo person = AppMsgUtil.getPersonByUserId((Context)ctx, (String)ed.receiver);
        MailApproveAgentInfo info = new MailApproveAgentInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setAssignid(ed.assignmentId);
        info.setUserId(ed.receiver);
        info.setSendmail(person.getEmail());
        info.setReceivermail("");
        info.setTime(new Timestamp(System.currentTimeMillis()));
        return info;
    }

    private void sendMail(Context ctx, AssignmentCreationEvent ed, MailApproveHtmlDTO dto) {
        Message message = this.getInitialMessage(ed);
        String html = MailApproveHtmlDTO.buildHtml((MailApproveHtmlDTO)dto);
        String title = dto.getMailTitleArea().getTitleName();
        for (int i = 1; i < 4; ++i) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            message.setLocaleStringHeader("title", title, locale);
            message.setLocaleStringHeader("body", html, locale);
        }
        AppMsgUtil.sendBOSMessage((Context)ctx, (Message)message);
    }

    private Message getInitialMessage(AssignmentCreationEvent ed) {
        TextMessage message = new TextMessage();
        message.setStringHeader("databaseCenter", ed.databaseCenter);
        message.setStringHeader("solution", ed.solution);
        message.setStringHeader("ProcessInstId", ed.processInstId);
        message.setStringHeader("activityInstId", ed.actvityInstId);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setStringHeader("operation", ed.operationName);
        message.setStringHeader("function", ed.functionName);
        message.setStringHeader("bizPackage", ed.bizPackage);
        message.setStringHeader("processDefHashValue", ed.processDefHashValue);
        message.setIntHeader("type", 10);
        message.setIntHeader("priority", 10);
        message.setStringHeader("receiver", ed.receiver);
        message.setStringHeader("sourceID", ed.assignmentId);
        message.setStringHeader("isSendEmail", "true");
        message.setStringHeader("isSendMobile", "false");
        return message;
    }

    private List<MailHisApprove> approveRecord(Context ctx, String billId) throws Exception {
        String curProcInstId = new WfUtil(ctx).getProcInstId(billId);
        HashSet curProcInstIdSet = WfInvokeTool.findParentAndChild((Context)ctx, (String)curProcInstId);
        List curList = WfInvokeTool.getApprovalRecord((Context)ctx, (HashSet)curProcInstIdSet);
        ArrayList<MailHisApprove> mailHisApproves = new ArrayList<MailHisApprove>();
        for (ApprovalRecordInfo info : curList) {
            MailHisApprove approve = new MailHisApprove();
            approve.setApproveDefName(info.getActivityNode());
            approve.setApproveResult(info.getApproveResult());
            approve.setApproveTime(info.getApproveTime());
            approve.setApproveUser(info.getApprover());
            approve.setApproveOpinion(info.getApproveOpinion());
            approve.setResultType(Integer.valueOf(info.isPass() ? 1 : 0));
            mailHisApproves.add(approve);
        }
        return mailHisApproves;
    }

    public Object val(Object jsonObj, String keyExpression, int MAX_SIZE, String language) {
        String[] keys = keyExpression.split("\\.");
        for (int i = 0; i < keys.length; ++i) {
            if (i == keys.length - 1) {
                if (jsonObj instanceof JSONArray) {
                    JSONArray array = (JSONArray)jsonObj;
                    ArrayList<String> values = new ArrayList<String>();
                    if (MAX_SIZE == 1) {
                        JSONObject obj = (JSONObject)array.get(0);
                        if (obj == null) {
                            values.add("");
                        } else {
                            Object v = obj.get((Object)keys[i]);
                            if (v instanceof Map) {
                                values.add((String)((Map)v).get(language));
                            } else {
                                values.add((String)v);
                            }
                        }
                        return values;
                    }
                    if (array.size() < MAX_SIZE) {
                        MAX_SIZE = array.size();
                    }
                    for (int r = 0; r < MAX_SIZE; ++r) {
                        String v;
                        JSONObject jo = (JSONObject)array.get(r);
                        if (jo == null || (v = jo.getString(keys[i])) == null) continue;
                        values.add(jo.getString(keys[i]));
                    }
                    return values;
                }
                if (!(jsonObj instanceof JSONObject)) continue;
                return ((JSONObject)jsonObj).getString(keys[i]);
            }
            if (jsonObj instanceof JSONObject) {
                Object obj = ((JSONObject)jsonObj).get((Object)keys[i]);
                return this.val(obj, this.rebuildExp(i, keys), MAX_SIZE, language);
            }
            if (!(jsonObj instanceof JSONArray)) continue;
            JSONArray temp = new JSONArray();
            JSONArray array = (JSONArray)jsonObj;
            if (array.size() < MAX_SIZE) {
                MAX_SIZE = array.size();
            }
            for (int r = 0; r < MAX_SIZE; ++r) {
                JSONObject jo = (JSONObject)array.get(r);
                temp.add((Object)jo.getJSONObject(keys[i]));
            }
            return this.val(temp, this.rebuildExp(i, keys), MAX_SIZE, language);
        }
        return null;
    }

    private String rebuildExp(int i, String[] keys) {
        String exp = "";
        for (int j = i + 1; j < keys.length; ++j) {
            if (exp.length() > 0) {
                exp = exp + ".";
            }
            exp = exp + keys[j];
        }
        return exp;
    }

    private IObjectValue getBizObj(Context ctx, List<MailDigestField> digestFields, List<MailEntriesField> entriesFields, String billId) throws WfException {
        String code;
        SelectorItemCollection selectors = new SelectorItemCollection();
        for (MailDigestField mailDigestField : digestFields) {
            code = this.cutBillName(mailDigestField.getDigestFieldCode());
            selectors.add(new SelectorItemInfo(code));
        }
        for (MailEntriesField mailEntriesField : entriesFields) {
            code = this.cutBillName(mailEntriesField.getThCode());
            selectors.add(new SelectorItemInfo(code));
        }
        IObjectValue obj = ScriptUtil.getBizObject((Context)ctx, (String)billId, (SelectorItemCollection)selectors);
        return obj;
    }

    private boolean checkIfDisplay(String dispalyVar, WfProcess process) throws WfException {
        Object obj;
        if (dispalyVar != null && dispalyVar.trim().length() > 0 && (obj = process.getProcessContext().getDataFieldValue(dispalyVar)) instanceof Boolean) {
            return (Boolean)obj;
        }
        return true;
    }

    private String cutBillName(String fieldExpr) {
        int i = fieldExpr.indexOf(".");
        return fieldExpr.substring(i + 1);
    }

    private Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }
}

