/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WFUrgentAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFUrgentAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;
    Map<String, Object> contents = null;

    public boolean isNeedSendXT() {
        return true;
    }

    public WFUrgentAdapter(Message message) {
        logger.debug((Object)"WFUrgentAdapter init");
        this.message = message;
        this.ctx = WFUrgentAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    public Map<String, Object> getContent() {
        if (this.contents != null) {
            return this.contents;
        }
        this.contents = new HashMap<String, Object>();
        Map<String, Object> content = this.parseContent();
        this.contents.putAll(content);
        this.contents.put("wxtitle", "\u60a8\u6709\u50ac\u529e\u6d88\u606f");
        String assignId = this.message.getStringHeader("sourceID");
        String process = this.message.getStringHeader("ProcessInstId");
        String dbCode = this.ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        String url = host;
        url = host.indexOf("?") > -1 ? url + "&storeEid=21231&name=approveui.navui&viewtype=message&eid=" + newEid + "&type=message&appid=" + appId + "&assignId=" + assignId + "&fprocinstid=" + process : url + "/dealWithNotice.html?viewtype=message&eid=" + newEid + "&type=message&appid=" + appId + "&assignId=" + assignId;
        this.contents.put("url", url);
        this.contents.put("appid", appId);
        this.contents.put("assignId", assignId);
        this.contents.put("procinstid", process);
        this.contents.put("sendId", this.message.getStringHeader("initiatorId"));
        this.contents.put("receiver", this.message.getStringHeader("receiver"));
        this.contents.put("todo", "0");
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.MESSAGEMODEL)) {
            this.contents.put("itemtitle", this.message.getLocaleStringHeader("title", new Locale("L2")));
            this.contents.put("text", this.message.getLocaleStringHeader("body", new Locale("L2")));
            this.contents.put("tagId", "task");
        }
        return this.contents;
    }

    private Map<String, Object> parseContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        ArrayList fieldList = new ArrayList();
        HashMap<String, String> title = new HashMap<String, String>();
        HashMap<String, String> msg = new HashMap<String, String>();
        fieldList.add(title);
        fieldList.add(msg);
        String msgContent = null;
        if (msgContent == null || msgContent.equals("")) {
            msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u6d88\u606f\u5185\u5bb9\uff1a" + this.message.getLocaleStringHeader("body", new Locale("L2"));
            title.put("name", "\u526f\u6807\u9898");
            title.put("value", this.message.getLocaleStringHeader("title", new Locale("L2")));
            msg.put("name", "\u6d88\u606f\u5185\u5bb9");
            msg.put("value", this.message.getLocaleStringHeader("body", new Locale("L2")));
        }
        contents.put("text", msgContent);
        contents.put("fieldList", fieldList);
        return contents;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String assignid = this.message.getStringHeader("sourceID");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                String initiatorId = service.getProcessInstInfoByAssign(assignid).getInitiatorId();
                this.message.setStringHeader("initiatorId", initiatorId);
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{initiatorId, initiatorId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.MESSAGEMODEL = MessageModelEnum.FLOWCENTERNOTICE;
        }
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }
}

