/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.message.web.BillWebAuditConfig;
import com.kingdee.eas.cp.common.StringUtil;
import com.kingdee.eas.framework.workflow.IWorkFlowHtml;
import com.kingdee.eas.framework.workflow.WorkFlowHtmlCollection;
import com.kingdee.eas.framework.workflow.WorkFlowHtmlFactory;
import com.kingdee.eas.framework.workflow.WorkFlowHtmlInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class BillWebUtil {
    protected static final Logger logger = Logger.getLogger(BillWebUtil.class);

    public static boolean isHasWebHtml(Context ctx, String assignId, String proName) {
        if (assignId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)assignId));
            try {
                AssignInfo assignInfo = BillWebUtil.getAssignInfo(ctx, (IObjectPK)pk);
                String billId = assignInfo.getBizObjID();
                String result = BillWebAuditConfig.getInstance().readProcConfigFile(proName);
                if (result != null && !result.equals("")) {
                    return true;
                }
                IWorkFlowHtml query = WorkFlowHtmlFactory.getLocalInstance((Context)ctx);
                String html = query.getHtmlByBillId(billId);
                return html != null;
            }
            catch (Exception e) {
                logger.error((Object)("isHasWebHtml failed, id=" + assignId), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileHtml(Context ctx, String assignId, ServletContext app) {
        block27: {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)assignId));
            BufferedWriter buff = null;
            FileOutputStream stream = null;
            int version = 0;
            WorkFlowHtmlInfo info = null;
            if (assignId != null) {
                try {
                    String filename;
                    File tempFile;
                    String bill;
                    File fileDir;
                    AssignInfo assignInfo = BillWebUtil.getAssignInfo(ctx, (IObjectPK)pk);
                    String billId = assignInfo.getBizObjID();
                    IWorkFlowHtml query = WorkFlowHtmlFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo entityViewInfo = new EntityViewInfo();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("version"));
                    entityViewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
                    FilterInfo filterInfo = new FilterInfo();
                    FilterItemInfo queryFilterItem = new FilterItemInfo("billId", (Object)billId);
                    filterInfo.getFilterItems().add(queryFilterItem);
                    entityViewInfo.setFilter(filterInfo);
                    WorkFlowHtmlCollection coll = query.getWorkFlowHtmlCollection(entityViewInfo);
                    if (coll != null) {
                        info = coll.get(coll.size() - 1);
                        if (info == null) {
                            return "";
                        }
                        version = info.getVersion();
                    }
                    if (!(fileDir = new File(app.getRealPath("") + "//billwebaudit//")).exists()) {
                        fileDir.mkdir();
                    }
                    if ((bill = StringUtil.encoder((String)billId)).indexOf("%") > -1) {
                        bill = bill.replaceAll("%", "9");
                    }
                    if (BillWebUtil.validateHtml(tempFile = new File(fileDir, filename = bill + "_" + String.valueOf(version) + ".html"))) {
                        String result = BillWebUtil.getHtmlFromFile(tempFile);
                        return result;
                    }
                    String html = query.getHtmlByBillId(billId);
                    if (html == null) break block27;
                    try {
                        stream = new FileOutputStream(tempFile);
                        buff = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
                        buff.write(html);
                        buff.flush();
                    }
                    catch (Exception e) {
                        logger.error((Object)("getFileHtml failed, id=" + assignId), (Throwable)e);
                    }
                    finally {
                        if (buff != null) {
                            try {
                                buff.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    return html;
                }
                catch (Exception e) {
                    logger.error((Object)("getFileHtml failed, id=" + assignId), (Throwable)e);
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHtmlFromFile(File f) {
        BufferedReader br = null;
        String ret = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            br = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8")));
            String line = null;
            StringBuffer sb = new StringBuffer((int)f.length());
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            ret = sb.toString();
        }
        catch (Exception e) {
            logger.error((Object)("getHtmlFromFile failed, file=" + f), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    public static boolean validateHtml(File file) {
        boolean result = false;
        if (file.exists()) {
            result = true;
        }
        return result;
    }

    public static AssignInfo getAssignInfo(Context ctx, IObjectPK pk) {
        try {
            EnactmentServiceProxy enactmentService = new EnactmentServiceProxy(ctx);
            AssignmentInfo assignmentInfo = enactmentService.getAssignmentById(pk.toString());
            if (assignmentInfo != null) {
                return assignmentInfo.getAssignInfo();
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getAssignInfo failed, assign=" + pk), (Throwable)e);
        }
        return null;
    }

    public static String getFileJSP(Context ctx, String proName, String actName, String assignId, ServletContext app) {
        String jsp = BillWebAuditConfig.getInstance().getJspName(app, actName, proName);
        return jsp;
    }
}

