/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TempMessage
implements Serializable {
    private static final long serialVersionUID = -192555763825785361L;
    private String msgContent;
    private String msgTitle;
    private String senderName;
    private long msgID;
    private long msgLifeCyc;
    public static final Map MESSAGE_MAP = new HashMap();

    private TempMessage(String msgContent, String msgTitle, int lifeCyc, String senderName) {
        this.msgContent = msgContent;
        this.msgTitle = msgTitle;
        this.senderName = senderName;
        this.msgID = TempMessage.GenerateTempMsgID();
        this.msgLifeCyc = (long)(lifeCyc * 60 * 1000) + this.msgID;
    }

    public static synchronized TempMessage CreateInstance(String content, String title, int lifeCyc, String senderName) {
        TempMessage tempMsg = new TempMessage(content, title, lifeCyc, senderName);
        MESSAGE_MAP.put(new Long(tempMsg.getMsgID()), tempMsg);
        return tempMsg;
    }

    public static void DestroyAreadyReadMsg(long currentTime) {
        Iterator itr = MESSAGE_MAP.values().iterator();
        ArrayList<Long> tempDeleteList = new ArrayList<Long>();
        currentTime = System.currentTimeMillis();
        while (itr.hasNext()) {
            TempMessage tempInfo = (TempMessage)itr.next();
            if (tempInfo.getMsgLifeCyc() > currentTime) continue;
            tempDeleteList.add(new Long(tempInfo.getMsgID()));
        }
        int delSize = tempDeleteList.size();
        if (delSize != 0) {
            for (int i = 0; i < delSize; ++i) {
                MESSAGE_MAP.remove(tempDeleteList.get(i));
            }
        }
    }

    private static synchronized long GenerateTempMsgID() {
        return System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TempMessage)) {
            return false;
        }
        TempMessage other = (TempMessage)obj;
        return this.getMsgTitle().equals(other.getMsgTitle()) ? this.getMsgContent().equals(other.getMsgContent()) : false;
    }

    public int hashCode() {
        int result = this.getMsgTitle().hashCode();
        return result += this.getMsgContent().hashCode();
    }

    public String toString() {
        return "Message Titile is : " + this.getMsgTitle() + "\n Content is : " + this.getMsgContent() + "\n ID is " + this.getMsgID();
    }

    public String getMsgContent() {
        return this.msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public long getMsgID() {
        return this.msgID;
    }

    public void setMsgID(long msgID) {
        this.msgID = msgID;
    }

    public String getMsgTitle() {
        return this.msgTitle;
    }

    public void setMsgTitle(String msgTitle) {
        this.msgTitle = msgTitle;
    }

    public long getMsgLifeCyc() {
        return this.msgLifeCyc;
    }

    public void setMsgLifeCyc(long msgLifeCyc) {
        this.msgLifeCyc = msgLifeCyc;
    }

    public static Map getMessageMap() {
        return MESSAGE_MAP;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }
}

