/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.ctrl.swing.KDTextAreaCtrl;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.base.forewarn.ForewarnUtil;
import com.kingdee.eas.base.forewarn.SimpleForewarnDeal;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.client.AbstractMessageHandleUI;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.message.client.MessageUtil;
import com.kingdee.eas.base.message.client.MsgForwardOpinionUI;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JOptionPane;

public class MessageHandleUI
extends AbstractMessageHandleUI {
    private KDWorkButton disposeButton;
    private KDWorkButton rollbackButton;
    private KDWorkButton deliverButton;
    private KDWorkButton rejectButton;
    private KDWorkButton showWFImageButton;
    private String resName = "com.kingdee.eas.base.message.client.MessageCenter";
    private String resNamere = "com.kingdee.eas.base.message.MessageCenter";
    private KDWorkButton viewButton;
    private BMCMessageInfo currentMessageInfo;
    private KDTextAreaCtrl areaCtrlContent = null;
    private EASWfServiceClient workflowClient;
    private String billId;
    private String billStat;
    private String procInstId;
    private KDWorkButton btnShowWFImage;
    private KDWorkButton btnShowBill;
    private Component owner = null;
    public static boolean isAlreadyPopWarnMsg;

    public MessageHandleUI() throws Exception {
        this.initUI();
        isAlreadyPopWarnMsg = true;
        this.owner = this;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = new RequestContext();
            request.setClassName("com.kingdee.eas.base.message.app.MessageHandleUIHandler");
            if ("1".equals(this.getUIContext().get("messageType"))) {
                request.put("way", (Object)new Integer(1));
                AssignReadInfo assignInfo = new AssignReadInfo();
                request.setBosType(assignInfo.getBOSType());
            } else {
                request.put("way", (Object)new Integer(2));
                Boolean enableHistory = (Boolean)this.getUIContext().get("enableHistory");
                request.put("enableHistory", (Object)enableHistory);
                BMCMessageInfo info = new BMCMessageInfo();
                request.setBosType(info.getBOSType());
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    @Override
    public void loadFields() {
        block13: {
            super.loadFields();
            if ("1".equals(this.getUIContext().get("messageType"))) {
                ObjectUuidPK iObjectPK = new ObjectUuidPK(this.editData.getId());
                BMCMessageInfo info = new BMCMessageInfo();
                try {
                    AssignReadInfo assignReadInfo = MessageUtil.getAssignReadInfo((IObjectPK)iObjectPK);
                    if (assignReadInfo == null) break block13;
                    AssignInfo assignInfo = MessageUtil.getAssignInfo((IObjectPK)new ObjectUuidPK(assignReadInfo.getAssignID()));
                    info.setTitle(assignInfo.getSubject());
                    info.setBody(assignInfo.getBody());
                    info.setSender(assignReadInfo.getSender());
                    info.setSourceID(assignInfo.getAssignID().toString());
                    info.setType(MsgType.TASK);
                    info.setBizType(MsgBizType.WORKFLOW);
                    info.setPriority(MsgPriority.getEnum(assignInfo.getPriority()));
                    info.setReceiveTime(assignInfo.getCreatedTime());
                    this.currentMessageInfo = info;
                    if (assignReadInfo.getStatus().equals((Object)MsgStatus.UNREADED)) {
                        MessageUtil.readAssignRead(assignReadInfo);
                    }
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            } else {
                Boolean enableHistory = (Boolean)this.getUIContext().get("enableHistory");
                if (!enableHistory.booleanValue()) {
                    this.currentMessageInfo = (BMCMessageInfo)this.editData;
                    if (this.currentMessageInfo.getStatus().equals((Object)MsgStatus.UNREADED)) {
                        try {
                            MessageUtil.readBMCMessage(this.currentMessageInfo);
                        }
                        catch (Exception e) {
                            this.handUIException(e);
                        }
                    }
                } else {
                    ObjectUuidPK iObjectPK = new ObjectUuidPK(this.editData.getId());
                    BMCMessageInfo info = new BMCMessageInfo();
                    try {
                        BMCMessageHistoryInfo hInfo = MessageUtil.getBMCMessageHstInfo((IObjectPK)iObjectPK);
                        info.setTitle(hInfo.getTitle());
                        info.setBody(hInfo.getBody());
                        info.setSender(hInfo.getSender());
                        info.setSourceID(hInfo.getSourceID());
                        info.setType(hInfo.getType());
                        info.setBizType(hInfo.getBizType());
                        info.setPriority(hInfo.getPriority());
                        info.setReceiveTime(hInfo.getReceiveTime());
                        info.setSourceIDs(hInfo.getSourceIDs());
                        this.currentMessageInfo = info;
                        if (hInfo.getStatus().getValue() == 0) {
                            ObjectUuidPK pk = new ObjectUuidPK(hInfo.getId());
                            hInfo.setStatus(MsgStatus.READED);
                            BMCMessageHistoryFactory.getRemoteInstance().update((IObjectPK)pk, hInfo);
                        }
                    }
                    catch (Exception e) {
                        this.handUIException(e);
                    }
                }
                this.procInstId = MessageUtil.getWFAMsgPart(this.currentMessageInfo, 0);
                this.billId = MessageUtil.getWFAMsgPart(this.currentMessageInfo, 1);
                this.billStat = MessageUtil.getWFAMsgPart(this.currentMessageInfo, 2);
                this.btnShowWFImage.setVisible(true);
                this.btnShowBill.setVisible(true);
                this.btnShowWFImage.setEnabled(!StringUtils.isEmpty((String)this.procInstId));
                this.btnShowBill.setEnabled(!StringUtils.isEmpty((String)this.billId));
            }
        }
        this.init();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void setMessageDisplay() {
        this.setUITitle(this.currentMessageInfo.getTitle());
        this.kDTextFieldBizType.setText(this.currentMessageInfo.getBizType().getAlias());
        this.kDTextFieldPriority.setText(this.currentMessageInfo.getPriority().getAlias());
        this.kDTextFieldSendTime.setText(new SimpleDateFormat(CtrlFormatUtilities.getDateTimeFormatString()).format(this.currentMessageInfo.getReceiveTime()));
        this.kDTextFieldReceiver.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
        this.kDTextFieldTitle.setText(this.currentMessageInfo.getTitle());
        this.txtSender.setText(this.currentMessageInfo.getSender());
        if (this.currentMessageInfo.getBody() != null) {
            this.areaCtrlContent.setText(new String(this.currentMessageInfo.getBody()));
        } else {
            this.areaCtrlContent.setText("");
        }
        this.kDTextFieldBizType.setBackground(null);
        this.kDTextFieldPriority.setBackground(null);
        this.kDTextFieldSendTime.setBackground(null);
        this.kDTextFieldReceiver.setBackground(null);
        this.kDTextFieldTitle.setBackground(null);
        this.txtSender.setBackground(null);
    }

    private void clearToolbar() {
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.disposeButton);
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.rollbackButton);
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.deliverButton);
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.rejectButton);
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.showWFImageButton);
        MessageUtil.removeFromToobar(this.toolBar, (Component)this.viewButton);
    }

    private void setToolbar() {
        this.clearToolbar();
        this.actionRemove.setEnabled(true);
        if (this.currentMessageInfo.getBizType().equals((Object)MsgBizType.WORKFLOW)) {
            if (this.currentMessageInfo.getType().equals((Object)MsgType.TASK)) {
                this.disposeButton = new KDWorkButton();
                this.disposeButton.setText(EASResource.getString((String)this.resName, (String)"dispose"));
                this.disposeButton.setToolTipText(EASResource.getString((String)this.resName, (String)"dispose"));
                this.disposeButton.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
                this.disposeButton.setBounds(new Rectangle(5, 5, 30, 20));
                this.disposeButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.disposeButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.rollbackButton = new KDWorkButton();
                this.rollbackButton.setText(EASResource.getString((String)this.resName, (String)"rollback"));
                this.rollbackButton.setToolTipText(EASResource.getString((String)this.resName, (String)"rollback"));
                this.rollbackButton.setIcon(EASResource.getIcon((String)"imgTbtn_untread"));
                this.rollbackButton.setBounds(new Rectangle(5, 5, 30, 20));
                this.rollbackButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.rollbackButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.deliverButton = new KDWorkButton();
                this.deliverButton.setText(EASResource.getString((String)this.resName, (String)"deliver"));
                this.deliverButton.setToolTipText(EASResource.getString((String)this.resName, (String)"deliver"));
                this.deliverButton.setIcon(EASResource.getIcon((String)"imgTbtn_deliverto"));
                this.deliverButton.setBounds(new Rectangle(40, 5, 30, 20));
                this.deliverButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.deliverButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.rejectButton = new KDWorkButton();
                if (com.kingdee.eas.base.message.util.MessageUtil.isFD(null)) {
                    this.rejectButton.setText("\u5220\u9664");
                } else {
                    this.rejectButton.setText(EASResource.getString((String)this.resName, (String)"reject"));
                }
                this.rejectButton.setToolTipText(EASResource.getString((String)this.resName, (String)"reject"));
                this.rejectButton.setIcon(EASResource.getIcon((String)"imgTbtn_refuse"));
                this.rejectButton.setBounds(new Rectangle(75, 5, 30, 20));
                this.rejectButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.rejectButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.rejectButton.setVisible(false);
                this.rejectButton.setEnabled(false);
                if (this.isNeedShowReject()) {
                    this.rejectButton.setVisible(true);
                    this.rejectButton.setEnabled(true);
                }
                this.showWFImageButton = new KDWorkButton();
                this.showWFImageButton.setText(EASResource.getString((String)this.resName, (String)"showWFImage"));
                this.showWFImageButton.setToolTipText(EASResource.getString((String)this.resName, (String)"showWFImage"));
                this.showWFImageButton.setIcon(EASResource.getIcon((String)"imgTbtn_estatechart"));
                this.showWFImageButton.setBounds(new Rectangle(105, 5, 60, 20));
                this.showWFImageButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.showWFImageButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.toolBar.add((Component)this.disposeButton, 1);
                this.toolBar.add((Component)this.deliverButton, 2);
                this.toolBar.add((Component)this.rejectButton, 3);
                this.toolBar.add((Component)this.rollbackButton, 4);
                this.toolBar.add((Component)this.showWFImageButton, 5);
                this.btnShowWFImage.setVisible(false);
                this.btnShowBill.setVisible(false);
            }
            this.actionRemove.setEnabled(false);
        } else if (this.currentMessageInfo.getBizType().equals((Object)MsgBizType.FORWARN)) {
            if (this.currentMessageInfo.getSourceIDs() != null) {
                this.viewButton = new KDWorkButton();
                this.viewButton.setText(EASResource.getString((String)this.resName, (String)"view"));
                this.viewButton.setToolTipText(EASResource.getString((String)this.resName, (String)"view"));
                this.viewButton.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
                this.viewButton.setBounds(new Rectangle(5, 5, 30, 20));
                this.viewButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            MessageHandleUI.this.viewButton_actionPerformed(e);
                        }
                        catch (Exception exc) {
                            MessageHandleUI.this.handUIException(exc);
                        }
                    }
                });
                this.toolBar.add((Component)this.viewButton, 1);
                this.btnShowBill.setVisible(false);
            }
        } else if (this.currentMessageInfo.getBizType().equals((Object)MsgBizType.XITONGOFFICE)) {
            if (this.currentMessageInfo.getSourceID() != null && !this.currentMessageInfo.getSourceID().endsWith("WFWKITEM")) {
                this.btnShowBill.setVisible(true);
                this.btnShowBill.setEnabled(true);
            }
        } else {
            this.toolBar.remove((Component)this.separatorCommon);
        }
        this.setButtonStatus();
        MessageUtil.repaintToolbar(this.toolBar);
    }

    public boolean isNeedShowReject() {
        try {
            String value = ParamManager.getParamValue(null, null, (String)"MessageCenter_ShowRejectBtn");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void setButtonStatus() {
        this.setMessageButtonStatus();
    }

    private void setMessageButtonStatus() {
        if ("1".equals(this.getUIContext().get("messageType"))) {
            this.disposeButton.setEnabled(true);
            this.deliverButton.setEnabled(true);
            this.rollbackButton.setEnabled(false);
            this.rejectButton.setEnabled(true);
        }
        if (this.currentMessageInfo.getType().equals((Object)MsgType.NOTICE)) {
            if (!StringUtils.isEmpty((String)this.currentMessageInfo.getSourceIDs())) {
                String sourceIDs = this.currentMessageInfo.getSourceIDs();
                if (sourceIDs.indexOf("PASS::") >= 0) {
                    String[] ids = sourceIDs.split(":");
                    if (ids.length >= 3 && !StringUtils.isEmpty((String)ids[2])) {
                        this.btnShowWFImage.setVisible(true);
                        this.btnShowWFImage.setEnabled(true);
                    }
                    if (ids.length >= 4 && !StringUtils.isEmpty((String)ids[3])) {
                        this.btnShowBill.setEnabled(true);
                    }
                } else if (sourceIDs.indexOf("::") > 0 && MessageUtil.ifShowBillBtn(sourceIDs)) {
                    this.btnShowBill.setEnabled(true);
                }
            } else if (!StringUtils.isEmpty((String)this.currentMessageInfo.getSourceID()) && !this.currentMessageInfo.getBizType().equals((Object)MsgBizType.FORWARN)) {
                this.btnShowBill.setEnabled(true);
            }
        }
    }

    private void init() {
        this.readMessage();
        this.setMessageDisplay();
        this.setToolbar();
        this.menuBar.remove((Component)this.menuEdit);
        this.save = true;
    }

    private void initUI() {
        this.areaCtrlContent = new KDTextAreaCtrl();
        this.areaCtrlContent.setEditable(false);
        this.areaCtrlContent.setBounds(new Rectangle(10, 127, 680, 364));
        this.add((Component)this.areaCtrlContent, null);
        this.btnShowWFImage = new KDWorkButton();
        this.btnShowWFImage.setText(EASResource.getString((String)this.resName, (String)"showWFImage"));
        this.btnShowWFImage.setToolTipText(EASResource.getString((String)this.resName, (String)"showWFImage"));
        this.btnShowWFImage.setIcon(EASResource.getIcon((String)"imgTbtn_showdata"));
        this.btnShowWFImage.setBounds(new Rectangle(105, 5, 60, 20));
        this.btnShowWFImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!StringUtils.isEmpty((String)MessageHandleUI.this.procInstId)) {
                        MessageUtil.showWorkFlowImageByProcInstId(MessageHandleUI.this.getWorkflowClient(), MessageHandleUI.this.procInstId, this);
                    } else {
                        String sourceIds = MessageHandleUI.this.currentMessageInfo.getSourceIDs();
                        if (!StringUtils.isEmpty((String)sourceIds) && sourceIds.indexOf("PASS::") >= 0) {
                            String[] ids = sourceIds.split(":");
                            MessageUtil.showWorkFlowImageByProcInstId(MessageHandleUI.this.getWorkflowClient(), ids[2], this);
                            return;
                        }
                        MessageUtil.showWorkFlowImage(MessageHandleUI.this.getWorkflowClient(), sourceIds, this);
                    }
                }
                catch (Exception exc) {
                    MessageHandleUI.this.handUIException(exc);
                }
            }
        });
        this.btnShowBill = new KDWorkButton();
        this.btnShowBill.setText(EASResource.getString((String)this.resNamere, (String)"bill"));
        this.btnShowBill.setToolTipText(EASResource.getString((String)this.resNamere, (String)"bill"));
        this.btnShowBill.setIcon(EASResource.getIcon((String)"imgTbtn_estatechart"));
        this.btnShowBill.setBounds(new Rectangle(140, 5, 60, 20));
        this.btnShowBill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageHandleUI.this.showBill(e);
            }
        });
        this.toolBar.add((Component)this.btnShowWFImage);
        this.toolBar.add((Component)this.btnShowBill);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showBill(ActionEvent e) {
        if (this.currentMessageInfo.getType().equals((Object)MsgType.NOTICE)) {
            if (!StringUtils.isEmpty((String)this.billId)) {
                MessageServiceProvider.showWFBIllByBillId((Component)((Object)this), this.billId, this.billStat);
                return;
            } else {
                String sourceId = this.currentMessageInfo.getSourceID();
                String sourceIds = this.currentMessageInfo.getSourceIDs();
                if (!StringUtils.isEmpty((String)sourceId)) {
                    MessageServiceProvider.showWFBill((Component)((Object)this), sourceId);
                    return;
                } else {
                    if (StringUtils.isEmpty((String)sourceIds)) return;
                    if (sourceIds.startsWith("(")) {
                        sourceIds = sourceIds.substring(1, sourceIds.length() - 1).replaceAll("'", "");
                        String[] ids = sourceIds.split(",");
                        for (int i = 0; i < ids.length; ++i) {
                            MessageServiceProvider.showWFBill((Component)((Object)this), ids[i]);
                        }
                    }
                    if (sourceIds.indexOf("::") < 0 || sourceIds.startsWith("PASS")) return;
                    try {
                        MessageServiceProvider.showConfigBill((Component)((Object)this), sourceIds);
                        return;
                    }
                    catch (UIException e1) {
                        this.handUIException(e1);
                    }
                }
            }
            return;
        } else {
            String sourceId = this.currentMessageInfo.getSourceID();
            MessageServiceProvider.showWFBill((Component)((Object)this), sourceId);
        }
    }

    protected void jbInit() {
    }

    private void readMessage() {
    }

    private void disposeButton_actionPerformed(ActionEvent e) {
        try {
            MessageUtil.showBusinessUI(this.getWorkflowClient(), this.currentMessageInfo.getSourceID(), (Object)this);
            this.currentMessageInfo.setSourceStatus(MessageUtil.getSourceStatus(this.getWorkflowClient(), this.currentMessageInfo.getSourceID()));
            this.setMessageButtonStatus();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"disposeTaskFail"), (Throwable)e1);
        }
    }

    private void rollbackButton_actionPerformed(ActionEvent e) {
        try {
            MessageUtil.rollbackAssignment(this.getWorkflowClient(), this.currentMessageInfo.getSourceID());
            this.currentMessageInfo.setSourceStatus(MessageUtil.getSourceStatus(this.getWorkflowClient(), this.currentMessageInfo.getSourceID()));
            this.setMessageButtonStatus();
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"rollbackTaskSucceed"));
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"rollbackTaskFail"), (Throwable)e1);
        }
    }

    private void deliverButton_actionPerformed(ActionEvent e) {
        try {
            String id = this.currentMessageInfo.getSourceID();
            ObjectUuidPK iObjectPK = new ObjectUuidPK(id);
            ArrayList<AssignInfo> msgInfoList = new ArrayList<AssignInfo>();
            AssignInfo assignInfo = MessageUtil.getAssignInfo((IObjectPK)iObjectPK);
            if (!MessageServiceProvider.canForwardAssignment((Component)((Object)this), assignInfo.getAssignID().toString())) {
                return;
            }
            msgInfoList.add(assignInfo);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"msgInfoList", msgInfoList);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MsgForwardOpinionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void rejectButton_actionPerformed(ActionEvent e) throws Exception {
        AssignmentInfo[] assignmentInfo = MessageUtil.getAssignmentsByOneAssID(this.getWorkflowClient(), this.currentMessageInfo.getSourceID());
        if (assignmentInfo == null || assignmentInfo.length <= 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"cannotReject"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"rejectConfirm")) == 0) {
            try {
                MessageUtil.rejectAssignment(this.getWorkflowClient(), this.currentMessageInfo.getSourceID());
                this.currentMessageInfo.setSourceStatus(MessageUtil.getSourceStatus(this.getWorkflowClient(), this.currentMessageInfo.getSourceID()));
                this.setMessageButtonStatus();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"rejectSucceed"));
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"rejectFail"), (Throwable)e1);
            }
        }
    }

    private void showWFImageButton_actionPerformed(ActionEvent e) {
        try {
            MessageUtil.showWorkFlowImage(this.getWorkflowClient(), this.currentMessageInfo.getSourceID(), (Object)this);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"showImageFail"), (Throwable)e1);
        }
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    private void viewButton_actionPerformed(ActionEvent e) {
        try {
            if (this.getUIWindow() instanceof Dialog) {
                ForewarnUtil.handleUI((String)this.currentMessageInfo.getSourceIDs(), (Component)((Dialog)this.getUIWindow()));
            } else if (this.getUIWindow() instanceof UINewFrame) {
                ForewarnUtil.handleUI((String)this.currentMessageInfo.getSourceIDs(), (Component)((UINewFrame)this.getUIWindow()));
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)this.resName, (String)"getMessageFail"), (Throwable)e1);
        }
    }

    protected IObjectValue createNewData() {
        return new BMCMessageInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        if ("1".equals(this.getUIContext().get("messageType"))) {
            return AssignReadFactory.getRemoteInstance();
        }
        Boolean enableHistory = (Boolean)this.getUIContext().get("enableHistory");
        if (!enableHistory.booleanValue()) {
            return BMCMessageFactory.getRemoteInstance();
        }
        return BMCMessageHistoryFactory.getRemoteInstance();
    }

    protected void disposeUIWindow() {
        isAlreadyPopWarnMsg = false;
        super.disposeUIWindow();
    }

    public void showForeWarnUIForWeb(String objIDs) {
        SimpleForewarnDeal fd = new SimpleForewarnDeal();
        if (objIDs == null || objIDs.trim().length() == 0) {
            return;
        }
        fd.show(objIDs, (Component)this.getFrame());
    }

    private Frame getFrame() {
        return JOptionPane.getFrameForComponent(SystemEntry.instance.getApplet());
    }
}

