/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.exception.ActivityIsNotRunningException;
import com.kingdee.bos.workflow.exception.AlreadySuspendedException;
import com.kingdee.bos.workflow.exception.CannotForwardException;
import com.kingdee.bos.workflow.exception.ForbidForwardException;
import com.kingdee.bos.workflow.exception.NoReferenceEmployeeException;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.metas.WorkflowLogItem;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.NotRollbackCause;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.IWebViewMessageFacade;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.WebViewMessageFacadeFactory;
import com.kingdee.eas.base.message.client.HandSendMessageUI;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.message.client.MessageHandleUI;
import com.kingdee.eas.base.message.client.MessageUtil;
import com.kingdee.eas.base.message.client.MsgForwardOpinionUI;
import com.kingdee.eas.base.message.client.WFDisposedAssignViewUI;
import com.kingdee.eas.base.message.util.WorkflowLogUtil;
import com.kingdee.eas.base.multiapprove.ISqlFacade;
import com.kingdee.eas.base.multiapprove.MetadataUtils;
import com.kingdee.eas.base.multiapprove.SqlFacadeFactory;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.base.uiframe.client.NewWinMainUI;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.cp.eip.sso.SSOHandleFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MessageServiceProvider {
    private static final Logger logger = CoreUIObject.getLogger(MessageCenterUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.message.client.MessageCenter";
    private static final String UICONTEXT_ISFROMWORKFLOW = "isFromWorkflow";
    private static final String EASPORTAL_NAME = "easportal";
    private static final String EASPORTAL_PATH = "/easportal";
    private static final String EASWEB_NAME = "easweb";
    private static final String EASWEB_PATH = "/easweb";
    private static int COMMON_NOTICE = 1;
    private static int PASS_NOTICE = 2;
    private static int ONLINE_NOTICE = 3;
    private static final String RES = "com.kingdee.eas.base.message.client.MessageCenter";

    public static void handleMultiAssignments(Component owner, String assignmentIds) {
        try {
            EASWfServiceClient ormClient = new EASWfServiceClient();
            String[] idArray = assignmentIds.split(";");
            if (idArray.length == 1) {
                MessageServiceProvider.handleAssignment(owner, idArray[0]);
                return;
            }
            HashSet<String> sourceIDs = new HashSet<String>();
            for (int i = 0; i < idArray.length; ++i) {
                sourceIDs.add(idArray[i]);
            }
            IEnactmentService iService = EnactmentServiceFactory.createRemoteEnactService();
            String[] canNotHandIdArray = iService.acceptAssignments(idArray);
            if (canNotHandIdArray.length < idArray.length) {
                if (canNotHandIdArray.length > 0) {
                    if (MsgBox.showConfirm2((Component)owner, (String)(EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"have") + canNotHandIdArray.length + EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"hanUpMsg"))) == 0) {
                        for (int i = 0; i < canNotHandIdArray.length; ++i) {
                            sourceIDs.remove(canNotHandIdArray[i]);
                        }
                        String[] canHandIdArray = sourceIDs.toArray(new String[sourceIDs.size()]);
                        ormClient.invokeUI(canHandIdArray, (Object)owner);
                    }
                } else {
                    ormClient.invokeUI(idArray, (Object)owner);
                }
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"allProHandUp"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"disposeTaskFail"), (Throwable)e);
        }
    }

    public static void handleAssignment(Component owner, String assignmentId) {
        if (MessageServiceProvider.canHandleAssignment(owner, assignmentId)) {
            try {
                EASWfServiceClient workflowClient = MessageServiceProvider.getWorkflowClient();
                workflowClient.invokeUI(assignmentId, (Object)owner);
            }
            catch (AlreadySuspendedException ale) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"flowAlreadyHangUp"));
            }
            catch (ActivityIsNotRunningException ex) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"ActivityIsNotRunning"));
            }
            catch (WfException e1) {
                ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"disposeTaskFail"), (Throwable)e1);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"disposeTaskFail"), (Throwable)ex);
            }
        }
    }

    public static void handleAssign(Component owner, String messageId, String assignmentId) {
        try {
            MessageUtil.readAssignRead(messageId);
        }
        catch (Exception e) {
            logger.error((Object)"handleAssign (readAssignRead) failed!", (Throwable)e);
        }
        if (MessageServiceProvider.canHandleAssignment(owner, assignmentId)) {
            try {
                EASWfServiceClient workflowClient = MessageServiceProvider.getWorkflowClient();
                workflowClient.invokeUI(assignmentId, (Object)owner);
            }
            catch (AlreadySuspendedException ale) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"flowAlreadyHangUp"));
            }
            catch (ActivityIsNotRunningException ex) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"ActivityIsNotRunning"));
            }
            catch (WfException e1) {
                ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"disposeTaskFail"), (Throwable)e1);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"disposeTaskFail"), (Throwable)ex);
            }
        }
    }

    public static boolean isNotAssignmentId(String sourceID) {
        return !sourceID.endsWith("WFWKITEM");
    }

    public static boolean canHandleAssignment(Component owner, String assignmentId) {
        AssignmentInfo assignmentInfo;
        try {
            assignmentInfo = MessageServiceProvider.getAssignmentById(MessageServiceProvider.getWorkflowClient(), assignmentId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
            return false;
        }
        return assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED);
    }

    public static void rollbackAssignment(Component owner, String assignmentId) {
        try {
            IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
            AssignmentInfo assignmentInfo = enactmentService.getAssignmentById(assignmentId);
            NotRollbackCause notRollbackCause = enactmentService.canRollbackActInstNew(assignmentId);
            if (notRollbackCause.isCanRollback()) {
                IObjectPK logPk = WorkflowLogUtil.beginLogByRemote(WorkflowLogItem.ALREADY_DONE_RETRACT, assignmentInfo.getActInstId());
                enactmentService.rollbackActInst(assignmentId);
                MessageServiceProvider.addrollback(assignmentId);
                WorkflowLogUtil.engLogByRemote(logPk);
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"rollbackTaskSucceed"));
            } else {
                MsgBox.showInfo((Component)owner, (String)notRollbackCause.getCauseMsg(SysContext.getSysContext().getLocale()));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
    }

    private static void addrollback(String assignid) {
        try {
            String sql = "update t_bas_option set FTYPE = '10' where FASSIGNMENTID= '" + assignid + "' ";
            String sql1 = "update T_BAS_MULTIAPPROVE set Ftype = '10' where FASSIGNMENTID='" + assignid + "'";
            ISqlFacade sqlfacade = SqlFacadeFactory.getRemoteInstance();
            sqlfacade.executeSql(sql);
            sqlfacade.executeSql(sql1);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    public static boolean canRollbackAssignment(Component owner, String assignmentId) {
        try {
            AssignmentInfo assignmentInfo = MessageServiceProvider.getAssignmentById(MessageServiceProvider.getWorkflowClient(), assignmentId);
            return EnactmentServiceFactory.createRemoteEnactService().canRollbackActInst(assignmentInfo.getActInstId());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void forwardAssignment_bak(Component owner, String assignmentId) {
        if (MessageServiceProvider.canForwardAssignment(owner, assignmentId)) {
            KDCommonPromptDialog dialog = new KDCommonPromptDialog((Frame)owner, EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"deliverDialogTitle"));
            QueryInfo queryInfo = Util.getQueryInfo((String)"com.kingdee.eas.base.permission.app.UserSimpleQuery");
            dialog.setQueryInfo(queryInfo);
            dialog.show();
            Object data = dialog.getData();
            if (dialog.isCanceled()) {
                return;
            }
            if (data == null) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"chosenUserIsNull"));
                return;
            }
            Object[] objects = (Object[])dialog.getData();
            UserInfo userInfo = (UserInfo)objects[0];
            PersonInfo personInfo = userInfo.getPerson();
            UserInfo currentUserInfo = (UserInfo)SysContext.getSysContext().getCurrentUser();
            PersonInfo currentPerson = currentUserInfo.getPerson();
            if (personInfo == null) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noReferenceEmployee"));
                return;
            }
            if (currentPerson != null && personInfo.getId().equals((Object)currentPerson.getId())) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"canNotDeliverToTheSamePerson"));
                return;
            }
            try {
                EASWfServiceClient workflowClient = MessageServiceProvider.getWorkflowClient();
                workflowClient.forwardAssignment(assignmentId, userInfo.getId().toString(), null);
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"deliverTaskSucceed"));
            }
            catch (NoReferenceEmployeeException ne) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noReferenceEmployee"));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)owner, (Throwable)e);
            }
        }
    }

    public static void forwardAssignment(Component owner, String assignmentIds) {
        try {
            if (StringUtils.isEmpty((String)assignmentIds)) {
                return;
            }
            String[] idArray = assignmentIds.split(";");
            ArrayList<AssignInfo> msgInfoList = new ArrayList<AssignInfo>();
            AssignInfo assignInfo = null;
            for (int i = 0; i < idArray.length; ++i) {
                ObjectUuidPK iObjectPK = new ObjectUuidPK(idArray[i]);
                assignInfo = MessageUtil.getAssignInfo((IObjectPK)iObjectPK);
                if (!MessageServiceProvider.canForwardAssignment(owner, assignInfo.getAssignID().toString())) {
                    return;
                }
                msgInfoList.add(assignInfo);
            }
            UIContext uiContext = new UIContext((Object)owner);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MsgForwardOpinionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            MsgForwardOpinionUI opinionUi = (MsgForwardOpinionUI)uiWindow.getUIObject();
            if (!opinionUi.isCanceled()) {
                for (int i = 0; i < msgInfoList.size(); ++i) {
                    assignInfo = (AssignInfo)msgInfoList.get(i);
                    MessageUtil.forwardAssignmentWithOpinion(MessageServiceProvider.getWorkflowClient(), assignInfo.getAssignID().toString(), opinionUi.getUserID(), opinionUi.getMsgOpinon());
                }
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"deliverTaskSucceed"));
            }
        }
        catch (CannotForwardException ex) {
            MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"canNotDeliverEndFlow"));
        }
        catch (ForbidForwardException ef) {
            MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"flowForbidDeliver"));
        }
        catch (AlreadySuspendedException ae) {
            MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"canNotDeliverAlreadySuspendedFlow"));
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"deliverTaskFail"), (Throwable)e1);
        }
    }

    public static boolean canForwardAssignment(Component owner, String assignmentId) {
        AssignmentInfo assignmentInfo;
        try {
            EASWfServiceClient client = MessageServiceProvider.getWorkflowClient();
            IEnactmentService service = client.getService();
            boolean allowForward = MultiApproveUtil.allowForward((IEnactmentService)service, (String)assignmentId);
            if (!allowForward) {
                String msg = MultiApproveUtil.getMultiApproveResource((String)"DISABLEFORWARD");
                MsgBox.showInfo((Component)owner, (String)msg);
                return false;
            }
            assignmentInfo = MessageServiceProvider.getAssignmentById(client, assignmentId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
            return false;
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED)) {
            return true;
        }
        MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"canNotDeliverEndFlow"));
        return false;
    }

    public static void rejectAssignment(Component owner, String assignmentId) {
        try {
            EASWfServiceClient workflowClient = MessageServiceProvider.getWorkflowClient();
            workflowClient.rejectAssignment(assignmentId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
    }

    public static boolean canRejectAssignment(Component owner, String assignmentId) {
        AssignmentInfo assignmentInfo;
        try {
            assignmentInfo = MessageServiceProvider.getAssignmentById(MessageServiceProvider.getWorkflowClient(), assignmentId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
            return false;
        }
        return assignmentInfo.getState().equals((Object)WfAssignmentState.ASSIGNED) || assignmentInfo.getState().equals((Object)WfAssignmentState.ACCEPTED);
    }

    public static void showWfDiagram(Component owner, String assignmentId) {
        UIContext uiContext = new UIContext((Object)owner);
        try {
            EASWfServiceClient workflowClient = MessageServiceProvider.getWorkflowClient();
            String procInstId = MessageServiceProvider.getAssignmentById(workflowClient, assignmentId).getProcInstId();
            MessageUtil.showWorkFlowImageByProcInstId(workflowClient, procInstId, owner);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
    }

    public static void viewMessage(Component owner, String messageId, String nodeType, String ifHistory) {
        IUIWindow uiWindow = null;
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"ID", (Object)messageId);
        try {
            if (nodeType.equals("1")) {
                uiContext.put((Object)"enableHistory", (Object)Boolean.valueOf(ifHistory));
                uiContext.put((Object)"messageType", (Object)nodeType);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(MessageHandleUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (nodeType.equals("2")) {
                uiContext.put((Object)"enableHistory", (Object)Boolean.valueOf(ifHistory));
                uiContext.put((Object)"messageType", (Object)nodeType);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(WFDisposedAssignViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            } else if (nodeType.equals("3")) {
                int noticeType = MessageServiceProvider.getNoticeType(owner, messageId, Boolean.valueOf(ifHistory));
                if (noticeType == ONLINE_NOTICE) {
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HandSendMessageUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                } else if (noticeType == COMMON_NOTICE) {
                    uiContext.put((Object)"enableHistory", (Object)Boolean.valueOf(ifHistory));
                    uiContext.put((Object)"messageType", (Object)nodeType);
                    uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MessageHandleUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                } else {
                    try {
                        CoreBaseInfo info;
                        String sourceID = "";
                        if (!Boolean.valueOf(ifHistory).booleanValue()) {
                            info = MessageUtil.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(messageId));
                            if (info.getStatus().equals((Object)MsgStatus.UNREADED)) {
                                MessageUtil.readBMCMessage((BMCMessageInfo)info);
                            }
                            sourceID = info.getSourceIDs();
                        } else {
                            info = MessageUtil.getBMCMessageHstInfo((IObjectPK)new ObjectUuidPK(messageId));
                            if (info.getStatus().equals((Object)MsgStatus.UNREADED)) {
                                MessageUtil.readBMCMessageHst((BMCMessageHistoryInfo)info);
                            }
                            sourceID = info.getSourceIDs();
                        }
                        String editUIName = MetadataUtils.getEditUIClassByBillId((String)sourceID);
                        uiContext.put((Object)"ID", (Object)sourceID);
                        uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUIName, (Map)uiContext, null, OprtState.VIEW);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Component)owner, (Throwable)e);
                    }
                }
            }
            if (uiWindow != null) {
                uiWindow.show();
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
    }

    public static void deleteMessage(Component owner, String messageId) {
        if (MessageServiceProvider.canDeleteMessage(owner, messageId)) {
            try {
                BMCMessageFactory.getRemoteInstance().delete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)messageId)));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)owner, (Throwable)e);
            }
        }
    }

    public static int getNoticeType(Component owner, String messageId, boolean ifHistory) {
        try {
            if (!ifHistory) {
                BMCMessageInfo msg = MessageUtil.getBMCMessageInfo((IObjectPK)new ObjectUuidPK(messageId));
                if (msg.getBizType().equals((Object)MsgBizType.WORKFLOW) && !StringUtils.isEmpty((String)msg.getSourceIDs())) {
                    return PASS_NOTICE;
                }
                if (msg.getType().equals((Object)MsgType.ONLINE)) {
                    return ONLINE_NOTICE;
                }
            } else {
                BMCMessageHistoryInfo hMsg = MessageUtil.getBMCMessageHstInfo((IObjectPK)new ObjectUuidPK(messageId));
                if (hMsg.getBizType().equals((Object)MsgBizType.WORKFLOW) && !StringUtils.isEmpty((String)hMsg.getSourceIDs())) {
                    return PASS_NOTICE;
                }
                if (hMsg.getType().equals((Object)MsgType.ONLINE)) {
                    return ONLINE_NOTICE;
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
        return COMMON_NOTICE;
    }

    public static boolean canDeleteMessage(Component owner, String messageId) {
        BMCMessageInfo msg;
        try {
            msg = MessageServiceProvider.getMessageById(messageId);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
            return false;
        }
        return !msg.getType().equals((Object)MsgType.TASK) || !msg.getBizType().equals((Object)MsgBizType.WORKFLOW) || !msg.getSourceStatus().equals((Object)MsgSourceStatus.ASSIGNED) && !msg.getSourceStatus().equals((Object)MsgSourceStatus.ACCEPTED);
    }

    private static EASWfServiceClient getWorkflowClient() throws Exception {
        EASWfServiceClient workflowClient = new EASWfServiceClient();
        workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        return workflowClient;
    }

    private static AssignmentInfo getAssignmentById(EASWfServiceClient workflowClient, String assignId) throws WfException {
        return workflowClient.getAssignmentById(assignId);
    }

    private static BMCMessageInfo getMessageById(String messageId) throws Exception {
        ObjectUuidPK iObjectPK = new ObjectUuidPK(BOSUuid.read((String)messageId));
        if (MessageServiceProvider.getBizInterface().exists((IObjectPK)iObjectPK)) {
            return ((IBMCMessage)MessageServiceProvider.getBizInterface()).getBMCMessageInfo((IObjectPK)iObjectPK);
        }
        BMCMessageHistoryInfo historyInfo = ((IBMCMessageHistory)MessageServiceProvider.getHistoryBizInterface()).getBMCMessageHistoryInfo((IObjectPK)iObjectPK);
        return MessageServiceProvider.historyMsgToMsg(historyInfo);
    }

    protected static BMCMessageInfo historyMsgToMsg(BMCMessageHistoryInfo hInfo) {
        if (hInfo != null) {
            BMCMessageInfo info = new BMCMessageInfo();
            info.setId(hInfo.getId());
            info.setStatus(hInfo.getStatus());
            info.setSourceStatus(hInfo.getSourceStatus());
            info.setSourceID(hInfo.getSourceID());
            info.setSourceIDs(hInfo.getSourceIDs());
            info.setBizType(hInfo.getBizType());
            info.setSender(hInfo.getSender());
            info.setBody(hInfo.getBody());
            return info;
        }
        return null;
    }

    protected static ICoreBase getBizInterface() throws Exception {
        return BMCMessageFactory.getRemoteInstance();
    }

    protected static ICoreBase getHistoryBizInterface() throws Exception {
        return BMCMessageHistoryFactory.getRemoteInstance();
    }

    public static void addNewMessage(Component owner) {
        UIContext uiContext = new UIContext((Object)owner);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HandSendMessageUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)owner, (Throwable)e);
        }
    }

    public static void setMsgUnread() {
    }

    public static void setMsgRead() {
    }

    public static void showWfDiagramByBizObjectID(Component owner, String bizObjId) throws Exception {
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(bizObjId);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!"open.running".equals(procInsts[i].getState())) continue;
            instInfo = procInsts[i];
        }
        if (instInfo == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"id", (Object)instInfo.getProcInstId());
            String className = BasicWorkFlowMonitorPanel.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    public static void showWFBillFromApplet(String sourceId) {
        Frame owner = JOptionPane.getFrameForComponent(SystemEntry.instance.getApplet());
        MessageServiceProvider.showWFBill(owner, sourceId);
    }

    public static void showWFBillFromGUI(Component owner, String sourceId) {
        MessageServiceProvider.showWFBill(owner, sourceId);
    }

    public static void showWFBill(Component owner, String sourceId) {
        String billId = "";
        try {
            if (!StringUtils.isEmpty((String)sourceId)) {
                Map exendMap = null;
                if (MessageServiceProvider.isNotAssignmentId(sourceId)) {
                    if (BOSUuid.isValid((String)sourceId, (boolean)true)) {
                        billId = sourceId;
                    }
                    if (!"".equals(billId)) {
                        MessageServiceProvider.showWFBIllByBillId(owner, billId, null, exendMap);
                    } else {
                        MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                    }
                } else {
                    IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
                    AssignmentInfo info = wfService.getAssignmentById(sourceId);
                    exendMap = wfService.getExtendedAttributesFromAssignment(sourceId);
                    if (info != null && info.getBizObjectIdArray() != null && info.getBizObjectIdArray().length > 0) {
                        billId = info.getBizObjectIdArray()[0];
                    }
                    if (!"".equals(billId)) {
                        MessageServiceProvider.showWFBIllByBillId(owner, billId, sourceId, null, exendMap);
                    } else {
                        MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                    }
                }
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }

    public static void invokePassCommentUI(String billObjectId, String msgSender) throws UIException {
        HashMap<String, String> uiContext = new HashMap<String, String>();
        IUIWindow window = null;
        uiContext.put("boid", billObjectId);
        uiContext.put("sender", msgSender);
        uiContext.put("canResize", "true");
        window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.base.multiapprove.client.PassCommentUI", uiContext, null, null, 66);
        if (window instanceof UINewFrame) {
            window.getUIObject().getUIMenuBar().setVisible(false);
        }
        window.show();
    }

    public static void invokePassCommentUI(String parameters) throws UIException {
        HashMap<String, String> uiContext = new HashMap<String, String>();
        IUIWindow window = null;
        uiContext.put("parameters", parameters);
        uiContext.put("canResize", "true");
        window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.base.multiapprove.client.PassCommentUI", uiContext, null, null, 66);
        if (window instanceof UINewFrame) {
            window.getUIObject().getUIMenuBar().setVisible(false);
        }
        window.show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showWFBIllByBillId(Component owner, String billId, String assignId, String billStatus, Map exendMap) {
        try {
            if (StringUtils.isEmpty((String)billId)) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                return;
            }
            boolean webSupportOnly = MessageUtil.isWebSupportOnly(billId);
            if (webSupportOnly) {
                String serverURL = MessageServiceProvider.getServerURL();
                IWebViewMessageFacade webViewFacade = WebViewMessageFacadeFactory.getRemoteInstance();
                String toUrl = webViewFacade.getUrlByBillID(billId);
                if (StringUtils.isEmpty((String)toUrl)) {
                    MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                    return;
                }
                if ((toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&billId=" + URLEncoder.encode(billId, "utf-8") + "&assigmentId=" + assignId : toUrl + "?billId=" + URLEncoder.encode(billId, "utf-8") + "&assigmentId=" + assignId).indexOf("pureWFBillUrl") < 0) {
                    toUrl = "/easweb/" + toUrl;
                }
                toUrl = URLEncoder.encode(toUrl, "utf-8");
                String url = serverURL + "/" + SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = MessageServiceProvider.replaceAllStr(url, "&", "^&");
                NewWinMainUI.gotoSite((String)url);
                return;
            }
            String editUIName = MetadataUtils.getEditUIClassByBillId((String)billId);
            if (StringUtils.isEmpty((String)editUIName) || editUIName.equals("com.kingdee.eas.cp.eip.cm.client.CMPublishUI") || editUIName.equals("com.kingdee.eas.cp.mc.client.DatePlanEventAuditUI") || editUIName.equals("com.kingdee.eas.hr.perf.client.NodeProcesserEditUI")) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                return;
            }
            if (StringUtils.isEmpty((String)billStatus)) {
                billStatus = OprtState.VIEW;
            }
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
            if (exendMap != null) {
                String tUIConfSolutionID;
                String string = tUIConfSolutionID = exendMap.get("UIConfSolutionID") == null ? "" : exendMap.get("UIConfSolutionID").toString();
                if (!StringUtils.isEmpty((String)tUIConfSolutionID)) {
                    uiContext.put((Object)"ConfigureID", (Object)tUIConfSolutionID);
                }
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(editUIName, (Map)uiContext, null, billStatus);
            uiWindow.show();
            return;
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showWFBIllByBillId(Component owner, String billId, String billStatus, Map exendMap) {
        try {
            if (StringUtils.isEmpty((String)billId)) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                return;
            }
            boolean webSupportOnly = MessageUtil.isWebSupportOnly(billId);
            if (webSupportOnly) {
                String serverURL = MessageServiceProvider.getServerURL();
                IWebViewMessageFacade webViewFacade = WebViewMessageFacadeFactory.getRemoteInstance();
                String toUrl = webViewFacade.getUrlByBillID(billId);
                if (StringUtils.isEmpty((String)toUrl)) {
                    MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                    return;
                }
                if ((toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&billId=" + URLEncoder.encode(billId, "utf-8") : toUrl + "?billId=" + URLEncoder.encode(billId, "utf-8")).indexOf("pureWFBillUrl") < 0) {
                    toUrl = "/easweb/" + toUrl;
                }
                toUrl = URLEncoder.encode(toUrl, "utf-8");
                String url = serverURL + "/" + SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = MessageServiceProvider.replaceAllStr(url, "&", "^&");
                NewWinMainUI.gotoSite((String)url);
                return;
            }
            String editUIName = MetadataUtils.getEditUIClassByBillId((String)billId);
            if (StringUtils.isEmpty((String)editUIName) || editUIName.equals("com.kingdee.eas.cp.eip.cm.client.CMPublishUI") || editUIName.equals("com.kingdee.eas.cp.mc.client.DatePlanEventAuditUI") || editUIName.equals("com.kingdee.eas.hr.perf.client.NodeProcesserEditUI")) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                return;
            }
            if (StringUtils.isEmpty((String)billStatus)) {
                billStatus = OprtState.VIEW;
            }
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
            if (exendMap != null) {
                String tUIConfSolutionID;
                String string = tUIConfSolutionID = exendMap.get("UIConfSolutionID") == null ? "" : exendMap.get("UIConfSolutionID").toString();
                if (!StringUtils.isEmpty((String)tUIConfSolutionID)) {
                    uiContext.put((Object)"ConfigureID", (Object)tUIConfSolutionID);
                }
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(editUIName, (Map)uiContext, null, billStatus);
            uiWindow.show();
            return;
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showWFBIllByBillId(Component owner, String billId, String billStatus) {
        try {
            if (StringUtils.isEmpty((String)billId)) {
                MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                return;
            }
            boolean webSupportOnly = MessageUtil.isWebSupportOnly(billId);
            if (webSupportOnly) {
                String serverURL = MessageServiceProvider.getServerURL();
                IWebViewMessageFacade webViewFacade = WebViewMessageFacadeFactory.getRemoteInstance();
                String toUrl = webViewFacade.getUrlByBillID(billId);
                if (StringUtils.isEmpty((String)toUrl)) {
                    MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                    return;
                }
                if ((toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&billId=" + URLEncoder.encode(billId, "utf-8") : toUrl + "?billId=" + URLEncoder.encode(billId, "utf-8")).indexOf("pureWFBillUrl") < 0) {
                    toUrl = "/easweb/" + toUrl;
                }
                toUrl = URLEncoder.encode(toUrl, "utf-8");
                String url = serverURL + "/" + SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = MessageServiceProvider.replaceAllStr(url, "&", "^&");
                NewWinMainUI.gotoSite((String)url);
                return;
            }
            String editUIName = MetadataUtils.getEditUIClassByBillId((String)billId);
            if (StringUtils.isEmpty((String)editUIName) || editUIName.equals("com.kingdee.eas.cp.eip.cm.client.CMPublishUI") || editUIName.equals("com.kingdee.eas.cp.mc.client.DatePlanEventAuditUI") || editUIName.equals("com.kingdee.eas.hr.perf.client.NodeProcesserEditUI")) {
                MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                return;
            }
            if (StringUtils.isEmpty((String)billStatus)) {
                billStatus = OprtState.VIEW;
            }
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)"ID", (Object)billId);
            uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(editUIName, (Map)uiContext, null, billStatus);
            uiWindow.show();
            return;
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }

    private static String getServerURL() {
        return MessageUtil.getEasWebServerURL();
    }

    private static String replaceAllStr(String strSource, String strFrom, String strTo) {
        int intPos;
        if (strFrom == null || strFrom.equals("")) {
            return strSource;
        }
        String strDest = "";
        int intFromLen = strFrom.length();
        while ((intPos = strSource.indexOf(strFrom)) != -1) {
            strDest = strDest + strSource.substring(0, intPos);
            strDest = strDest + strTo;
            strSource = strSource.substring(intPos + intFromLen);
        }
        strDest = strDest + strSource;
        return strDest;
    }

    public static void showAuditResult(Component owner, String sourceId) {
        try {
            if (!StringUtils.isEmpty((String)sourceId)) {
                IEnactmentService wfService = EnactmentServiceFactory.createRemoteEnactService();
                AssignmentInfo info = wfService.getAssignmentById(sourceId);
                info.getBizObjectIdArray();
                if (info != null && info.getBizObjectIdArray() != null && info.getBizObjectIdArray().length > 0) {
                    MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)info.getBizObjectIdArray()[0]), (String)UIModelDialogFactory.class.getName(), (Object)owner);
                } else {
                    MsgBox.showWarning((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"noBillOrDeleted"));
                }
            }
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }

    public static void delayRefresh(Object obj) {
        if (obj != null && obj instanceof MessageCenterUI) {
            ((MessageCenterUI)((Object)obj)).delayRefresh();
        }
        try {
            MainFrameCallBack.callWebRefresh((String)"refreshMsg");
        }
        catch (Exception e) {
            logger.error((Object)"refreshMsg", (Throwable)e);
        }
    }

    public static void viewConfigMessage(Component owner, String parameter, HashMap map) throws Exception {
        String isModel = "false";
        if (!MessageUtil.isValueEmpty(map.get("viewgui"))) {
            Map viewMap = (Map)map.get("viewgui");
            if (!MessageUtil.isValueEmpty(viewMap.get("model"))) {
                isModel = viewMap.get("model").toString();
            }
            if (!MessageUtil.isValueEmpty(viewMap.get("websupport")) && viewMap.get("websupport").toString().equalsIgnoreCase("true")) {
                String appName = viewMap.get("easappname").toString();
                String url = map.get("gui").toString();
                try {
                    MessageServiceProvider.viewMessageByWeb(appName, url, parameter);
                }
                catch (Exception e) {
                    logger.error((Object)("viewConfigMessage:view message on web failed>>>>" + e), (Throwable)e);
                    throw e;
                }
            } else {
                String uiName = viewMap.get("gui").toString();
                MessageServiceProvider.viewMessageByGUI(owner, parameter, isModel, uiName);
            }
        } else {
            isModel = map.get("model").toString();
            String uiName = map.get("gui").toString();
            MessageServiceProvider.viewMessageByGUI(owner, parameter, isModel, uiName);
        }
    }

    public static void viewMessageByGUI(Component owner, String parameter, String isModel, String uiName) throws UIException {
        IUIWindow window = null;
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"parameters", (Object)parameter);
        window = isModel.equalsIgnoreCase("true") ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, null, 66) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiName, (Map)uiContext, null, null, 66);
        if (window instanceof UINewFrame) {
            window.getUIObject().getUIMenuBar().setVisible(false);
        }
        window.show();
    }

    public static void viewMessageByWeb(String appName, String toUrl, String sourceIds) throws Exception {
        String serverURL = System.getProperty("UPDATE_SERVER_ADDR");
        serverURL = StringUtils.isEmpty((String)serverURL) ? "http://localhost:6888" : "http://" + serverURL;
        if (!StringUtils.isEmpty((String)toUrl)) {
            toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&parameters=" + URLEncoder.encode(sourceIds, "utf-8") : toUrl + "?parameters=" + URLEncoder.encode(sourceIds, "utf-8");
            String url = "";
            if (appName.equalsIgnoreCase(EASWEB_NAME)) {
                url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, false, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = serverURL + EASWEB_PATH + toUrl + url;
            } else if (appName.equalsIgnoreCase(EASPORTAL_NAME)) {
                url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                url = serverURL + EASPORTAL_PATH + "/" + url;
            }
            url = MessageServiceProvider.replaceAllStr(url, "&", "^&");
            NewWinMainUI.gotoSite((String)url);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void showConfigBill(Component owner, String sourceIds) throws UIException {
        try {
            String prefix = sourceIds.substring(0, sourceIds.indexOf("::"));
            Object configObj = MessageViewConfig.getInstance(false).getConfigByPrefix(prefix);
            if (configObj == null) {
                MsgBox.showInfo((Component)owner, (String)("the message that prefix is " + prefix + "is not set in the config of messageViewConfig.xml"));
                return;
            }
            Map map = (Map)configObj;
            if (MessageUtil.isValueEmpty(map.get("billgui"))) {
                MsgBox.showInfo((Component)owner, (String)("the message that prefix is " + prefix + "is set wrongly in the config of messageViewConfig.xml"));
                return;
            }
            Map billMap = (Map)map.get("billgui");
            Object websupportObj = billMap.get("websupport");
            if (websupportObj != null && !StringUtils.isEmpty((String)websupportObj.toString()) && websupportObj.toString().equalsIgnoreCase("true")) {
                String toUrl = billMap.get("billgui").toString();
                String appName = billMap.get("easappname").toString();
                String serverURL = System.getProperty("UPDATE_SERVER_ADDR");
                serverURL = StringUtils.isEmpty((String)serverURL) ? "http://localhost:6888" : "http://" + serverURL;
                if (StringUtils.isEmpty((String)toUrl)) {
                    MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"can.not.surrport.open"));
                    return;
                }
                toUrl = toUrl.indexOf("?") > 0 ? toUrl + "&parameters=" + URLEncoder.encode(sourceIds, "utf-8") : toUrl + "?parameters=" + URLEncoder.encode(sourceIds, "utf-8");
                String url = "";
                if (appName.equalsIgnoreCase(EASWEB_NAME)) {
                    url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, false, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                    url = serverURL + EASWEB_PATH + toUrl + url;
                } else if (appName.equalsIgnoreCase(EASPORTAL_NAME)) {
                    url = SSOHandleFacadeFactory.getRemoteInstance().getGUItoPortalUrl(toUrl, true, SysContext.getSysContext().getLocale().toString(), SysContext.getSysContext().getDCNumber());
                    url = serverURL + EASPORTAL_PATH + "/" + url;
                }
                url = MessageServiceProvider.replaceAllStr(url, "&", "^&");
                NewWinMainUI.gotoSite((String)url);
                return;
            }
            String billGuiPath = billMap.get("billgui").toString();
            UIContext uiContext = new UIContext((Object)owner);
            uiContext.put((Object)UICONTEXT_ISFROMWORKFLOW, (Object)new Boolean(true));
            uiContext.put((Object)"ID", (Object)sourceIds);
            uiContext.put((Object)"parameters", (Object)sourceIds);
            IUIWindow window = null;
            window = map.get("model").toString().equalsIgnoreCase("true") ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(billGuiPath, (Map)uiContext, null, OprtState.VIEW) : UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(billGuiPath, (Map)uiContext, null, OprtState.VIEW);
            if (window instanceof UINewFrame) {
                window.getUIObject().getUIMenuBar().setVisible(false);
            }
            window.show();
            return;
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"showBillFailure"), (Throwable)e1);
        }
    }
}

