/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.AssignDetailFactory;
import com.kingdee.bos.workflow.metas.AssignDetailInfo;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignHstFactory;
import com.kingdee.bos.workflow.metas.AssignHstInfo;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.bos.workflow.metas.IAssignDetail;
import com.kingdee.bos.workflow.metas.IAssignHst;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryFactory;
import com.kingdee.eas.base.message.BMCMessageHistoryInfo;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.IBMCMessage;
import com.kingdee.eas.base.message.IBMCMessageHistory;
import com.kingdee.eas.base.message.IMessageCenter;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.MessageViewConfig;
import com.kingdee.eas.base.message.MsgSourceStatus;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.client.MessageServiceProvider;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MessageUtil {
    private static Logger logger = Logger.getLogger(MessageUtil.class);
    private static final String resName = "com.kingdee.eas.base.message.client.MessageCenter";
    public static final String MESSAGETYPE_KEY = "messageType";
    public static final String ENABLEHISTORY = "enableHistory";
    public static final String UNDISPOSETASK = "1";
    public static final String DISPOSEDTASKNODE = "2";
    public static final String NOTICE = "3";
    public static final String OTHERSYS = "10";
    public static final String DELEGATE = "4";
    public static final String ISTRANSMITMSG = "ISTRANSMITMSG";
    public static final String ISREPLYMSG = "ISREPLYMSG";
    public static final String ISSENDVIEW = "ISSENDVIEW";

    protected static void acceptAssignment(EASWfServiceClient workflowClient, String assignmentId) throws Exception {
    }

    protected static void rollbackAssignment(EASWfServiceClient workflowClient, String assignmentId) throws WfException {
        AssignmentInfo assignmentInfo = workflowClient.getAssignmentById(assignmentId);
        workflowClient.rollbackActInst(assignmentInfo.getActInstId());
    }

    protected static AssignmentInfo forwardAssignment(EASWfServiceClient workflowClient, String assignmentId, String destUserId) throws Exception {
        MessageUtil.acceptAssignment(workflowClient, assignmentId);
        return workflowClient.forwardAssignment(assignmentId, destUserId, null);
    }

    protected static AssignmentInfo forwardAssignmentWithOpinion(EASWfServiceClient workflowClient, String assignmentId, String destUserId, HashMap opinonMap) throws Exception {
        MessageUtil.acceptAssignment(workflowClient, assignmentId);
        return EnactmentServiceFactory.createRemoteEnactService().forwardAssignment(assignmentId, destUserId, (Map)opinonMap);
    }

    protected static AssignmentInfo getAssignmentById(EASWfServiceClient workflowClient, String assignId) throws Exception {
        return workflowClient.getAssignmentById(assignId);
    }

    protected static void rejectAssignment(EASWfServiceClient workflowClient, String assignmentId) throws Exception {
        MessageUtil.acceptAssignment(workflowClient, assignmentId);
        workflowClient.rejectAssignment(assignmentId);
    }

    protected static AssignmentInfo[] getAssignmentsByOneAssID(EASWfServiceClient workflowClient, String assignmentId) throws Exception {
        AssignInfo assignInfo = AssignFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(assignmentId));
        return workflowClient.getAssignmentByActInstId(assignInfo.getActInstID().toString(), WfAssignmentState.ASSIGNED);
    }

    protected static void showBusinessUI(EASWfServiceClient workflowClient, String assignmentId, Object owner) throws Exception {
        MessageUtil.acceptAssignment(workflowClient, assignmentId);
        workflowClient.invokeUI(new String[]{assignmentId}, owner);
    }

    protected static boolean showBusinessUINew(EASWfServiceClient workflowClient, String assignmentId, Object owner) throws Exception {
        MessageUtil.acceptAssignment(workflowClient, assignmentId);
        return workflowClient.invokeUI(new String[]{assignmentId}, owner);
    }

    public static void showWorkFlowImage(EASWfServiceClient workflowClient, String assignmentId, Object owner) throws Exception {
        MessageUtil.showWorkFlowImageByProcInstId(workflowClient, MessageUtil.getAssignmentById(workflowClient, assignmentId).getProcInstId(), owner);
    }

    protected static void showWorkFlowImageByProcInstId(EASWfServiceClient workflowClient, String procInstId, Object owner) throws Exception {
        UIContext uiContext = new UIContext(owner);
        uiContext.put((Object)"id", (Object)procInstId);
        String className = BasicWorkFlowMonitorPanel.class.getName();
        uiContext.put((Object)"OpenAsNewWin", (Object)"");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext);
        UINewFrame frame = (UINewFrame)uiWindow;
        frame.getStatusBar().setVisible(false);
        frame.getJMenuBar().setVisible(false);
        frame.setExtendedState(6);
        uiWindow.show();
    }

    protected static void showForewarnUI(String forewarnID) throws Exception {
    }

    protected static void removeFromToobar(KDToolBar parent, Component remove) {
        if (remove != null && remove.getParent() == parent) {
            parent.remove(remove);
        }
    }

    protected static boolean canAccepted(EASWfServiceClient workflowClient, String assignmentId) throws Exception {
        return MessageUtil.getAssignmentById(workflowClient, assignmentId).getState().equals((Object)WfAssignmentState.ASSIGNED);
    }

    protected static MsgSourceStatus getSourceStatus(EASWfServiceClient workflowClient, String assignmentId) throws Exception {
        Object msgSourceStatus = null;
        WfAssignmentState state = MessageUtil.getAssignmentById(workflowClient, assignmentId).getState();
        return MsgSourceStatus.getEnum(state.getValue());
    }

    protected static void repaintToolbar(KDToolBar toolBar) {
        toolBar.invalidate();
        if (toolBar.getParent() != null) {
            toolBar.getParent().validate();
        }
    }

    public static IAssignRead getAssinReadBizInterface() throws Exception {
        return AssignReadFactory.getRemoteInstance();
    }

    public static IAssignDetail getAssinDetailBizInterface() throws Exception {
        return AssignDetailFactory.getRemoteInstance();
    }

    public static IAssign getAssinBizInterface() throws Exception {
        return AssignFactory.getRemoteInstance();
    }

    public static IAssignHst getAssinHstBizInterface() throws Exception {
        return AssignHstFactory.getRemoteInstance();
    }

    public static IBMCMessage getBMCMessageBizInterface() throws Exception {
        return BMCMessageFactory.getRemoteInstance();
    }

    public static IBMCMessageHistory getBMCMessageHstBizInterface() throws Exception {
        return BMCMessageHistoryFactory.getRemoteInstance();
    }

    public static AssignReadInfo getAssignReadInfo(IObjectPK iObjectPK) throws Exception {
        IAssignRead iAssignRead = MessageUtil.getAssinReadBizInterface();
        if (iAssignRead.exists(iObjectPK)) {
            return iAssignRead.getAssignReadInfo(iObjectPK);
        }
        return null;
    }

    public static AssignInfo getAssignInfo(IObjectPK iObjectPK) throws Exception {
        IAssign iAssign = MessageUtil.getAssinBizInterface();
        if (iAssign.exists(iObjectPK)) {
            return iAssign.getValue(iObjectPK);
        }
        return null;
    }

    public static AssignHstInfo getAssignHstInfo(IObjectPK iObjectPK) throws Exception {
        IAssignHst iAssignHst = MessageUtil.getAssinHstBizInterface();
        if (iAssignHst.exists(iObjectPK)) {
            return iAssignHst.getValue(iObjectPK);
        }
        return null;
    }

    public static AssignDetailInfo getAssignDetailInfo(IObjectPK iObjectPK) throws Exception {
        IAssignDetail iAssignDetail = MessageUtil.getAssinDetailBizInterface();
        if (iAssignDetail.exists(iObjectPK)) {
            return iAssignDetail.getValue(iObjectPK);
        }
        return null;
    }

    public static BMCMessageInfo getBMCMessageInfo(IObjectPK iObjectPK) throws Exception {
        IBMCMessage iBMCMessage = MessageUtil.getBMCMessageBizInterface();
        if (iBMCMessage.exists(iObjectPK)) {
            return iBMCMessage.getBMCMessageInfo(iObjectPK);
        }
        return null;
    }

    public static BMCMessageHistoryInfo getBMCMessageHstInfo(IObjectPK iObjectPK) throws Exception {
        IBMCMessageHistory iBMCMessageHst = MessageUtil.getBMCMessageHstBizInterface();
        if (iBMCMessageHst.exists(iObjectPK)) {
            return iBMCMessageHst.getBMCMessageHistoryInfo(iObjectPK);
        }
        return null;
    }

    public static void readBMCMessage(BMCMessageInfo info) throws Exception {
        info.setStatus(MsgStatus.READED);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        MessageUtil.getBMCMessageBizInterface().updatePartial(info, selectors);
    }

    public static void readBMCMessageHst(BMCMessageHistoryInfo info) throws Exception {
        info.setStatus(MsgStatus.READED);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        MessageUtil.getBMCMessageHstBizInterface().updatePartial(info, selectors);
    }

    public static void readAssignRead(AssignReadInfo info) throws Exception {
        info.setStatus(MsgStatus.READED);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("status"));
        MessageUtil.getAssinReadBizInterface().updatePartial(info, selectors);
    }

    public static void readAssignRead(String messageId) throws Exception {
        AssignReadInfo info;
        if (!StringUtils.isEmpty((String)messageId) && (info = MessageUtil.getAssignReadInfo((IObjectPK)new ObjectUuidPK(messageId))) != null) {
            info.setStatus(MsgStatus.READED);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("status"));
            MessageUtil.getAssinReadBizInterface().updatePartial(info, selectors);
        }
    }

    public void showWFImage(String id) {
        MessageServiceProvider.showWfDiagram(this.getFrame(), id);
    }

    protected Frame getFrame() {
        return JOptionPane.getFrameForComponent(SystemEntry.instance.getApplet());
    }

    public static boolean isWFAMessage(BMCMessageInfo msg) {
        if (msg.getType().equals((Object)MsgType.NOTICE)) {
            String sourceIds = msg.getSourceIDs();
            return sourceIds != null && sourceIds.startsWith("|");
        }
        return false;
    }

    public static String getWFAMsgPart(BMCMessageInfo msg, int part) {
        if (part > 2 || !MessageUtil.isWFAMessage(msg)) {
            return null;
        }
        String sourceIds = msg.getSourceIDs().substring(1);
        String[] ids = sourceIds.split("\\|");
        if (ids.length <= part) {
            return null;
        }
        return ids[part];
    }

    public static boolean isWebSupportOnly(String billId) {
        boolean webOnly = false;
        BOSUuid id = BOSUuid.read((String)billId);
        BOSObjectType type = id.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo vo = loader.getEntity(type);
        String webSupportOnly = vo.getExtendedProperty("webSupportOnly");
        if (!StringUtils.isEmpty((String)webSupportOnly)) {
            webOnly = Boolean.valueOf(webSupportOnly);
        }
        return webOnly;
    }

    public static String getAuditResult(String sourceId, boolean isHst) throws Exception {
        StringBuffer auditBody = new StringBuffer("\n\n");
        IMessageCenter iMessage = MessageCenterFactory.getRemoteInstance();
        String[] auditRes = iMessage.getAuditResult(sourceId, isHst);
        if (!StringUtils.isEmpty((String)auditRes[0])) {
            auditBody.append(EASResource.getString((String)resName, (String)"auditresult")).append(": ");
            if (auditRes[0].equals("true")) {
                auditBody.append(EASResource.getString((String)resName, (String)"agree"));
            } else {
                auditBody.append(EASResource.getString((String)resName, (String)"notagree"));
            }
            auditBody.append("\n");
        }
        if (!StringUtils.isEmpty((String)auditRes[1])) {
            auditBody.append(EASResource.getString((String)resName, (String)"auditperson")).append(": ");
            auditBody.append(auditRes[1]);
            auditBody.append("\n");
        }
        if (!StringUtils.isEmpty((String)auditRes[2])) {
            auditBody.append(EASResource.getString((String)resName, (String)"auditopinion")).append(": ");
            auditBody.append(auditRes[2]);
            auditBody.append("\n");
        }
        return auditBody.toString();
    }

    public static boolean isValueEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            String temp = o.toString();
            return StringUtils.isEmpty((String)temp);
        }
        if (o instanceof Map) {
            Map temp = (Map)o;
            return temp == null || temp.isEmpty();
        }
        if (o instanceof List) {
            List temp = (List)o;
            return temp == null || temp.isEmpty();
        }
        if (o instanceof Set) {
            Set temp = (Set)o;
            return temp == null || temp.isEmpty();
        }
        return false;
    }

    public static boolean ifShowBillBtn(String sourceIDs) {
        if (!StringUtils.isEmpty((String)sourceIDs)) {
            String prefix = sourceIDs.substring(0, sourceIDs.indexOf("::"));
            Object configObj = MessageViewConfig.getInstance(false).getConfigByPrefix(prefix);
            if (configObj != null) {
                Map map = (Map)configObj;
                return !MessageUtil.isValueEmpty(map.get("billgui"));
            }
            return false;
        }
        return false;
    }

    public static String getAssignStateByMsgId(BMCMessageInfo info) {
        String assignId = "";
        MsgSourceStatus msgState = null;
        WfAssignmentState assignState = null;
        IBMCMessage iBmc = null;
        try {
            iBmc = BMCMessageFactory.getRemoteInstance();
        }
        catch (Exception e) {
            logger.error((Object)("BMCMessageFactory.getRemoteInstance\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        msgState = info.getSourceStatus();
        int msgStateVal = msgState.getValue();
        assignId = info.getSourceID();
        IEnactmentService iService = null;
        try {
            iService = EnactmentServiceFactory.createRemoteEnactService();
        }
        catch (BOSException e) {
            logger.error((Object)("\u53d6IEnactmentService\u63a5\u53e3\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        AssignmentInfo assignInfo = null;
        try {
            assignInfo = iService.getAssignmentById(assignId);
        }
        catch (WfException e) {
            logger.error((Object)("IEnactmentService.getAssignmentById\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            return "";
        }
        assignState = assignInfo.getState();
        int assignStateVal = assignState.getValue();
        if (assignStateVal != msgStateVal) {
            if (assignState.equals((Object)WfAssignmentState.ACCEPTED)) {
                info.setSourceStatus(MsgSourceStatus.ACCEPTED);
            } else if (assignState.equals((Object)WfAssignmentState.ASSIGNED)) {
                info.setSourceStatus(MsgSourceStatus.ASSIGNED);
            } else if (assignState.equals((Object)WfAssignmentState.CANCELED)) {
                info.setSourceStatus(MsgSourceStatus.CANCELED);
            } else if (assignState.equals((Object)WfAssignmentState.COMPLETED)) {
                info.setSourceStatus(MsgSourceStatus.COMPLETED);
            } else if (assignState.equals((Object)WfAssignmentState.REJECTED)) {
                info.setSourceStatus(MsgSourceStatus.REJECTED);
            } else {
                info.setSourceStatus(MsgSourceStatus.EMPTY);
            }
            try {
                iBmc.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
            }
            catch (Exception e) {
                logger.error((Object)("\u66f4\u65b0\u6d88\u606f\u7684\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a" + e.getMessage()), (Throwable)e);
            }
            msgState = info.getSourceStatus();
        }
        return msgState.getName();
    }

    public static String getEasWebServerURL() {
        String serverURL = System.getProperty("EASPORTAL_ROOT");
        String rpcURL = System.getProperty("EAS_SERVER");
        if (StringUtils.isEmpty((String)serverURL)) {
            serverURL = "http://localhost:6888/portal";
        } else {
            int index = serverURL.indexOf("/easportal");
            if (index > 0) {
                serverURL = serverURL.substring(0, index) + "/portal";
            }
        }
        if (!StringUtils.isEmpty((String)rpcURL) && rpcURL.indexOf("https") > -1) {
            serverURL = serverURL.replace("http", "https");
        } else {
            String isHttps = System.getProperty("IS_HTTPS");
            if (Boolean.valueOf(isHttps).booleanValue()) {
                serverURL = serverURL.replace("http", "https");
            }
        }
        return serverURL;
    }
}

