/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.IOtherSysTreeNode;
import com.kingdee.eas.base.message.OtherSysTreeNodeCollection;
import com.kingdee.eas.base.message.OtherSysTreeNodeFactory;
import com.kingdee.eas.base.message.OtherSysTreeNodeInfo;
import com.kingdee.eas.base.message.TreeNodeUseStateEnum;
import com.kingdee.eas.base.message.client.AbstractOtherSysNodeControllerUI;
import com.kingdee.eas.base.message.client.OtherSysNodeEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OtherSysNodeControllerUI
extends AbstractOtherSysNodeControllerUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherSysNodeControllerUI.class);
    private static final String RESOURCE = "com.kingdee.eas.base.message.OtherSysTreeNodeResource";
    private DefaultKingdeeTreeNode rootNode;
    private HashMap nodeMap = new HashMap();
    private boolean isTableAction = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        if (this.queryOtherSysNodeQuery == null) {
            this.queryOtherSysNodeQuery = new EntityViewInfo();
            super.setDataObject((IObjectValue)this.queryOtherSysNodeQuery);
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        this.kdtQueryOtherSysNodeQuery.getSelectManager().setSelectMode(2);
    }

    private void initUI() throws Exception {
        this.btnExit.setVisible(false);
        this.iniController();
        this.iniTree();
        this.initOthers();
    }

    private void iniController() {
        this.btnAddNew.setEnabled(true);
        this.btnEdit.setEnabled(true);
        this.btnView.setEnabled(true);
        this.btnDelete.setEnabled(true);
        this.btnSearch.setEnabled(true);
        this.btnInUse.setEnabled(true);
        this.btnUnUse.setEnabled(true);
        this.btnRefresh.setEnabled(true);
        this.btnGroupAddNew.setVisible(false);
        this.btnGroupEdit.setVisible(false);
        this.btnGroupRemove.setVisible(false);
        this.btnGroupView.setVisible(false);
    }

    private void initOthers() {
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null && !OtherSysNodeControllerUI.this.isTableAction) {
                    DefaultKingdeeTreeNode object = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    NodeObject no = (NodeObject)object.getUserObject();
                    String id = no.getID();
                    try {
                        OtherSysNodeControllerUI.this.childNodeData(id);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"\u67e5\u8be2\u5b50\u8282\u70b9\u6570\u636e\u65f6\u51fa\u9519", (Throwable)exception);
                    }
                }
            }
        });
        this.mainTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OtherSysNodeControllerUI.this.isTableAction = false;
            }
        });
        this.kdtQueryOtherSysNodeQuery.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock sb = e.getSelectBlock();
                if (sb != null) {
                    IRow row = OtherSysNodeControllerUI.this.kdtQueryOtherSysNodeQuery.getRow(sb.getTop());
                    String id = (String)row.getCell("id").getValue();
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)OtherSysNodeControllerUI.this.nodeMap.get(id);
                    OtherSysNodeControllerUI.this.isTableAction = true;
                    OtherSysNodeControllerUI.this.mainTree.setSelectionNode(node);
                }
            }
        });
    }

    private void iniTree() throws Exception {
        int count = 0;
        OtherSysTreeNodeCollection collection = null;
        OtherSysTreeNodeInfo nodeInfo = null;
        this.rootNode = this.createRootNode();
        IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
        count = iostn.getOtherSysNodeCount();
        if (count > 0) {
            collection = (OtherSysTreeNodeCollection)iostn.getOtherSysNodeColl();
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                nodeInfo = (OtherSysTreeNodeInfo)iter.next();
                DefaultKingdeeTreeNode node = this.createNode(nodeInfo.getId().toString(), nodeInfo.getName(), nodeInfo.getFilter(), nodeInfo.getSysName(), nodeInfo.getSysID(), nodeInfo.getSuperiorID(), nodeInfo.getInUse(), nodeInfo.isChildNode());
                this.nodeMap.put(nodeInfo.getId().toString(), node);
            }
            iter = collection.iterator();
            while (iter.hasNext()) {
                nodeInfo = (OtherSysTreeNodeInfo)iter.next();
                DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)this.nodeMap.get(nodeInfo.getSuperiorID());
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.nodeMap.get(nodeInfo.getId().toString());
                parentNode.add((MutableTreeNode)childNode);
            }
        }
        this.mainTree.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)this.mainTree.getModel().getRoot()));
        this.mainTree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)this.rootNode));
        this.mainTree.getSelectionModel().setSelectionMode(1);
    }

    private DefaultKingdeeTreeNode createRootNode() {
        NodeObject nodeObject = new NodeObject();
        nodeObject.setID("/KORLgEUEADgAAAHwKgS4soJlqk=");
        nodeObject.setDisplayText(EASResource.getString((String)RESOURCE, (String)"otherSysNode"));
        nodeObject.setTitle(EASResource.getString((String)RESOURCE, (String)"otherSysNode"));
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)nodeObject);
        this.nodeMap.put(nodeObject.getID(), treeNode);
        return treeNode;
    }

    private DefaultKingdeeTreeNode createNode(String ID, String name, String filter, String sysName, String sysID, String superiorID, TreeNodeUseStateEnum inUse, boolean childNode) {
        NodeObject nodeObject = new NodeObject();
        nodeObject.setID(ID);
        nodeObject.setDisplayText(name);
        nodeObject.setFilter(filter);
        nodeObject.setSysName(sysName);
        nodeObject.setSysID(sysID);
        nodeObject.setInUse(inUse);
        nodeObject.setChildNode(childNode);
        nodeObject.setSuperiorID(superiorID);
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)nodeObject);
        this.nodeMap.put(nodeObject.getID(), treeNode);
        return treeNode;
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        if (object == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        NodeObject nodeObject = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
        uiContext.put((Object)"parent", object);
        uiContext.put((Object)"parentID", (Object)nodeObject.getID());
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OtherSysNodeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.freshAll();
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        IOtherSysTreeNode iostn = null;
        OtherSysTreeNodeInfo info = null;
        if (object != null) {
            NodeObject nodeObject = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
            String id = nodeObject.getID();
            if (id.equals("/KORLgEUEADgAAAHwKgS4soJlqk=")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sysNode"));
            } else {
                ObjectUuidPK pk = new ObjectUuidPK(id);
                iostn = OtherSysTreeNodeFactory.getRemoteInstance();
                info = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)pk);
                boolean flag = OtherSysTreeNodeFactory.getRemoteInstance().hasChildNode(info.getId().toString());
                if (flag) {
                    if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deleteConfierm")))) {
                        iostn.delete((IObjectPK)pk);
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"deleteSuccess"));
                        this.freshAll();
                    }
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"haveChild"));
                }
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        if (object != null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = null;
            NodeObject nodeObject = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
            if ("/KORLgEUEADgAAAHwKgS4soJlqk=".equals(nodeObject.getID())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sysNodeCanNotEdit"));
            } else {
                uiContext.put((Object)"node", object);
                uiContext.put((Object)"nodeID", (Object)nodeObject.getID());
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OtherSysNodeEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
                uiWindow.show();
                this.fresh();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
        this.freshAll();
    }

    @Override
    public void actionInUse_actionPerformed(ActionEvent e) throws Exception {
        super.actionInUse_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        if (object == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
        NodeObject no = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
        if (object != null) {
            String id = no.getID();
            IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
            OtherSysTreeNodeInfo childInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
            if (childInfo.getSuperiorID().equals("0000000000")) {
                iostn.updateNodeUseState(1, id);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InUseSuccess"));
                this.fresh();
            } else {
                OtherSysTreeNodeInfo parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(childInfo.getSuperiorID()));
                if (parentInfo.getInUse() == TreeNodeUseStateEnum.UNUSE) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"parentIsUnUse"));
                }
                if (parentInfo.getInUse() == TreeNodeUseStateEnum.INUSE) {
                    iostn.updateNodeUseState(1, id);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"InUseSuccess"));
                    this.fresh();
                }
            }
        }
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo result;
        super.actionSearch_actionPerformed(e);
        CommonQueryDialog classSetdlg = new CommonQueryDialog();
        classSetdlg.setOwner((Component)((Object)this));
        classSetdlg.setShowSorter(false);
        classSetdlg.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        classSetdlg.setQueryObjectPK(this.queryOtherSysNodeQueryPK);
        classSetdlg.setTitle(EASResource.getString((String)RESOURCE, (String)"otherSysNode"));
        classSetdlg.setShowToolbar(false);
        if (classSetdlg.show() && (result = classSetdlg.getEntityViewInfoResult()) != null) {
            if (this.queryOtherSysNodeQuery.getFilter() == null) {
                this.queryOtherSysNodeQuery = result;
            } else {
                FilterInfo newFilterInfo = result.getFilter();
                this.queryOtherSysNodeQuery.getFilter().mergeFilter(newFilterInfo, "AND");
                this.fresh();
            }
        }
    }

    @Override
    public void actionUnUse_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnUse_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        if (object == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
        NodeObject no = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
        if (object != null) {
            String id = no.getID();
            IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
            OtherSysTreeNodeInfo parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
            if (parentInfo.isChildNode()) {
                iostn.updateNodeUseState(0, id);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"UnUseSuccess"));
                this.fresh();
            } else {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterItemInfo itemInfo1 = new FilterItemInfo("superiorID", (Object)parentInfo.getId().toString());
                FilterItemInfo itemInfo2 = new FilterItemInfo("inUse", (Object)new Integer(1), CompareType.EQUALS);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(itemInfo1);
                filterInfo.getFilterItems().add(itemInfo2);
                filterInfo.setMaskString("#0 and #1");
                entityViewInfo.setFilter(filterInfo);
                IQueryExecutor exec = this.getQueryExecutor(this.queryOtherSysNodeQueryPK, entityViewInfo);
                if (exec.getRowCount() > 0) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"childIsInUse"));
                } else {
                    iostn.updateNodeUseState(0, id);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"UnUseSuccess"));
                    this.fresh();
                }
            }
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        Object object = this.mainTree.getLastSelectedPathComponent();
        if (object != null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow uiWindow = null;
            NodeObject nodeObject = (NodeObject)((DefaultKingdeeTreeNode)object).getUserObject();
            if ("/KORLgEUEADgAAAHwKgS4soJlqk=".equals(nodeObject.getID())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"sysNodeCanNotEdit"));
            } else {
                uiContext.put((Object)"node", object);
                uiContext.put((Object)"nodeID", (Object)nodeObject.getID());
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OtherSysNodeEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
                this.fresh();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"checkSelect"));
            return;
        }
        this.freshAll();
    }

    @Override
    public void actionFresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionFresh_actionPerformed(e);
        this.fresh();
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupAddNew_actionPerformed(e);
        logger.info((Object)"1111111111111111");
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
        logger.info((Object)"22222222222222222222");
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupEdit_actionPerformed(e);
        logger.info((Object)"33333333333333333333");
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupRemove_actionPerformed(e);
        logger.info((Object)"4444444444444444444444444444");
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private void fresh() throws Exception {
        this.kdtQueryOtherSysNodeQuery.repaint();
        this.kdtQueryOtherSysNodeQuery.removeRows();
        this.kdtQueryOtherSysNodeQuery.getSelectManager().setSelectMode(2);
    }

    @Override
    protected void kdtQueryOtherSysNodeQuery_doRequestRowSet(RequestRowSetEvent e) {
        if (this.queryOtherSysNodeQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.queryOtherSysNodeQueryPK, this.queryOtherSysNodeQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
                this.kdtQueryOtherSysNodeQuery.getSelectManager().setSelectMode(2);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    protected void childNodeData(String ID) throws Exception {
        FilterItemInfo itemInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        itemInfo = new FilterItemInfo("superiorID", (Object)ID, CompareType.EQUALS);
        filterInfo.getFilterItems().add(itemInfo);
        itemInfo = new FilterItemInfo("id", (Object)ID, CompareType.EQUALS);
        filterInfo.getFilterItems().add(itemInfo);
        filterInfo.setMaskString("#0 or #1");
        if (this.queryOtherSysNodeQuery.getFilter() != null) {
            this.queryOtherSysNodeQuery.getSorter().clear();
        }
        this.queryOtherSysNodeQuery.setFilter(filterInfo);
        this.fresh();
    }

    private void freshAll() throws Exception {
        this.iniTree();
        this.kdtQueryOtherSysNodeQuery.repaint();
        this.kdtQueryOtherSysNodeQuery.removeRows();
        this.kdtQueryOtherSysNodeQuery.getSelectManager().setSelectMode(2);
    }

    class NodeObject {
        private String ID;
        private String displayText;
        private String filter;
        private String title;
        private String sysName;
        private String sysID;
        private String superiorID;
        private TreeNodeUseStateEnum inUse;
        private boolean childNode;

        NodeObject() {
        }

        public String getDisplayText() {
            return this.displayText;
        }

        public void setDisplayText(String displayText) {
            this.displayText = displayText;
        }

        public String getID() {
            return this.ID;
        }

        public void setID(String id) {
            this.ID = id;
        }

        public String toString() {
            return this.displayText;
        }

        public boolean isChildNode() {
            return this.childNode;
        }

        public void setChildNode(boolean childNode) {
            this.childNode = childNode;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public TreeNodeUseStateEnum isInUse() {
            return this.inUse;
        }

        public void setInUse(TreeNodeUseStateEnum inUse) {
            this.inUse = inUse;
        }

        public String getSysID() {
            return this.sysID;
        }

        public void setSysID(String sysID) {
            this.sysID = sysID;
        }

        public String getSysName() {
            return this.sysName;
        }

        public void setSysName(String sysName) {
            this.sysName = sysName;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getSuperiorID() {
            return this.superiorID;
        }

        public void setSuperiorID(String superiorID) {
            this.superiorID = superiorID;
        }
    }
}

