/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.message.IOtherSysTreeNode;
import com.kingdee.eas.base.message.IWebServiceMessage;
import com.kingdee.eas.base.message.OtherSysTreeNodeFactory;
import com.kingdee.eas.base.message.OtherSysTreeNodeInfo;
import com.kingdee.eas.base.message.TreeNodeUseStateEnum;
import com.kingdee.eas.base.message.WebServiceMessageFactory;
import com.kingdee.eas.base.message.client.AbstractOtherSysNodeEditUI;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OtherSysNodeEditUI
extends AbstractOtherSysNodeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OtherSysNodeEditUI.class);
    private Locale locale;
    private List sysIDList = new LinkedList();
    private List sysNameList = new LinkedList();
    private String filter;
    private String parentID;
    public boolean sucess;
    private String classFilter = "";
    private boolean alerm = false;
    private String nodeID = "";
    private String RESOURCE = "com.kingdee.eas.base.message.OtherSysTreeNodeResource";
    private static MetaDataPK QueryPK = new MetaDataPK("com.kingdee.eas.base.message.WebServiceMessageQuery");
    protected static IMetaDataPK queryOtherSysNodeQueryPK = new MetaDataPK("com.kingdee.eas.base.message.app", "OtherSysNodeQuery");

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initController();
        this.initOthers();
        this.loadData();
    }

    private void initController() {
        this.checkSysName.setEnabled(true);
        this.connParent.setEnabled(true);
        this.connSysID.setEnabled(true);
        this.txtParent.setEnabled(true);
        this.txtSysID.setEnabled(true);
        this.txtSysID.setEnabled(false);
        this.txtParent.setEditable(false);
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.btnSave.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnInUse.setEnabled(false);
            this.btnUnUse.setEnabled(false);
            this.btnSetFilter.setEnabled(true);
            this.checkSysName.setEditable(false);
            this.multiLangNodeName.setEditable(true);
            this.alerm = true;
            this.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"addNew"));
        }
        if (this.getOprtState() == OprtState.EDIT) {
            this.btnSave.setEnabled(true);
            this.btnEdit.setEnabled(false);
            this.btnInUse.setEnabled(false);
            this.btnUnUse.setEnabled(false);
            this.btnSetFilter.setEnabled(true);
            this.checkSysName.setEditable(false);
            this.multiLangNodeName.setEditable(true);
            this.alerm = true;
            this.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"edit"));
        }
        if (this.getOprtState() == OprtState.VIEW) {
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnInUse.setEnabled(true);
            this.btnUnUse.setEnabled(true);
            this.btnSetFilter.setEnabled(false);
            this.checkSysName.setEditable(false);
            this.multiLangNodeName.setEditable(false);
            this.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"view"));
        }
    }

    private void initOthers() {
    }

    private void loadData() throws Exception {
        String parentId;
        String id;
        Map context = this.getUIContext();
        IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
        OtherSysTreeNodeInfo nodeInfo = null;
        OtherSysTreeNodeInfo parentInfo = null;
        if (this.getOprtState() == OprtState.ADDNEW) {
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)context.get("parent");
            this.txtParent.setText(parentNode.getText());
            this.parentID = (String)context.get("parentID");
            if (this.parentID.equals("/KORLgEUEADgAAAHwKgS4soJlqk=")) {
                this.readConfig();
            } else {
                parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(this.parentID));
                this.txtSysID.setText(parentInfo.getSysID());
                this.checkSysName.addItem((Object)parentInfo.getSysName());
                this.checkSysName.setSelectedItem((Object)parentInfo.getSysName());
            }
        }
        if (this.getOprtState() == OprtState.EDIT) {
            this.nodeID = id = (String)context.get("nodeID");
            nodeInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
            parentId = nodeInfo.getSuperiorID();
            parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(parentId));
            this.multiLangNodeName.setSelectedItemData((Object)nodeInfo.getName());
            this.txtParent.setText(parentInfo.getName());
            this.classFilter = nodeInfo.getFilter();
            if (parentId.equals("/KORLgEUEADgAAAHwKgS4soJlqk=") && nodeInfo.isChildNode()) {
                this.readConfig();
            }
            parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(parentId));
            this.txtSysID.setText(nodeInfo.getSysID());
            this.checkSysName.addItem((Object)nodeInfo.getSysName());
            this.checkSysName.setSelectedItem((Object)nodeInfo.getSysName());
        }
        if (this.getOprtState() == OprtState.VIEW) {
            this.nodeID = id = (String)context.get("nodeID");
            nodeInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
            parentId = nodeInfo.getSuperiorID();
            parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(parentId));
            this.checkSysName.addItem((Object)nodeInfo.getSysName());
            this.checkSysName.setSelectedItem((Object)nodeInfo.getSysName());
            this.txtSysID.setText(nodeInfo.getSysID());
            this.multiLangNodeName.setSelectedItemData((Object)nodeInfo.getName());
            this.txtParent.setText(parentInfo.getName());
            this.classFilter = nodeInfo.getFilter();
        }
    }

    private void readConfig() {
        IWebServiceMessage wsm = null;
        List configList = null;
        try {
            wsm = WebServiceMessageFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"\u83b7\u53d6WebServiceMessage\u63a5\u53e3\u7684\u65f6\u5019\u51fa\u9519", (Throwable)e);
        }
        try {
            configList = wsm.getOtherSys();
        }
        catch (BOSException e) {
            logger.error((Object)"\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u7684\u65f6\u5019\u51fa\u9519", (Throwable)e);
        }
        if (configList != null) {
            List temp2 = null;
            for (List temp2 : configList) {
                String sysID = (String)temp2.get(0);
                String sysName = (String)temp2.get(1);
                this.sysIDList.add(sysID);
                this.sysNameList.add(sysName);
            }
            for (String sysName : this.sysNameList) {
                this.checkSysName.addItem((Object)sysName);
            }
        } else {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"configError"));
            this.sucess = false;
            this.getUIWindow().close();
        }
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.checkData();
        if (this.getOprtState() == OprtState.ADDNEW) {
            IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
            OtherSysTreeNodeInfo nodeInfo = new OtherSysTreeNodeInfo();
            nodeInfo.setId(BOSUuid.create((BOSObjectType)nodeInfo.getBOSType()));
            nodeInfo.setName((String)this.multiLangNodeName.getSelectedItemData());
            nodeInfo.setInUse(TreeNodeUseStateEnum.INUSE);
            nodeInfo.setFilter(this.classFilter);
            nodeInfo.setSysID(this.txtSysID.getText());
            nodeInfo.setSysName((String)this.checkSysName.getSelectedItem());
            nodeInfo.setSuperiorID(this.parentID);
            nodeInfo.setChildNode(true);
            iostn.addnew(nodeInfo);
            this.sucess = true;
        } else {
            IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
            OtherSysTreeNodeInfo nodeInfo = new OtherSysTreeNodeInfo();
            ObjectUuidPK pk = new ObjectUuidPK(this.nodeID);
            nodeInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)pk);
            nodeInfo.setName((String)this.multiLangNodeName.getSelectedItemData());
            nodeInfo.setInUse(TreeNodeUseStateEnum.INUSE);
            nodeInfo.setFilter(this.classFilter);
            nodeInfo.setSysID(this.txtSysID.getText());
            nodeInfo.setSysName((String)this.checkSysName.getSelectedItem());
            iostn.update((IObjectPK)pk, nodeInfo);
        }
        this.getUIWindow().close();
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.alerm = true;
        this.btnSave.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.btnInUse.setEnabled(false);
        this.btnUnUse.setEnabled(false);
        this.btnSetFilter.setEnabled(true);
        this.checkSysName.setEditable(false);
        this.multiLangNodeName.setEditable(true);
        this.checkSysName.removeAllItems();
        IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
        OtherSysTreeNodeInfo nodeInfo = null;
        OtherSysTreeNodeInfo parentInfo = null;
        String id = this.nodeID;
        nodeInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
        String parentId = nodeInfo.getSuperiorID();
        parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(parentId));
        if (parentId.equals("/KORLgEUEADgAAAHwKgS4soJlqk=") && nodeInfo.isChildNode()) {
            this.readConfig();
        } else {
            parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(parentId));
            this.txtSysID.setText(nodeInfo.getSysID());
            this.checkSysName.addItem((Object)nodeInfo.getSysName());
            this.checkSysName.setSelectedItem((Object)nodeInfo.getSysName());
        }
    }

    @Override
    public void actionInUse_actionPerformed(ActionEvent e) throws Exception {
        super.actionInUse_actionPerformed(e);
        Map context = this.getUIContext();
        String id = (String)context.get("nodeID");
        IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
        OtherSysTreeNodeInfo childInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
        OtherSysTreeNodeInfo parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(childInfo.getSuperiorID()));
        if (parentInfo.getInUse() == TreeNodeUseStateEnum.UNUSE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"parentIsUnUse"));
        }
        if (parentInfo.getInUse() == TreeNodeUseStateEnum.INUSE) {
            iostn.updateNodeUseState(1, id);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"InUseSuccess"));
        }
    }

    @Override
    public void actionUnUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnUser_actionPerformed(e);
        Map context = this.getUIContext();
        String id = (String)context.get("nodeID");
        IOtherSysTreeNode iostn = OtherSysTreeNodeFactory.getRemoteInstance();
        OtherSysTreeNodeInfo parentInfo = (OtherSysTreeNodeInfo)iostn.getValue((IObjectPK)new ObjectUuidPK(id));
        if (parentInfo.isChildNode()) {
            iostn.updateNodeUseState(0, id);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"UnUseSuccess"));
        } else {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterItemInfo itemInfo1 = new FilterItemInfo("superiorID", (Object)parentInfo.getId().toString());
            FilterItemInfo itemInfo2 = new FilterItemInfo("inUse", (Object)new Integer(1));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(itemInfo1);
            filterInfo.getFilterItems().add(itemInfo2);
            filterInfo.setMaskString("#0 and #1");
            entityViewInfo.setFilter(filterInfo);
            IQueryExecutor exec = this.getQueryExecutor(queryOtherSysNodeQueryPK, entityViewInfo);
            if (exec.getRowCount() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"childIsInUse"));
            } else {
                iostn.updateNodeUseState(0, id);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"UnUseSuccess"));
            }
        }
    }

    @Override
    public void actionSetFilter_actionPerformed(ActionEvent e) throws Exception {
        EntityViewInfo result;
        super.actionSetFilter_actionPerformed(e);
        CommonQueryDialog classSetdlg = new CommonQueryDialog();
        classSetdlg.setOwner((Component)((Object)this));
        classSetdlg.setShowSorter(false);
        classSetdlg.setParentUIClassName(((Object)((Object)this)).getClass().getName());
        classSetdlg.setQueryObjectPK((IMetaDataPK)QueryPK);
        classSetdlg.setTitle(EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"queryDialogTitle"));
        classSetdlg.setShowToolbar(false);
        if (!StringUtils.isEmpty((String)this.classFilter)) {
            classSetdlg.setEntityViewInfo(new EntityViewInfo(" WHERE " + this.classFilter));
        }
        if (classSetdlg.show() && (result = classSetdlg.getEntityViewInfoResult()) != null) {
            this.classFilter = result.getFilter().toString();
        }
    }

    @Override
    public void actionSysSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionSysSelected_actionPerformed(e);
        int num = 0;
        String sysID = "";
        if (this.checkSysName.getSelectedItem() != null && this.sysNameList.size() > 0) {
            num = this.checkSysName.getSelectedIndex();
            sysID = (String)this.sysIDList.get(num);
            this.txtSysID.setText(sysID);
        }
    }

    private void checkData() {
        if (this.checkSysName.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"sysNameNotNull"));
            this.checkSysName.requestFocus();
            SysUtil.abort();
        }
        if (this.multiLangNodeName.getSelectedItemData() == null || ((String)this.multiLangNodeName.getSelectedItemData()).trim().length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"nodeNameNotNull"));
            this.multiLangNodeName.requestFocus();
            SysUtil.abort();
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        if (this.alerm) {
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Check"));
            if (result == 0) {
                this.actionSave_actionPerformed(e);
                this.getUIWindow().close();
            }
            if (result == 1) {
                this.getUIWindow().close();
            }
        } else {
            this.getUIWindow().close();
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }
}

