/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.TempMessageException;
import com.kingdee.eas.base.message.client.AbstractTempMessageSendUI;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.border.Border;

public class TempMessageSendUI
extends AbstractTempMessageSendUI {
    private static final long serialVersionUID = 8909592139038525356L;
    private Border border;

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdSender.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
        this.kdMsgLifeCyc.setText("1");
        this.kdMsgTitle.requestFocus();
        this.kdSend.setIcon(EASResource.getIcon((String)"imgTbtn_send"));
        this.border = this.kdMsgContent.getBorder();
        this.kdMsgContent.setBorder(null);
        this.kDScrollPane1.setBorder(KingdeeBorders.createEditorBorder());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    @Override
    public void actionSendTempMsg_actionPerformed(ActionEvent e) throws Exception {
        this.validateParams();
        this.getUIWindow().close();
    }

    private void validateParams() throws Exception {
        String senderName = this.kdSender.getText();
        if (senderName == null || senderName.equals("")) {
            this.kdSender.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_SENDER_NOT_NULL);
        }
        String strLifeCyc = this.kdMsgLifeCyc.getText();
        if (strLifeCyc == null || strLifeCyc.equals("")) {
            this.kdMsgLifeCyc.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_CYC_NOT_NULL);
        }
        Integer lifeCyc = null;
        try {
            lifeCyc = Integer.valueOf(this.kdMsgLifeCyc.getText());
        }
        catch (NumberFormatException e) {
            this.kdMsgLifeCyc.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_CYCTIME_UNAVAILD);
        }
        int intLifeCyc = lifeCyc;
        if (intLifeCyc < 0 || intLifeCyc > 60) {
            this.kdMsgLifeCyc.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_CYC_NOT_STANDARD);
        }
        String title = this.kdMsgTitle.getText();
        if (title == null || title.equals("")) {
            this.kdMsgTitle.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_TITLE_NOT_NULL);
        }
        String content = this.kdMsgContent.getText();
        if (content == null || content.equals("")) {
            this.kdMsgContent.requestFocus();
            throw new TempMessageException(TempMessageException.MSG_CONTENT_NOT_NULL);
        }
        MessageCenterFactory.getRemoteInstance().sendTempMsg(content, title, intLifeCyc, senderName);
    }

    @Override
    public void actionSendCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void kdMsgContent_focusGained(FocusEvent e) throws Exception {
        this.kDScrollPane1.setBorder(this.border);
    }

    @Override
    protected void kdMsgContent_focusLost(FocusEvent e) throws Exception {
        this.kDScrollPane1.setBorder(KingdeeBorders.createEditorBorder());
    }
}

