/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.message.DBTempMsgFacadeFactory;
import com.kingdee.eas.base.message.DBTempMsgInfo;
import com.kingdee.eas.base.message.IDBTempMsgFacade;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.message.TempMessage;
import com.kingdee.eas.base.message.client.NotifyAllMessageUI;
import com.kingdee.eas.base.message.client.TempMessageClient;
import com.kingdee.eas.base.message.client.TempMessageSendUI;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;

public class TempMsgManager {
    private static Timer inspectTimer;
    private ActionListener actionInspectForNotifyNews = new ActionInspectForNotifyNews();
    private static Component parentUI;
    private static TempMsgManager tempMsgManager;
    private static final String SAFE_WARN_USER = "safe_warn_user";

    public static TempMsgManager getInstance() {
        if (tempMsgManager == null) {
            tempMsgManager = new TempMsgManager();
            TempMsgManager.firstAccessServerMsgContainer();
        }
        return tempMsgManager;
    }

    private TempMsgManager() {
        this.initInspectTimer();
    }

    public void showTempMsgSendUI(Component parentUI) {
        HashMap<String, Component> ctx = new HashMap<String, Component>();
        ctx.put("Owner", parentUI);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(TempMessageSendUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException uIException) {
            // empty catch block
        }
    }

    private void initInspectTimer() {
        boolean INSPECT_TIME_FOR_MIN = true;
        int time = 60000;
        inspectTimer = new Timer(time, this.actionInspectForNotifyNews);
        inspectTimer.setDelay(time);
        inspectTimer.start();
    }

    private static void firstAccessServerMsgContainer() {
        TempMsgManager tempMsgManager = TempMsgManager.tempMsgManager;
        tempMsgManager.getClass();
        FirstGetMsgThread thread = tempMsgManager.new FirstGetMsgThread();
        thread.start();
    }

    private void destroyOverTimeTempMsg() throws EASBizException, BOSException {
        long currentTime = System.currentTimeMillis();
        MessageCenterFactory.getRemoteInstance().destroyOverTimeMsg(currentTime);
        TempMessageClient.DestroryOverTimeMsg(currentTime);
    }

    private void processReceiveTempMsg(Map msgMap) throws EASBizException, BOSException {
        Set alreadyReadMsgSet = TempMessageClient.getAlreadyReadMsgIDMap();
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Iterator msgItr = msgMap.values().iterator();
        String msgTitle = null;
        String msgContent = null;
        String senderName = null;
        IDBTempMsgFacade iMsgFacade = DBTempMsgFacadeFactory.getRemoteInstance();
        if (iMsgFacade.isCluster()) {
            DBTempMsgInfo info = null;
            while (msgItr.hasNext()) {
                info = (DBTempMsgInfo)msgItr.next();
                msgTitle = info.getMsgTitle();
                msgContent = info.getMsgContent();
                long msgID = new Long(info.getMsgSendTime());
                long msgLifeCyc = info.getMsgLifeCyc();
                senderName = info.getSenderName();
                if (alreadyReadMsgSet.contains(new Long(msgLifeCyc))) continue;
                ctx.put("title", msgTitle);
                ctx.put("message", msgContent);
                ctx.put("id", new Long(msgID));
                ctx.put("lifeCyc", new Long(msgLifeCyc));
                ctx.put("senderName", senderName);
                ctx.put("Owner", SystemEntry.instance.getOwnerFrame());
                IUIWindow messageDialog = uiFactory.create(NotifyAllMessageUI.class.getName(), ctx);
                alreadyReadMsgSet.add(new Long(msgLifeCyc));
                messageDialog.show();
            }
        } else {
            TempMessage info = null;
            while (msgItr.hasNext()) {
                info = (TempMessage)msgItr.next();
                msgTitle = info.getMsgTitle();
                msgContent = info.getMsgContent();
                long msgID = info.getMsgID();
                long msgLifeCyc = info.getMsgLifeCyc();
                senderName = info.getSenderName();
                if (alreadyReadMsgSet.contains(new Long(msgLifeCyc))) continue;
                ctx.put("title", msgTitle);
                ctx.put("message", msgContent);
                ctx.put("id", new Long(msgID));
                ctx.put("lifeCyc", new Long(msgLifeCyc));
                ctx.put("senderName", senderName);
                ctx.put("Owner", SystemEntry.instance.getOwnerFrame());
                IUIWindow messageDialog = uiFactory.create(NotifyAllMessageUI.class.getName(), ctx);
                alreadyReadMsgSet.add(new Long(msgLifeCyc));
                messageDialog.show();
            }
        }
    }

    private void procedureOfClient() throws Exception {
        Map msgMap = MessageCenterFactory.getRemoteInstance().receiveTempMsg();
        if (msgMap.size() == 0) {
            return;
        }
        if ((msgMap = this.handleMsgMap(msgMap)).size() == 0) {
            return;
        }
        this.processReceiveTempMsg(msgMap);
        this.destroyOverTimeTempMsg();
    }

    private Map handleMsgMap(Map msgMap) {
        try {
            HashMap msgMapReal = new HashMap();
            for (Object key : msgMap.keySet()) {
                TempMessage message = (TempMessage)msgMap.get(key);
                String msgContentAll = message.getMsgContent();
                if (msgContentAll.startsWith(SAFE_WARN_USER)) {
                    boolean safeWarnForUser = this.isSafeWarnForUser(message);
                    if (!safeWarnForUser) continue;
                    int pos = msgContentAll.lastIndexOf("|");
                    String msgContent = msgContentAll.substring(pos + 1);
                    message.setMsgContent(msgContent);
                    msgMapReal.put(key, message);
                    continue;
                }
                msgMapReal.put(key, message);
            }
            return msgMapReal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return msgMap;
        }
    }

    private boolean isSafeWarnForUser(TempMessage message) {
        String senderName = message.getSenderName();
        String clientIP = SysContext.getSysContext().getClientIP() == null ? "" : SysContext.getSysContext().getClientIP();
        String sessionId = SysContext.getSysContext().getSessionID();
        String dc = SysContext.getSysContext().getDCNumber();
        if (!senderName.equals(SysContext.getSysContext().getCurrentUserInfo().getNumber())) {
            return false;
        }
        if (dc != null && message.getMsgContent() != null && !message.getMsgContent().contains("|" + dc + "|")) {
            return false;
        }
        if (sessionId != null && message.getMsgContent() != null && message.getMsgContent().contains(sessionId)) {
            return false;
        }
        long time = message.getMsgLifeCyc() - System.currentTimeMillis();
        return message.getMsgLifeCyc() > System.currentTimeMillis();
    }

    public static void stopInspectTimer() {
        if (inspectTimer != null) {
            inspectTimer.stop();
            inspectTimer = null;
        }
        tempMsgManager = null;
    }

    public static void setParentUI(Component parentUI) {
        if (parentUI == null) {
            throw new NullPointerException("Parent UI can not be Null !");
        }
        TempMsgManager.parentUI = parentUI;
    }

    private class FirstGetMsgThread
    extends Thread {
        private FirstGetMsgThread() {
        }

        @Override
        public void run() {
            try {
                TempMsgManager.this.procedureOfClient();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ActionInspectForNotifyNews
    implements ActionListener {
        private ActionInspectForNotifyNews() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TempMsgManager.this.procedureOfClient();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

