/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.metas.ProcDefInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.message.WfCommonProcessAppConfigFactory;
import com.kingdee.eas.base.message.WfCommonProcessAppConfigInfo;
import com.kingdee.eas.base.message.client.AbstractWfCommonProcessAppConfigEditUI;
import com.kingdee.eas.base.message.client.ProcDefCellValue;
import com.kingdee.eas.base.message.client.WfCPAppConfigProcF7SelectorUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class WfCommonProcessAppConfigEditUI
extends AbstractWfCommonProcessAppConfigEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WfCommonProcessAppConfigEditUI.class);
    WfCPAppConfigProcF7SelectorUI selectorUI;

    private JFrame getFrame() {
        Window window = null;
        JFrame frame = null;
        for (Container parent = window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JFrame)) continue;
            frame = (JFrame)parent;
            break;
        }
        return frame;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("srcSystem"));
        sic.add(new SelectorItemInfo("procDefId"));
        return sic;
    }

    private WfCPAppConfigProcF7SelectorUI getSelectorUI() {
        if (this.selectorUI == null) {
            this.selectorUI = new WfCPAppConfigProcF7SelectorUI(this.getFrame());
        }
        return this.selectorUI;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String value = this.txtNumber.getStringValue();
        if (value == null || value.trim().length() == 0) {
            String number = this.contNumber.getBoundLabelText();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{number});
        }
        value = this.txtName.getStringValue();
        if (value == null || value.trim().length() == 0) {
            String number = this.contName.getBoundLabelText();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{number});
        }
        value = this.txtSrcSystem.getStringValue();
        if (value == null || value.trim().length() == 0) {
            String number = this.contSrcSystem.getBoundLabelText();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{number});
        }
        if (this.pbProcDef.getValue() == null) {
            String number = this.lcProcDef.getBoundLabelText();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{number});
        }
    }

    @Override
    public void storeFields() {
        ProcDefCellValue cellValue;
        super.storeFields();
        if (this.editData.getNumber() != null && (cellValue = (ProcDefCellValue)this.pbProcDef.getValue()) != null) {
            this.editData.setProcDefId(cellValue.info.getProcdefID().toString());
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.pbProcDef.setSelector(new KDPromptSelector(){

            public void show() {
                WfCommonProcessAppConfigEditUI.this.getSelectorUI().show();
            }

            public boolean isCanceled() {
                return WfCommonProcessAppConfigEditUI.this.getSelectorUI().isCanceled();
            }

            public Object getData() {
                return WfCommonProcessAppConfigEditUI.this.getSelectorUI().getData();
            }
        });
        WfCommonProcessAppConfigInfo info = this.editData;
        String procDefId = info.getProcDefId();
        if (procDefId == null) {
            return;
        }
        try {
            ProcessDefInfo processDefInfo = EnactmentServiceFactory.createRemoteEnactService().getProcessDefInfo(procDefId);
            ProcDefInfo procDefInfo = processDefInfo.getMeta();
            this.pbProcDef.setValue((Object)new ProcDefCellValue(procDefInfo));
        }
        catch (WfException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSave_actionPerformed(e);
    }

    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception {
        super.actionKnowStore_actionPerformed(e);
    }

    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception {
        super.actionAnswer_actionPerformed(e);
    }

    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoteAssist_actionPerformed(e);
    }

    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupCopy_actionPerformed(e);
    }

    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForMail_actionPerformed(e);
    }

    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForMail_actionPerformed(e);
    }

    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionExcelForRpt_actionPerformed(e);
    }

    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception {
        super.actionLinkForRpt_actionPerformed(e);
    }

    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception {
        super.actionPopupPaste_actionPerformed(e);
    }

    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception {
        super.actionToolBarCustom_actionPerformed(e);
    }

    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudFeed_actionPerformed(e);
    }

    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudShare_actionPerformed(e);
    }

    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception {
        super.actionCloudScreen_actionPerformed(e);
    }

    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception {
        super.actionXunTongFeed_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    public void actionReset_actionPerformed(ActionEvent e) throws Exception {
        super.actionReset_actionPerformed(e);
    }

    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception {
        super.actionMsgFormat_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return new WfCommonProcessAppConfigInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WfCommonProcessAppConfigFactory.getRemoteInstance();
    }
}

