/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.message.util;

import com.kingdee.eas.base.message.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String YYMM_EN = "yyyy-MM";
    public static final String YYMMDD_EN = "yyyy-MM-dd";
    public static final String YYMMDDHHMMSS_EN = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
    }

    public static String dateToStr(Date date, String format) {
        try {
            SimpleDateFormat adf = new SimpleDateFormat(format);
            return adf.format(date);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            return "";
        }
    }

    public static Date strToDate(String str, String format) {
        Date date = null;
        SimpleDateFormat adf = new SimpleDateFormat(format);
        try {
            date = adf.parse(str);
        }
        catch (ParseException ex) {
            logger.error(str + "\u8f6c\u6362\u6210\u65e5\u671f\u65f6\u51fa\u9519\u3002");
            date = null;
        }
        return date;
    }

    public static Date getDate(int year, int month, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(year, month - 1, day, hour, minute, second);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "yyyy"));
    }

    public static int getMonth(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "MM"));
    }

    public static int getDay(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "dd"));
    }

    public static int getHours(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "HH"));
    }

    public static int getMinutes(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "mm"));
    }

    public static int getSeconds(Date date) {
        return StringUtil.string2Int(DateUtil.dateToStr(date, "ss"));
    }

    public static String getToday() {
        return DateUtil.dateToStr(new Date(), YYMMDD_EN);
    }

    public static String getCuttentTime() {
        return DateUtil.dateToStr(new Date(), YYMMDDHHMMSS_EN);
    }

    public static Date getPreviousMonthDate() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        Date prevMonDate = cal.getTime();
        return prevMonDate;
    }

    public static Date getTomorrow(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        Date tomorrow = cal.getTime();
        return tomorrow;
    }
}

